#import <Foundation/NSObject.h>
#import <ApplicationServices/ApplicationServices.h>
#import <QuartzCore/CVImageBuffer.h>
#include <QuartzCore/CIImage.h>

/*The following constants define pixel formats.
Constant	
Description
CIFormat	
Specifies the data type for a pixel format.
kCIFormatARGB8	
Specifies a 32 bit-per-pixel, fixed-point pixel format.
kCIFormatRGBA16	
Specifies a 64 bit-per-pixel, fixed-point pixel format.
kCIFormatRGBAf	
Specifies a 128 bit-per-pixel, floating-point pixel format*/
 CIFormat kCIFormatARGB8;
 CIFormat kCIFormatRGBA16;
CIFormat kCIFormatRGBAf;


@implementation CIImage

/*extent
Gets the extent of an image.

- (CGRect)extent
Return Value

A rectangle that specifies the extent of the image in working space coordinates.
Availability
Mac OS X v10.4 and later.*/

- (CGRect)extent{
printf ("extent");
}


/*imageWithCVImageBuffer:

Creates an image object from the contents of CVImageBuffer object.

+ (CIImage *)imageWithCVImageBuffer:(CVImageBufferRef)imageBuffer
Parameters
imageBuffer

A CVImageBuffer object. For more information, see Core Video Programming Guide and Core Video Reference.
Return Value

An image object initialized with the contents of the CVImageBuffer object.
Availability
Mac OS X v10.4 and later.*/
+ (CIImage *)imageWithCVImageBuffer:(CVImageBufferRef)imageBuffer{
printf ("imageWithCVImageBuffer",imageBuffer);
}


/*imageWithContentsOfURL:

Creates an image object from the contents of a file.

+ (CIImage *)imageWithContentsOfURL: (NSURL *)url
Parameters
url

The location of the file.
Return Value

An image object initialized with the contents of the file.
Availability
Mac OS X v10.4 and later.*/
+ (CIImage *)imageWithContentsOfURL: (NSURL *)url{
printf ("imageWithContentsOfURL",url);
}


/*initWithCGImage:

Initializes an image object with a Quartz 2D image.

- (id)initWithCGImage:(CGImageRef)image
Parameters
image

A Quartz 2D image (CGImageRef) object. For more information, see Quartz 2D Programming Guide and CGImage Reference.
Return Value

The initialized image object or nil if the object could not be initialized.
Availability
Mac OS X v10.4 and later.*/
- (id)initWithCGImage:(CGImageRef)image{
printf ("initWithCGImage",image);
}


/*imageWithCGImage:

Creates an image object from a Quartz 2D image.

+ (CIImage *)imageWithCGImage:(CGImageRef)image
Parameters
image

A Quartz 2D image (CGImageRef) object. For more information, see Quartz 2D Programming Guide and CGImage Reference.
Return Value

An image object initialized with the contents of the Quartz 2D image.
Availability
Mac OS X v10.4 and later.*/
+ (CIImage *)imageWithCGImage:(CGImageRef)image{
printf ("initWithCGImage",image);
}


/*imageByApplyingTransform:

Transforms an image object by applying an affine transform.

- (CIImage *)imageByApplyingTransform:(CGAffineTransform)matrix
Parameters
matrix

An affine transform.
Return Value

The transformed image object.
Availability
Mac OS X v10.4 and later.*/
- (CIImage *)imageByApplyingTransform:(CGAffineTransform)matrix{
printf ("imageByApplyingTransform",matrix);
}


/*imageWithData:

Creates an image object initialized with the supplied image data.

+ (CIImage *)imageWithData: (NSData *)data
Parameters
data

A pointer to the image data. The data must be premultiplied.
Return Value

An image object initialized with the supplied data.
Availability
Mac OS X v10.4 and later.*/
+ (CIImage *)imageWithData: (NSData *)data{
printf ("imageWithData",data);
}

/*initWithCGLayer:

Initializes an image object from the contents supplied by a CGLayer object.

- (id)initWithCGLayer:(CGLayerRef)layer
Parameters
layer

A CGLayer object. For more information see Quartz 2D Programming Guide and CGLayer Reference.
Return Value

The initialized image object or nil if the object could not be initialized.
Availability
Mac OS X v10.4 and later.
See Also
– createCGLayerWithSize:info:*/
- (id)initWithCGLayer:(CGLayerRef)layer{
printf ("initWithCGLayer",layer);
}

/*initWithCVImageBuffer:

Initializes an image object from the contents of CVImageBuffer object.

- (id)initWithCVImageBuffer:(CVImageBufferRef)imageBuffer
Parameters
imageBuffer

A CVImageBuffer object. For more information, see Core Video Programming Guide and Core Video Reference.
Return Value

The initialized image object or nil if the object could not be initialized.
Availability
Mac OS X v10.4 and later.*/
- (id)initWithCVImageBuffer:(CVImageBufferRef)imageBuffer{
printf ("initWithCVImageBuffer",imageBuffer);
}


@end

