#include <QuartzCore/CVBuffer.h>

/*CVBufferRelease

Releases a Core Video buffer. 

void CVBufferRelease (CVBufferRef buffer);
Parameters
buffer

The Core Video buffer that you want to release.
Discussion

Like CFRelease CVBufferRelease decrements the retain count of a Core Video buffer. If that count consequently becomes zero the memory allocated to the object is deallocated and the object is destroyed. Unlike CFRelease, you can pass NULL to CVBufferRelease without causing a crash. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVBuffer.h*/
void CVBufferRelease (CVBufferRef buffer){
printf ("CVBufferRelease",buffer);
};

/*CVBufferRetain

Retains a Core Video buffer.

CVBufferRef CVBufferRetain (CVBufferRef buffer);
Parameters
buffer

The Core Video buffer that you want to retain.
Return Value

For convenience, the same Core Video buffer you wanted to retain.
Discussion

Like CFRetain, CVBufferRetain increments the retain count of a Core Video buffer. Unlike CFRetain, you can pass NULL to CVBufferRetain without causing a crash. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVBuffer.h*/
CVBufferRef CVBufferRetain (CVBufferRef buffer){
printf ("CVBufferRetain",buffer);
};

