#include <QuartzCore/CVDisplayLink.h>


/*CVDisplayLinkRelease

Releases a display link.

void CVDisplayLinkRelease (
   CVDisplayLinkRef displayLink
);
Parameters
displayLink

The display link to release. This function is NULL-safe.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
void CVDisplayLinkRelease (
   CVDisplayLinkRef displayLink
){
printf ("CVDisplayLinkRelease",displayLink);
};

/*CVDisplayLinkCreateWithActiveCGDisplays

Creates a display link capable of being used with all active displays.

CVReturn CVDisplayLinkCreateWithActiveCGDisplays (
   CVDisplayLinkRef *displayLinkOut
);
Parameters
displayLinkOut

On return, displayLinkOut points to the newly created display link.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

CVDisplayLinkCreateWithActiveCGDisplays determines the displays actively used by the host computer and creates a display link compatible with all of them. For most applications, calling this function is the most convenient way to create a display link. After creation, you can assign the display link to any active display by calling CVDisplayLinkSetCurrentCGDisplay.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkCreateWithActiveCGDisplays (
   CVDisplayLinkRef *displayLinkOut
){
printf ("CVDisplayLinkCreateWithActiveCGDisplays",*displayLinkOut);
};

/*CVDisplayLinkSetOutputCallback

Set the renderer output callback function.

CVReturn CVDisplayLinkSetOutputCallback (
   CVDisplayLinkRef displayLink,
   CVDisplayLinkOutputCallback callback,
   void *userInfo
);
Parameters
displayLink

The display link whose output callback you want to set. 
callback

The callback function to set for this display link. See CVDisplayLinkOutputCallback for more information about implementing this function. 
userInfo

A pointer to user data.
Return Value

A Core Video result code. See “Result Codes” for possible values.
Discussion

The display link invokes this callback whenever it wants you to output a frame. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkSetOutputCallback (
   CVDisplayLinkRef displayLink,
   CVDisplayLinkOutputCallback callback,
   void *userInfo
){
printf ("CVDisplayLinkSetOutputCallback",displayLink,callback,userInfo);
};

/*CVDisplayLinkSetCurrentCGDisplayFromOpenGLContext

Selects the display link most optimal for the current renderer of an OpenGL context.

CVReturn CVDisplayLinkSetCurrentCGDisplayFromOpenGLContext (
   CVDisplayLinkRef displayLink,
   CGLContextObj cglContext,
   CGLPixelFormatObj cglPixelFormat
);
Parameters
displayLink

The display link for which you want to set the current display.
cglContext

The OpenGL context to retrieve the current renderer from.
cglPixelFormat

The OpenGL pixel format used to create the passed-in OpenGL context.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

This function chooses the display with the lowest refresh rate. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkSetCurrentCGDisplayFromOpenGLContext (
   CVDisplayLinkRef displayLink,
   CGLContextObj cglContext,
   CGLPixelFormatObj cglPixelFormat
){
printf ("CVDisplayLinkSetCurrentCGDisplayFromOpenGLContext",displayLink,cglContext,cglPixelFormat);
};

/*CVDisplayLinkStart

Activates a display link.

CVReturn CVDisplayLinkStart (
   CVDisplayLinkRef displayLink
);
Parameters
displayLink

The display link to activate. 
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

Calling this function starts the display link thread, which then periodically calls back to your application to request that you display frames. If the specified display link is already running, CVDisplayLinkStart returns an error.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkStart (
   CVDisplayLinkRef displayLink
){
printf ("CVDisplayLinkStart",displayLink);
};

/*CVDisplayLinkCreateWithOpenGLDisplayMask

Creates a display link from an OpenGL display mask.

CVReturn CVDisplayLinkCreateWithOpenGLDisplayMask (
   CGOpenGLDisplayMask mask,
   CVDisplayLinkRef *displayLinkOut
);
Parameters
mask

The OpenGL display mask describing the available displays.
displayLinkOut

On return, displayLinkOut points to the newly created display link.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

Using this function avoids having to call the Core Graphics function CGOpenGLDisplayMaskToDisplayID.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/

CVReturn CVDisplayLinkCreateWithOpenGLDisplayMask (
   CGOpenGLDisplayMask mask,
   CVDisplayLinkRef *displayLinkOut
){
printf ("CVDisplayLinkCreateWithOpenGLDisplayMask",mask,*displayLinkOut);
};

/*CVDisplayLinkStop

Stops a display link.

CVReturn CVDisplayLinkStop (
   CVDisplayLinkRef displayLink
);
Parameters
displayLink

The display link to stop.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

If the specified display link is already stopped, CVDisplayLinkStop returns an error.

In Mac OS X v.10.4 and later, the display link thread is automatically stopped if the user employs Fast User Switching. The display link is restarted when switching back to the original user. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkStop (
   CVDisplayLinkRef displayLink
){
printf ("CVDisplayLinkStop",displayLink);
};

/*CVDisplayLinkSetCurrentCGDisplay

Sets the current display of a display link. 

CVReturn CVDisplayLinkSetCurrentCGDisplay (
   CVDisplayLinkRef displayLink,
   CGDirectDisplayID displayID
);
Parameters
displayLink

The display link whose display you want to set. 
displayID

The ID of the display to be set. 
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

Although it is safe to call this function on a running display link, a discontinuity may appear in the video timestamp. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkSetCurrentCGDisplay (
   CVDisplayLinkRef displayLink,
   CGDirectDisplayID displayID
){
printf ("CVDisplayLinkSetCurrentCGDisplay",displayLink,displayID);
};

/*CVDisplayLinkIsRunning

Indicates whether a given display link is running. 

Boolean CVDisplayLinkIsRunning (
   CVDisplayLink displayLink
);
Parameters
displayLink

The display link whose run state you want to determine. 
Return Value

Returns true if the display link is running, false otherwise. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
Boolean CVDisplayLinkIsRunning (
   CVDisplayLinkRef  displayLink
){
printf ("CVDisplayLinkIsRunning",displayLink);
};

/*CVDisplayLinkCreateWithCGDisplay

Creates a display link for a single display.

CVReturn CVDisplayLinkCreateWithCGDisplay (
   CGDirectDisplayID displayID,
   CVDisplayLinkRef *displayLinkOut
);
Parameters
displayID

The Core Graphics ID of the target display.
displayLinkOut

On return, displayLinkOut points to the newly created display link.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

Use this call to create a display link for a single display. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/

CVReturn CVDisplayLinkCreateWithCGDisplay (
   CGDirectDisplayID displayID,
   CVDisplayLinkRef *displayLinkOut
){
printf ("CVDisplayLinkCreateWithCGDisplay",displayID,*displayLinkOut);
};

