#include <Security/Security.h>

/*SSLGetPeerCertificates

Retrieves a peer certificate. 

OSStatus SSLGetPeerCertificates (
SSLContextRef context,
CFArrayRef *certs
);
Parameters
context

An SSL session context reference.
certs

On return, a pointer to an array of values of type SecCertificateRef representing the peer certificate and the certificate chain used to validate it. The certificate at index 0 of the returned array is the peer certificate; the root certificate (or the closest certificate to it) is at the end of the returned array. The entire array is created by the Secure Transport library; you must release it when you are finished with it.
Return Value

A result code. See “Secure Transport Result Codes”.
Discussion

This function is valid any time after a handshake attempt. You can use it to examine a peer certificate, to examine a certificate chain to determine why a handshake attempt failed, or to retrieve the certificate chain in order to validate the certificate yourself (see SSLSetEnableCertVerify). 
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLGetPeerCertificates (
SSLContextRef context,
CFArrayRef *certs
){
printf ("SSLGetPeerCertificates ",context,*certs);
};

/*SSLGetNumberSupportedCiphers

Determines the number of cipher suites supported. 

OSStatus SSLGetNumberSupportedCiphers (
SSLContextRef context,
size_t *numCiphers
);
Parameters
context

An SSL session context reference. 
numCiphers

On return, points to the number of supported cipher suites.
Return Value

A result code. See “Secure Transport Result Codes”.
Discussion

You use the number of enabled cipher suites returned by this function when you call the SSLGetNumberSupportedCiphers function to retrieve the list of currently enabled cipher suites.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLGetNumberSupportedCiphers (
SSLContextRef context,
size_t *numCiphers
){
printf ("SSLGetNumberSupportedCiphers ",context,*numCiphers);
};

/*SSLGetSupportedCiphers

Determines the values of the supported cipher suites.

OSStatus SSLGetSupportedCiphers (
SSLContextRef context,
SSLCipherSuite *ciphers,
size_t *numCiphers
);
Parameters
context

An SSL session context reference.
ciphers

On return, points to the values of the supported cipher suites. Before calling, you must allocate this buffer using the number of supported cipher suites retrieved from a call to the SSLGetNumberSupportedCiphers function.
numCiphers

Points to the number of supported cipher suites that you want returned. Before calling, retrieve this value by calling the SSLGetNumberSupportedCiphers function.
Return Value

A result code. See “Secure Transport Result Codes”. If the supplied buffer is too small, errSSLBufferOverflow is returned.
Discussion

All the supported cipher suites are enabled by default. Use the SSLSetEnabledCiphers function to enable a subset of the supported cipher suites. Use the SSLGetEnabledCiphers function to determine which cipher suites are currently enabled.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLGetSupportedCiphers (
SSLContextRef context,
SSLCipherSuite *ciphers,
size_t *numCiphers
){
printf ("SSLGetSupportedCiphers",context,*ciphers,*numCiphers);
};

/*SSLSetEnabledCiphers

Specifies a restricted set of SSL cipher suites to be enabled by the current SSL session context.

OSStatus SSLSetEnabledCiphers (
SSLContextRef context,
const SSLCipherSuite *ciphers,
size_t numCiphers
);
Parameters
context

An SSL session context reference.
ciphers

A pointer to the cipher suites to enable.
numCiphers

The number of cipher suites to enable.
Return Value

A result code. See “Secure Transport Result Codes”.
Discussion

You can call this function, for example, to limit cipher suites to those that use exportable key sizes or to those supported by a particular protocol version.

This function can be called only when no session is active. The default set of enabled cipher suites is the complete set of supported cipher suites obtained by calling the SSLGetSupportedCiphers function.

Call the SSLGetEnabledCiphers function to determine which SSL cipher suites are currently enabled.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLSetEnabledCiphers (
SSLContextRef context,
const SSLCipherSuite *ciphers,
size_t numCiphers
){
printf ("SSLSetEnabledCiphers",context,*ciphers,numCiphers);
};


/*SSLNewContext

Creates a new SSL session context.

OSStatus SSLNewContext (
Boolean isServer,
SSLContextRef *contextPtr
);
Parameters
isServer

A Boolean value; True if the calling process is a server.
contextPtr

On return, points to a new SSL session context reference.
Return Value

A result code. See “Secure Transport Result Codes”.
Discussion

The SSL session context is an opaque data structure that identifies a session and stores session information. You must pass this object to every other function in the Secure Transport API.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/

OSStatus SSLNewContext (
Boolean isServer,
SSLContextRef *contextPtr
){
printf ("SSLNewContext",isServer,*contextPtr);
};

/*SSLSetIOFuncs

Specifies callback functions that perform the network I/O operations.

OSStatus SSLSetIOFuncs (
SSLContextRef context,
SSLReadFunc read,
SSLWriteFunc write
);
Parameters
context

An SSL session context reference.
read

A pointer to your read callback function. See SSLReadFunc for information on defining this function.
write

A pointer to your write callback function. See SSLWriteFunc for information on defining this function.
Return Value

A result code. See “Secure Transport Result Codes”.
Discussion

Secure Transport calls your read and write callback functions to perform network I/O. You must define these functions before calling SSLSetIOFuncs.

You must call SSLSetIOFuncs prior to calling the SSLHandshake function. SSLSetIOFuncs cannot be called while a session is active.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLSetIOFuncs (
SSLContextRef context,
SSLReadFunc read,
SSLWriteFunc write
){
printf ("SSLSetIOFuncs",context,read,write);
};

/*SSLSetProtocolVersion

Sets the SSL protocol version. This function is deprecated. 



OSStatus SSLSetProtocolVersion (
SSLContextRef context,
SSLProtocol version
);
Parameters
context

An SSL session context reference.
version

The SSL protocol version to negotiate.
Return Value

A result code. See “Secure Transport Result Codes”.
Discussion

Use the SSLSetProtocolVersionEnabled function instead.

This function cannot be called when a session is active.
Availability
Available in Mac OS X v10.2.
Declared In
SecureTransport.h*/
OSStatus SSLSetProtocolVersion (
SSLContextRef context,
SSLProtocol version
){
printf ("SSLSetProtocolVersion",context,version);
};


/*SSLSetConnection

Specifies an I/O connection for a specific session.

OSStatus SSLSetConnection (
SSLContextRef context,
   SSLConnectionRef connection
);
Parameters
context

An SSL session context reference.
connection

An SSL session connection reference. The connection data is opaque to Secure Transport; you can set it to any value that your application can use to uniquely identify the connection in the callback functions SSLReadFunc and SSLWriteFunc. 
Return Value

A result code. See “Secure Transport Result Codes”.
Discussion

You must establish a connection before creating a secure session. After calling the SSLNewContext function to create an SSL session context, you call the SSLSetConnection function to specify the connection to which the context applies. You specify a value in the connection parameter that your callback routines can use to identify the connection. This value might be a pointer to a socket (if you are using the Sockets API) or an endpoint (if you are using Open Transport). For example, you might create a socket, start a connection on it, create a context reference, cast the socket to an SSLConnectionRef, and then pass both the context reference and connection reference to the SSLSetConnection function.

Note that the Sockets API is the preferred networking interface for new development.

On the client side, it’s assumed that communication has been established with the desired server on this connection. On the server side, it’s assumed that a connection has been established in response to an incoming client request .

This function must be called prior to the SSLHandshake function; consequently, this function can be called only when no session is active.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLSetConnection (
SSLContextRef context,
   SSLConnectionRef connection
){
printf ("SSLSetConnection",context,connection);
};

/*SSLSetPeerDomainName

Specifies the fully qualified domain name of the peer.

OSStatus SSLSetPeerDomainName (
SSLContextRef context,
const char *peerName,
size_t peerNameLen );
Parameters
context

An SSL session context reference.
peerName

The fully qualified domain name of the peer—for example, store.apple.com. The name is in the form of a C string, except that NULL termination is optional.
peerNameLen

The number of bytes passed in the peerName parameter.
Return Value

A result code. See “Secure Transport Result Codes”.
Discussion

You can use this function to verify the common name field in the peer’s certificate. If you call this function and the common name in the certificate does not match the value you specify in the peerName parameter, then handshake fails and returns errSSLXCertChainInvalid. Use of this function is optional.

This function can be called only when no session is active.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLSetPeerDomainName (
SSLContextRef context,
const char *peerName,
size_t peerNameLen ){
printf ("SSLSetPeerDomainName",context,*peerName,peerNameLen);
};

/*SSLSetAllowsExpiredCerts

Specifies whether certificate expiration times are ignored.

OSStatus SSLSetAllowsExpiredCerts (
SSLContextRef context,
Boolean allowsExpired
);
Parameters
context

An SSL session context reference.
allowsExpired

A Boolean flag representing whether the certificate expiration times are ignored. The default for this flag is false, meaning expired certificates result in an errSSLCertExpired result code.
Return Value

A result code. See “Secure Transport Result Codes”.
Discussion

You can use this function to allow the handshake to succeed even if one or more certificates in the certificate chain have expired. You can use the SSLGetAllowsExpiredCerts function to determine the current setting of the allowsExpired flag.

Use the SSLSetAllowsExpiredRoots function to set a flag specifying whether expired root certificates are allowed.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLSetAllowsExpiredCerts (
SSLContextRef context,
Boolean allowsExpired
){
printf ("SSLSetAllowsExpiredCerts",context,allowsExpired);
};

/*SSLSetAllowsAnyRoot

Specifies whether root certificates from unrecognized certification authorities are allowed.

OSStatus SSLSetAllowsAnyRoot (
SSLContextRef context,
Boolean anyRoot
);
Parameters
context

An SSL session context reference.
anyRoot

A Boolean flag specifying whether root certificates from unrecognized certification authorities (CAs) are allowed. The default for this flag is false, specifying that roots from unrecognized CAs are not allowed.
Return Value

A result code. See “Secure Transport Result Codes”.
Discussion

The system maintains a set of root certificates signed by known, trusted root CAs. When the anyRoot flag is true, Secure Transport does not return an error if one of the following two conditions occurs:
The peer returns a certificate chain with a root certificate, and the chain verifies to that root, but the CA for the root certificate is not one of the known, trusted root CAs. This results in an errSSLUnknownRootCert result code when the anyRoot flag is false.
The peer returns a certificate chain that does not contain a root certificate, and the server can’t verify the chain to one of the trusted root certificates. This results in an errSSLNoRootCert result code when the anyRoot flag is false.

Both of these error conditions are ignored when the anyRoot flag is true, allowing connection to a peer for which trust could not be established.

If you use this function to allow an untrusted root to be used for validation of a certificate—for example, after prompting the user for permission to do so—remember to set the anyRoot Boolean value back to false. If you don’t, any random root certificate can be used for signing a certificate chain. To add a certificate to the list of trusted roots, use the SecTrustSetAnchorCertificates function.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLSetAllowsAnyRoot (
SSLContextRef context,
Boolean anyRoot
){
printf ("SSLSetAllowsAnyRoot ",context,anyRoot);
};

/*SSLSetCertificate

Specifies this connection’s certificate or certificates.

OSStatus SSLSetCertificate (
SSLContextRef context,
CFArrayRef certRefs
);
Parameters
context

An SSL session context reference.
certRefs

The certificates to set. This array contains items of type SecCertificateRef, except for certRefs[0], which is of type SecIdentityRef.
Return Value

A result code. See “Secure Transport Result Codes”.
Discussion

Setting the certificate or certificates is mandatory for server connections, but is optional for clients. Specifying a certificate for a client enables SSL client-side authentication. You must place in certRefs[0] a SecIdentityRef object that identifies the leaf certificate and its corresponding private key. Specifying a root certificate is optional; if it’s not specified, the root certificate that verifies the certificate chain specified here must be present in the system wide set of trusted anchor certificates.

This function can be called only when no session is active.

Secure Transport assumes the following:
The certificate references remain valid for the lifetime of the session.
The identity specified in certRefs[0] is capable of signing.

The required capabilities of the identity specified in certRefs[0], and of the optional certificate specified in the SSLSetEncryptionCertificate function, are highly dependent on the application. For example, to work as a server with Netscape clients, the identity specified here must be capable of both signing and encrypting.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLSetCertificate (
SSLContextRef context,
CFArrayRef certRefs
){
printf ("SSLSetCertificate",context,certRefs);
};

/*SSLSetEncryptionCertificate

Specifies the encryption certificates used for this connection.

OSStatus SSLSetEncryptionCertificate (
SSLContextRef context,
CFArrayRef certRefs
);
Parameters
context

An SSL session context reference. 
certRefs

A value of type CFArrayRef referring to an array of certificate references. The references are type SecCertificateRef, except for certRefs[0], which is of type SecIdentityRef.
Return Value

A result code. See “Secure Transport Result Codes”.
Discussion

Use this function in one of the following cases:
The leaf certificate specified in the SSLSetCertificate function is not capable of encryption.
The leaf certificate specified in the SSLSetCertificate function contains a key that is too large or strong for legal encryption in this session. In this case, a weaker certificate is specified here and is used for server-initiated key exchange.

The following assumptions are made:
The certRefs parameter’s references remain valid for the lifetime of the connection.
The specified certRefs[0] value is capable of encryption.

This function can be called only when no session is active. 

SSL servers that enforce the SSL3 or TLS1 specification to the letter do not accept encryption certificates with key sizes larger than 512 bits for exportable ciphers (that is, for SSL sessions with 40-bit session keys). Therefore, if you wish to support exportable ciphers and your certificate has a key larger than 512 bits, you must specify a separate encryption certificate. 
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLSetEncryptionCertificate (
SSLContextRef context,
CFArrayRef certRefs
){
printf ("SSLSetEncryptionCertificate ",context,certRefs);
};

/*SSLSetPeerID

Specifies data that is sufficient to uniquely identify the peer of the current session.

OSStatus SSLSetPeerID (
SSLContextRef context,
const void *peerID,
size_t peerIDLen
);
Parameters
context

An SSL session context reference.
peerID

A pointer to a buffer containing the peer ID data to set.
peerIDLen

The length of the peer ID data buffer.
Return Value

A result code. See “Secure Transport Result Codes”.
Discussion

Secure Transport uses the peer ID to match the peer of an SSL session with the peer of a previous session in order to resume an interrupted session. If the peer IDs match, Secure Transport attempts to resume the session with the same parameters as used in the previous session with the same peer. 

The data you provide to this function is treated as an opaque blob by Secure Transport but is compared byte for byte with previous peer ID data values set by the current application. An example of peer ID data is an IP address and port, stored in some caller-private manner. Calling this function is optional but is required if you want the session to be resumable. If you do call this function, you must call it prior to the handshake for the current session. 

You can use the SSLGetPeerID function to retrieve the peer ID data for the current session.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLSetPeerID (
SSLContextRef context,
const void *peerID,
size_t peerIDLen
){
printf ("SSLSetPeerID ",context,peerID,peerIDLen);
};


/*SSLHandshake

Performs the SSL handshake.

OSStatus SSLHandshake (
SSLContextRef context
);
Parameters
context

An SSL session context reference. 
Return Value

A result code. See “Secure Transport Result Codes”.
Discussion

On successful return, the session is ready for normal secure communication using the functions SSLRead and SSLWrite.

If it finds any problems with the peer’s certificate chain, Secure Transport aborts the handshake. You can use the SSLGetPeerCertificates function to see the peer’s certificate chain. This function can return a wide variety of result codes, including the following:
errSSLUnknownRootCert—The peer has a valid certificate chain, but the root of the chain is not a known anchor certificate.
errSSLNoRootCert—The peer’s certificate chain was not verifiable to a root certificate. 
errSSLCertExpired—The peer’s certificate chain has one or more expired certificates. 
errSSLXCertChainInvalid—The peer has an invalid certificate chain; for example, signature verification within the chain failed, or no certificates were found.

A return value of errSSLWouldBlock indicates that the SSLHandshake function must be called again until a different result code is returned.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLHandshake (
SSLContextRef context
){
printf (" SSLHandshake",context);
};

/*SSLGetNegotiatedCipher

Retrieves the cipher suite negotiated for this session.

OSStatus SSLGetNegotiatedCipher (
SSLContextRef context,
SSLCipherSuite *cipherSuite
);
Parameters
context

An SSL session context reference.
cipherSuite

On return, points to the cipher suite that was negotiated for this session.
Return Value

A result code. See “Secure Transport Result Codes”.
Discussion

You should call this function only when a session is active.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLGetNegotiatedCipher (
SSLContextRef context,
SSLCipherSuite *cipherSuite
){
printf (" SSLGetNegotiatedCipher ",context,*cipherSuite);
};

/*SSLGetNegotiatedProtocolVersion

Obtains the negotiated protocol version of the active session. 

OSStatus SSLGetNegotiatedProtocolVersion (
SSLContextRef context,
SSLProtocol *protocol
);
Parameters
context

An SSL session context reference.
protocol

On return, points to the negotiated protocol version of the active session.
Return Value

A result code. See “Secure Transport Result Codes”. This function returns kSSLProtocolUnknown if no SSL session is in progress.
Discussion

This function retrieves the version of SSL or TLS protocol negotiated for the session. Note that the negotiated protocol may not be the same as your preferred protocol, depending on which protocol versions you enabled with the SSLSetProtocolVersionEnabled function. This function can return any of the following values:
kSSLProtocol2
kSSLProtocol3
kTLSProtocol1
kSSLProtocolUnknown 
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLGetNegotiatedProtocolVersion (
SSLContextRef context,
SSLProtocol *protocol
){
printf (" SSLGetNegotiatedProtocolVersion ",context,*protocol);
};


/*SSLDisposeContext

Disposes of an SSL session context.

OSStatus SSLDisposeContext (
SSLContextRef context
);
Parameters
context

A reference to the SSL session context to dispose.
Return Value

A result code. See “Secure Transport Result Codes”.
Discussion

When you are completely finished with a secure session, you should dispose of the SSL session context in order to release the memory associated with the session.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLDisposeContext (
SSLContextRef context
){
printf (" SSLDisposeContext  ",context);
};

/*SSLRead

Performs a normal application-level read operation.

OSStatus SSLRead (
SSLContextRef context,
void *data,
size_t dataLength,
size_t *processed
);
Parameters
context

An SSL session context reference.
data

On return, points to the data read. You must allocate this buffer before calling the function. The size of this buffer must be equal to or greater than the value in the dataLength parameter.
dataLength

The amount of data you would like to read. 
processed

On return, points to the number of bytes actually read.
Return Value

A result code. See “Secure Transport Result Codes”.
Discussion

The SSLRead function might call the SSLReadFunc function that you provide (see SSLSetIOFuncs. Because you may configure the underlying connection to operate in a nonblocking manner, a read operation might return errSSLWouldBlock, indicating that less data than requested was actually transferred. In this case, you should repeat the call to SSLRead until some other result is returned. 
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLRead (
SSLContextRef context,
void *data,
size_t dataLength,
size_t *processed
){
printf ("SSLRead",context,data,dataLength,*processed);
};

/*SSLWrite

Performs a normal application-level write operation.

OSStatus SSLWrite (
SSLContextRef context,
const void *data,
size_t dataLength,
size_t *processed
);
Parameters
context

An SSL session context reference.
data

A pointer to the buffer of data to write.
dataLength

The amount, in bytes, of data to write.
processed

On return, the length, in bytes, of the data actually written.
Return Value

A result code. See “Secure Transport Result Codes”.
Discussion

The SSLWrite function might call the SSLWriteFunc function that you provide (see SSLSetIOFuncs). Because you may configure the underlying connection to operate in a no-blocking manner, a write operation might return errSSLWouldBlock, indicating that less data than requested was actually transferred. In this case, you should repeat the call to SSLWrite until some other result is returned. 
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLWrite (
SSLContextRef context,
const void *data,
size_t dataLength,
size_t *processed
){
printf ("SSLWrite",context,data,dataLength,*processed);
};

/*SSLClose

Terminates the current SSL session.

OSStatus SSLClose (
SSLContextRef context
);
Parameters
context

The SSL session context reference of the session you want to terminate.
Return Value

A result code. See “Secure Transport Result Codes”.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLClose (
SSLContextRef context
){
printf ("SSLClose",context);
};

/*SSLGetPeerID

Retrieves the current peer ID data.

OSStatus SSLGetPeerID (
SSLContextRef context,
const void **peerID,
size_t *peerIDLen
);
Parameters
context

An SSL session context reference. 
peerID

On return, points to a buffer containing the peer ID data. 
peerIDLen

On return, the length of the peer ID data buffer. 
Return Value

A result code. See “Secure Transport Result Codes”.
Discussion

If the peer ID data for this context was not set by calling the SSLSetPeerID function, this function returns a NULL pointer in the peerID parameter, and 0 in the peerIDLen parameter. 
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLGetPeerID (
SSLContextRef context,
const void **peerID,
size_t *peerIDLen
){
printf ("SSLGetPeerID",context,peerID,*peerIDLen);
};

/*SSLGetBufferedReadSize

Determines how much data is available to be read.

OSStatus SSLGetBufferedReadSize (
SSLContextRef context,
size_t *bufSize
);
Parameters
context

An SSL session context reference.
bufSize

On return, the size of the data to be read.
Return Value

A result code. See “Secure Transport Result Codes”.
Discussion

This function determines how much data you can be guaranteed to obtain in a call to the SSLRead function. This function does not block or cause any low-level read operations to occur.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecureTransport.h*/
OSStatus SSLGetBufferedReadSize (
SSLContextRef context,
size_t *bufSize
){
printf ("SSLGetBufferedReadSize",context,*bufSize);
};

