#include <SyncServices/ISyncManager.h>

@implementation  ISyncManager
//work

/*sharedManager

Returns a shared ISyncManager object.

+ (ISyncManager *)sharedManager
Availability
Available in Mac OS X v10.4 and later.*/
+ (ISyncManager *)sharedManager{}

/*clientWithIdentifier:

Returns the sync client identified by clientIdentifier, or nil if not found.

- (ISyncClient *)clientWithIdentifier:(NSString *)clientIdentifier
Availability
Available in Mac OS X v10.4 and later.
See Also
registerClientWithIdentifier:descriptionFilePath:
unregisterClient:*/
- (ISyncClient *)clientWithIdentifier:(NSString *)clientIdentifier{}

/*registerClientWithIdentifier:descriptionFilePath:

Returns an existing or new sync client uniquely identified by clientIdentifier. 

- (ISyncClient *)registerClientWithIdentifier:(NSString *)clientIdentifier descriptionFilePath:(NSString *)descriptionFilePath
Discussion

There are no restrictions on the content or length of clientIdentifier, but it must be unique across all clients. Typically, it’s a DNS-style name such as com.apple.iCal.

The client description file located at descriptionFilePath is a property list that specifies client information that the sync engine needs to know to sync its records. For example, the client description file a list of the client supported entities and properties. See Sync Services Programming Guide for a complete description of the client description file.

If the client already exists, then invoking this method updates the client description. If the set of supported entities and properties changes, the sync engine may force the client to slow sync the next time it syncs. This can be expensive, so only reregister a client if necessary.
Availability
Available in Mac OS X v10.4 and later.
See Also
clientWithIdentifier:
unregisterClient:
canPullChangesForEntityName: (ISyncClient)
canPushChangesForEntityName: (ISyncClient)
displayName (ISyncClient)
imagePath (ISyncClient)*/
- (ISyncClient *)registerClientWithIdentifier:(NSString *)clientIdentifier descriptionFilePath:(NSString *)descriptionFilePath{}


/*snapshotOfRecordsInTruthWithEntityNames:usingIdentifiersForClient:

Returns an immutable snapshot of the records for entityNames from the truth database.

- (ISyncRecordSnapshot *)snapshotOfRecordsInTruthWithEntityNames:(NSArray *)entityNames usingIdentifiersForClient:(ISyncClient *)client
Discussion

The truth database stores a copy of all the synced records and contains the amalgamation of all entities and properties from all clients. The snapshot is made of the records for entities specified by the entityNames argument, an array of NSString objects containing the names of entities. You access the records by sending messages to the returned ISyncRecordSnapshot object.

Each client has its own name space for record identifiers. The client argument specifies the name space you want to use. If client is nil or invalid, the record identifiers from the sync engine’s global name space are used.

The snapshot is an immutable copy of the records taken at the time returned object is created. If the truth database is subsequently modified, the changes are not be reflected in the snapshot. You should create a new snapshot if you want up-to-date records.

Do not use this method if you are syncing and want a snapshot that is consistent with the sync session. Another client may be pushing changes that you have not pulled yet. Instead, you can use the ISyncSession snapshotOfRecordsInTruth method to get the state of a session.
Availability
Available in Mac OS X v10.4 and later.
See Also
clientWithIdentifier:*/
- (ISyncRecordSnapshot *)snapshotOfRecordsInTruthWithEntityNames:(NSArray *)entityNames usingIdentifiersForClient:(ISyncClient *)client{}




@end
