#include <SystemConfiguration/SystemConfiguration.h>

/*SCNetworkInterfaceCopyAll

CFArrayRef // of SCNetworkInterfaceRef's 
SCNetworkInterfaceCopyAll (
    void);  
Return Value

The list of SCNetworkInterface devices on the system. You must release the returned value. 
Discussion 

Returns all network capable devices on the system. 
Availability
Introduced in Mac OS X v10.4.*/
CFArrayRef // of SCNetworkInterfaceRef's
SCNetworkInterfaceCopyAll (
    void){};

  

/*SCNetworkInterfaceGetInterfaceType

CFStringRef SCNetworkInterfaceGetInterfaceType (
    SCNetworkInterfaceRef interface);  
Parameters
interface
The network interface.
Return Value

The interface type. 
Discussion 

Returns the associated network interface type. 
Availability
Introduced in Mac OS X v10.4.*/

CFStringRef SCNetworkInterfaceGetInterfaceType (
    SCNetworkInterfaceRef interface){};

  
/*SCNetworkInterfaceGetBSDName

CFStringRef SCNetworkInterfaceGetBSDName (
    SCNetworkInterfaceRef interface);  
Parameters
interface
The network interface.
Return Value

The BSD name associated with the interface (e.g. "en0"); NULL if no BSD name is available. 
Discussion 

Returns the BSD interface (en0) or device name (modem) for the interface. 
Availability
Introduced in Mac OS X v10.4.*/

CFStringRef SCNetworkInterfaceGetBSDName (
    SCNetworkInterfaceRef interface){};
  

/*SCNetworkInterfaceGetHardwareAddressString

CFStringRef SCNetworkInterfaceGetHardwareAddressString (
    SCNetworkInterfaceRef interface);  
Parameters
interface
The network interface.
Return Value

A string representing the hardware (MAC) address for the interface. 
Discussion 

Returns a displayable link layer address for the interface. 
Availability
Introduced in Mac OS X v10.4.*/
CFStringRef SCNetworkInterfaceGetHardwareAddressString (
    SCNetworkInterfaceRef interface){};

 /*SCNetworkInterfaceGetLocalizedDisplayName

CFStringRef SCNetworkInterfaceGetLocalizedDisplayName (
    SCNetworkInterfaceRef interface);  
Parameters
interface
The network interface.
Return Value

A localized, display name for the interface; NULL if no name is available. 
Discussion 

Returns the localized name (e.g. "Built-in Ethernet") for the interface. 
Availability
Introduced in Mac OS X v10.4.*/
CFStringRef SCNetworkInterfaceGetLocalizedDisplayName (
    SCNetworkInterfaceRef interface){};  

/*kSCNetworkInterfaceTypeModem

extern const CFStringRef kSCNetworkInterfaceTypeModem;  
Availability
Introduced in Mac OS X v10.4.*/
const CFStringRef kSCNetworkInterfaceTypeModem;  

/*kSCNetworkInterfaceTypeIEEE80211

extern const CFStringRef kSCNetworkInterfaceTypeIEEE80211;  // IEEE 802.11, AirPort 
Availability
Introduced in Mac OS X v10.4.*/
const CFStringRef kSCNetworkInterfaceTypeIEEE80211;  // IEEE 802.11, AirPort 


/*kSCNetworkInterfaceTypeFireWire

extern const CFStringRef kSCNetworkInterfaceTypeFireWire;  
Availability
Introduced in Mac OS X v10.4.*/
const CFStringRef kSCNetworkInterfaceTypeFireWire;  

/*kSCNetworkInterfaceTypeEthernet

extern const CFStringRef kSCNetworkInterfaceTypeEthernet;  
Availability
Introduced in Mac OS X v10.4.*/
const CFStringRef kSCNetworkInterfaceTypeEthernet;  

/*kSCNetworkInterfaceTypeBluetooth

extern const CFStringRef kSCNetworkInterfaceTypeBluetooth;  
Availability
Introduced in Mac OS X v10.4.*/
const CFStringRef kSCNetworkInterfaceTypeBluetooth;  

