/*
 * Decompiled with CFR 0.152.
 */
package info.jinwoomin.p1cartoon;

import java.util.Observable;

public class PageCounter
extends Observable {
    private int curPage = 0;
    private int totalPage = 0;

    public void setCurPage(int page) {
        this.curPage = page;
    }

    public void setTotalPage(int page) {
        this.totalPage = page;
    }

    public int getCurPage() {
        return this.curPage;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public void changeCurPage(int page) {
        this.setCurPage(page);
        this.setChanged();
        this.notifyObservers();
    }

    public void changeTotalPage(int page) {
        this.setTotalPage(page);
        this.setChanged();
        this.notifyObservers();
    }

    public void setChanged() {
        super.setChanged();
        this.notifyObservers();
    }

    public void goNextPage() {
        int page = this.getCurPage();
        if (++page > this.getTotalPage() - 1) {
            page = this.getTotalPage() - 1;
        }
        this.changeCurPage(page);
    }

    public void goPrevPage() {
        int page = this.getCurPage();
        if (--page < 0) {
            page = 0;
        }
        this.changeCurPage(page);
    }
}

