/*
 * Decompiled with CFR 0.152.
 */
package info.jinwoomin.p1cartoon;

import com.ibm.java2dhelper.Graphics2DRenderer;
import info.jinwoomin.logging.ILoggable;
import info.jinwoomin.logging.ILogger;
import info.jinwoomin.logging.SimpleLogger;
import info.jinwoomin.p1cartoon.data.P1CartoonData;
import info.jinwoomin.p1cartoon.gui.AboutDialog;
import info.jinwoomin.p1cartoon.gui.FolderSetter;
import info.jinwoomin.p1cartoon.gui.SettingsDialog;
import java.awt.Button;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.io.File;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class P1Cartoon
implements ILoggable,
Observer,
KeyListener {
    private Shell sShell = null;
    private Composite compositeCanvas = null;
    private Canvas canvas = null;
    private ToolBar toolBar = null;
    private Graphics2DRenderer renderer = new Graphics2DRenderer();
    private Cursor arrowCursor = null;
    private Cursor waitCursor = null;
    private Cursor prevCursor = null;
    private Cursor nextCursor = null;
    private ILogger logger = null;
    private P1CartoonData data = null;
    private Button comp = new Button();
    private Image awtImage = null;
    private org.eclipse.swt.graphics.Image image = null;
    private static final int _TOOLITEM_ID_TWO_IN_ONE_PAGE = 7;
    private static final int _TOOLITEM_ID_RIGHT_TO_LEFT = 8;
    private static final int _TOOLITEM_ID_AUTO_MODE = 9;
    private static final int _TOOLITEM_ID_RESAMPLE = 11;
    private static final int _TOOLITEM_ID_MOUSE_CLICK = 13;

    private void createCompositeCanvas() {
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.marginWidth = 0;
        gridLayout1.marginHeight = 0;
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.grabExcessVerticalSpace = true;
        gridData1.verticalAlignment = 4;
        this.compositeCanvas = new Composite((Composite)this.sShell, 0);
        this.compositeCanvas.setLayoutData((Object)gridData1);
        this.compositeCanvas.setLayout((Layout)gridLayout1);
        this.createCanvas();
    }

    private void createCanvas() {
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = true;
        gridData2.verticalAlignment = 4;
        this.canvas = new Canvas(this.compositeCanvas, 0);
        this.canvas.setLayoutData((Object)gridData2);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int srcHeight;
                int srcWidth;
                int srcY;
                int srcX;
                if (P1Cartoon.this.data.isAutoMode()) {
                    if (((P1Cartoon)P1Cartoon.this).image.getImageData().width > ((P1Cartoon)P1Cartoon.this).image.getImageData().height) {
                        if (!P1Cartoon.this.data.isRightToLeft()) {
                            P1Cartoon.this.data.setCurrPosition(1);
                        }
                        P1Cartoon.this.data.setTwoInOnePage(true);
                        P1Cartoon.this.data.setRightToLeft(true);
                    } else {
                        P1Cartoon.this.data.setTwoInOnePage(false);
                        P1Cartoon.this.data.setRightToLeft(false);
                    }
                }
                if (P1Cartoon.this.data.isTwoInOnePage()) {
                    srcX = ((P1Cartoon)P1Cartoon.this).image.getImageData().width / 2 * P1Cartoon.this.data.getCurrPosition();
                    srcY = 0;
                    srcWidth = ((P1Cartoon)P1Cartoon.this).image.getImageData().width / 2;
                    srcHeight = ((P1Cartoon)P1Cartoon.this).image.getImageData().height;
                } else {
                    srcX = 0;
                    srcY = 0;
                    srcWidth = ((P1Cartoon)P1Cartoon.this).image.getImageData().width;
                    srcHeight = ((P1Cartoon)P1Cartoon.this).image.getImageData().height;
                }
                P1Cartoon.this.logger.debug("useResample=[" + P1Cartoon.this.data.isUseResample() + "]");
                if (P1Cartoon.this.data.isUseResample()) {
                    GC gc = e.gc;
                    P1Cartoon.this.renderer.prepareRendering(gc);
                    Graphics2D g2d = P1Cartoon.this.renderer.getGraphics2D();
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                    g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g2d.drawImage(P1Cartoon.this.awtImage, 0, 0, ((P1Cartoon)P1Cartoon.this).canvas.getSize().x, ((P1Cartoon)P1Cartoon.this).canvas.getSize().y, srcX, srcY, srcX + srcWidth, srcHeight, null);
                    P1Cartoon.this.renderer.render(gc);
                } else {
                    e.gc.drawImage(P1Cartoon.this.image, srcX, srcY, srcWidth, srcHeight, 0, 0, ((P1Cartoon)P1Cartoon.this).canvas.getSize().x, ((P1Cartoon)P1Cartoon.this).canvas.getSize().y);
                }
            }
        });
        this.canvas.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (!P1Cartoon.this.data.isUseMouseClick()) {
                    P1Cartoon.this.canvas.setCursor(null);
                    return;
                }
                P1Cartoon.this.logger.debug(e.toString());
                P1Cartoon.this.canvas.setCursor(P1Cartoon.this.waitCursor);
                if (e.y > ((P1Cartoon)P1Cartoon.this).canvas.getSize().y / 2) {
                    P1Cartoon.this.data.goNextPage();
                } else {
                    P1Cartoon.this.data.goPrevPage();
                }
                P1Cartoon.this.reloadImage();
                P1Cartoon.this.canvas.redraw();
                P1Cartoon.this.canvas.setCursor(null);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (!P1Cartoon.this.data.isUseMouseClick()) {
                    P1Cartoon.this.canvas.setCursor(null);
                    return;
                }
                P1Cartoon.this.logger.debug(e.toString());
                if (e.y > ((P1Cartoon)P1Cartoon.this).canvas.getSize().y / 2) {
                    P1Cartoon.this.canvas.setCursor(P1Cartoon.this.nextCursor);
                } else {
                    P1Cartoon.this.canvas.setCursor(P1Cartoon.this.prevCursor);
                }
            }
        });
        this.canvas.addKeyListener((KeyListener)this);
    }

    private void createToolBar() {
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.heightHint = -1;
        gridData3.verticalAlignment = 2;
        this.toolBar = new ToolBar((Composite)this.sShell, 0x800000);
        this.toolBar.setLayoutData((Object)gridData3);
        ToolItem toolItem2 = new ToolItem(this.toolBar, 2);
        ToolItem toolItemAbout = new ToolItem(this.toolBar, 8);
        toolItemAbout.setText("");
        toolItemAbout.setToolTipText("About P1Cartoon");
        toolItemAbout.setImage(new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/ico4346.ico")));
        toolItemAbout.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AboutDialog dialog = new AboutDialog();
                dialog.open(P1Cartoon.this.sShell.getDisplay());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ToolItem toolItem = new ToolItem(this.toolBar, 2);
        ToolItem toolItemFolder = new ToolItem(this.toolBar, 8);
        toolItemFolder.setText("");
        toolItemFolder.setToolTipText("Open folder");
        toolItemFolder.setImage(new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/ico3602.ico")));
        ToolItem toolItem6 = new ToolItem(this.toolBar, 2);
        toolItemFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FolderSetter fs = new FolderSetter(P1Cartoon.this.sShell, P1Cartoon.this.data);
                String folder = fs.open();
                if (folder != null) {
                    P1Cartoon.this.data.setFolder(folder);
                    P1Cartoon.this.logger.info("Choosed new cartoons folder. [" + folder + "]");
                    P1Cartoon.this.data.changeCurPage(0);
                    P1Cartoon.this.data.loadFileList();
                    P1Cartoon.this.reloadImage();
                    P1Cartoon.this.canvas.redraw();
                } else {
                    P1Cartoon.this.logger.info("Setting new cartoons folder canceled.");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ToolItem toolItemSettings = new ToolItem(this.toolBar, 8);
        toolItemSettings.setText("");
        toolItemSettings.setToolTipText("Settings...");
        toolItemSettings.setImage(new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/ico3470.ico")));
        ToolItem toolItem1 = new ToolItem(this.toolBar, 2);
        ToolItem toolItemTwoInOnePages = new ToolItem(this.toolBar, 32);
        toolItemTwoInOnePages.setImage(new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/ico1259.ico")));
        ToolItem toolItemRightToLeft = new ToolItem(this.toolBar, 32);
        toolItemRightToLeft.setImage(new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/right2left.png")));
        ToolItem toolItemAutoMode = new ToolItem(this.toolBar, 32);
        toolItemAutoMode.setImage(new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/ico2035.ico")));
        ToolItem toolItem5 = new ToolItem(this.toolBar, 2);
        toolItemRightToLeft.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                P1Cartoon.this.data.setRightToLeft(((ToolItem)e.getSource()).getSelection());
                P1Cartoon.this.canvas.redraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        toolItemTwoInOnePages.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                P1Cartoon.this.data.setTwoInOnePage(((ToolItem)e.getSource()).getSelection());
                P1Cartoon.this.dataToControl();
                P1Cartoon.this.canvas.redraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ToolItem toolItemResample = new ToolItem(this.toolBar, 32);
        toolItemResample.setImage(new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/resample.png")));
        toolItemResample.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                P1Cartoon.this.data.setUseResample(((ToolItem)e.getSource()).getSelection());
                P1Cartoon.this.canvas.redraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        toolItemAutoMode.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ToolItem item = (ToolItem)e.getSource();
                P1Cartoon.this.data.setAutoMode(item.getSelection());
                P1Cartoon.this.dataToControl();
                P1Cartoon.this.canvas.redraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ToolItem toolItem3 = new ToolItem(this.toolBar, 2);
        ToolItem toolItemMouseClick = new ToolItem(this.toolBar, 32);
        toolItemMouseClick.setImage(new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/ico2034.ico")));
        ToolItem toolItem4 = new ToolItem(this.toolBar, 2);
        toolItemMouseClick.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                P1Cartoon.this.data.setUseMouseClick(((ToolItem)e.getSource()).getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        toolItemSettings.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SettingsDialog dialog = new SettingsDialog();
                dialog.open(P1Cartoon.this.sShell.getDisplay(), P1Cartoon.this.data);
                P1Cartoon.this.dataToControl();
                P1Cartoon.this.canvas.redraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void setData(P1CartoonData data) {
        this.data = data;
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        P1Cartoon thisClass = new P1Cartoon();
        SimpleLogger logger = new SimpleLogger();
        P1CartoonData data = new P1CartoonData();
        data.setLogger(logger);
        data.load();
        thisClass.setLogger(logger);
        thisClass.setData(data);
        thisClass.createSShell();
        thisClass.ready();
        thisClass.sShell.open();
        while (!thisClass.sShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
        data.save();
    }

    private void createSShell() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.sShell = new Shell();
        this.sShell.setText("P1Cartoon");
        this.sShell.setImage(new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream("/pooh.ico")));
        this.createCompositeCanvas();
        this.sShell.setLayout((Layout)gridLayout);
        this.createToolBar();
        this.sShell.setSize(new Point(299, 305));
        this.sShell.addKeyListener((KeyListener)this);
    }

    public void dataToControl() {
        this.toolBar.getItem(7).setSelection(this.data.isTwoInOnePage());
        this.toolBar.getItem(8).setSelection(this.data.isRightToLeft());
        this.toolBar.getItem(9).setSelection(this.data.isAutoMode());
        this.toolBar.getItem(11).setSelection(this.data.isUseResample());
        this.toolBar.getItem(13).setSelection(this.data.isUseMouseClick());
        if (this.data.isAutoMode()) {
            this.toolBar.getItem(7).setEnabled(false);
            this.toolBar.getItem(8).setEnabled(false);
        } else {
            this.toolBar.getItem(7).setEnabled(true);
            this.toolBar.getItem(8).setEnabled(this.data.isTwoInOnePage());
        }
    }

    public void ready() {
        this.waitCursor = new Cursor((Device)Display.getCurrent(), 1);
        this.prevCursor = new Cursor((Device)Display.getCurrent(), 21);
        this.nextCursor = new Cursor((Device)Display.getCurrent(), 21);
        this.dataToControl();
        this.toolBar.getItem(9).setToolTipText("\ud398\uc774\uc9c0 \ud06c\uae30\ub97c \uc790\ub3d9\uc73c\ub85c \ud310\ub2e8\ud574\uc11c 2 in 1 page, Right to left \uc635\uc158\uc744 \uc124\uc815\ud574 \uc90d\ub2c8\ub2e4.");
        this.toolBar.getItem(7).setToolTipText("2\uba74\uc744 \ud55c \uc7a5\uc758 \uc774\ubbf8\uc9c0\uc5d0 \uc2a4\uce94\ud55c \uacbd\uc6b0 \uccb4\ud06c\ud569\ub2c8\ub2e4.");
        this.toolBar.getItem(8).setToolTipText("2\uba74\uc774 \ud55c \uc7a5\uc758 \uc774\ubbf8\uc9c0\uc774\uace0 \uc624\ub978\ucabd\uc5d0\uc11c \uc67c\ucabd\uc73c\ub85c \uc77d\uc5b4\uc57c \ud558\ub294 \uacbd\uc6b0 \uccb4\ud06c\ud569\ub2c8\ub2e4.");
        this.toolBar.getItem(11).setToolTipText("\uc774\ubbf8\uc9c0\ub97c \uc880 \ub354 \ubd80\ub4dc\ub7fd\uac8c \ubcf4\ub824\uba74 \uccb4\ud06c\ud569\ub2c8\ub2e4.");
        this.toolBar.getItem(13).setToolTipText("\ub9c8\uc6b0\uc2a4\ub97c \ud074\ub9ad\ud574\uc11c \ud398\uc774\uc9c0\ub97c \uc774\ub3d9\ud569\ub2c8\ub2e4. \uc911\uc559\uc5d0\uc11c \uc704\ucabd\uc744 \ud074\ub9ad\ud558\uba74 \uc774\uc804 \ud398\uc774\uc9c0\ub85c, \uc544\ub798\ub97c \ud074\ub9ad\ud558\uba74 \ub2e4\uc74c \ud398\uc774\uc9c0\ub85c \uc774\ub3d9\ud569\ub2c8\ub2e4.");
        this.image = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/pooh.jpg")).createImage();
        this.data.addObserver(this);
        if (this.data.getFolder() != null) {
            this.data.loadFileList();
            this.reloadImage();
            this.canvas.redraw();
            this.data.setChanged();
        }
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public static boolean waitForImage(Image image, Component c) {
        MediaTracker tracker = new MediaTracker(c);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !tracker.isErrorAny();
    }

    public void reloadImage() {
        File imageFile = this.data.getCurrImageFile();
        if (imageFile != null) {
            this.sShell.setCursor(this.waitCursor);
            this.image.dispose();
            this.image = new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), imageFile.getAbsolutePath());
            this.awtImage = this.comp.getToolkit().getImage(imageFile.getAbsolutePath());
            P1Cartoon.waitForImage(this.awtImage, this.comp);
            this.logger.info("New image loaded. [" + imageFile.getName() + "]");
            this.sShell.setCursor(this.arrowCursor);
        }
    }

    public void update(Observable observable, Object arg1) {
        this.logger.debug("observable=[" + observable + "]");
        if (observable instanceof P1CartoonData) {
            P1CartoonData data = (P1CartoonData)observable;
            if (data.getTotalPage() == 0 || data.getFolder() == null) {
                this.sShell.setText("P1Cartoon 0.4");
            } else {
                this.sShell.setText("P1Cartoon 0.4 [" + data.getFolder() + "] - " + new Integer(data.getCurPage() + 1).toString() + "/" + new Integer(data.getTotalPage()).toString());
            }
        }
    }

    public void keyPressed(KeyEvent e) {
        this.logger.debug(e.toString());
        switch (e.keyCode) {
            case 0x1000006: {
                this.logger.debug("page down");
                this.data.pageDown();
                this.reloadImage();
                this.canvas.redraw();
                break;
            }
            case 0x1000005: {
                this.logger.debug("page up");
                this.data.pageUp();
                this.reloadImage();
                this.canvas.redraw();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

