/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICS;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICSA;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICSW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.Item;

public class ExpandItem
extends Item {
    ExpandBar parent;
    Control control;
    boolean expanded;
    boolean hover;
    int x;
    int y;
    int width;
    int height;
    static final int TEXT_INSET = 6;
    static final int BORDER = 1;

    public ExpandItem(ExpandBar parent, int style) {
        this(parent, style, ExpandItem.checkNull(parent).getItemCount());
    }

    public ExpandItem(ExpandBar parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, style, index);
    }

    static ExpandBar checkNull(ExpandBar control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    private void drawChevron(int hDC, RECT rect) {
        int[] polyline2;
        int[] polyline1;
        int py;
        int px;
        rect.left += 4;
        rect.top += 4;
        rect.right -= 4;
        rect.bottom -= 4;
        int blackPen = OS.CreatePen(0, 1, 0);
        int oldPen = OS.SelectObject(hDC, blackPen);
        if (this.expanded) {
            px = rect.left + 5;
            py = rect.top + 7;
            polyline1 = new int[]{px, py, px + 1, py, px + 1, py - 1, px + 2, py - 1, px + 2, py - 2, px + 3, py - 2, px + 3, py - 3, px + 3, py - 2, px + 4, py - 2, px + 4, py - 1, px + 5, py - 1, px + 5, py, px + 7, py};
            polyline2 = new int[]{px, py += 4, px + 1, py, px + 1, py - 1, px + 2, py - 1, px + 2, py - 2, px + 3, py - 2, px + 3, py - 3, px + 3, py - 2, px + 4, py - 2, px + 4, py - 1, px + 5, py - 1, px + 5, py, px + 7, py};
        } else {
            px = rect.left + 5;
            py = rect.top + 4;
            polyline1 = new int[]{px, py, px + 1, py, px + 1, py + 1, px + 2, py + 1, px + 2, py + 2, px + 3, py + 2, px + 3, py + 3, px + 3, py + 2, px + 4, py + 2, px + 4, py + 1, px + 5, py + 1, px + 5, py, px + 7, py};
            polyline2 = new int[]{px, py += 4, px + 1, py, px + 1, py + 1, px + 2, py + 1, px + 2, py + 2, px + 3, py + 2, px + 3, py + 3, px + 3, py + 2, px + 4, py + 2, px + 4, py + 1, px + 5, py + 1, px + 5, py, px + 7, py};
        }
        OS.Polyline(hDC, polyline1, polyline1.length / 2);
        OS.Polyline(hDC, polyline2, polyline2.length / 2);
        if (this.hover) {
            int whitePen = OS.CreatePen(0, 1, OS.GetSysColor(OS.COLOR_3DHILIGHT));
            int darkGrayPen = OS.CreatePen(0, 1, OS.GetSysColor(OS.COLOR_3DSHADOW));
            OS.SelectObject(hDC, whitePen);
            OS.MoveToEx(hDC, rect.left, rect.bottom, 0);
            OS.LineTo(hDC, rect.left, rect.top);
            OS.LineTo(hDC, rect.right, rect.top);
            OS.SelectObject(hDC, darkGrayPen);
            OS.LineTo(hDC, rect.right, rect.bottom);
            OS.LineTo(hDC, rect.left, rect.bottom);
            OS.SelectObject(hDC, oldPen);
            OS.DeleteObject(whitePen);
            OS.DeleteObject(darkGrayPen);
        } else {
            OS.SelectObject(hDC, oldPen);
        }
        OS.DeleteObject(blackPen);
    }

    void drawItem(GC gc, int hTheme, RECT clipRect, boolean drawFocus) {
        int hDC = gc.handle;
        int headerHeight = 24;
        RECT rect = new RECT();
        OS.SetRect(rect, this.x, this.y, this.x + this.width, this.y + headerHeight);
        if (hTheme != 0) {
            OS.DrawThemeBackground(hTheme, hDC, 8, 0, rect, clipRect);
        } else {
            int oldBrush = OS.SelectObject(hDC, OS.GetSysColorBrush(OS.COLOR_BTNFACE));
            OS.PatBlt(hDC, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, 15728673);
            OS.SelectObject(hDC, oldBrush);
        }
        if (this.image != null) {
            rect.left += 6;
            Rectangle bounds = this.image.getBounds();
            if (bounds.height > headerHeight) {
                gc.drawImage(this.image, 0, 0, bounds.width, bounds.height, rect.left, rect.top, bounds.width, headerHeight);
            } else {
                gc.drawImage(this.image, rect.left, rect.top + (headerHeight - bounds.height) / 2);
            }
            rect.left += bounds.width;
        }
        if (this.text.length() > 0) {
            rect.left += 6;
            TCHAR buffer = new TCHAR(this.parent.getCodePage(), this.text, false);
            if (hTheme != 0) {
                OS.DrawThemeText(hTheme, hDC, 8, 0, buffer.chars, buffer.length(), 36, 0, rect);
            } else {
                NONCLIENTMETRICS info = OS.IsUnicode ? new NONCLIENTMETRICSW() : new NONCLIENTMETRICSA();
                info.cbSize = NONCLIENTMETRICS.sizeof;
                int hFont = 0;
                int oldFont = 0;
                if (OS.SystemParametersInfo(41, 0, info, 0)) {
                    LOGFONT logFont = OS.IsUnicode ? info.lfCaptionFont : ((NONCLIENTMETRICSA)info).lfCaptionFont;
                    hFont = OS.CreateFontIndirect(logFont);
                    oldFont = OS.SelectObject(hDC, hFont);
                }
                int oldBkMode = OS.SetBkMode(hDC, 1);
                OS.DrawText(hDC, buffer, buffer.length(), rect, 36);
                OS.SetBkMode(hDC, oldBkMode);
                if (hFont != 0) {
                    OS.SelectObject(hDC, oldFont);
                    OS.DeleteObject(hFont);
                }
            }
        }
        rect.left = rect.right - headerHeight;
        if (hTheme != 0) {
            int partID = this.expanded ? 6 : 7;
            int stateID = this.hover ? 2 : 1;
            OS.DrawThemeBackground(hTheme, hDC, partID, stateID, rect, clipRect);
        } else {
            this.drawChevron(hDC, rect);
        }
        if (drawFocus) {
            OS.SetRect(rect, this.x + 1, this.y + 1, this.x + this.width - 2, this.y + headerHeight - 2);
            OS.DrawFocusRect(hDC, rect);
        }
        if (this.expanded && (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed())) {
            int pen = OS.CreatePen(0, 1, OS.GetSysColor(OS.COLOR_BTNFACE));
            int oldPen = OS.SelectObject(hDC, pen);
            OS.MoveToEx(hDC, this.x, this.y + headerHeight, 0);
            OS.LineTo(hDC, this.x, this.y + headerHeight + this.height);
            OS.LineTo(hDC, this.x + this.width - 1, this.y + headerHeight + this.height);
            OS.LineTo(hDC, this.x + this.width - 1, this.y + headerHeight - 1);
            OS.SelectObject(hDC, oldPen);
            OS.DeleteObject(pen);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public int getHeight() {
        this.checkWidget();
        return this.height;
    }

    public ExpandBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getPreferredWidth(int hTheme, int hDC) {
        int width = 36;
        if (this.image != null) {
            width += 6;
            width += this.image.getBounds().width;
        }
        if (this.text.length() > 0) {
            RECT rect = new RECT();
            TCHAR buffer = new TCHAR(this.parent.getCodePage(), this.text, false);
            if (hTheme != 0) {
                OS.GetThemeTextExtent(hTheme, hDC, 8, 0, buffer.chars, buffer.length(), 32, null, rect);
            } else {
                NONCLIENTMETRICS info = OS.IsUnicode ? new NONCLIENTMETRICSW() : new NONCLIENTMETRICSA();
                info.cbSize = NONCLIENTMETRICS.sizeof;
                int hFont = 0;
                int oldFont = 0;
                if (OS.SystemParametersInfo(41, 0, info, 0)) {
                    LOGFONT logFont = OS.IsUnicode ? info.lfCaptionFont : ((NONCLIENTMETRICSA)info).lfCaptionFont;
                    hFont = OS.CreateFontIndirect(logFont);
                    oldFont = OS.SelectObject(hDC, hFont);
                }
                OS.DrawText(hDC, buffer, buffer.length(), rect, 1024);
                if (hFont != 0) {
                    OS.SelectObject(hDC, oldFont);
                    OS.DeleteObject(hFont);
                }
            }
            width += rect.right - rect.left;
        }
        return width;
    }

    void redraw(boolean all) {
        int parentHandle = this.parent.handle;
        RECT rect = new RECT();
        int left = all ? this.x : this.x + this.width - 24;
        OS.SetRect(rect, left, this.y, this.x + this.width, this.y + 24);
        OS.InvalidateRect(parentHandle, rect, true);
        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
            OS.SetRect(rect, this.x, this.y + 24, this.x + this.width, this.y + 24 + this.height + 1);
            OS.InvalidateRect(parentHandle, rect, true);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
    }

    void setBounds(int x, int y, int width, int height, boolean move, boolean size) {
        this.redraw(true);
        int flags = 55;
        if (move) {
            this.x = x;
            this.y = y;
            flags &= 0xFFFFFFFD;
            this.redraw(true);
        }
        if (size) {
            this.width = width;
            this.height = height;
            flags &= 0xFFFFFFFE;
            this.redraw(true);
        }
        if (this.control != null && !this.control.isDisposed()) {
            int hwnd = this.control.handle;
            if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
                ++x;
                width = Math.max(0, width - 2);
                height = Math.max(0, height - 1);
            }
            this.SetWindowPos(hwnd, 0, x, y + 24, width, height, flags);
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        this.control = control;
        if (control != null) {
            int hwnd = control.handle;
            OS.ShowWindow(hwnd, this.expanded ? 5 : 0);
            int flags = 52;
            if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
                ++this.x;
                this.width = Math.max(0, this.width - 2);
                this.height = Math.max(0, this.height - 1);
            }
            this.SetWindowPos(hwnd, 0, this.x, this.y + 24, this.width, this.height, flags);
        }
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        this.expanded = expanded;
        this.parent.showItem(this.parent.indexOf(this));
    }

    public void setHeight(int height) {
        this.checkWidget();
        if (height < 0) {
            return;
        }
        this.setBounds(0, 0, this.width, height, false, true);
        if (this.expanded) {
            this.parent.layoutItems(this.parent.indexOf(this) + 1, true);
        }
    }

    public void setImage(Image image) {
        super.setImage(image);
        this.redraw(true);
    }

    public void setText(String string) {
        super.setText(string);
        this.redraw(true);
    }
}

