/*
 * Decompiled with CFR 0.152.
 */
package info.jinwoomin.p1cartoon.data;

import info.jinwoomin.logging.ILoggable;
import info.jinwoomin.logging.ILogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Properties;

public class P1CartoonData
extends Observable
implements ILoggable {
    private ILogger logger = null;
    private List imageFiles = new ArrayList();
    private String folder = new String();
    private boolean isAutoMode = false;
    private boolean isTwoInOnePage = false;
    private boolean isRightToLeft = false;
    private boolean useResample = false;
    private boolean useMouseClick = false;
    private int currPosition = 0;
    private int curPage = 0;
    private int totalPage = 0;

    public void loadFileList() {
        int i;
        File file = new File(this.folder);
        File[] files = file.listFiles();
        file = null;
        this.imageFiles.clear();
        if (files == null) {
            return;
        }
        this.logger.info("Loading file list.");
        for (i = 0; i < files.length; ++i) {
            if (!files[i].getName().toLowerCase().endsWith(".jpg") && !files[i].getName().toLowerCase().endsWith(".png") && !files[i].getName().toLowerCase().endsWith(".bmp") && !files[i].getName().toLowerCase().endsWith(".gif")) continue;
            this.imageFiles.add(files[i]);
        }
        this.setTotalPage(this.imageFiles.size());
        for (i = 0; i < this.imageFiles.size(); ++i) {
            this.logger.debug(this.imageFiles.get(i).toString());
        }
        this.logger.info("File list loaded.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Properties props = new Properties();
        props.setProperty("p1cartoon.program.name", "P1Cartoon 0.41");
        props.setProperty("p1cartoon.cartoons.folder", this.folder);
        this.logger.debug("currImageNum=" + this.getCurPage());
        props.setProperty("p1cartoon.curr.image.num", new Integer(this.getCurPage()).toString());
        props.setProperty("p1cartoon.curr.position", new Integer(this.currPosition).toString());
        props.setProperty("p1cartoon.automode", new Boolean(this.isAutoMode).toString());
        props.setProperty("p1cartoon.1in2pages", new Boolean(this.isTwoInOnePage).toString());
        props.setProperty("p1cartoon.right2left", new Boolean(this.isRightToLeft).toString());
        props.setProperty("p1cartoon.resample", new Boolean(this.useResample).toString());
        props.setProperty("p1cartoon.mouse", new Boolean(this.useMouseClick).toString());
        try {
            props.store(new FileOutputStream("p1cartoon.properties"), "P1Cartoon Settings");
            this.logger.info("Settings saved.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            props.clear();
            props = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream("p1cartoon.properties"));
            this.folder = props.getProperty("p1cartoon.cartoons.folder", "");
            this.setCurPage(Integer.parseInt(props.getProperty("p1cartoon.curr.image.num")));
            this.currPosition = Integer.parseInt(props.getProperty("p1cartoon.curr.position"));
            this.isAutoMode = Boolean.parseBoolean(props.getProperty("p1cartoon.automode"));
            this.isTwoInOnePage = Boolean.parseBoolean(props.getProperty("p1cartoon.1in2pages"));
            this.isRightToLeft = Boolean.parseBoolean(props.getProperty("p1cartoon.right2left"));
            this.useResample = Boolean.parseBoolean(props.getProperty("p1cartoon.resample"));
            this.useMouseClick = Boolean.parseBoolean(props.getProperty("p1cartoon.mouse"));
            this.logger.info("Settings loaded.");
        }
        catch (NumberFormatException e) {
            this.logger.warn("Can't load settings.");
        }
        catch (FileNotFoundException e) {
            this.logger.warn("Can't load settings.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            props.clear();
            props = null;
        }
    }

    public boolean isUseResample() {
        return this.useResample;
    }

    public void setUseResample(boolean useResample) {
        this.useResample = useResample;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public boolean isRightToLeft() {
        return this.isRightToLeft;
    }

    public void setRightToLeft(boolean isRightToLeft) {
        this.isRightToLeft = isRightToLeft;
    }

    public boolean isTwoInOnePage() {
        return this.isTwoInOnePage;
    }

    public void setTwoInOnePage(boolean isTwoInOnePage) {
        this.isTwoInOnePage = isTwoInOnePage;
    }

    public boolean isUseMouseClick() {
        return this.useMouseClick;
    }

    public void setUseMouseClick(boolean useMouseClick) {
        this.useMouseClick = useMouseClick;
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public int getCurrPosition() {
        return this.currPosition;
    }

    public void setCurrPosition(int currPosition) {
        this.currPosition = currPosition;
    }

    public File getCurrImageFile() {
        if (this.imageFiles.size() > 0) {
            File imageFile = (File)this.imageFiles.get(this.getCurPage());
            return imageFile;
        }
        return null;
    }

    public void setCurPage(int page) {
        this.curPage = page;
    }

    public void setTotalPage(int page) {
        this.totalPage = page;
    }

    public int getCurPage() {
        return this.curPage;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public void changeCurPage(int page) {
        this.setCurPage(page);
        this.setChanged();
        this.notifyObservers();
    }

    public void changeTotalPage(int page) {
        this.setTotalPage(page);
        this.setChanged();
        this.notifyObservers();
    }

    public void setChanged() {
        super.setChanged();
        this.notifyObservers();
    }

    public void goNextPage() {
        int page = this.getCurPage();
        if (++page > this.getTotalPage() - 1) {
            page = this.getTotalPage() - 1;
        }
        this.changeCurPage(page);
    }

    public void goPrevPage() {
        int page = this.getCurPage();
        if (--page < 0) {
            page = 0;
        }
        this.changeCurPage(page);
    }

    public void pageDown() {
        if (this.isTwoInOnePage()) {
            if (this.isRightToLeft()) {
                if (this.currPosition == 0) {
                    this.currPosition = 1;
                    this.goNextPage();
                } else {
                    this.currPosition = 0;
                }
            } else if (this.currPosition == 1) {
                this.currPosition = 0;
                this.goNextPage();
            } else {
                this.currPosition = 1;
            }
        } else {
            this.goNextPage();
        }
    }

    public void pageUp() {
        if (this.isTwoInOnePage()) {
            if (this.isRightToLeft()) {
                if (this.currPosition == 1) {
                    this.currPosition = 0;
                    this.goPrevPage();
                } else {
                    this.currPosition = 1;
                }
            } else if (this.currPosition == 0) {
                this.currPosition = 1;
                this.goPrevPage();
            } else {
                this.currPosition = 0;
            }
        } else {
            this.goPrevPage();
        }
    }

    public boolean isAutoMode() {
        return this.isAutoMode;
    }

    public void setAutoMode(boolean isAutoMode) {
        this.isAutoMode = isAutoMode;
    }
}

