// Purpose: Critical Section Ѵ. 
// Author : ڱ
// Update : 2003/05/06
// Date   : 2003/05/06

#ifndef __CRITICALSECTION_H_
#define __CRITICALSECTION_H_

//
// Class
//

class C_CriticalSection
{
// Constructors & Destructors
public:
    C_CriticalSection()
    {
        InitializeCriticalSection(&m_hCriticalSection);
        m_bIsLock = false;
    }
    ~C_CriticalSection()
    {
        if (true == m_bIsLock) Unlock(); 
    }

// Attributes
private:
    CRITICAL_SECTION    m_hCriticalSection;
    bool                m_bIsLock;

// Methods
public:
    void Lock()
    {
        ASSERT(false == m_bIsLock);
        EnterCriticalSection(&m_hCriticalSection);
        m_bIsLock = true;
    }
    void Unlock()
    {
        ASSERT(true == m_bIsLock);
        LeaveCriticalSection(&m_hCriticalSection);
        m_bIsLock = false;
    }
    bool IsLocked() { return m_bIsLock; }
};

#endif

