// Purpose:	ASSERT & TRACE  Ŭ 
// Author : ڱ
// Update : 2003/04/24
// Date	  : 2003/04/18
// Comment:
//      C_Assert Ŭ ASSERT  TRACE  ִ Ŭ ̱ 
//      ٸ Ŭ Լ Լ ؼ ȵȴ.  ٸ Ŭ
//       ʰ Լ  ʴ´. 
//      C_Assert ü Ǿ Ѵ. 
//      C_Assert Ŭ  assert ȿ ˻Ѵ.
//		ASSERT: Լ  Parameter  ȿ Ǵϰų ݵ Ȯؾ
//          ϴ  ȿ ǴѴ.  Ѿ   ASSERT 
//             ؼ ȵȴ. ASSERT ׸忡 ȿϱ
//          ̴. ׸ ASSERT Ͽ  ۾  
//          ð ʰ α׷   ִ. ̷ ó
//          ó ؾ ϴ 쿡 ASSERT ؼ ȵȴ.
//      WARNING: ASSERT   ȿ Ǵϳ α׷
//          ؼ ȵ  Ѵ.
//          WARNING_SOCK socketԼ ϸ ڵ Ͽ ȣ  
//          ޼(WIN32 ۵) ڵ Ѵ.
//          WARNING_WIN32 WIN32 WIN32 API  ߻  ȣ  
//          ޼ ڵ Ѵ. 
//      TRACE:   Ȯؾ   Ȯ̳   Ȯ 
//          Ѵ. ASSERT  ׸忡 ȿϱ 
//           뿡 ؼ LOG ؾ Ѵ.

#ifndef	__ASSERT_H_
#define	__ASSERT_H_

//
// Definitions
//

// ASSERT _DEBUG 쿡 ۵Ѵ. 
#if !defined(_DEBUG)
	#define	ASSERT(func, f)
	#define ASSERT_SOCK(func, f)
	#define	WARNING(func, f)
	#define WARNING_SOCK(func, f)

    #if defined(_WIN32)
        #define ASSERT_WIN32(func, f)
        #define WARNING_WIN32(func, f)
    #endif	

	#define TRACE0(func, sz)
	#define TRACE1(func, sz, ps1)
	#define TRACE2(func, sz, ps1, ps2)
	#define TRACE3(func, sz, ps1, ps2, ps3)
	#define TRACE4(func, sz, ps1, ps2, ps3, ps4)
#else
    // ASSERT, WARNING, TRACE ϱ  ϴ TEXT 
	#define TEXT_ASSERT    "ASSERT"
	#define TEXT_WARNING   "WARNING"
	#define TEXT_TRACE     "TRACE"
	#define TEXT_UNKNOWN   "UNKNOWN"

    // ASSERT, WARNING, TRACE ĺ
    #define TYPE_ASSERT_BIT 0x0f   
    #define TYPE_ASSERT     1
    #define TYPE_WARNING    2
    #define TYPE_TRACE      4

    // ASSERT, WARNING, TRACE 
    #define TYPE_CHECK_BIT  0xf0
    #define TYPE_CHECK_DEFAULT  16
    #define TYPE_CHECK_SOCK     32
    #if defined(_WIN32)
	   #define TYPE_CHECK_WIN32    64
    #endif

	#define	ASSERT(func, f)  \
        if (!(f)) C_Assert::Trace(THIS_FILE, __LINE__,   \
            TYPE_CHECK_DEFAULT | TYPE_ASSERT, func, #f)
    #define	ASSERT_SOCK(func, f)  \
        if (!(f)) C_Assert::Trace(THIS_FILE, __LINE__,   \
            TYPE_CHECK_SOCK | TYPE_ASSERT, func, #f)
	#define	WARNING(func, f) \
        if (!(f)) C_Assert::Trace(THIS_FILE, __LINE__,   \
            TYPE_CHECK_DEFAULT | TYPE_WARNING, func, #f)
	#define WARNING_SOCK(func, f)  \
        if (!(f)) C_Assert::Trace(THIS_FILE, __LINE__,   \
            TYPE_CHECK_SOCK | TYPE_WARNING, func, #f)

    #if defined(_WIN32)
        #define ASSERT_WIN32(func, f) \
            if (!(f)) C_Assert::Trace(THIS_FILE, __LINE__,   \
                TYPE_CHECK_WIN32 | TYPE_ASSERT, func, #f)
        #define WARNING_WIN32(func, f) \
            if (!(f)) C_Assert::Trace(THIS_FILE, __LINE__,   \
                TYPE_CHECK_WIN32 | TYPE_WARNING, func, #f)
    #endif	

	#define TRACE0(func, sz)   \
        C_Assert::Trace(THIS_FILE, __LINE__, \
            TYPE_CHECK_DEFAULT | TYPE_TRACE, func, sz)
	#define TRACE1(func, sz, ps1)  \
        C_Assert::Trace(THIS_FILE, __LINE__, \
            TYPE_CHECK_DEFAULT | TYPE_TRACE, func, sz, ps1)
	#define TRACE2(func, sz, ps1, ps2) \
        C_Assert::Trace(THIS_FILE, __LINE__, \
            TYPE_CHECK_DEFAULT | TYPE_TRACE, func, sz, ps1,ps2)
	#define TRACE3(func, sz, ps1, ps2, ps3)    \
        C_Assert::Trace(THIS_FILE, __LINE__, \
            TYPE_CHECK_DEFAULT | TYPE_TRACE, func, sz, ps1, ps2, ps3)
	#define TRACE4(func, sz, ps1, ps2, ps3, ps4)   \
        C_Assert::Trace(__FILE__, __LINE__, \
            TYPE_CHECK_DEFAULT | TYPE_TRACE, func, sz, ps1, ps2, ps3, ps4)
#endif

#ifdef  _DEBUG

//
// Includes
//

#include <pesc.h>

//
// Class
//

class C_Assert
{
// Constants, Enumerations & Structures
private:
    static LPCSTR mc_lpszAssertFile;    // ASSERT  ϸ
    static LPCSTR mc_lpszTimeFormat;    // ð 
    static UINT   mc_uTimeBufferSize;   // ð¿  ũ
    static UINT   mc_uErrorBufferSize;
    static UINT   mc_uTypeBufferSize; 

// Constructors & Destructors
public:
	C_Assert();
	~C_Assert();

// Attributes
private:
	static FILE	*ms_phAssert;  // ASSERT ϴ File handle 
                               //  νϽ ϴµ Ѵ. 
	
// Methods
private:
    static void   GetCurrentTm(char* szTime);
    static LPCSTR GetFileExceptPath(LPCSTR c_lpszPath);

public:
	static void Trace(LPCSTR c_lpszFile, UINT uLine, UINT uType, 
                    LPCSTR c_lpszFunc, LPCSTR c_lpszFormat, ...);
};

#endif  // _DEBUG

#endif  // __ASSERT_H_
