// Purpose: Win32 GDI  Ŭ 
// Author : ڱ
// Update : 2003/05/07
// Date   : 2003/05/07

#if defined(_WIN32) && defined(_GUI)

//
// Headers
//

#include <pesc.h>

//
// Definitions
//

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//
// Construction/Destruction
//

// Purpose: ʱȭѴ. 
C_DC::C_DC()
    : m_hWnd(NULL), m_hDC(NULL)
{
}

// Purpose: ʱȭѴ. 
C_DC::C_DC(HWND hWnd)
    : m_hWnd(hWnd), m_hDC(NULL)
{
    ASSERT("C_DC", NULL != m_hWnd);
    bool bRet = BeginPaint();
    WARNING("C_DC", true == bRet);
}

//
// Methods
//

int C_DC::DrawText(LPCSTR lpszString, LPRECT lpRect, UINT uFormat,
    int nCount)
{
    ASSERT("DrawText", NULL != m_hDC);
    int iRet = ::DrawText(m_hDC, lpszString, nCount, lpRect, uFormat);
    WARNING_WIN32("DrawText", 0 != iRet);
    return iRet;
}

inline void C_DC::Attach(HWND hWnd)
{
    ASSERT("Attach", NULL != hWnd);
    ASSERT("Attach", NULL == m_hWnd);
    m_hWnd = hWnd;
}
inline void C_DC::Detach()
{
    ASSERT("Detach", NULL != m_hWnd);
    m_hWnd = NULL;
}

inline bool C_DC::BeginPaint()
{
    ASSERT("BeginPaint", NULL != m_hWnd);
    ASSERT("BeginPaint", NULL == m_hDC);
    m_hDC = ::BeginPaint(m_hWnd, &m_pS);
    WARNING_WIN32("BeginPaint", NULL != m_hDC);
    return (NULL != m_hDC);
}

void C_DC::EndPaint()
{
    ASSERT("EndPaint", NULL != m_hWnd);
    ASSERT("EndPaint", NULL != m_hDC);
    ::EndPaint(m_hWnd, &m_pS);
    m_hDC = NULL;
}

#endif  // _WIN32, _GUI
