// Purpose: Win32 GUI application frame Ŭ 
// Author : ڱ
// Update : 2003/05/20
// Date   : 2003/05/02

#if defined(_WIN32) && defined(_GUI)

//
// Headers
//

#include <pesc.h>

//
// Definitions 
//

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

BEGIN_MESSAGE_MAP(C_Frame, C_Wnd)
END_MESSAGE_MAP()

//
// Methods
//

// Purpose: SDI Window Ѵ.
// Accepts: c_lpszClassName- Class ̸ 
//          c_lpszWindowName- Window ̸ 
//          nIDResource-  쿡  ҽ ID
//          nWindowListPos- Window List ġ 
//          dwDefaultStyle- Window Ÿ
//          dwExStyle- Ȯ Window Ÿ
//          hbrBackground- 
//          hWndParent- ƹ  
// Returns: true- , false-  
bool C_Frame::Create(LPCSTR c_lpszClassName, LPCSTR c_lpszWindowName,
    UINT nIDResource, UINT nWindowListPos, DWORD dwDefaultStyle,
    DWORD dwExStyle, HBRUSH hbrBackground, HWND hWndParent)
{
    ASSERT("Create", NULL != c_lpszClassName);
    ASSERT("Create", '\0' != *c_lpszClassName);
    ASSERT("Create", NULL != c_lpszWindowName);
    ASSERT("Create", '\0' != *c_lpszWindowName);

    bool    bRet;

    bRet = RegisterClassWithIcon(c_lpszClassName, nIDResource,
        CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS, hbrBackground);
    if (false == bRet) goto cleanup;
    
    if (0 != nIDResource)
    {
        bRet = LoadMenu(nIDResource);
        if (false == bRet) goto cleanup;
        
        bRet = GetSubMenu(nWindowListPos);
        if (false == bRet) goto cleanup;
    }
    
    bRet = CreateWindowEx(dwExStyle, c_lpszClassName, c_lpszWindowName,
        dwDefaultStyle, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
        CW_USEDEFAULT, hWndParent, m_hMenu);
    if (false == bRet) goto cleanup;

    return true; 

cleanup:
    WARNING("Create", !"C_Frame::Create");
    return false;
}

#endif  // _WIN32, _GUI
