// Purpose: Socket ⺻ Ŭ 
// Author : ڱ
// Update : 2003-04-30
// Date   : 2003-04-24

#if defined(_SOCKET)

//
// Headers
//

#include <pesc.h> 

//
// Definitions
//

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//
// Construction/Destruction
//

// Purpose: Ŭ ʱȭѴ. 
C_Sock::C_Sock()
    : m_enStatus(NotConnected), m_enMode(Blocking),
    m_hSock(INVALID_SOCKET), m_fOption(0)
{
    ::memset(&m_SockAddr, 0, sizeof(m_SockAddr));
    m_SockAddr.bIsValid = false;
}

// Purpose:  ڿ ȯѴ. 
C_Sock::~C_Sock()
{
    if (INVALID_SOCKET != m_hSock)
    {
        WARNING("~C_Sock", !"C_Sock::~C_Sock");
        Close();
    }
}

//
// Methods
//

// Purpose: ּҸ Ѵ.
// Accepts: nFamily- sim_family
//          unPort- sin_port
//          uladdr- sin_addr.s_addr
// Returns: true- , false- 
bool C_Sock::SetAddress(short nFamily, unsigned short unPort,
    unsigned long ulAddr)
{
    m_SockAddr.SockAddr.sin_family = nFamily;
    m_SockAddr.SockAddr.sin_port = htons(unPort);
    m_SockAddr.SockAddr.sin_addr.s_addr = htonl(ulAddr);
    m_SockAddr.bIsValid = true;
    return true;
}

// Purpose: ּҸ Ѵ.
// Accepts: nFamily- sim_family
//          unPort- sin_port
//          c_lpszAddr- sin_addr.s_addr
// Returns: true- , false- 
bool C_Sock::SetAddress(short nFamily, unsigned short unPort, LPCSTR c_lpszAddr)
{
    unsigned long ulAddr = inet_addr(c_lpszAddr);
    if (INADDR_NONE == ulAddr)
    {
        WARNING("SetAddress", !"C_Sock::SetAddr");
        m_SockAddr.bIsValid = false;
        return false;
    }
    m_SockAddr.SockAddr.sin_family = nFamily;
    m_SockAddr.SockAddr.sin_port = htons(unPort);
    m_SockAddr.SockAddr.sin_addr.s_addr = ulAddr;
    m_SockAddr.bIsValid = true;
    return true;
}

// Purpose:  ɼ Ѵ.
// Returns: true- , false-  
bool C_Sock::ApplyOption()
{
    ASSERT("ApplyOption", INVALID_SOCKET != m_hSock);
    ASSERT("ApplyOption", NotConnected == m_enStatus);
    bool    bRet;

    // Non blocking带 Ѵ. 
    if (NonBlocking == m_enMode)
    {
        unsigned long ulNonBlock = 1;
        bRet = Ioctlsocket(FIONBIO, (unsigned long *) & ulNonBlock);
        if (false == bRet) goto cleanup;
    }

    return true;

cleanup:
    WARNING("ApplyOption", !"C_Sock::SetOption");
    
    return false;
}

    //   (Accept ̿Ͽ socket handle ޾ƿ ʿϴ.) 
inline void C_Sock::SetServer(SOCKET hSock, Mode enMode = Blocking,
        Status enStatus = Connected)
    {
        ASSERT("SetServer", INVALID_SOCKET != hSock);
        ASSERT("SetServer", INVALID_SOCKET == m_hSock);
        m_hSock = hSock;
        m_enMode = enMode;
        m_enStatus = enStatus;
    }
    
//
// API Wrapper inline Լ 
//
    
inline bool C_Sock::Socket(int iAF, int iType, int iProtocol = 0)
	{
        ASSERT("Socket", INVALID_SOCKET == m_hSock);
        m_hSock = ::socket(iAF, iType, iProtocol);
        WARNING_SOCK("Socket", INVALID_SOCKET != m_hSock);
        return("Socket" ,INVALID_SOCKET != m_hSock);
    }
inline bool C_Sock::Ioctlsocket(long lCommand, DWORD* lpArgument)
	{
        ASSERT("Ioctlsocket", INVALID_SOCKET != m_hSock);
        ASSERT("Ioctlsocket", NotConnected == m_enStatus);
        int iRet = ::ioctlsocket(m_hSock, lCommand, lpArgument);
        WARNING_SOCK("Ioctlsocket", SOCKET_ERROR != iRet);
        return (SOCKET_ERROR != iRet);
    }
inline bool C_Sock::SetSockOpt(int iOptionName, const void* lpOptionValue,	int iOptionLen,
        int iLevel = SOL_SOCKET)
	{
        ASSERT("SetSockOpt", INVALID_SOCKET != m_hSock);
        ASSERT("SetSockOpt", NotConnected == m_enStatus);
        int iRet = ::setsockopt(m_hSock, iLevel, iOptionName,
            (LPCSTR)lpOptionValue, iOptionLen);
        WARNING_SOCK("SetSockOpt", SOCKET_ERROR != iRet);
        return (SOCKET_ERROR != iRet);
    }
inline bool C_Sock::GetSockOpt(int iOptionName, void* lpOptionValue, int* piOptionLen,
        int iLevel = SOL_SOCKET)
	{
        ASSERT("GetSockOpt", INVALID_SOCKET != m_hSock);
        ASSERT("GetSockOpt", NotConnected == m_enStatus);
        int iRet = ::getsockopt(m_hSock, iLevel, iOptionName,
            (LPSTR)lpOptionValue, piOptionLen);
        WARNING_SOCK("GetSockOpt", SOCKET_ERROR != iRet);
        return (SOCKET_ERROR != iRet);
    }
inline bool C_Sock::Bind()
	{
        ASSERT("Bind", INVALID_SOCKET != m_hSock);
        ASSERT("Bind", NotConnected == m_enStatus);
        ASSERT("Bind", true == m_SockAddr.bIsValid);
        int iRet = ::bind(m_hSock, (struct sockaddr *) &m_SockAddr.SockAddr,
            sizeof(m_SockAddr.SockAddr));
        WARNING_SOCK("Bind", SOCKET_ERROR != iRet);
        return (SOCKET_ERROR != iRet);
    }
inline bool C_Sock::Listen(int iBacklog = SOMAXCONN)
	{
        ASSERT("Listen", INVALID_SOCKET != m_hSock);
        ASSERT("Listen", NotConnected == m_enStatus);
        ASSERT("Listen", SOMAXCONN >= iBacklog);
        int iRet = ::listen(m_hSock, iBacklog);
        WARNING_SOCK("Listen", SOCKET_ERROR != iRet);
        return (SOCKET_ERROR != iRet);
    }
inline bool C_Sock::Close()
    {
        ASSERT("Close", INVALID_SOCKET != m_hSock);
        int iRet = ::closesocket(m_hSock);
        m_hSock = INVALID_SOCKET;
        WARNING_SOCK("Close", SOCKET_ERROR != iRet);
        m_enStatus = NotConnected; 
        return(SOCKET_ERROR != iRet);
    }
    
    //
    //  Լ Non-blocking modeK 츦 ó  Ѵ.
    //

inline SOCKET C_Sock::Accept()
    {
        ASSERT("Accept", INVALID_SOCKET != m_hSock);
        ASSERT("Accept", NotConnected == m_enStatus);
        ASSERT("Accept", true == m_SockAddr.bIsValid);
        int iAddrLen = sizeof(m_SockAddr.SockAddr);
        SOCKET hSock = ::accept(m_hSock,
            (struct sockaddr *) &m_SockAddr.SockAddr, &iAddrLen);
        WARNING_SOCK("Accept", INVALID_SOCKET != hSock);
        return hSock;
    }
inline bool C_Sock::Connect()
	{
        ASSERT("Connect", INVALID_SOCKET != m_hSock);
        ASSERT("Connect", NotConnected == m_enStatus);
        ASSERT("Connect", true == m_SockAddr.bIsValid);
        int iRet = ::connect(m_hSock, (struct sockaddr *) &m_SockAddr.SockAddr,
            sizeof(m_SockAddr.SockAddr));
        WARNING_SOCK("Connect", SOCKET_ERROR != iRet);
        if (SOCKET_ERROR != iRet)
        {
            m_enStatus = Connected;
            return true;
        }
        return false;
    }
inline int C_Sock::Send(const void* lpBuf, int iBufLen, int nFlags = 0)
	{
        ASSERT("Send", Connected == m_enStatus);
        int iLen = ::send(m_hSock, (LPSTR)lpBuf, iBufLen, nFlags);
        WARNING_SOCK("Send", SOCKET_ERROR != iLen);
        return iLen;
    }
inline int C_Sock::Recv(void* lpBuf, int iBufLen, int nFlags = 0)
	{
        ASSERT("Recv", Connected == m_enStatus);
        int iLen = ::recv(m_hSock, (LPSTR)lpBuf, iBufLen, nFlags);
        WARNING_SOCK("Recv", SOCKET_ERROR != iLen);
        return iLen;
    }


#endif  // _SOCKET
