<?php
  include_once('./classes/ArrayRecordSet.php');
	/**
	 * Manage schemas within a database
	 *
	 * $Id: database.php,v 1.88.2.3 2007/07/09 14:55:22 xzilla Exp $
	 */

	// Include application functions
	include_once('./libraries/lib.inc.php');

	$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
	if (!isset($msg)) $msg = '';

	function _highlight($string, $term) {
		return str_replace($term, "<b>{$term}</b>", $string);
	}	

	/**
	 * Display a form for alter and perform actual alter
	 */
	function doAlter() {
		global $data, $misc, $db;
		global $lang;
	
		$misc->printTrail('database');
		$misc->printTitle($lang['stralter']);

    include_once "waiting.php";
		
		echo "<form action=\"all_db.php\" method=\"post\">\n";
		echo "<table>\n";
		echo "<tr><th class=\"data left required\">{$lang['strname']}</th>\n";
		echo "<td class=\"data1\">";
		echo "<input name=\"newname\" size=\"32\" maxlength=\"{$data->_maxDbLen}\" value=\"$db\" /></td></tr>\n";
		
		echo "</table>\n";
		echo "<input type=\"hidden\" name=\"action\" value=\"alter\" />\n";
		echo $misc->form;
		echo "<input type=\"hidden\" name=\"oldname\" value=\"", 
			htmlspecialchars($db), "\" />\n";
		echo "<input type=\"submit\" name=\"alter\" value=\"{$lang['stralter']}\"  onclick=\"show_waiting();\"/>\n";
		echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
		echo "</form>\n";
	}

	function doCopy() {
		global $data, $misc, $db;
		global $lang;
	
		$misc->printTrail('database');
		$misc->printTitle($lang['strcopydb']);

    include_once "waiting.php";
		
		echo "<form action=\"all_db.php\" method=\"post\">\n";
		echo "<table>\n";
		echo "<tr><th class=\"data left required\">{$lang['strname']}</th>\n";
		echo "<td class=\"data1\">";
		echo "<input name=\"newname\" size=\"32\" maxlength=\"{$data->_maxDbLen}\" value=\"$db\" /></td></tr>\n";
		
		echo "</table>\n";
		echo "<input type=\"hidden\" name=\"action\" value=\"copy\" />\n";
		echo $misc->form;
		echo "<input type=\"hidden\" name=\"oldname\" value=\"", 
			htmlspecialchars($db), "\" />\n";
		echo "<input type=\"submit\" name=\"alter\" value=\"{$lang['strcopydb']}\"  onclick=\"show_waiting();\"/>\n";
		echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
		echo "</form>\n";
	}
	
	/**
	 * Show confirmation of drop and perform actual drop
	 */
	function doDrop() {
		global $data, $misc, $db;
		global $lang;

			$misc->printTrail('database');
			$misc->printTitle($lang['strdrop']);
			
      include_once "waiting.php";

			echo "<p>", sprintf($lang['strconfdropdatabase'], $misc->printVal($db)), "</p>\n";	
			echo "<form action=\"all_db.php\" method=\"post\">\n";
			echo "<input type=\"hidden\" name=\"action\" value=\"drop\" />\n";
			echo $misc->form;
			echo "<input type=\"hidden\" name=\"dropdatabase\" value=\"", htmlspecialchars($db), "\" />\n";
			echo "<input type=\"submit\" name=\"drop\" value=\"{$lang['strdrop']}\"  onclick=\"show_waiting();\"/>\n";
			echo "<input type=\"submit\" name=\"cancel\" value=\"{$lang['strcancel']}\" />\n";
			echo "</form>\n";
	}


	function doDefault($msg = '') {
		global $data, $conf, $misc, $_server_info, $db;
		global $lang;

		$misc->printTrail('database');
		$misc->printTabs('database','database');
		$misc->printMsg($msg);
		

    $columns = array(
			'title' => array(
				'title' => $lang['strfield'],
				'field' => 'title',
			),
			'content' => array(
				'title' => $lang['strcontent'],
				'field' => 'content',
			),
		);
		
    $contents = array(
			array(
				'title' => $lang['strlogin'],
				'content' => $_server_info['login'][$db],
			),
			array(
				'title' => $lang['strisdba'],
				'content' => $_server_info['isdba'][$db],
			),
			array(
				'title' => $lang['strpagesize'],
				'content' => $_server_info['pagesize'][$db],
			),
			array(
				'title' => $lang['strstatus'],
				'content' => $_server_info['dbstat'][$db],
			),
		);
			
		$datrows = new ArrayRecordSet($contents);
		$actions = array();
		$misc->printTable($datrows, $columns, $actions);
		
    if (isset($_server_info['spaceinfo'][$db])) {
  		$spi = $_server_info['spaceinfo'][$db];
			for ($j = 0; $j < count($spi); $j++) {
				if ($spi[$j]['type'] == "Active_log" || 
				    $spi[$j]['type'] == "Archive_log") {
				  $spi[$j]['freepage'] = "";
				}
				else 
				  $spi[$j]['freepage'] = $spi[$j]['freepage']."(".($spi[$j]['freepage'] * $_server_info['pagesize'][$db]/1024000)."MB)";
				$spi[$j]['totalpage'] = $spi[$j]['totalpage']."(".($spi[$j]['totalpage'] * $_server_info['pagesize'][$db]/1024000)."MB)";
      }

      $datrows = new ArrayRecordSet($spi);

      $columns = array(
  			'spacename' => array(
  				'title' => $lang['strvolume'],
  				'field' => 'spacename',
  			),
  			'type' => array(
  				'title' => $lang['strtype'],
  				'field' => 'type',
  			),
  			'freepage' => array(
  				'title' => $lang['strfreespace'],
  				'field' => 'freepage',
  			),
  			'totalpage' => array(
  				'title' => $lang['strtotalspace'],
  				'field' => 'totalpage',
  			),
  		);
  		$misc->printTable($datrows, $columns, $actions);
  	}
    
    include_once "waiting.php";
          
		echo "<br><ul>\n";

    if ($_server_info['isdba'][$db] == 'y') {
      if ($_server_info['dbstat'][$db] == 'start') {
  			echo "\t<li><a href=\"all_db.php?action=stopdb&amp;subject=database&amp;{$misc->href}&amp;\"".
  			     " onclick=\"show_waiting();\">{$lang['strstopdb']}</a></li>\n";
  			echo "\t<li><a href=\"all_db.php?action=restartdb&amp;subject=database&amp;{$misc->href}&amp;\"".
  			     " onclick=\"show_waiting();\">{$lang['strrestartdb']}</a></li>\n";
      }
      else {
  			echo "\t<li><a href=\"all_db.php?action=startdb&amp;subject=database&amp;{$misc->href}&amp;\"".
  			     " onclick=\"show_waiting();\">{$lang['strstartdb']}</a></li>\n";
  			echo "\t<li><a href=\"database.php?action=confirm_drop&amp;subject=database&amp;".
  			     "{$misc->href}&amp;\">{$lang['strdrop']}</a></li>\n";
  			echo "\t<li><a href=\"database.php?action=confirm_alter&amp;subject=database&amp;".
  			     "{$misc->href}&amp;\">{$lang['stralter']}</a></li>\n";
        if ($_server_info['dbsuper']=="admin")
  			  echo "\t<li><a href=\"database.php?action=confirm_copy&amp;subject=database&amp;".
  			       "{$misc->href}&amp;\">{$lang['strcopydb']}</a></li>\n";
  			//@@@TODO 1.2 load
      }
 			//@@@TODO 1.2 unload
 			//@@@TODO 1.2 para
    }

		echo "</ul>\n";
	}


	function doTree() {
		global $misc, $lang;

		$reqvars = $misc->getRequestVars('database');

		$tabs = $misc->getNavTabs('database');

		$items = $misc->adjustTabsForTree($tabs);
		
		$attrs = array(
			'text'   => noEscape(field('title')),
			'icon'   => field('icon'),
			'action' => url(field('url'),
							$reqvars,
							field('urlvars', array())
						),
			'branch' => url(field('url'),
							$reqvars,
							field('urlvars'),
							array('action' => 'tree')
						),
		);
		
		$misc->printTreeXML($items, $attrs);

		exit;
	}

	if ($action == 'tree') doTree();
	
	$misc->printHeader($lang['strschemas']);
	$misc->printBody();

	switch ($action) {
		case 'sql':
			doSQL();
			break;
		case 'variables':
			doVariables();
			break;
		case 'confirm_drop':
			doDrop();
			break;
		case 'confirm_alter':
			doAlter();
			break;
		case 'confirm_copy':
			doCopy();
			break;
		default:
			doDefault();
			break;
	}

	$misc->printFooter();

?>
