<?php
  include_once('./classes/ArrayRecordSet.php');

	/**
	 * List app server in a broker
	 *
	 */

	// Include application functions
	include_once('./libraries/lib.inc.php');

	$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';

	/**
	 * Show default list of columns in the table
	 */
	function doDefault($msg = '', $refresh = FALSE) {
		global $conf, $misc, $_server_info;
		global $lang;

		// Get columns
		$attrs = $misc->getBroker($_REQUEST['broker'], $refresh);
		
		$misc->printTrail('broker');
		$misc->printTabs('broker','appserver');
		$title = $lang['strappserver'].':'.$attrs['asnum'].'(MIN:'.$attrs['minas'].', MAX:'.$attrs['maxas'].')';
		unset($attrs['asnum']);
		unset($attrs['minas']);
		unset($attrs['maxas']);
		$misc->printTitle($_server_info['UNICASVER']." ".$title,'');
		$misc->printMsg($msg);

		$columns = array(
			'appserver' => array(
				'title' => $lang['strappserver'],
				'field' => 'as_id',
			),
			'status' => array(
				'title' => $lang['strstatus'],
				'field' => 'as_status',
			),
			'process' => array(
				'title' => $lang['strprocess'],
				'field' => 'as_pid',
			),
			'request' => array(
				'title' => $lang['strrequest'],
				'field' => 'as_c',
			),
			'psize' => array(
				'title' => $lang['strpsize'],
				'field' => 'as_psize',
			),
			'lastaccess' => array(
				'title' => $lang['strlastaccess'],
				'field' => 'as_lat',
			),
			'jobinfo' => array(
				'title' => $lang['strjobinfo'],
				'field' => 'as_cur',
			),
			'actions' => array(
				'title' => $lang['stractions'],
			)
		);

		$actions = array(
		  //@@@TODO 1.2 뼭 ߰//
		  //@@@TODO 1.2 Ķ 
		  //@@@TODO 1.2 source_env
		);

    $datrows = new ArrayRecordSet($attrs);
		$misc->printTable($datrows, $columns, $actions);
		
		echo "<br />\n";

		echo "<ul>\n";
		echo "\t<li><a href=\"broker.php?action=refresh&amp;{$misc->href}&amp;broker=", urlencode($_REQUEST['broker']),"\">{$lang['strrefresh']}</a></li>\n";
		echo "</ul>\n";
	}

	$misc->printHeader($lang['strbroker'] . ' - ' . $_REQUEST['broker']);
	$misc->printBody();

	switch ($action) {
		default:
			doDefault();
			break;
		case 'refresh':
			doDefault('', TRUE);
			break;
	}
	
	$misc->printFooter();

?>
