<?php
/**
 * Function library : log read, page up/down
 *
 * $Id: viewlog.inc.php
 */
function manager_viewlog($logpath, $acturl, $line_start) {
    global $data, $lang, $broker, $_reload_browser, $_server_info, $misc;
    $linemax = 1000;
    $areamax = 10;

    echo "<br>";
    $line_start += 0;
    $line_end = $line_start + $linemax;
    $tk = $misc->ManagerCommand($_server_info['id'], "viewlog" , 
        "dbname:TESTDB\npath:$logpath\nstart:$line_start\nend:$line_end\n");
    if ($tk['status']!="success") {
        $arealines = 3;
        $msg = $lang['logreadfail']." ".$tk['note'];
    }
    else {
        echo "<a href=\"$acturl"."log_start_line=0&amp;\" onclick=\"show_waiting();\">".$lang['strfirst']."</a> ";
        if ($tk['start'] > 0) {
            $line_start = ($tk['start'] > $linemax) 
                ? ($tk['start'] - $linemax) : 0;
            echo "<a href=\"$acturl"."log_start_line=$line_start&amp;\" onclick=\"show_waiting();\">".
                $lang['strprev']."</a> ";
        }
        if ($tk['end'] < $tk['total']) {
            $line_start = $tk['end'];
            echo "<a href=\"$acturl"."log_start_line=$line_start&amp;\" onclick=\"show_waiting();\">".
                $lang['strnext']."</a> ";
        }
        if ($tk['total'] > $linemax) {
            $line_start = $tk['total'] - $linemax;
            echo "<a href=\"$acturl"."log_start_line=$line_start&amp;\" onclick=\"show_waiting();\">".
                $lang['strlast']."</a> ";
        }
        echo "<br>\n";
        $arealines = (($tk['end']-$tk['start']) > $areamax) 
            ? $areamax : ($tk['end']-$tk['start'])+1;
        $msg = $misc->array_implode($tk['log'][0]['line'], "\n");
    }
    echo "<textarea rows=$arealines cols=80>$msg</textarea>\n";
}


function manager_viewlog2() {
    global $data, $lang, $_reload_browser, $_server_info, $misc;
    $linemax = 1000;
    $areamax = 10;

    echo "<br>";
    $tk = $misc->ManagerCommand($_server_info['id'], "loadaccesslog" , "");
    if ($tk['status']!="success") {
        $msg = $lang['logreadfail']." ".$tk['note'];
        echo "<textarea rows=3 cols=80>$msg</textarea>\n";
    }
    else {
        $acclog = $tk['accesslog'][0];
        $cnt = (isset($acclog['user'])) ? count($acclog['user']) : 0;
        $msg = "";
        for ($i = 0; $i < $cnt; $i ++) {
            $msg .= $acclog['time'][$i]." ".$acclog['user'][$i]." ".$acclog['taskname'][$i]." \n";
        }

        $errlog = $tk['errorlog'][0];
        $cnt = (isset($errlog['user'])) ? count($errlog['user']) : 0;
        $msg2 = "";
        for ($i = 0; $i < $cnt; $i ++) {
            $msg2 .= $errlog['time'][$i]." ".$errlog['user'][$i]." ".
                $errlog['taskname'][$i]."(".$errlog['errornote'][$i].") \n";
        }

        echo "<table border=0 cellpadding=0 cellspacing=0><tr><td><textarea rows=16 cols=50>$msg</textarea><br>\n";
        echo "<input type='button' value='".$lang['strdeletelog']."' onclick='confirm_url(\"".$lang['strconfdeletelog'];
        echo "\", \"adminusers.php?action=resetlog&amp;logpath=accesslog&amp;subject=server&amp;{$misc->href}&amp;\")'></td>";
        echo "<td><textarea rows=16 cols=50>$msg2</textarea><br>\n";
        echo "<input type='button' value='".$lang['strdeletelog']."' onclick='confirm_url(\"".$lang['strconfdeletelog'];
        echo "\", \"adminusers.php?action=resetlog&amp;logpath=errorlog&amp;subject=server&amp;{$misc->href}&amp;\")'>".
            "</td></tr></table>";
    }
}
	
?>
