<?php
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +--------------------------------------------------------+
// | PHP version 5.x                                        |
// +--------------------------------------------------------+
// | Copyright : Song Hyo-Jin <shj at xenosi.de>            |
// +--------------------------------------------------------+
// | License : BSD                                          |
// +--------------------------------------------------------+
//
// $Id: PDOMSSQL.inc.php, 2009. 3. 23. crucify Exp $

include_once 'PDOExt.inc.php';

class SHJPDOMSSQL extends SHJPDOExt
{
	public function __construct($conninfo, $pconnect = false)
	{
		$conndata = parse_ini_file($conninfo);
		$conntext = 'dblib:';
		if(isset($conndata['host'])) {
			$conntext .= 'host=' . $conndata['host'] . ';';
		}
		if(isset($conndata['port'])) {
			$conntext .= 'port=' . $conndata['port'] . ';';
		}
		$conntext .= 'dbname=' . $conndata['db'] . ';';
		if(isset($conndata['charset'])) {
			$this->charset = $conndata['charset'];
		}
		parent::__construct($conntext, $conndata['user'], $conndata['pass'], $pconnect);
		$this->setDsn('mssql');
		$this->setSelect('MSSQL');
	}
	
	public function begin()
	{
		if($this->transaction) {
			throw new Exception('already begined.');
		}
		$this->class->exec('BEGIN TRAN');
		$this->transaction = true;
	}

	public function commit()
	{
		if(!$this->transaction) {
			throw new Exception('not begined.');
		}
		$this->class->exec('COMMIT TRAN');
		$this->transaction = false;
	}

	public function rollback()
	{
		if(!$this->transaction) {
			throw new Exception('not begined.');
		}
		$this->class->exec('ROLLBACK TRAN');
		$this->transaction = false;
	}
	
	public function id($seq_no = 0, $table_name = '')
	{
		if($table_name != '') {
			$this->table = $table_name;
		}
		if($seq_no != 0 && $this->table == '') {
			throw new Exception('SHJPDOMSSQL::id() must set table name.');
		}
		if($seq_no > 0) {
			$this->class->exec('DBCC CHECKIDENT ('.$this->table.', RESEED, '.($seq_no - 1).')'); // if seeding 1 then next val is 2 
			return true;
		} else if($seq_no == -1) {
			throw new Exception('SHJPDOMSSQL::id() nextval not supported.');
		}
		return $this->query('SELECT @@IDENTITY')->field();
	}
		
	public function escape_string($str)
	{
		return mysql_escape_string($str);
	}
	
	public function get_pkey($table_name)
	{
		if(false === ($pkey = $this->query('SELECT TOP 1 COLUMN_NAME FROM Information_Schema.Key_Column_Usage WHERE TABLE_NAME = \''.$table_name.'\' AND CONSTRAINT_NAME LIKE \'PK%\'')->field())) {
			throw new Exception($table_name.' table has no primary key.');
		}

		return $pkey;
	}
}

class SHJPDOMSSQLSelect extends SHJPDOSelect
{
	public $pkey = false;
	
	public function compile($lock = false)
	{
		$query = '';
		
		if(count($this->fields) == 0) {
			$query .= '*';
		} else {
			$query .= implode(', ', $this->fields);
		}
		$query .= ' FROM '.implode(', ', $this->tables);
		if(count($this->wheres) != 0) {
			$query .= ' WHERE ('.implode(') AND (', $this->wheres).')';
		}
		if(count($this->orders) == 0 && $this->offset && false === $this->pkey) {
			$this->pkey = $this->class->get_pkey(preg_replace('/\s.*$/', '', $this->tables[0]));
			$this->orders[] = $this->pkey;
		}
		if(count($this->orders) == 0) {
			$this->orders[] = '1';
		}
		$query .= ' ORDER BY '.implode(', ', $this->orders);
		if($lock) {
			$query .= ' FOR UPDATE';
		}
		
		if($this->limit) {
			if(!preg_match('/^\d+$/', $this->limit)) {
				throw new Exception('SHJPDOMSSQLSelect::compile() limit must integer');
			}
		}
		if($this->offset) {
			if(!preg_match('/^\d+$/', $this->offset)) {
				throw new Exception('SHJPDOMSSQLSelect::compile() offset must integer');
			}
		}
		
		if($this->limit && $this->offset) {
			$query = 'SELECT * FROM (SELECT TOP '.$this->limit.' * FROM (SELECT TOP '.($this->offset + $this->limit).' '.$query.') xenoq1 ORDER BY '.implode(', ', $this->order_rev($this->orders)).') xenoq2 ORDER BY '.implode(', ', $this->orders);
		} else if($this->limit) {
			$query = 'SELECT TOP '.$this->limit.' '.$query;
		} else if($this->offset) {
			throw new Exception('SHJPDOMSSQLSelect::compile() offset need limit');
		}
		return $query;
	}
	
	public function prepare($lock = false)
	{
		$stmt = $this->class->prepare($this->compile($lock));
		if($this->wfields != null) {
			$stmt->bind($this->wfields);
		}
		return $stmt;
	}
	
	private function order_rev($orders)
	{
		foreach($orders as $order) {
			$rets[] = preg_replace_callback('/^([^\s]+)(\s+(ASC|DESC))?$/i', array(&$this, 'order_rev_callback'), $order);
		}
		return $rets;
	}
	
	private function order_rev_callback($matches)
	{
		if(isset($matches[3])) {
			if(strtoupper($matches[3]) == 'DESC') {
				return $matches[1];
			}
		}
		return $matches[1].' DESC';
	}
}