<?php
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +--------------------------------------------------------+
// | PHP version 5.x                                        |
// +--------------------------------------------------------+
// | Copyright : Song Hyo-Jin <shj at xenosi.de>            |
// +--------------------------------------------------------+
// | License : BSD                                          |
// +--------------------------------------------------------+
//
// $Id: PDOPostgreSQL.inc.php, 2009. 3. 24. crucify Exp $

include_once 'PDOExt.inc.php';

class SHJPDOPostgreSQL extends SHJPDOExt
{
	public function __construct($conninfo, $pconnect = false)
	{
		$conndata = parse_ini_file($conninfo);
		$conntext = 'pgsql:';
		if(isset($conndata['host'])) {
			$conntext .= 'host='.$conndata['host'].';';
		}
		if(isset($conndata['port'])) {
			$conntext .= 'port='.$conndata['port'].';';
		}
		$conntext .= 'dbname='.$conndata['db'].';';
		if(isset($conndata['charset'])) {
			$this->charset = $conndata['charset'];
		}
		parent::__construct($conntext, $conndata['user'], $conndata['pass'], $pconnect);
		$this->setDsn('pgsql');
		$this->setSelect('PostgreSQL');
		$this->setInsert('PostgreSQL');
	}

	public function id($seq_name = null, $seq_no = 0)
	{
		if($seq_no > 0) {
			$this->class->exec('SELECT setval(\''.$seq_name.'\', '.$seq_no.', TRUE)');
			return true;
		} else if($seq_no == -1) {
			return $this->class->query('SELECT nextval(\''.$seq_name.'\'')->field();
		}
		if(!$seq_name) {
			return $this->class->lastInsertId($this->table.'_seq_seq'); // PostgreSQL field name is table_seq and type serial : sequence name is table_seq_seq
		} else {
			return $this->class->lastInsertId($seq_name);
		}
	}
	
	public function escape_string($str)
	{
		return pg_escape_string($str);
	}
}

class SHJPDOPostgreSQLSelect extends SHJPDOSelect
{
	public function compile($lock = false)
	{
		$query = parent::compile();
		if($lock) {
			$query .= ' FOR UPDATE';
		}
		return $query;
	}

	public function prepare($lock = false)
	{
		$fields = null;
		if($this->limit) {
			$fields->limit = &$this->limit;
		}
		if($this->offset) {
			$fields->offset = &$this->offset;
		}
		$stmt = $this->class->prepare($this->compile($lock));
		if($fields != null) {
			$stmt->bind($fields);
		}
		if($this->wfields != null) {
			$stmt->bind($this->wfields);
		}
		return $stmt;
	}
}

class SHJPDOPostgreSQLInsert extends SHJPDOInsert
{
	public function insertCompile($result = false)
	{
		$query = parent::insertCompile();
		if($result) {
			$query .= ' RETURNING *';
		}
		return $query;
	}
	
	public function insert($result = false)
	{
		$stmt = $this->class->prepare($this->insertCompile($result));
		$stmt->bind($this->fields);
		return $stmt;
	}
	
	public function updateCompile($result = false)
	{
		$query = parent::updateCompile();
		if($result) {
			$query .= ' RETURNING *';
		}
		return $query;
	}

	public function update($result = false)
	{
		$stmt = $this->class->prepare($this->updateCompile($result));
		$stmt->bind($this->fields);
		$stmt->bind($this->wfields);
		return $stmt;
	}	
}

