/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<HSThread.h>	2006-03-20,21:02

*/

#ifndef __HSTHREAD_H__
#define __HSTHREAD_H__





#include "HSDefine.h"
#include "HSPrint.h"
#include "HSUtil.h"
#include "NoLockList.h"





#if defined(_WIN32) || defined(_WIN32_WCE)
typedef DWORD	HS_TQ;
#define HS_INVALID_TQ	0
typedef MSG HSQmsg;

#elif defined(_VXWORKS)
typedef MSG_Q_ID HS_TQ;
#define HS_INVALID_TQ	NULL
typedef struct
{
	HS_UINT	message;
	HS_UINT wParam;
	HS_UINT lParam;
} HSQmsg;

#elif defined(_LINUX)
typedef int HS_TQ;
#define HS_INVALID_TQ			(-1)
#define HS_LINUX_MSGQ_TYPE		1234
#define HS_LINUX_MSGQ_KEY_MIN	10000
#define HS_LINUX_MSGQ_KEY_MAX	HS_LINUX_MSGQ_KEY_MIN +2000
typedef struct
{
	long	type;
	HS_UINT	message;
	HS_UINT	wParam;
	HS_UINT	lParam;
} HSQmsg;

HS_TQ HSThread_msgget();
#endif





/*
 *
 * thread pool
 *
 */
HS_RESULT OpenThreadPool(HS_UINT pSize);
HS_RESULT CloseThreadPool();
HS_QID AddThreadQ(HS_TQ pQ);
HS_RESULT UpdateQ(HS_QID pId,HS_TQ pQ);
HS_RESULT SubThreadQ(HS_QID pId);
void ShowThreadPool();





/*
 *
 * hs thread
 *
 */
#if defined(_WIN32) || defined(_WIN32_WCE)
#define _thread_struct(memb)	\
{								\
	char	mName[32];			\
	HS_QID	mQid;				\
	BOOL	mActive;			\
	##memb						\
}
#elif defined(_LINUX) || defined(_VXWORKS)
#define _thread_struct(memb)	\
{								\
	char	mName[32];			\
	HS_QID	mQid;				\
	BOOL	mActive;			\
	memb						\
}
#endif


#define HS_THREAD_INIT(obj,name)		\
	if(name==NULL)						\
		strcpy(obj->mName,"noname");	\
	else if( strlen(name)>31 )			\
	{									\
		memcpy(obj->mName,name,31);		\
		obj->mName[32] = '\0';			\
	}									\
	else								\
		strcpy(obj->mName,name);		\
	obj->mQid = HS_INVALID_QID;			\
	obj->mActive = FALSE


#define HS_THREAD_IS_ACTIVE(obj)	obj->mActive



HS_QID _HSThreadStart(char *pName,void *pObj,void *pArg,HS_RESULT (*pFunc)(HS_TQ,void*,void*));
#define HSThreadStart(obj,arg,func)	\
(obj->mQid=_HSThreadStart(obj->mName,obj,arg,func))


HS_RESULT _HSThreadStop(HS_QID pQid);
#define HSThreadStop(obj)	\
_HSThreadStop(obj->mQid)


HS_RESULT _HSExitThread(HS_TQ pQ,HS_RESULT pResult);
#define HSExitThread(q,result)	\
_HSExitThread(q,result)


HS_RESULT _HSThreadSendMessage(HS_QID pQid,HS_UINT pMessage,HS_UINT pWparam,HS_UINT pLparam);
#define HSThreadSendMessage(obj,msg,wp,lp)	\
_HSThreadSendMessage(obj->mQid,msg,wp,lp)


HS_RESULT _HSThreadGetMessage(HS_TQ pQ,HSQmsg *pQmsg,HS_UINT pMin,HS_UINT pMax,BOOL pIsWait);
#define HSThreadGetMessage(q,msg,mini,maxi,waiti)	\
_HSThreadGetMessage(q,msg,mini,maxi,waiti)





#endif/*__HSTHREAD_H__*/
