/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<HSTimer.h>	2005-03-13,10:30

*/

#ifndef __HSTIMER_H__
#define __HSTIMER_H__

#include "HSDefine.h"
#include "HSThread.h"





/* timer list of lingered on
   programer must init this list
   to use HSTimer.
*/
HS_RESULT OpenTimerList();
HS_RESULT CloseTimerList();





/* HSTimerEvent object : timer response object.
   when timer expire, timer thread send queue message
   to origin thread(calling thread) with this struct.
*/
typedef struct
{
	HS_TID	mTid;
	HS_UINT mSub;
} HSTimerEvent;
HSTimerEvent *newm_HSTimerEvent(HS_TID pTid,HS_UINT pSub);
HS_RESULT deletem_HSTimerEvent(HSTimerEvent *pObj);





/* timer request functions
*/
typedef enum
{
	e_TimerType_Once,
	e_TimerType_Forever
} TimerType;

HS_RESULT HSSetTimer(HS_UINT pTime,HS_QID pQid,HS_TID pTid,HS_UINT pSub,TimerType pType);
HS_RESULT HSKillTimer(HS_TID pT,HS_UINT pSub);





#endif/*__HSTIMER_H__*/
