/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<HSUtil.c>		2005-10-18,22:09

*/

#include "HSUtil.h"

#if defined(_LINUX)
#include <netdb.h>
extern int h_errno;
#endif





/* convert functions
*/
HS_RESULT Uchar2Uint(HS_UINT *pUint,HS_UCHAR *pUchar)
{
	if( pUint==NULL || pUchar==NULL )
		return HS_ERR_NULL_PARAM;

#ifdef HS_BIG_ENDIAN
	memcpy(pUint,pUchar,4);
#else
	((unsigned char*)pUint)[3] = pUchar[0];
	((unsigned char*)pUint)[2] = pUchar[1];
	((unsigned char*)pUint)[1] = pUchar[2];
	((unsigned char*)pUint)[0] = pUchar[3];
#endif

	return HS_OK;
}



HS_RESULT Uint2Uchar(HS_UCHAR *pUchar,HS_UINT *pUint)
{
	if( pUchar==NULL || pUint==NULL )
		return HS_ERR_NULL_PARAM;

#ifdef HS_BIG_ENDIAN
	memcpy(pUchar,pUint,4);
#else
	pUchar[0] = ((unsigned char*)pUint)[3];
	pUchar[1] = ((unsigned char*)pUint)[2];
	pUchar[2] = ((unsigned char*)pUint)[1];
	pUchar[3] = ((unsigned char*)pUint)[0];
#endif

	return HS_OK;
}



HS_RESULT Uchar2Ushort(HS_USHORT *pUshort,HS_UCHAR *pUchar)
{
	if( pUshort==NULL || pUchar==NULL )
		return HS_ERR_NULL_PARAM;

#ifdef HS_BIG_ENDIAN
	memcpy(pUshort,pUchar,2);
#else
	((unsigned char*)pUshort)[1] = pUchar[0];
	((unsigned char*)pUshort)[0] = pUchar[1];
#endif

	return HS_OK;
}



HS_RESULT Ushort2Uchar(HS_UCHAR *pUchar,HS_USHORT *pUshort)
{
	if( pUchar==NULL || pUshort==NULL )
		return HS_ERR_NULL_PARAM;

#ifdef HS_BIG_ENDIAN
	memcpy(pUchar,pUshort,2);
#else
	pUchar[0] = ((unsigned char*)pUshort)[1];
	pUchar[1] = ((unsigned char*)pUshort)[0];
#endif

	return HS_OK;
}


HS_RESULT Name2IpAddr(HS_UINT *pIpAddr,char *pName)
{
	HS_UINT tAddr = 0;

	if( pIpAddr==NULL || pName==NULL ) return HS_ERR_NULL_PARAM;

#if defined(_WIN32) || defined(_WIN32_WCE)
	if( (tAddr=inet_addr(pName))==INADDR_NONE )
	{
		struct hostent *tEntry = gethostbyname(pName);
		if( tEntry==NULL )
			return HS_ERR;

		tAddr = *((unsigned long *)(tEntry->h_addr_list[0]));
	}
#elif defined(_VXWORKS)
	tAddr = inet_addr(pName);

	if( tAddr==ERROR )
		tAddr = hostGetByName(pName);

	if( tAddr==ERROR )
		return HS_ERR;
#elif defined(_LINUX)
	if( (tAddr=inet_addr(pName))==INADDR_NONE )
	{
		struct hostent *tEntry = gethostbyname((const char*)pName);

		if( tEntry==NULL )
			return HS_ERR;

		tAddr = *((unsigned long *)(tEntry->h_addr_list[0]));
	}
#endif

	*pIpAddr = tAddr;
	return HS_OK;
}





/* alloc functions
*/
char *HSStringAlloc(char *pString)
{
	char *tRet = NULL;

	if( pString==NULL ) return NULL;
	/*if( strlen(pString)==0 ) return NULL;*/
	if( (tRet=(char*)HSMalloc(strlen(pString)+1))==NULL ) return NULL;
	strcpy(tRet,pString);
	return tRet;
}


char *HSStringAllocEx(char *pString, HS_UINT pSize)
{
	char *tRet = NULL;

	if( pString==NULL ) return NULL;
	/*if( pSize==0 ) return NULL;*/
	if( (tRet=(char*)HSMalloc(pSize+1))==NULL ) return NULL;
	memcpy(tRet,pString,pSize);
	tRet[pSize]='\0';
	return tRet;
}


char *HSUintAlloc(HS_UINT pUint)
{
	char tString[32];
	char *tCharp = NULL;

	sprintf(tString,"%u",pUint);
	if( (tCharp=(char*)HSMalloc(strlen(tString)+1)) == NULL )
		return NULL;

	strcpy(tCharp,tString);
	return tCharp;
}




/* etc..
*/
void HSSleep(HS_UINT pMilliSec)
{

#if defined(_WIN32) || defined(_WIN32_WCE)
	if( pMilliSec==0 )
		Sleep(1);
	else
		Sleep(pMilliSec);
#elif defined(_VXWORKS)
	HS_UINT tSysClkRate = sysClkRateGet();
	if( pMilliSec<tSysClkRate )
		taskDelay(1);
	else
		taskDelay(tSysClkRate*pMilliSec/1000);
#elif defined(_LINUX)
	if( pMilliSec < 1000 )
		sleep(1);
	else
		sleep(pMilliSec/1000);
#endif
}




