/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<TcpConnect.c>		2005-03-27,16:42

*/

#include "TcpConnect.h"





/* TcpConnected member functions
*/
TcpConnected *newm_TcpConnected(SOCKET pSocket, HS_TR_HANDLE pHandle)
{
	TcpConnected *pObj = NULL;

	if( (pObj=(TcpConnected*)HSMalloc(sizeof(TcpConnected)))==NULL )
		return NULL;
	pObj->mSocket = pSocket;
	pObj->mHandle = pHandle;
	return pObj;
}


HS_RESULT delete_TcpConnected(void *pObject)
{
	TcpConnected *pObj = (TcpConnected*)pObject;

	if( pObj==NULL )
		return HS_ERR_NULL_PARAM;
	pObj->mSocket = INVALID_SOCKET;
	pObj->mHandle = HS_INVALID_HANDLE;
	return HS_OK;
}


HS_RESULT deletem_TcpConnected(void *pObject)
{
	HS_RESULT tRet;

	HS_TRY( delete_TcpConnected(pObject) );
	HSFree(pObject);
	return HS_OK;
}





/* TcpConnect member functions
*/
TcpConnect *newm_TcpConnect(HS_UINT pIp,HS_USHORT pPort,HS_QID pQid,HS_TR_HANDLE pHandle)
{
	TcpConnect *tResult = NULL;

	if( pPort==HS_INVALID_TSAP_PORT || pQid==HS_INVALID_QID || pHandle==HS_INVALID_HANDLE ) return NULL;
	if( (tResult=(TcpConnect*)HSMalloc(sizeof(TcpConnect)))==NULL) return NULL;

	HS_THREAD_INIT(tResult,"tcp_conn");
	tResult->mIp   = pIp;
	tResult->mPort = pPort;

	tResult->mTarget = pQid;
	tResult->mHandle = pHandle;
	return tResult;
}


TcpConnect *newm_TcpConnectEx(HS_UCHAR *pIp,HS_USHORT pPort,HS_QID pQid,HS_TR_HANDLE pHandle)
{
	HS_UINT tIp;

	if( pIp==NULL || pPort==HS_INVALID_TSAP_PORT || pQid==HS_INVALID_QID || pHandle==HS_INVALID_HANDLE ) return NULL;
	if( Uchar2Uint(&tIp,pIp) != HS_OK ) return NULL;

	return newm_TcpConnect(htonl(tIp),pPort,pQid,pHandle);
}


TcpConnect *newm_TcpConnectEx1(char *pDest,HS_USHORT pPort,HS_QID pQid,HS_TR_HANDLE pHandle)
{
	HS_UINT tIp;
	TcpConnect *tResult = NULL;

	if( pDest==NULL || pPort==HS_INVALID_TSAP_PORT || pQid==HS_INVALID_QID || pHandle==HS_INVALID_HANDLE ) return NULL;
	if( Name2IpAddr(&tIp,pDest)!=HS_OK ) return NULL;

	return newm_TcpConnect(tIp,pPort,pQid,pHandle);
}


HS_RESULT delete_TcpConnect(void *pObject)
{
	TcpConnect *pObj = (TcpConnect*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	HS_THREAD_INIT(pObj,NULL);
	pObj->mIp   = 0;
	pObj->mPort = HS_INVALID_TSAP_PORT;
	pObj->mTarget = HS_INVALID_QID;
	pObj->mHandle = HS_INVALID_HANDLE;
	return HS_OK;
}


HS_RESULT deletem_TcpConnect(void *pObject)
{
	HS_RESULT tRet;

	HS_TRY( delete_TcpConnect(pObject) );
	HSFree(pObject);
	return HS_OK;
}





/* connection thread
*/
HS_RESULT TcpConnect_Demon(HS_TQ pQ,void *pObject,void *pArg)
{
	SOCKET	tSock;
	struct sockaddr_in tSockIn;
	TcpConnected *tConnected = NULL;
	TcpConnect *pObj = (TcpConnect*)pObject;

	if( pObj==NULL || pQ==HS_INVALID_TQ )
		return HSExitThread(pQ,HS_ERR_NULL_PARAM);

	if( (tSock=socket(AF_INET,SOCK_STREAM,0))==INVALID_SOCKET )
		tConnected = newm_TcpConnected(INVALID_SOCKET,pObj->mHandle);
	else
	{
		memset(&tSockIn,0,sizeof(tSockIn));
		tSockIn.sin_family = AF_INET;
		tSockIn.sin_addr.s_addr	= pObj->mIp;
		tSockIn.sin_port = htons(pObj->mPort);

		if( connect(tSock,(struct sockaddr*)(&tSockIn),sizeof(tSockIn))==0 )
			tConnected = newm_TcpConnected(tSock,pObj->mHandle);
		else
		{
			closesocket(tSock);
			tConnected = newm_TcpConnected(INVALID_SOCKET,pObj->mHandle);
		}
	}

	_HSThreadSendMessage(pObj->mTarget,HS_QM_CONNECTED,0,(HS_UINT)tConnected);
	deletem_TcpConnect(pObj);
	return HSExitThread(pQ,HS_OK);
}


HS_RESULT HSConnect(HS_UINT pIp,HS_USHORT pPort,HS_QID pQid,HS_TR_HANDLE pHandle)
{
	TcpConnect *tObj = NULL;

	if( (tObj=newm_TcpConnect(pIp,pPort,pQid,pHandle))==NULL ) return HS_ERR_MALLOC;

	return HSConnectEx2(tObj);
}


HS_RESULT HSConnectEx(HS_UCHAR *pIp,HS_USHORT pPort,HS_QID pQid,HS_TR_HANDLE pHandle)
{
	TcpConnect *tObj = NULL;

	if( pIp==NULL ) return HS_ERR_NULL_PARAM;
	if( (tObj=newm_TcpConnectEx(pIp,pPort,pQid,pHandle))==NULL ) return HS_ERR_MALLOC;

	return HSConnectEx2(tObj);
}


HS_RESULT HSConnectEx1(char *pDest,HS_USHORT pPort,HS_QID pQid,HS_TR_HANDLE pHandle)
{
	TcpConnect *tObj = NULL;

	if( pDest==NULL ) return HS_ERR_NULL_PARAM;
	if( (tObj=newm_TcpConnectEx1(pDest,pPort,pQid,pHandle))==NULL ) return HS_ERR_MALLOC;

	return HSConnectEx2(tObj);
}


HS_RESULT HSConnectEx2(TcpConnect *pObj)
{
	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( HSThreadStart(pObj,NULL,TcpConnect_Demon)==HS_INVALID_QID )
		return HS_ERR;
	return HS_OK;
}





