/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<h225_0.c>

*/

#include "H225.h"

ASN_NO_USE_YET_C(H225ClearToken,"H225ClearToken")
ASN_NO_USE_YET_C(H225CryptoH323Token,"H225CryptoH323Token")
ASN_NO_USE_YET_C(H225AuthenticationMechanism,"H225AuthenticationMechanism")
/*Inheritance*/
HS_RESULT new_ASNH225NumberDigits( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH225NumberDigits *pObj = (ASNH225NumberDigits *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225NumberDigits(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if( new_AsnSingleString( &(pObj->inheritance), e_asnTagIA5String,e_constrained,1,128,0,HS_ASN_MAX_CONSTRAINT ) != HS_OK )
		return HS_ERR_NULL_PARAM;
	/*From Constraint*/
	ss = &(pObj->inheritance);
	strcpy((char*)(ss->fromConstraint), "#*,0123456789");
	ss->fromSize = 13;
	ss->reIndexing = GetStringTypeEncodingBits(
		ss->fromSize,
		ASN_IA5_STRING_VMAX,
		&(ss->encodingBitsOfAlign),
		&(ss->encodingBitsOfUnalign)
	);

	return HS_OK;
}
HS_RESULT delete_ASNH225NumberDigits( void *pObject )
{
	ASNH225NumberDigits *pObj = (ASNH225NumberDigits *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnSingleString( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225NumberDigits_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH225NumberDigits *pObj = (ASNH225NumberDigits *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnSingleString_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH225NumberDigits_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH225NumberDigits_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH225NumberDigits *pObj = (ASNH225NumberDigits *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnSingleString_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH225NumberDigits_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH225NumberDigits *pObj = (ASNH225NumberDigits *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnSingleString_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH225TBCD_STRING( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH225TBCD_STRING *pObj = (ASNH225TBCD_STRING *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225TBCD_STRING(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if( new_AsnSingleString( &(pObj->inheritance), e_asnTagIA5String,e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT ) != HS_OK )
		return HS_ERR_NULL_PARAM;
	/*From Constraint*/
	ss = &(pObj->inheritance);
	strcpy((char*)(ss->fromConstraint), "#*0123456789abc");
	ss->fromSize = 15;
	ss->reIndexing = GetStringTypeEncodingBits(
		ss->fromSize,
		ASN_IA5_STRING_VMAX,
		&(ss->encodingBitsOfAlign),
		&(ss->encodingBitsOfUnalign)
	);

	return HS_OK;
}
HS_RESULT delete_ASNH225TBCD_STRING( void *pObject )
{
	ASNH225TBCD_STRING *pObj = (ASNH225TBCD_STRING *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnSingleString( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225TBCD_STRING_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH225TBCD_STRING *pObj = (ASNH225TBCD_STRING *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnSingleString_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH225TBCD_STRING_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH225TBCD_STRING_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH225TBCD_STRING *pObj = (ASNH225TBCD_STRING *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnSingleString_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH225TBCD_STRING_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH225TBCD_STRING *pObj = (ASNH225TBCD_STRING *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnSingleString_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH225GloballyUniqueID( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH225GloballyUniqueID *pObj = (ASNH225GloballyUniqueID *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225GloballyUniqueID(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnOctetString( &(pObj->inheritance), e_constrained,16,16,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH225GloballyUniqueID( void *pObject )
{
	ASNH225GloballyUniqueID *pObj = (ASNH225GloballyUniqueID *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnOctetString( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225GloballyUniqueID_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH225GloballyUniqueID *pObj = (ASNH225GloballyUniqueID *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnOctetString_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH225GloballyUniqueID_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH225GloballyUniqueID_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH225GloballyUniqueID *pObj = (ASNH225GloballyUniqueID *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnOctetString_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH225GloballyUniqueID_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH225GloballyUniqueID *pObj = (ASNH225GloballyUniqueID *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnOctetString_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH225RequestSeqNum( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH225RequestSeqNum *pObj = (ASNH225RequestSeqNum *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225RequestSeqNum(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnInteger( &(pObj->inheritance), e_constrained,1,65535,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH225RequestSeqNum( void *pObject )
{
	ASNH225RequestSeqNum *pObj = (ASNH225RequestSeqNum *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnInteger( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225RequestSeqNum_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH225RequestSeqNum *pObj = (ASNH225RequestSeqNum *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH225RequestSeqNum_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH225RequestSeqNum_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH225RequestSeqNum *pObj = (ASNH225RequestSeqNum *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH225RequestSeqNum_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH225RequestSeqNum *pObj = (ASNH225RequestSeqNum *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH225GatekeeperIdentifier( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH225GatekeeperIdentifier *pObj = (ASNH225GatekeeperIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225GatekeeperIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if( new_AsnDoubleString( &(pObj->inheritance), e_asnTagBMPString,e_constrained,1,128,0,HS_ASN_MAX_CONSTRAINT ) != HS_OK )
		return HS_ERR_NULL_PARAM;
	return HS_OK;
}
HS_RESULT delete_ASNH225GatekeeperIdentifier( void *pObject )
{
	ASNH225GatekeeperIdentifier *pObj = (ASNH225GatekeeperIdentifier *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnDoubleString( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225GatekeeperIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH225GatekeeperIdentifier *pObj = (ASNH225GatekeeperIdentifier *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnDoubleString_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH225GatekeeperIdentifier_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH225GatekeeperIdentifier_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH225GatekeeperIdentifier *pObj = (ASNH225GatekeeperIdentifier *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnDoubleString_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH225GatekeeperIdentifier_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH225GatekeeperIdentifier *pObj = (ASNH225GatekeeperIdentifier *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnDoubleString_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH225BandWidth( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH225BandWidth *pObj = (ASNH225BandWidth *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225BandWidth(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnInteger( &(pObj->inheritance), e_constrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH225BandWidth( void *pObject )
{
	ASNH225BandWidth *pObj = (ASNH225BandWidth *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnInteger( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225BandWidth_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH225BandWidth *pObj = (ASNH225BandWidth *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH225BandWidth_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH225BandWidth_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH225BandWidth *pObj = (ASNH225BandWidth *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH225BandWidth_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH225BandWidth *pObj = (ASNH225BandWidth *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH225CallReferenceValue( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH225CallReferenceValue *pObj = (ASNH225CallReferenceValue *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225CallReferenceValue(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnInteger( &(pObj->inheritance), e_constrained,0,65535,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH225CallReferenceValue( void *pObject )
{
	ASNH225CallReferenceValue *pObj = (ASNH225CallReferenceValue *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnInteger( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225CallReferenceValue_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH225CallReferenceValue *pObj = (ASNH225CallReferenceValue *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH225CallReferenceValue_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH225CallReferenceValue_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH225CallReferenceValue *pObj = (ASNH225CallReferenceValue *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH225CallReferenceValue_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH225CallReferenceValue *pObj = (ASNH225CallReferenceValue *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH225EndpointIdentifier( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH225EndpointIdentifier *pObj = (ASNH225EndpointIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225EndpointIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if( new_AsnDoubleString( &(pObj->inheritance), e_asnTagBMPString,e_constrained,1,128,0,HS_ASN_MAX_CONSTRAINT ) != HS_OK )
		return HS_ERR_NULL_PARAM;
	return HS_OK;
}
HS_RESULT delete_ASNH225EndpointIdentifier( void *pObject )
{
	ASNH225EndpointIdentifier *pObj = (ASNH225EndpointIdentifier *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnDoubleString( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225EndpointIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH225EndpointIdentifier *pObj = (ASNH225EndpointIdentifier *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnDoubleString_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH225EndpointIdentifier_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH225EndpointIdentifier_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH225EndpointIdentifier *pObj = (ASNH225EndpointIdentifier *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnDoubleString_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH225EndpointIdentifier_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH225EndpointIdentifier *pObj = (ASNH225EndpointIdentifier *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnDoubleString_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH225ProtocolIdentifier( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH225ProtocolIdentifier *pObj = (ASNH225ProtocolIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225ProtocolIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnObjectIdentifier( &(pObj->inheritance) );
}
HS_RESULT delete_ASNH225ProtocolIdentifier( void *pObject )
{
	ASNH225ProtocolIdentifier *pObj = (ASNH225ProtocolIdentifier *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnObjectIdentifier( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ProtocolIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH225ProtocolIdentifier *pObj = (ASNH225ProtocolIdentifier *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnObjectIdentifier_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH225ProtocolIdentifier_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH225ProtocolIdentifier_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH225ProtocolIdentifier *pObj = (ASNH225ProtocolIdentifier *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnObjectIdentifier_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH225ProtocolIdentifier_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH225ProtocolIdentifier *pObj = (ASNH225ProtocolIdentifier *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnObjectIdentifier_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH225TimeToLive( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH225TimeToLive *pObj = (ASNH225TimeToLive *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225TimeToLive(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnInteger( &(pObj->inheritance), e_constrained,1,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH225TimeToLive( void *pObject )
{
	ASNH225TimeToLive *pObj = (ASNH225TimeToLive *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnInteger( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225TimeToLive_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH225TimeToLive *pObj = (ASNH225TimeToLive *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH225TimeToLive_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH225TimeToLive_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH225TimeToLive *pObj = (ASNH225TimeToLive *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH225TimeToLive_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH225TimeToLive *pObj = (ASNH225TimeToLive *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnInteger_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH225H248PackagesDescriptor( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH225H248PackagesDescriptor *pObj = (ASNH225H248PackagesDescriptor *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225H248PackagesDescriptor(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnOctetString( &(pObj->inheritance), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH225H248PackagesDescriptor( void *pObject )
{
	ASNH225H248PackagesDescriptor *pObj = (ASNH225H248PackagesDescriptor *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnOctetString( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225H248PackagesDescriptor_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH225H248PackagesDescriptor *pObj = (ASNH225H248PackagesDescriptor *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnOctetString_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH225H248PackagesDescriptor_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH225H248PackagesDescriptor_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH225H248PackagesDescriptor *pObj = (ASNH225H248PackagesDescriptor *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnOctetString_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH225H248PackagesDescriptor_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH225H248PackagesDescriptor *pObj = (ASNH225H248PackagesDescriptor *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnOctetString_Decode( &(pObj->inheritance), pStrm );
}
/*Inheritance*/
HS_RESULT new_ASNH225H248SignalsDescriptor( void *pObject )
{
	AsnSingleString *ss = HS_NULL;
	AsnDoubleString *ds = HS_NULL;
	ASNH225H248SignalsDescriptor *pObj = (ASNH225H248SignalsDescriptor *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225H248SignalsDescriptor(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	return new_AsnOctetString( &(pObj->inheritance), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
}
HS_RESULT delete_ASNH225H248SignalsDescriptor( void *pObject )
{
	ASNH225H248SignalsDescriptor *pObj = (ASNH225H248SignalsDescriptor *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return delete_AsnOctetString( &(pObj->inheritance) );
}
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225H248SignalsDescriptor_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	ASNH225H248SignalsDescriptor *pObj = (ASNH225H248SignalsDescriptor *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnOctetString_Print( &(pObj->inheritance), pDepth, pTypeName );
}
#endif
HS_RESULT ASNH225H248SignalsDescriptor_MakeMold( void *pObject ){return HS_OK;}
HS_RESULT ASNH225H248SignalsDescriptor_Encode( void *pObject, AsnStream *pStrm )
{
	ASNH225H248SignalsDescriptor *pObj = (ASNH225H248SignalsDescriptor *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnOctetString_Encode( &(pObj->inheritance), pStrm );
}
HS_RESULT ASNH225H248SignalsDescriptor_Decode( void *pObject, AsnStream *pStrm )
{
	ASNH225H248SignalsDescriptor *pObj = (ASNH225H248SignalsDescriptor *)pObject;
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	return AsnOctetString_Decode( &(pObj->inheritance), pStrm );
}
/***************************************************************************************/
/* ASNH225H323_UserInformation_user_data Class
*/
/*ASNH225H323_UserInformation_user_data Constructor*/
HS_RESULT new_ASNH225H323_UserInformation_user_data(void *pObject)
{
	ASNH225H323_UserInformation_user_data *pObj = (ASNH225H323_UserInformation_user_data *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225H323_UserInformation_user_data(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_protocol_discriminator), e_constrained, 0, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnOctetString( &(pObj->m_user_information), e_constrained, 1, 131, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH225H323_UserInformation_user_data Destructor */
HS_RESULT delete_ASNH225H323_UserInformation_user_data(void *pObject)
{
	ASNH225H323_UserInformation_user_data *pObj = (ASNH225H323_UserInformation_user_data *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225H323_UserInformation_user_data(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_protocol_discriminator) );
	delete_AsnOctetString( &(pObj->m_user_information) );
	return HS_OK;
}

/* ASNH225H323_UserInformation_user_data MakeMold */
HS_RESULT ASNH225H323_UserInformation_user_data_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225H323_UserInformation_user_data *pObj = (ASNH225H323_UserInformation_user_data *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H323_UserInformation_user_data_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH225H323_UserInformation_user_data Encode */
HS_RESULT ASNH225H323_UserInformation_user_data_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225H323_UserInformation_user_data *pObj = (ASNH225H323_UserInformation_user_data *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H323_UserInformation_user_data_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_protocol_discriminator),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H323_UserInformation_user_data_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Encode( &(pObj->m_user_information),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H323_UserInformation_user_data_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225H323_UserInformation_user_data Decode */
HS_RESULT ASNH225H323_UserInformation_user_data_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225H323_UserInformation_user_data *pObj = (ASNH225H323_UserInformation_user_data *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H323_UserInformation_user_data_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_protocol_discriminator),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H323_UserInformation_user_data_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Decode(&(pObj->m_user_information),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H323_UserInformation_user_data_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225H323_UserInformation_user_data Print */
HS_RESULT ASNH225H323_UserInformation_user_data_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225H323_UserInformation_user_data *pObj = (ASNH225H323_UserInformation_user_data *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225H323_UserInformation_user_data_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_protocol_discriminator), pDepth+1, "protocol_discriminator" );
	AsnOctetString_Print( &(pObj->m_user_information), pDepth+1, "user_information" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225TransportAddress_ipAddress Class
*/
/*ASNH225TransportAddress_ipAddress Constructor*/
HS_RESULT new_ASNH225TransportAddress_ipAddress(void *pObject)
{
	ASNH225TransportAddress_ipAddress *pObj = (ASNH225TransportAddress_ipAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225TransportAddress_ipAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = FALSE;
	pObj->extended = FALSE;
	new_AsnOctetString( &(pObj->m_ip), e_constrained, 4, 4, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_port), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH225TransportAddress_ipAddress Destructor */
HS_RESULT delete_ASNH225TransportAddress_ipAddress(void *pObject)
{
	ASNH225TransportAddress_ipAddress *pObj = (ASNH225TransportAddress_ipAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225TransportAddress_ipAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnOctetString( &(pObj->m_ip) );
	delete_AsnInteger( &(pObj->m_port) );
	return HS_OK;
}

/* ASNH225TransportAddress_ipAddress MakeMold */
HS_RESULT ASNH225TransportAddress_ipAddress_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225TransportAddress_ipAddress *pObj = (ASNH225TransportAddress_ipAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipAddress_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH225TransportAddress_ipAddress Encode */
HS_RESULT ASNH225TransportAddress_ipAddress_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225TransportAddress_ipAddress *pObj = (ASNH225TransportAddress_ipAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipAddress_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnOctetString_Encode( &(pObj->m_ip),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_port),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225TransportAddress_ipAddress Decode */
HS_RESULT ASNH225TransportAddress_ipAddress_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225TransportAddress_ipAddress *pObj = (ASNH225TransportAddress_ipAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipAddress_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnOctetString_Decode(&(pObj->m_ip),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipAddress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_port),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipAddress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225TransportAddress_ipAddress Print */
HS_RESULT ASNH225TransportAddress_ipAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225TransportAddress_ipAddress *pObj = (ASNH225TransportAddress_ipAddress *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225TransportAddress_ipAddress_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnOctetString_Print( &(pObj->m_ip), pDepth+1, "ip" );
	AsnInteger_Print( &(pObj->m_port), pDepth+1, "port" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225TransportAddress_ipSourceRoute_routing Struct
*/
/* ASNH225TransportAddress_ipSourceRoute_routing Constructor */
HS_RESULT new_ASNH225TransportAddress_ipSourceRoute_routing( void *pObject )
{
	ASNH225TransportAddress_ipSourceRoute_routing *pObj = (ASNH225TransportAddress_ipSourceRoute_routing *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225TransportAddress_ipSourceRoute_routing(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225TransportAddress_ipSourceRoute_routingChoice_strict;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225TransportAddress_ipSourceRoute_routingChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225TransportAddress_ipSourceRoute_routing Destructor */
HS_RESULT delete_ASNH225TransportAddress_ipSourceRoute_routing( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225TransportAddress_ipSourceRoute_routing *pObj = (ASNH225TransportAddress_ipSourceRoute_routing *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225TransportAddress_ipSourceRoute_routing(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225TransportAddress_ipSourceRoute_routing_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225TransportAddress_ipSourceRoute_routing(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225TransportAddress_ipSourceRoute_routing SetChoice */
void* ASNH225TransportAddress_ipSourceRoute_routing_SetChoice( void *pObject, ASNH225TransportAddress_ipSourceRoute_routingChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225TransportAddress_ipSourceRoute_routing *pObj = (ASNH225TransportAddress_ipSourceRoute_routing *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_routing_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225TransportAddress_ipSourceRoute_routingChoiceSizeExt ){
		if( pChoice > (ASNH225TransportAddress_ipSourceRoute_routingChoice)(e_ASNH225TransportAddress_ipSourceRoute_routingChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_routing_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225TransportAddress_ipSourceRoute_routing_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_routing_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225TransportAddress_ipSourceRoute_routingChoice_strict ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225TransportAddress_ipSourceRoute_routingChoice_loose ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_routing_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225TransportAddress_ipSourceRoute_routing DeleteAlternation */
HS_RESULT ASNH225TransportAddress_ipSourceRoute_routing_DeleteAlternation(void *pObject)
{
	ASNH225TransportAddress_ipSourceRoute_routing *pObj = (ASNH225TransportAddress_ipSourceRoute_routing *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_routing_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225TransportAddress_ipSourceRoute_routingChoice_strict ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225TransportAddress_ipSourceRoute_routingChoice_loose ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_routing_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225TransportAddress_ipSourceRoute_routing_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225TransportAddress_ipSourceRoute_routing Encode */
HS_RESULT ASNH225TransportAddress_ipSourceRoute_routing_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225TransportAddress_ipSourceRoute_routing *pObj = (ASNH225TransportAddress_ipSourceRoute_routing *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_routing_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_routing_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225TransportAddress_ipSourceRoute_routingChoiceSize )
		{
			if( pObj->choice > ((ASNH225TransportAddress_ipSourceRoute_routingChoice)(e_ASNH225TransportAddress_ipSourceRoute_routingChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225TransportAddress_ipSourceRoute_routingChoiceSize)) )
	}
	else
	{
		if( e_ASNH225TransportAddress_ipSourceRoute_routingChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225TransportAddress_ipSourceRoute_routingChoice_strict ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_routing_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225TransportAddress_ipSourceRoute_routingChoice_loose ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_routing_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_routing_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225TransportAddress_ipSourceRoute_routing Decode */
HS_RESULT ASNH225TransportAddress_ipSourceRoute_routing_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225TransportAddress_ipSourceRoute_routing *pObj = (ASNH225TransportAddress_ipSourceRoute_routing *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_routing_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225TransportAddress_ipSourceRoute_routingChoiceSize;
	}
	else
	{
		if( e_ASNH225TransportAddress_ipSourceRoute_routingChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225TransportAddress_ipSourceRoute_routingChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225TransportAddress_ipSourceRoute_routingChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_routing_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225TransportAddress_ipSourceRoute_routing_SetChoice( pObj, (ASNH225TransportAddress_ipSourceRoute_routingChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_routing_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225TransportAddress_ipSourceRoute_routingChoice_strict ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_routing_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225TransportAddress_ipSourceRoute_routingChoice_loose ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_routing_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_routing_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225TransportAddress_ipSourceRoute_routing Print */
HS_RESULT ASNH225TransportAddress_ipSourceRoute_routing_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225TransportAddress_ipSourceRoute_routing *pObj = (ASNH225TransportAddress_ipSourceRoute_routing *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_routing_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225TransportAddress_ipSourceRoute_routingChoice_strict ){
		AsnNull_Print( pObj->alter, pDepth+1, "strict" );
	}
	else if ( pObj->choice == e_ASNH225TransportAddress_ipSourceRoute_routingChoice_loose ){
		AsnNull_Print( pObj->alter, pDepth+1, "loose" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225TransportAddress_ipSourceRoute Class
*/
/*ASNH225TransportAddress_ipSourceRoute Constructor*/
HS_RESULT new_ASNH225TransportAddress_ipSourceRoute(void *pObject)
{
	ASNH225TransportAddress_ipSourceRoute *pObj = (ASNH225TransportAddress_ipSourceRoute *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225TransportAddress_ipSourceRoute(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnOctetString( &(pObj->m_ip), e_constrained, 4, 4, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_port), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_route), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225TransportAddress_ipSourceRoute_routing( &(pObj->m_routing) );

	return HS_OK;
}

/* ASNH225TransportAddress_ipSourceRoute Destructor */
HS_RESULT delete_ASNH225TransportAddress_ipSourceRoute(void *pObject)
{
	ASNH225TransportAddress_ipSourceRoute *pObj = (ASNH225TransportAddress_ipSourceRoute *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225TransportAddress_ipSourceRoute(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnOctetString( &(pObj->m_ip) );
	delete_AsnInteger( &(pObj->m_port) );
	delete_AsnSequenceOf( &(pObj->m_route) );
	delete_ASNH225TransportAddress_ipSourceRoute_routing( &(pObj->m_routing) );
	return HS_OK;
}

/* ASNH225TransportAddress_ipSourceRoute MakeMold */
HS_RESULT ASNH225TransportAddress_ipSourceRoute_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225TransportAddress_ipSourceRoute *pObj = (ASNH225TransportAddress_ipSourceRoute *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	AsnOctetString *tmold_route = (AsnOctetString *)HSMalloc( sizeof(AsnOctetString) );
	new_AsnOctetString(tmold_route,e_constrained,4,4,0,HS_ASN_MAX_CONSTRAINT);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_route,sizeof(AsnOctetString),AsnOctetString_MakeMold,AsnOctetString_Encode,AsnOctetString_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		AsnOctetString_Print,
#endif
		delete_AsnOctetString);
	AsnSequenceOf_SetMold( &(pObj->m_route), moldObject );
	}
	return HS_OK;
}

/* ASNH225TransportAddress_ipSourceRoute Encode */
HS_RESULT ASNH225TransportAddress_ipSourceRoute_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225TransportAddress_ipSourceRoute *pObj = (ASNH225TransportAddress_ipSourceRoute *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnOctetString_Encode( &(pObj->m_ip),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_port),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_route),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225TransportAddress_ipSourceRoute_routing_Encode( &(pObj->m_routing),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225TransportAddress_ipSourceRoute Decode */
HS_RESULT ASNH225TransportAddress_ipSourceRoute_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225TransportAddress_ipSourceRoute *pObj = (ASNH225TransportAddress_ipSourceRoute *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnOctetString_Decode(&(pObj->m_ip),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_port),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_route),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225TransportAddress_ipSourceRoute_routing_Decode(&(pObj->m_routing),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225TransportAddress_ipSourceRoute Print */
HS_RESULT ASNH225TransportAddress_ipSourceRoute_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225TransportAddress_ipSourceRoute *pObj = (ASNH225TransportAddress_ipSourceRoute *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225TransportAddress_ipSourceRoute_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnOctetString_Print( &(pObj->m_ip), pDepth+1, "ip" );
	AsnInteger_Print( &(pObj->m_port), pDepth+1, "port" );
	AsnSequenceOf_Print( &(pObj->m_route), pDepth+1, "route" );
	ASNH225TransportAddress_ipSourceRoute_routing_Print( &(pObj->m_routing), pDepth+1, "routing" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225TransportAddress_ipxAddress Class
*/
/*ASNH225TransportAddress_ipxAddress Constructor*/
HS_RESULT new_ASNH225TransportAddress_ipxAddress(void *pObject)
{
	ASNH225TransportAddress_ipxAddress *pObj = (ASNH225TransportAddress_ipxAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225TransportAddress_ipxAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = FALSE;
	pObj->extended = FALSE;
	new_AsnOctetString( &(pObj->m_node), e_constrained, 6, 6, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnOctetString( &(pObj->m_netnum), e_constrained, 4, 4, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnOctetString( &(pObj->m_port), e_constrained, 2, 2, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH225TransportAddress_ipxAddress Destructor */
HS_RESULT delete_ASNH225TransportAddress_ipxAddress(void *pObject)
{
	ASNH225TransportAddress_ipxAddress *pObj = (ASNH225TransportAddress_ipxAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225TransportAddress_ipxAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnOctetString( &(pObj->m_node) );
	delete_AsnOctetString( &(pObj->m_netnum) );
	delete_AsnOctetString( &(pObj->m_port) );
	return HS_OK;
}

/* ASNH225TransportAddress_ipxAddress MakeMold */
HS_RESULT ASNH225TransportAddress_ipxAddress_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225TransportAddress_ipxAddress *pObj = (ASNH225TransportAddress_ipxAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipxAddress_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH225TransportAddress_ipxAddress Encode */
HS_RESULT ASNH225TransportAddress_ipxAddress_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225TransportAddress_ipxAddress *pObj = (ASNH225TransportAddress_ipxAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipxAddress_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnOctetString_Encode( &(pObj->m_node),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipxAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Encode( &(pObj->m_netnum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipxAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Encode( &(pObj->m_port),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipxAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225TransportAddress_ipxAddress Decode */
HS_RESULT ASNH225TransportAddress_ipxAddress_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225TransportAddress_ipxAddress *pObj = (ASNH225TransportAddress_ipxAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipxAddress_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnOctetString_Decode(&(pObj->m_node),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipxAddress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Decode(&(pObj->m_netnum),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipxAddress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Decode(&(pObj->m_port),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ipxAddress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225TransportAddress_ipxAddress Print */
HS_RESULT ASNH225TransportAddress_ipxAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225TransportAddress_ipxAddress *pObj = (ASNH225TransportAddress_ipxAddress *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225TransportAddress_ipxAddress_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnOctetString_Print( &(pObj->m_node), pDepth+1, "node" );
	AsnOctetString_Print( &(pObj->m_netnum), pDepth+1, "netnum" );
	AsnOctetString_Print( &(pObj->m_port), pDepth+1, "port" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225TransportAddress_ip6Address Class
*/
/*ASNH225TransportAddress_ip6Address Constructor*/
HS_RESULT new_ASNH225TransportAddress_ip6Address(void *pObject)
{
	ASNH225TransportAddress_ip6Address *pObj = (ASNH225TransportAddress_ip6Address *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225TransportAddress_ip6Address(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnOctetString( &(pObj->m_ip), e_constrained, 16, 16, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_port), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH225TransportAddress_ip6Address Destructor */
HS_RESULT delete_ASNH225TransportAddress_ip6Address(void *pObject)
{
	ASNH225TransportAddress_ip6Address *pObj = (ASNH225TransportAddress_ip6Address *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225TransportAddress_ip6Address(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnOctetString( &(pObj->m_ip) );
	delete_AsnInteger( &(pObj->m_port) );
	return HS_OK;
}

/* ASNH225TransportAddress_ip6Address MakeMold */
HS_RESULT ASNH225TransportAddress_ip6Address_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225TransportAddress_ip6Address *pObj = (ASNH225TransportAddress_ip6Address *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ip6Address_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH225TransportAddress_ip6Address Encode */
HS_RESULT ASNH225TransportAddress_ip6Address_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225TransportAddress_ip6Address *pObj = (ASNH225TransportAddress_ip6Address *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ip6Address_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnOctetString_Encode( &(pObj->m_ip),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ip6Address_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_port),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ip6Address_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225TransportAddress_ip6Address Decode */
HS_RESULT ASNH225TransportAddress_ip6Address_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225TransportAddress_ip6Address *pObj = (ASNH225TransportAddress_ip6Address *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ip6Address_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnOctetString_Decode(&(pObj->m_ip),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ip6Address_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_port),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_ip6Address_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225TransportAddress_ip6Address Print */
HS_RESULT ASNH225TransportAddress_ip6Address_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225TransportAddress_ip6Address *pObj = (ASNH225TransportAddress_ip6Address *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225TransportAddress_ip6Address_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnOctetString_Print( &(pObj->m_ip), pDepth+1, "ip" );
	AsnInteger_Print( &(pObj->m_port), pDepth+1, "port" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225H221NonStandard Class
*/
/*ASNH225H221NonStandard Constructor*/
HS_RESULT new_ASNH225H221NonStandard(void *pObject)
{
	ASNH225H221NonStandard *pObj = (ASNH225H221NonStandard *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225H221NonStandard(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_t35CountryCode), e_constrained, 0, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_t35Extension), e_constrained, 0, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnInteger( &(pObj->m_manufacturerCode), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH225H221NonStandard Destructor */
HS_RESULT delete_ASNH225H221NonStandard(void *pObject)
{
	ASNH225H221NonStandard *pObj = (ASNH225H221NonStandard *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225H221NonStandard(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_t35CountryCode) );
	delete_AsnInteger( &(pObj->m_t35Extension) );
	delete_AsnInteger( &(pObj->m_manufacturerCode) );
	return HS_OK;
}

/* ASNH225H221NonStandard MakeMold */
HS_RESULT ASNH225H221NonStandard_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225H221NonStandard *pObj = (ASNH225H221NonStandard *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H221NonStandard_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH225H221NonStandard Encode */
HS_RESULT ASNH225H221NonStandard_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225H221NonStandard *pObj = (ASNH225H221NonStandard *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H221NonStandard_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnInteger_Encode( &(pObj->m_t35CountryCode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H221NonStandard_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_t35Extension),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H221NonStandard_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_manufacturerCode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H221NonStandard_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225H221NonStandard Decode */
HS_RESULT ASNH225H221NonStandard_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225H221NonStandard *pObj = (ASNH225H221NonStandard *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H221NonStandard_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_t35CountryCode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H221NonStandard_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_t35Extension),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H221NonStandard_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_manufacturerCode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H221NonStandard_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225H221NonStandard Print */
HS_RESULT ASNH225H221NonStandard_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225H221NonStandard *pObj = (ASNH225H221NonStandard *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225H221NonStandard_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_t35CountryCode), pDepth+1, "t35CountryCode" );
	AsnInteger_Print( &(pObj->m_t35Extension), pDepth+1, "t35Extension" );
	AsnInteger_Print( &(pObj->m_manufacturerCode), pDepth+1, "manufacturerCode" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225NonStandardIdentifier Struct
*/
/* ASNH225NonStandardIdentifier Constructor */
HS_RESULT new_ASNH225NonStandardIdentifier( void *pObject )
{
	ASNH225NonStandardIdentifier *pObj = (ASNH225NonStandardIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225NonStandardIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225NonStandardIdentifierChoice_object;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225NonStandardIdentifierChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225NonStandardIdentifier Destructor */
HS_RESULT delete_ASNH225NonStandardIdentifier( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225NonStandardIdentifier *pObj = (ASNH225NonStandardIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225NonStandardIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225NonStandardIdentifier_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225NonStandardIdentifier(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225NonStandardIdentifier SetChoice */
void* ASNH225NonStandardIdentifier_SetChoice( void *pObject, ASNH225NonStandardIdentifierChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225NonStandardIdentifier *pObj = (ASNH225NonStandardIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardIdentifier_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225NonStandardIdentifierChoiceSizeExt ){
		if( pChoice > (ASNH225NonStandardIdentifierChoice)(e_ASNH225NonStandardIdentifierChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225NonStandardIdentifier_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225NonStandardIdentifier_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225NonStandardIdentifier_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225NonStandardIdentifierChoice_object ){
		AsnObjectIdentifier *tAlter = (AsnObjectIdentifier *)HSMalloc( sizeof(AsnObjectIdentifier) );
		new_AsnObjectIdentifier(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225NonStandardIdentifierChoice_h221NonStandard ){
		ASNH225H221NonStandard *tAlter = (ASNH225H221NonStandard *)HSMalloc( sizeof(ASNH225H221NonStandard) );
		new_ASNH225H221NonStandard(tAlter);
		ASNH225H221NonStandard_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardIdentifier_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225NonStandardIdentifier DeleteAlternation */
HS_RESULT ASNH225NonStandardIdentifier_DeleteAlternation(void *pObject)
{
	ASNH225NonStandardIdentifier *pObj = (ASNH225NonStandardIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardIdentifier_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225NonStandardIdentifierChoice_object ){
			delete_AsnObjectIdentifier(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225NonStandardIdentifierChoice_h221NonStandard ){
			delete_ASNH225H221NonStandard(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225NonStandardIdentifier_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225NonStandardIdentifier_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225NonStandardIdentifier Encode */
HS_RESULT ASNH225NonStandardIdentifier_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225NonStandardIdentifier *pObj = (ASNH225NonStandardIdentifier *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardIdentifier_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardIdentifier_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225NonStandardIdentifierChoiceSize )
		{
			if( pObj->choice > ((ASNH225NonStandardIdentifierChoice)(e_ASNH225NonStandardIdentifierChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225NonStandardIdentifierChoiceSize)) )
	}
	else
	{
		if( e_ASNH225NonStandardIdentifierChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225NonStandardIdentifierChoice_object ){
		if( (tRet=AsnObjectIdentifier_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225NonStandardIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225NonStandardIdentifierChoice_h221NonStandard ){
		if( (tRet=ASNH225H221NonStandard_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225NonStandardIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardIdentifier_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225NonStandardIdentifier Decode */
HS_RESULT ASNH225NonStandardIdentifier_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225NonStandardIdentifier *pObj = (ASNH225NonStandardIdentifier *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardIdentifier_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225NonStandardIdentifierChoiceSize;
	}
	else
	{
		if( e_ASNH225NonStandardIdentifierChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225NonStandardIdentifierChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225NonStandardIdentifierChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225NonStandardIdentifier_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225NonStandardIdentifier_SetChoice( pObj, (ASNH225NonStandardIdentifierChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardIdentifier_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225NonStandardIdentifierChoice_object ){
		if( (tRet=AsnObjectIdentifier_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225NonStandardIdentifier_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225NonStandardIdentifierChoice_h221NonStandard ){
		if( (tRet=ASNH225H221NonStandard_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225NonStandardIdentifier_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardIdentifier_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225NonStandardIdentifier Print */
HS_RESULT ASNH225NonStandardIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225NonStandardIdentifier *pObj = (ASNH225NonStandardIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225NonStandardIdentifier_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225NonStandardIdentifierChoice_object ){
		AsnObjectIdentifier_Print( pObj->alter, pDepth+1, "object" );
	}
	else if ( pObj->choice == e_ASNH225NonStandardIdentifierChoice_h221NonStandard ){
		ASNH225H221NonStandard_Print( pObj->alter, pDepth+1, "h221NonStandard" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225NonStandardParameter Class
*/
/*ASNH225NonStandardParameter Constructor*/
HS_RESULT new_ASNH225NonStandardParameter(void *pObject)
{
	ASNH225NonStandardParameter *pObj = (ASNH225NonStandardParameter *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225NonStandardParameter(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = FALSE;
	pObj->extended = FALSE;
	new_ASNH225NonStandardIdentifier( &(pObj->m_nonStandardIdentifier) );
	new_AsnOctetString( &(pObj->m_data), e_unconstrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH225NonStandardParameter Destructor */
HS_RESULT delete_ASNH225NonStandardParameter(void *pObject)
{
	ASNH225NonStandardParameter *pObj = (ASNH225NonStandardParameter *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225NonStandardParameter(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225NonStandardIdentifier( &(pObj->m_nonStandardIdentifier) );
	delete_AsnOctetString( &(pObj->m_data) );
	return HS_OK;
}

/* ASNH225NonStandardParameter MakeMold */
HS_RESULT ASNH225NonStandardParameter_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225NonStandardParameter *pObj = (ASNH225NonStandardParameter *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardParameter_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225NonStandardIdentifier_MakeMold(&(pObj->m_nonStandardIdentifier));
	return HS_OK;
}

/* ASNH225NonStandardParameter Encode */
HS_RESULT ASNH225NonStandardParameter_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225NonStandardParameter *pObj = (ASNH225NonStandardParameter *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardParameter_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH225NonStandardIdentifier_Encode( &(pObj->m_nonStandardIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardParameter_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Encode( &(pObj->m_data),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardParameter_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225NonStandardParameter Decode */
HS_RESULT ASNH225NonStandardParameter_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225NonStandardParameter *pObj = (ASNH225NonStandardParameter *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardParameter_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH225NonStandardIdentifier_Decode(&(pObj->m_nonStandardIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardParameter_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Decode(&(pObj->m_data),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardParameter_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225NonStandardParameter Print */
HS_RESULT ASNH225NonStandardParameter_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225NonStandardParameter *pObj = (ASNH225NonStandardParameter *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225NonStandardParameter_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225NonStandardIdentifier_Print( &(pObj->m_nonStandardIdentifier), pDepth+1, "nonStandardIdentifier" );
	AsnOctetString_Print( &(pObj->m_data), pDepth+1, "data" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225TransportAddress Struct
*/
/* ASNH225TransportAddress Constructor */
HS_RESULT new_ASNH225TransportAddress( void *pObject )
{
	ASNH225TransportAddress *pObj = (ASNH225TransportAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225TransportAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225TransportAddressChoice_ipAddress;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225TransportAddressChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225TransportAddress Destructor */
HS_RESULT delete_ASNH225TransportAddress( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225TransportAddress *pObj = (ASNH225TransportAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225TransportAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225TransportAddress_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225TransportAddress(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225TransportAddress SetChoice */
void* ASNH225TransportAddress_SetChoice( void *pObject, ASNH225TransportAddressChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225TransportAddress *pObj = (ASNH225TransportAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225TransportAddressChoiceSizeExt ){
		if( pChoice > (ASNH225TransportAddressChoice)(e_ASNH225TransportAddressChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225TransportAddress_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225TransportAddressChoice_ipAddress ){
		ASNH225TransportAddress_ipAddress *tAlter = (ASNH225TransportAddress_ipAddress *)HSMalloc( sizeof(ASNH225TransportAddress_ipAddress) );
		new_ASNH225TransportAddress_ipAddress(tAlter);
		ASNH225TransportAddress_ipAddress_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225TransportAddressChoice_ipSourceRoute ){
		ASNH225TransportAddress_ipSourceRoute *tAlter = (ASNH225TransportAddress_ipSourceRoute *)HSMalloc( sizeof(ASNH225TransportAddress_ipSourceRoute) );
		new_ASNH225TransportAddress_ipSourceRoute(tAlter);
		ASNH225TransportAddress_ipSourceRoute_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225TransportAddressChoice_ipxAddress ){
		ASNH225TransportAddress_ipxAddress *tAlter = (ASNH225TransportAddress_ipxAddress *)HSMalloc( sizeof(ASNH225TransportAddress_ipxAddress) );
		new_ASNH225TransportAddress_ipxAddress(tAlter);
		ASNH225TransportAddress_ipxAddress_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225TransportAddressChoice_ip6Address ){
		ASNH225TransportAddress_ip6Address *tAlter = (ASNH225TransportAddress_ip6Address *)HSMalloc( sizeof(ASNH225TransportAddress_ip6Address) );
		new_ASNH225TransportAddress_ip6Address(tAlter);
		ASNH225TransportAddress_ip6Address_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225TransportAddressChoice_netBios ){
		AsnOctetString *tAlter = (AsnOctetString *)HSMalloc( sizeof(AsnOctetString) );
		new_AsnOctetString(tAlter,e_constrained,16,16,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225TransportAddressChoice_nsap ){
		AsnOctetString *tAlter = (AsnOctetString *)HSMalloc( sizeof(AsnOctetString) );
		new_AsnOctetString(tAlter,e_constrained,1,20,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225TransportAddressChoice_nonStandardAddress ){
		ASNH225NonStandardParameter *tAlter = (ASNH225NonStandardParameter *)HSMalloc( sizeof(ASNH225NonStandardParameter) );
		new_ASNH225NonStandardParameter(tAlter);
		ASNH225NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225TransportAddress DeleteAlternation */
HS_RESULT ASNH225TransportAddress_DeleteAlternation(void *pObject)
{
	ASNH225TransportAddress *pObj = (ASNH225TransportAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225TransportAddressChoice_ipAddress ){
			delete_ASNH225TransportAddress_ipAddress(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225TransportAddressChoice_ipSourceRoute ){
			delete_ASNH225TransportAddress_ipSourceRoute(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225TransportAddressChoice_ipxAddress ){
			delete_ASNH225TransportAddress_ipxAddress(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225TransportAddressChoice_ip6Address ){
			delete_ASNH225TransportAddress_ip6Address(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225TransportAddressChoice_netBios ){
			delete_AsnOctetString(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225TransportAddressChoice_nsap ){
			delete_AsnOctetString(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225TransportAddressChoice_nonStandardAddress ){
			delete_ASNH225NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225TransportAddress_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225TransportAddress Encode */
HS_RESULT ASNH225TransportAddress_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225TransportAddress *pObj = (ASNH225TransportAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225TransportAddressChoiceSize )
		{
			if( pObj->choice > ((ASNH225TransportAddressChoice)(e_ASNH225TransportAddressChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225TransportAddressChoiceSize)) )
	}
	else
	{
		if( e_ASNH225TransportAddressChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225TransportAddressChoice_ipAddress ){
		if( (tRet=ASNH225TransportAddress_ipAddress_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225TransportAddressChoice_ipSourceRoute ){
		if( (tRet=ASNH225TransportAddress_ipSourceRoute_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225TransportAddressChoice_ipxAddress ){
		if( (tRet=ASNH225TransportAddress_ipxAddress_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225TransportAddressChoice_ip6Address ){
		if( (tRet=ASNH225TransportAddress_ip6Address_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225TransportAddressChoice_netBios ){
		if( (tRet=AsnOctetString_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225TransportAddressChoice_nsap ){
		if( (tRet=AsnOctetString_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225TransportAddressChoice_nonStandardAddress ){
		if( (tRet=ASNH225NonStandardParameter_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225TransportAddress Decode */
HS_RESULT ASNH225TransportAddress_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225TransportAddress *pObj = (ASNH225TransportAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225TransportAddressChoiceSize;
	}
	else
	{
		if( e_ASNH225TransportAddressChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225TransportAddressChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225TransportAddressChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225TransportAddress_SetChoice( pObj, (ASNH225TransportAddressChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225TransportAddressChoice_ipAddress ){
		if( (tRet=ASNH225TransportAddress_ipAddress_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225TransportAddressChoice_ipSourceRoute ){
		if( (tRet=ASNH225TransportAddress_ipSourceRoute_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225TransportAddressChoice_ipxAddress ){
		if( (tRet=ASNH225TransportAddress_ipxAddress_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225TransportAddressChoice_ip6Address ){
		if( (tRet=ASNH225TransportAddress_ip6Address_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225TransportAddressChoice_netBios ){
		if( (tRet=AsnOctetString_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225TransportAddressChoice_nsap ){
		if( (tRet=AsnOctetString_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225TransportAddressChoice_nonStandardAddress ){
		if( (tRet=ASNH225NonStandardParameter_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TransportAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TransportAddress_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225TransportAddress Print */
HS_RESULT ASNH225TransportAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225TransportAddress *pObj = (ASNH225TransportAddress *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225TransportAddress_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225TransportAddressChoice_ipAddress ){
		ASNH225TransportAddress_ipAddress_Print( pObj->alter, pDepth+1, "ipAddress" );
	}
	else if ( pObj->choice == e_ASNH225TransportAddressChoice_ipSourceRoute ){
		ASNH225TransportAddress_ipSourceRoute_Print( pObj->alter, pDepth+1, "ipSourceRoute" );
	}
	else if ( pObj->choice == e_ASNH225TransportAddressChoice_ipxAddress ){
		ASNH225TransportAddress_ipxAddress_Print( pObj->alter, pDepth+1, "ipxAddress" );
	}
	else if ( pObj->choice == e_ASNH225TransportAddressChoice_ip6Address ){
		ASNH225TransportAddress_ip6Address_Print( pObj->alter, pDepth+1, "ip6Address" );
	}
	else if ( pObj->choice == e_ASNH225TransportAddressChoice_netBios ){
		AsnOctetString_Print( pObj->alter, pDepth+1, "netBios" );
	}
	else if ( pObj->choice == e_ASNH225TransportAddressChoice_nsap ){
		AsnOctetString_Print( pObj->alter, pDepth+1, "nsap" );
	}
	else if ( pObj->choice == e_ASNH225TransportAddressChoice_nonStandardAddress ){
		ASNH225NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandardAddress" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225PublicTypeOfNumber Struct
*/
/* ASNH225PublicTypeOfNumber Constructor */
HS_RESULT new_ASNH225PublicTypeOfNumber( void *pObject )
{
	ASNH225PublicTypeOfNumber *pObj = (ASNH225PublicTypeOfNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225PublicTypeOfNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225PublicTypeOfNumberChoice_unknown;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225PublicTypeOfNumberChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225PublicTypeOfNumber Destructor */
HS_RESULT delete_ASNH225PublicTypeOfNumber( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225PublicTypeOfNumber *pObj = (ASNH225PublicTypeOfNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225PublicTypeOfNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225PublicTypeOfNumber_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225PublicTypeOfNumber(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225PublicTypeOfNumber SetChoice */
void* ASNH225PublicTypeOfNumber_SetChoice( void *pObject, ASNH225PublicTypeOfNumberChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225PublicTypeOfNumber *pObj = (ASNH225PublicTypeOfNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PublicTypeOfNumber_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225PublicTypeOfNumberChoiceSizeExt ){
		if( pChoice > (ASNH225PublicTypeOfNumberChoice)(e_ASNH225PublicTypeOfNumberChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PublicTypeOfNumber_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225PublicTypeOfNumber_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PublicTypeOfNumber_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225PublicTypeOfNumberChoice_unknown ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225PublicTypeOfNumberChoice_internationalNumber ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225PublicTypeOfNumberChoice_nationalNumber ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225PublicTypeOfNumberChoice_networkSpecificNumber ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225PublicTypeOfNumberChoice_subscriberNumber ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225PublicTypeOfNumberChoice_abbreviatedNumber ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PublicTypeOfNumber_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225PublicTypeOfNumber DeleteAlternation */
HS_RESULT ASNH225PublicTypeOfNumber_DeleteAlternation(void *pObject)
{
	ASNH225PublicTypeOfNumber *pObj = (ASNH225PublicTypeOfNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PublicTypeOfNumber_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_unknown ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_internationalNumber ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_nationalNumber ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_networkSpecificNumber ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_subscriberNumber ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_abbreviatedNumber ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PublicTypeOfNumber_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225PublicTypeOfNumber_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225PublicTypeOfNumber Encode */
HS_RESULT ASNH225PublicTypeOfNumber_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225PublicTypeOfNumber *pObj = (ASNH225PublicTypeOfNumber *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PublicTypeOfNumber_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PublicTypeOfNumber_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225PublicTypeOfNumberChoiceSize )
		{
			if( pObj->choice > ((ASNH225PublicTypeOfNumberChoice)(e_ASNH225PublicTypeOfNumberChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225PublicTypeOfNumberChoiceSize)) )
	}
	else
	{
		if( e_ASNH225PublicTypeOfNumberChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_unknown ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PublicTypeOfNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_internationalNumber ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PublicTypeOfNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_nationalNumber ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PublicTypeOfNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_networkSpecificNumber ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PublicTypeOfNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_subscriberNumber ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PublicTypeOfNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_abbreviatedNumber ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PublicTypeOfNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PublicTypeOfNumber_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225PublicTypeOfNumber Decode */
HS_RESULT ASNH225PublicTypeOfNumber_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225PublicTypeOfNumber *pObj = (ASNH225PublicTypeOfNumber *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PublicTypeOfNumber_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225PublicTypeOfNumberChoiceSize;
	}
	else
	{
		if( e_ASNH225PublicTypeOfNumberChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225PublicTypeOfNumberChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225PublicTypeOfNumberChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PublicTypeOfNumber_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225PublicTypeOfNumber_SetChoice( pObj, (ASNH225PublicTypeOfNumberChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PublicTypeOfNumber_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_unknown ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PublicTypeOfNumber_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_internationalNumber ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PublicTypeOfNumber_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_nationalNumber ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PublicTypeOfNumber_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_networkSpecificNumber ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PublicTypeOfNumber_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_subscriberNumber ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PublicTypeOfNumber_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_abbreviatedNumber ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PublicTypeOfNumber_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PublicTypeOfNumber_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225PublicTypeOfNumber Print */
HS_RESULT ASNH225PublicTypeOfNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225PublicTypeOfNumber *pObj = (ASNH225PublicTypeOfNumber *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225PublicTypeOfNumber_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_unknown ){
		AsnNull_Print( pObj->alter, pDepth+1, "unknown" );
	}
	else if ( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_internationalNumber ){
		AsnNull_Print( pObj->alter, pDepth+1, "internationalNumber" );
	}
	else if ( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_nationalNumber ){
		AsnNull_Print( pObj->alter, pDepth+1, "nationalNumber" );
	}
	else if ( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_networkSpecificNumber ){
		AsnNull_Print( pObj->alter, pDepth+1, "networkSpecificNumber" );
	}
	else if ( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_subscriberNumber ){
		AsnNull_Print( pObj->alter, pDepth+1, "subscriberNumber" );
	}
	else if ( pObj->choice == e_ASNH225PublicTypeOfNumberChoice_abbreviatedNumber ){
		AsnNull_Print( pObj->alter, pDepth+1, "abbreviatedNumber" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225PublicPartyNumber Class
*/
/*ASNH225PublicPartyNumber Constructor*/
HS_RESULT new_ASNH225PublicPartyNumber(void *pObject)
{
	ASNH225PublicPartyNumber *pObj = (ASNH225PublicPartyNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225PublicPartyNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = FALSE;
	pObj->extended = FALSE;
	new_ASNH225PublicTypeOfNumber( &(pObj->m_publicTypeOfNumber) );
	new_ASNH225NumberDigits( &(pObj->m_publicNumberDigits) );

	return HS_OK;
}

/* ASNH225PublicPartyNumber Destructor */
HS_RESULT delete_ASNH225PublicPartyNumber(void *pObject)
{
	ASNH225PublicPartyNumber *pObj = (ASNH225PublicPartyNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225PublicPartyNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225PublicTypeOfNumber( &(pObj->m_publicTypeOfNumber) );
	delete_ASNH225NumberDigits( &(pObj->m_publicNumberDigits) );
	return HS_OK;
}

/* ASNH225PublicPartyNumber MakeMold */
HS_RESULT ASNH225PublicPartyNumber_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225PublicPartyNumber *pObj = (ASNH225PublicPartyNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PublicPartyNumber_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225PublicTypeOfNumber_MakeMold(&(pObj->m_publicTypeOfNumber));
	ASNH225NumberDigits_MakeMold(&(pObj->m_publicNumberDigits));
	return HS_OK;
}

/* ASNH225PublicPartyNumber Encode */
HS_RESULT ASNH225PublicPartyNumber_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225PublicPartyNumber *pObj = (ASNH225PublicPartyNumber *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PublicPartyNumber_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH225PublicTypeOfNumber_Encode( &(pObj->m_publicTypeOfNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PublicPartyNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225NumberDigits_Encode( &(pObj->m_publicNumberDigits),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PublicPartyNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225PublicPartyNumber Decode */
HS_RESULT ASNH225PublicPartyNumber_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225PublicPartyNumber *pObj = (ASNH225PublicPartyNumber *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PublicPartyNumber_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH225PublicTypeOfNumber_Decode(&(pObj->m_publicTypeOfNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PublicPartyNumber_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225NumberDigits_Decode(&(pObj->m_publicNumberDigits),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PublicPartyNumber_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225PublicPartyNumber Print */
HS_RESULT ASNH225PublicPartyNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225PublicPartyNumber *pObj = (ASNH225PublicPartyNumber *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225PublicPartyNumber_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225PublicTypeOfNumber_Print( &(pObj->m_publicTypeOfNumber), pDepth+1, "publicTypeOfNumber" );
	ASNH225NumberDigits_Print( &(pObj->m_publicNumberDigits), pDepth+1, "publicNumberDigits" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225PrivateTypeOfNumber Struct
*/
/* ASNH225PrivateTypeOfNumber Constructor */
HS_RESULT new_ASNH225PrivateTypeOfNumber( void *pObject )
{
	ASNH225PrivateTypeOfNumber *pObj = (ASNH225PrivateTypeOfNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225PrivateTypeOfNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225PrivateTypeOfNumberChoice_unknown;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225PrivateTypeOfNumberChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225PrivateTypeOfNumber Destructor */
HS_RESULT delete_ASNH225PrivateTypeOfNumber( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225PrivateTypeOfNumber *pObj = (ASNH225PrivateTypeOfNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225PrivateTypeOfNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225PrivateTypeOfNumber_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225PrivateTypeOfNumber(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225PrivateTypeOfNumber SetChoice */
void* ASNH225PrivateTypeOfNumber_SetChoice( void *pObject, ASNH225PrivateTypeOfNumberChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225PrivateTypeOfNumber *pObj = (ASNH225PrivateTypeOfNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225PrivateTypeOfNumberChoiceSizeExt ){
		if( pChoice > (ASNH225PrivateTypeOfNumberChoice)(e_ASNH225PrivateTypeOfNumberChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225PrivateTypeOfNumber_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225PrivateTypeOfNumberChoice_unknown ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225PrivateTypeOfNumberChoice_level2RegionalNumber ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225PrivateTypeOfNumberChoice_level1RegionalNumber ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225PrivateTypeOfNumberChoice_pISNSpecificNumber ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225PrivateTypeOfNumberChoice_localNumber ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225PrivateTypeOfNumberChoice_abbreviatedNumber ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225PrivateTypeOfNumber DeleteAlternation */
HS_RESULT ASNH225PrivateTypeOfNumber_DeleteAlternation(void *pObject)
{
	ASNH225PrivateTypeOfNumber *pObj = (ASNH225PrivateTypeOfNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_unknown ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_level2RegionalNumber ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_level1RegionalNumber ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_pISNSpecificNumber ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_localNumber ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_abbreviatedNumber ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225PrivateTypeOfNumber_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225PrivateTypeOfNumber Encode */
HS_RESULT ASNH225PrivateTypeOfNumber_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225PrivateTypeOfNumber *pObj = (ASNH225PrivateTypeOfNumber *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225PrivateTypeOfNumberChoiceSize )
		{
			if( pObj->choice > ((ASNH225PrivateTypeOfNumberChoice)(e_ASNH225PrivateTypeOfNumberChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225PrivateTypeOfNumberChoiceSize)) )
	}
	else
	{
		if( e_ASNH225PrivateTypeOfNumberChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_unknown ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_level2RegionalNumber ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_level1RegionalNumber ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_pISNSpecificNumber ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_localNumber ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_abbreviatedNumber ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225PrivateTypeOfNumber Decode */
HS_RESULT ASNH225PrivateTypeOfNumber_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225PrivateTypeOfNumber *pObj = (ASNH225PrivateTypeOfNumber *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225PrivateTypeOfNumberChoiceSize;
	}
	else
	{
		if( e_ASNH225PrivateTypeOfNumberChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225PrivateTypeOfNumberChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225PrivateTypeOfNumberChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225PrivateTypeOfNumber_SetChoice( pObj, (ASNH225PrivateTypeOfNumberChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_unknown ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_level2RegionalNumber ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_level1RegionalNumber ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_pISNSpecificNumber ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_localNumber ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_abbreviatedNumber ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225PrivateTypeOfNumber Print */
HS_RESULT ASNH225PrivateTypeOfNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225PrivateTypeOfNumber *pObj = (ASNH225PrivateTypeOfNumber *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225PrivateTypeOfNumber_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_unknown ){
		AsnNull_Print( pObj->alter, pDepth+1, "unknown" );
	}
	else if ( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_level2RegionalNumber ){
		AsnNull_Print( pObj->alter, pDepth+1, "level2RegionalNumber" );
	}
	else if ( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_level1RegionalNumber ){
		AsnNull_Print( pObj->alter, pDepth+1, "level1RegionalNumber" );
	}
	else if ( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_pISNSpecificNumber ){
		AsnNull_Print( pObj->alter, pDepth+1, "pISNSpecificNumber" );
	}
	else if ( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_localNumber ){
		AsnNull_Print( pObj->alter, pDepth+1, "localNumber" );
	}
	else if ( pObj->choice == e_ASNH225PrivateTypeOfNumberChoice_abbreviatedNumber ){
		AsnNull_Print( pObj->alter, pDepth+1, "abbreviatedNumber" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225PrivatePartyNumber Class
*/
/*ASNH225PrivatePartyNumber Constructor*/
HS_RESULT new_ASNH225PrivatePartyNumber(void *pObject)
{
	ASNH225PrivatePartyNumber *pObj = (ASNH225PrivatePartyNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225PrivatePartyNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = FALSE;
	pObj->extended = FALSE;
	new_ASNH225PrivateTypeOfNumber( &(pObj->m_privateTypeOfNumber) );
	new_ASNH225NumberDigits( &(pObj->m_privateNumberDigits) );

	return HS_OK;
}

/* ASNH225PrivatePartyNumber Destructor */
HS_RESULT delete_ASNH225PrivatePartyNumber(void *pObject)
{
	ASNH225PrivatePartyNumber *pObj = (ASNH225PrivatePartyNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225PrivatePartyNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225PrivateTypeOfNumber( &(pObj->m_privateTypeOfNumber) );
	delete_ASNH225NumberDigits( &(pObj->m_privateNumberDigits) );
	return HS_OK;
}

/* ASNH225PrivatePartyNumber MakeMold */
HS_RESULT ASNH225PrivatePartyNumber_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225PrivatePartyNumber *pObj = (ASNH225PrivatePartyNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PrivatePartyNumber_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225PrivateTypeOfNumber_MakeMold(&(pObj->m_privateTypeOfNumber));
	ASNH225NumberDigits_MakeMold(&(pObj->m_privateNumberDigits));
	return HS_OK;
}

/* ASNH225PrivatePartyNumber Encode */
HS_RESULT ASNH225PrivatePartyNumber_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225PrivatePartyNumber *pObj = (ASNH225PrivatePartyNumber *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PrivatePartyNumber_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH225PrivateTypeOfNumber_Encode( &(pObj->m_privateTypeOfNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PrivatePartyNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225NumberDigits_Encode( &(pObj->m_privateNumberDigits),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PrivatePartyNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225PrivatePartyNumber Decode */
HS_RESULT ASNH225PrivatePartyNumber_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225PrivatePartyNumber *pObj = (ASNH225PrivatePartyNumber *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PrivatePartyNumber_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH225PrivateTypeOfNumber_Decode(&(pObj->m_privateTypeOfNumber),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PrivatePartyNumber_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225NumberDigits_Decode(&(pObj->m_privateNumberDigits),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PrivatePartyNumber_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225PrivatePartyNumber Print */
HS_RESULT ASNH225PrivatePartyNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225PrivatePartyNumber *pObj = (ASNH225PrivatePartyNumber *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225PrivatePartyNumber_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225PrivateTypeOfNumber_Print( &(pObj->m_privateTypeOfNumber), pDepth+1, "privateTypeOfNumber" );
	ASNH225NumberDigits_Print( &(pObj->m_privateNumberDigits), pDepth+1, "privateNumberDigits" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225PartyNumber Struct
*/
/* ASNH225PartyNumber Constructor */
HS_RESULT new_ASNH225PartyNumber( void *pObject )
{
	ASNH225PartyNumber *pObj = (ASNH225PartyNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225PartyNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225PartyNumberChoice_e164Number;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225PartyNumberChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225PartyNumber Destructor */
HS_RESULT delete_ASNH225PartyNumber( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225PartyNumber *pObj = (ASNH225PartyNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225PartyNumber(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225PartyNumber_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225PartyNumber(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225PartyNumber SetChoice */
void* ASNH225PartyNumber_SetChoice( void *pObject, ASNH225PartyNumberChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225PartyNumber *pObj = (ASNH225PartyNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PartyNumber_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225PartyNumberChoiceSizeExt ){
		if( pChoice > (ASNH225PartyNumberChoice)(e_ASNH225PartyNumberChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PartyNumber_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225PartyNumber_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PartyNumber_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225PartyNumberChoice_e164Number ){
		ASNH225PublicPartyNumber *tAlter = (ASNH225PublicPartyNumber *)HSMalloc( sizeof(ASNH225PublicPartyNumber) );
		new_ASNH225PublicPartyNumber(tAlter);
		ASNH225PublicPartyNumber_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225PartyNumberChoice_dataPartyNumber ){
		ASNH225NumberDigits *tAlter = (ASNH225NumberDigits *)HSMalloc( sizeof(ASNH225NumberDigits) );
		new_ASNH225NumberDigits(tAlter);
		ASNH225NumberDigits_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225PartyNumberChoice_telexPartyNumber ){
		ASNH225NumberDigits *tAlter = (ASNH225NumberDigits *)HSMalloc( sizeof(ASNH225NumberDigits) );
		new_ASNH225NumberDigits(tAlter);
		ASNH225NumberDigits_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225PartyNumberChoice_privateNumber ){
		ASNH225PrivatePartyNumber *tAlter = (ASNH225PrivatePartyNumber *)HSMalloc( sizeof(ASNH225PrivatePartyNumber) );
		new_ASNH225PrivatePartyNumber(tAlter);
		ASNH225PrivatePartyNumber_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225PartyNumberChoice_nationalStandardPartyNumber ){
		ASNH225NumberDigits *tAlter = (ASNH225NumberDigits *)HSMalloc( sizeof(ASNH225NumberDigits) );
		new_ASNH225NumberDigits(tAlter);
		ASNH225NumberDigits_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PartyNumber_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225PartyNumber DeleteAlternation */
HS_RESULT ASNH225PartyNumber_DeleteAlternation(void *pObject)
{
	ASNH225PartyNumber *pObj = (ASNH225PartyNumber *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PartyNumber_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225PartyNumberChoice_e164Number ){
			delete_ASNH225PublicPartyNumber(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225PartyNumberChoice_dataPartyNumber ){
			delete_ASNH225NumberDigits(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225PartyNumberChoice_telexPartyNumber ){
			delete_ASNH225NumberDigits(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225PartyNumberChoice_privateNumber ){
			delete_ASNH225PrivatePartyNumber(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225PartyNumberChoice_nationalStandardPartyNumber ){
			delete_ASNH225NumberDigits(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PartyNumber_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225PartyNumber_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225PartyNumber Encode */
HS_RESULT ASNH225PartyNumber_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225PartyNumber *pObj = (ASNH225PartyNumber *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PartyNumber_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PartyNumber_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225PartyNumberChoiceSize )
		{
			if( pObj->choice > ((ASNH225PartyNumberChoice)(e_ASNH225PartyNumberChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225PartyNumberChoiceSize)) )
	}
	else
	{
		if( e_ASNH225PartyNumberChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225PartyNumberChoice_e164Number ){
		if( (tRet=ASNH225PublicPartyNumber_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PartyNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PartyNumberChoice_dataPartyNumber ){
		if( (tRet=ASNH225NumberDigits_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PartyNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PartyNumberChoice_telexPartyNumber ){
		if( (tRet=ASNH225NumberDigits_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PartyNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PartyNumberChoice_privateNumber ){
		if( (tRet=ASNH225PrivatePartyNumber_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PartyNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PartyNumberChoice_nationalStandardPartyNumber ){
		if( (tRet=ASNH225NumberDigits_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PartyNumber_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PartyNumber_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225PartyNumber Decode */
HS_RESULT ASNH225PartyNumber_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225PartyNumber *pObj = (ASNH225PartyNumber *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PartyNumber_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225PartyNumberChoiceSize;
	}
	else
	{
		if( e_ASNH225PartyNumberChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225PartyNumberChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225PartyNumberChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PartyNumber_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225PartyNumber_SetChoice( pObj, (ASNH225PartyNumberChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PartyNumber_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225PartyNumberChoice_e164Number ){
		if( (tRet=ASNH225PublicPartyNumber_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PartyNumber_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PartyNumberChoice_dataPartyNumber ){
		if( (tRet=ASNH225NumberDigits_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PartyNumber_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PartyNumberChoice_telexPartyNumber ){
		if( (tRet=ASNH225NumberDigits_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PartyNumber_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PartyNumberChoice_privateNumber ){
		if( (tRet=ASNH225PrivatePartyNumber_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PartyNumber_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PartyNumberChoice_nationalStandardPartyNumber ){
		if( (tRet=ASNH225NumberDigits_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PartyNumber_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PartyNumber_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225PartyNumber Print */
HS_RESULT ASNH225PartyNumber_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225PartyNumber *pObj = (ASNH225PartyNumber *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225PartyNumber_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225PartyNumberChoice_e164Number ){
		ASNH225PublicPartyNumber_Print( pObj->alter, pDepth+1, "e164Number" );
	}
	else if ( pObj->choice == e_ASNH225PartyNumberChoice_dataPartyNumber ){
		ASNH225NumberDigits_Print( pObj->alter, pDepth+1, "dataPartyNumber" );
	}
	else if ( pObj->choice == e_ASNH225PartyNumberChoice_telexPartyNumber ){
		ASNH225NumberDigits_Print( pObj->alter, pDepth+1, "telexPartyNumber" );
	}
	else if ( pObj->choice == e_ASNH225PartyNumberChoice_privateNumber ){
		ASNH225PrivatePartyNumber_Print( pObj->alter, pDepth+1, "privateNumber" );
	}
	else if ( pObj->choice == e_ASNH225PartyNumberChoice_nationalStandardPartyNumber ){
		ASNH225NumberDigits_Print( pObj->alter, pDepth+1, "nationalStandardPartyNumber" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225ANSI_41_UIM_system_id Struct
*/
/* ASNH225ANSI_41_UIM_system_id Constructor */
HS_RESULT new_ASNH225ANSI_41_UIM_system_id( void *pObject )
{
	ASNH225ANSI_41_UIM_system_id *pObj = (ASNH225ANSI_41_UIM_system_id *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225ANSI_41_UIM_system_id(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225ANSI_41_UIM_system_idChoice_sid;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225ANSI_41_UIM_system_idChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225ANSI_41_UIM_system_id Destructor */
HS_RESULT delete_ASNH225ANSI_41_UIM_system_id( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225ANSI_41_UIM_system_id *pObj = (ASNH225ANSI_41_UIM_system_id *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ANSI_41_UIM_system_id(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225ANSI_41_UIM_system_id_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ANSI_41_UIM_system_id(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225ANSI_41_UIM_system_id SetChoice */
void* ASNH225ANSI_41_UIM_system_id_SetChoice( void *pObject, ASNH225ANSI_41_UIM_system_idChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225ANSI_41_UIM_system_id *pObj = (ASNH225ANSI_41_UIM_system_id *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ANSI_41_UIM_system_id_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225ANSI_41_UIM_system_idChoiceSizeExt ){
		if( pChoice > (ASNH225ANSI_41_UIM_system_idChoice)(e_ASNH225ANSI_41_UIM_system_idChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_system_id_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225ANSI_41_UIM_system_id_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_system_id_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225ANSI_41_UIM_system_idChoice_sid ){
		ASNH225TBCD_STRING *tAlter = (ASNH225TBCD_STRING *)HSMalloc( sizeof(ASNH225TBCD_STRING) );
		new_ASNH225TBCD_STRING(tAlter);
		ASNH225TBCD_STRING_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ANSI_41_UIM_system_idChoice_mid ){
		ASNH225TBCD_STRING *tAlter = (ASNH225TBCD_STRING *)HSMalloc( sizeof(ASNH225TBCD_STRING) );
		new_ASNH225TBCD_STRING(tAlter);
		ASNH225TBCD_STRING_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ANSI_41_UIM_system_id_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225ANSI_41_UIM_system_id DeleteAlternation */
HS_RESULT ASNH225ANSI_41_UIM_system_id_DeleteAlternation(void *pObject)
{
	ASNH225ANSI_41_UIM_system_id *pObj = (ASNH225ANSI_41_UIM_system_id *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ANSI_41_UIM_system_id_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225ANSI_41_UIM_system_idChoice_sid ){
			delete_ASNH225TBCD_STRING(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ANSI_41_UIM_system_idChoice_mid ){
			delete_ASNH225TBCD_STRING(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_system_id_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225ANSI_41_UIM_system_id_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225ANSI_41_UIM_system_id Encode */
HS_RESULT ASNH225ANSI_41_UIM_system_id_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225ANSI_41_UIM_system_id *pObj = (ASNH225ANSI_41_UIM_system_id *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ANSI_41_UIM_system_id_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ANSI_41_UIM_system_id_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225ANSI_41_UIM_system_idChoiceSize )
		{
			if( pObj->choice > ((ASNH225ANSI_41_UIM_system_idChoice)(e_ASNH225ANSI_41_UIM_system_idChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225ANSI_41_UIM_system_idChoiceSize)) )
	}
	else
	{
		if( e_ASNH225ANSI_41_UIM_system_idChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ANSI_41_UIM_system_idChoice_sid ){
		if( (tRet=ASNH225TBCD_STRING_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_system_id_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ANSI_41_UIM_system_idChoice_mid ){
		if( (tRet=ASNH225TBCD_STRING_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_system_id_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ANSI_41_UIM_system_id_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225ANSI_41_UIM_system_id Decode */
HS_RESULT ASNH225ANSI_41_UIM_system_id_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225ANSI_41_UIM_system_id *pObj = (ASNH225ANSI_41_UIM_system_id *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ANSI_41_UIM_system_id_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225ANSI_41_UIM_system_idChoiceSize;
	}
	else
	{
		if( e_ASNH225ANSI_41_UIM_system_idChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225ANSI_41_UIM_system_idChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225ANSI_41_UIM_system_idChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_system_id_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225ANSI_41_UIM_system_id_SetChoice( pObj, (ASNH225ANSI_41_UIM_system_idChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ANSI_41_UIM_system_id_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ANSI_41_UIM_system_idChoice_sid ){
		if( (tRet=ASNH225TBCD_STRING_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_system_id_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ANSI_41_UIM_system_idChoice_mid ){
		if( (tRet=ASNH225TBCD_STRING_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_system_id_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ANSI_41_UIM_system_id_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225ANSI_41_UIM_system_id Print */
HS_RESULT ASNH225ANSI_41_UIM_system_id_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225ANSI_41_UIM_system_id *pObj = (ASNH225ANSI_41_UIM_system_id *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225ANSI_41_UIM_system_id_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ANSI_41_UIM_system_idChoice_sid ){
		ASNH225TBCD_STRING_Print( pObj->alter, pDepth+1, "sid" );
	}
	else if ( pObj->choice == e_ASNH225ANSI_41_UIM_system_idChoice_mid ){
		ASNH225TBCD_STRING_Print( pObj->alter, pDepth+1, "mid" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225ANSI_41_UIM Class
*/
/*ASNH225ANSI_41_UIM Constructor*/
HS_RESULT new_ASNH225ANSI_41_UIM(void *pObject)
{
	ASNH225ANSI_41_UIM *pObj = (ASNH225ANSI_41_UIM *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225ANSI_41_UIM(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225TBCD_STRING( &(pObj->m_imsi) );
	new_ASNH225TBCD_STRING( &(pObj->m_min) );
	new_ASNH225TBCD_STRING( &(pObj->m_mdn) );
	new_ASNH225TBCD_STRING( &(pObj->m_msisdn) );
	new_ASNH225TBCD_STRING( &(pObj->m_esn) );
	new_ASNH225TBCD_STRING( &(pObj->m_mscid) );
	new_ASNH225ANSI_41_UIM_system_id( &(pObj->m_system_id) );
	new_AsnOctetString( &(pObj->m_systemMyTypeCode), e_constrained, 1, 1, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnOctetString( &(pObj->m_systemAccessType), e_constrained, 1, 1, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnOctetString( &(pObj->m_qualificationInformationCode), e_constrained, 1, 1, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH225TBCD_STRING( &(pObj->m_sesn) );
	new_ASNH225TBCD_STRING( &(pObj->m_soc) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225ANSI_41_UIM Destructor */
HS_RESULT delete_ASNH225ANSI_41_UIM(void *pObject)
{
	ASNH225ANSI_41_UIM *pObj = (ASNH225ANSI_41_UIM *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ANSI_41_UIM(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225TBCD_STRING( &(pObj->m_imsi) );
	delete_ASNH225TBCD_STRING( &(pObj->m_min) );
	delete_ASNH225TBCD_STRING( &(pObj->m_mdn) );
	delete_ASNH225TBCD_STRING( &(pObj->m_msisdn) );
	delete_ASNH225TBCD_STRING( &(pObj->m_esn) );
	delete_ASNH225TBCD_STRING( &(pObj->m_mscid) );
	delete_ASNH225ANSI_41_UIM_system_id( &(pObj->m_system_id) );
	delete_AsnOctetString( &(pObj->m_systemMyTypeCode) );
	delete_AsnOctetString( &(pObj->m_systemAccessType) );
	delete_AsnOctetString( &(pObj->m_qualificationInformationCode) );
	delete_ASNH225TBCD_STRING( &(pObj->m_sesn) );
	delete_ASNH225TBCD_STRING( &(pObj->m_soc) );
	return HS_OK;
}

/* ASNH225ANSI_41_UIM MakeMold */
HS_RESULT ASNH225ANSI_41_UIM_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225ANSI_41_UIM *pObj = (ASNH225ANSI_41_UIM *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ANSI_41_UIM_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225TBCD_STRING_MakeMold(&(pObj->m_imsi));
	ASNH225TBCD_STRING_MakeMold(&(pObj->m_min));
	ASNH225TBCD_STRING_MakeMold(&(pObj->m_mdn));
	ASNH225TBCD_STRING_MakeMold(&(pObj->m_msisdn));
	ASNH225TBCD_STRING_MakeMold(&(pObj->m_esn));
	ASNH225TBCD_STRING_MakeMold(&(pObj->m_mscid));
	ASNH225TBCD_STRING_MakeMold(&(pObj->m_sesn));
	ASNH225TBCD_STRING_MakeMold(&(pObj->m_soc));
	return HS_OK;
}

/* ASNH225ANSI_41_UIM IncludeOptionalField */
HS_RESULT ASNH225ANSI_41_UIM_IncludeOptionField( void *pObject, ASNH225ANSI_41_UIMOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225ANSI_41_UIM *pObj = (ASNH225ANSI_41_UIM *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ANSI_41_UIM_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225ANSI_41_UIMOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225ANSI_41_UIM IsIncludeOptionalField */
BOOL ASNH225ANSI_41_UIM_IsIncludeOptionField( void *pObject, ASNH225ANSI_41_UIMOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225ANSI_41_UIM *pObj = (ASNH225ANSI_41_UIM *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ANSI_41_UIM_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225ANSI_41_UIMOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225ANSI_41_UIM Encode */
HS_RESULT ASNH225ANSI_41_UIM_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225ANSI_41_UIM *pObj = (ASNH225ANSI_41_UIM *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ANSI_41_UIM_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225ANSI_41_UIMOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225ANSI_41_UIMOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_imsi ) ){
		if( (tRet=ASNH225TBCD_STRING_Encode( &(pObj->m_imsi),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_min ) ){
		if( (tRet=ASNH225TBCD_STRING_Encode( &(pObj->m_min),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_mdn ) ){
		if( (tRet=ASNH225TBCD_STRING_Encode( &(pObj->m_mdn),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_msisdn ) ){
		if( (tRet=ASNH225TBCD_STRING_Encode( &(pObj->m_msisdn),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_esn ) ){
		if( (tRet=ASNH225TBCD_STRING_Encode( &(pObj->m_esn),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_mscid ) ){
		if( (tRet=ASNH225TBCD_STRING_Encode( &(pObj->m_mscid),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225ANSI_41_UIM_system_id_Encode( &(pObj->m_system_id),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ANSI_41_UIM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_systemMyTypeCode ) ){
		if( (tRet=AsnOctetString_Encode( &(pObj->m_systemMyTypeCode),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_systemAccessType ) ){
		if( (tRet=AsnOctetString_Encode( &(pObj->m_systemAccessType),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_qualificationInformationCode ) ){
		if( (tRet=AsnOctetString_Encode( &(pObj->m_qualificationInformationCode),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_sesn ) ){
		if( (tRet=ASNH225TBCD_STRING_Encode( &(pObj->m_sesn),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_soc ) ){
		if( (tRet=ASNH225TBCD_STRING_Encode( &(pObj->m_soc),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225ANSI_41_UIM Decode */
HS_RESULT ASNH225ANSI_41_UIM_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225ANSI_41_UIM *pObj = (ASNH225ANSI_41_UIM *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ANSI_41_UIM_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225ANSI_41_UIMOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225ANSI_41_UIMOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_imsi ) ){
		if( (tRet=ASNH225TBCD_STRING_Decode(&(pObj->m_imsi),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_min ) ){
		if( (tRet=ASNH225TBCD_STRING_Decode(&(pObj->m_min),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_mdn ) ){
		if( (tRet=ASNH225TBCD_STRING_Decode(&(pObj->m_mdn),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_msisdn ) ){
		if( (tRet=ASNH225TBCD_STRING_Decode(&(pObj->m_msisdn),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_esn ) ){
		if( (tRet=ASNH225TBCD_STRING_Decode(&(pObj->m_esn),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_mscid ) ){
		if( (tRet=ASNH225TBCD_STRING_Decode(&(pObj->m_mscid),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225ANSI_41_UIM_system_id_Decode(&(pObj->m_system_id),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ANSI_41_UIM_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_systemMyTypeCode ) ){
		if( (tRet=AsnOctetString_Decode(&(pObj->m_systemMyTypeCode),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_systemAccessType ) ){
		if( (tRet=AsnOctetString_Decode(&(pObj->m_systemAccessType),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_qualificationInformationCode ) ){
		if( (tRet=AsnOctetString_Decode(&(pObj->m_qualificationInformationCode),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_sesn ) ){
		if( (tRet=ASNH225TBCD_STRING_Decode(&(pObj->m_sesn),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_soc ) ){
		if( (tRet=ASNH225TBCD_STRING_Decode(&(pObj->m_soc),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ANSI_41_UIM_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225ANSI_41_UIM Print */
HS_RESULT ASNH225ANSI_41_UIM_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225ANSI_41_UIM *pObj = (ASNH225ANSI_41_UIM *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225ANSI_41_UIM_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_imsi ) )
		ASNH225TBCD_STRING_Print( &(pObj->m_imsi), pDepth+1, "imsi" );
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_min ) )
		ASNH225TBCD_STRING_Print( &(pObj->m_min), pDepth+1, "min" );
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_mdn ) )
		ASNH225TBCD_STRING_Print( &(pObj->m_mdn), pDepth+1, "mdn" );
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_msisdn ) )
		ASNH225TBCD_STRING_Print( &(pObj->m_msisdn), pDepth+1, "msisdn" );
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_esn ) )
		ASNH225TBCD_STRING_Print( &(pObj->m_esn), pDepth+1, "esn" );
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_mscid ) )
		ASNH225TBCD_STRING_Print( &(pObj->m_mscid), pDepth+1, "mscid" );
	ASNH225ANSI_41_UIM_system_id_Print( &(pObj->m_system_id), pDepth+1, "system_id" );
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_systemMyTypeCode ) )
		AsnOctetString_Print( &(pObj->m_systemMyTypeCode), pDepth+1, "systemMyTypeCode" );
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_systemAccessType ) )
		AsnOctetString_Print( &(pObj->m_systemAccessType), pDepth+1, "systemAccessType" );
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_qualificationInformationCode ) )
		AsnOctetString_Print( &(pObj->m_qualificationInformationCode), pDepth+1, "qualificationInformationCode" );
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_sesn ) )
		ASNH225TBCD_STRING_Print( &(pObj->m_sesn), pDepth+1, "sesn" );
	if( ASNH225ANSI_41_UIM_IsIncludeOptionField( pObj, e_ASNH225ANSI_41_UIMOptionMap_soc ) )
		ASNH225TBCD_STRING_Print( &(pObj->m_soc), pDepth+1, "soc" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225GSM_UIM Class
*/
/*ASNH225GSM_UIM Constructor*/
HS_RESULT new_ASNH225GSM_UIM(void *pObject)
{
	ASNH225GSM_UIM *pObj = (ASNH225GSM_UIM *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225GSM_UIM(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225TBCD_STRING( &(pObj->m_imsi) );
	new_AsnOctetString( &(pObj->m_tmsi), e_constrained, 1, 4, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH225TBCD_STRING( &(pObj->m_msisdn) );
	new_ASNH225TBCD_STRING( &(pObj->m_imei) );
	new_ASNH225TBCD_STRING( &(pObj->m_hplmn) );
	new_ASNH225TBCD_STRING( &(pObj->m_vplmn) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225GSM_UIM Destructor */
HS_RESULT delete_ASNH225GSM_UIM(void *pObject)
{
	ASNH225GSM_UIM *pObj = (ASNH225GSM_UIM *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225GSM_UIM(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225TBCD_STRING( &(pObj->m_imsi) );
	delete_AsnOctetString( &(pObj->m_tmsi) );
	delete_ASNH225TBCD_STRING( &(pObj->m_msisdn) );
	delete_ASNH225TBCD_STRING( &(pObj->m_imei) );
	delete_ASNH225TBCD_STRING( &(pObj->m_hplmn) );
	delete_ASNH225TBCD_STRING( &(pObj->m_vplmn) );
	return HS_OK;
}

/* ASNH225GSM_UIM MakeMold */
HS_RESULT ASNH225GSM_UIM_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225GSM_UIM *pObj = (ASNH225GSM_UIM *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GSM_UIM_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225TBCD_STRING_MakeMold(&(pObj->m_imsi));
	ASNH225TBCD_STRING_MakeMold(&(pObj->m_msisdn));
	ASNH225TBCD_STRING_MakeMold(&(pObj->m_imei));
	ASNH225TBCD_STRING_MakeMold(&(pObj->m_hplmn));
	ASNH225TBCD_STRING_MakeMold(&(pObj->m_vplmn));
	return HS_OK;
}

/* ASNH225GSM_UIM IncludeOptionalField */
HS_RESULT ASNH225GSM_UIM_IncludeOptionField( void *pObject, ASNH225GSM_UIMOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225GSM_UIM *pObj = (ASNH225GSM_UIM *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GSM_UIM_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225GSM_UIMOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225GSM_UIM IsIncludeOptionalField */
BOOL ASNH225GSM_UIM_IsIncludeOptionField( void *pObject, ASNH225GSM_UIMOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225GSM_UIM *pObj = (ASNH225GSM_UIM *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GSM_UIM_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225GSM_UIMOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225GSM_UIM Encode */
HS_RESULT ASNH225GSM_UIM_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225GSM_UIM *pObj = (ASNH225GSM_UIM *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GSM_UIM_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225GSM_UIMOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225GSM_UIMOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225GSM_UIM_IsIncludeOptionField( pObj, e_ASNH225GSM_UIMOptionMap_imsi ) ){
		if( (tRet=ASNH225TBCD_STRING_Encode( &(pObj->m_imsi),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GSM_UIM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225GSM_UIM_IsIncludeOptionField( pObj, e_ASNH225GSM_UIMOptionMap_tmsi ) ){
		if( (tRet=AsnOctetString_Encode( &(pObj->m_tmsi),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GSM_UIM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225GSM_UIM_IsIncludeOptionField( pObj, e_ASNH225GSM_UIMOptionMap_msisdn ) ){
		if( (tRet=ASNH225TBCD_STRING_Encode( &(pObj->m_msisdn),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GSM_UIM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225GSM_UIM_IsIncludeOptionField( pObj, e_ASNH225GSM_UIMOptionMap_imei ) ){
		if( (tRet=ASNH225TBCD_STRING_Encode( &(pObj->m_imei),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GSM_UIM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225GSM_UIM_IsIncludeOptionField( pObj, e_ASNH225GSM_UIMOptionMap_hplmn ) ){
		if( (tRet=ASNH225TBCD_STRING_Encode( &(pObj->m_hplmn),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GSM_UIM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225GSM_UIM_IsIncludeOptionField( pObj, e_ASNH225GSM_UIMOptionMap_vplmn ) ){
		if( (tRet=ASNH225TBCD_STRING_Encode( &(pObj->m_vplmn),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GSM_UIM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225GSM_UIM Decode */
HS_RESULT ASNH225GSM_UIM_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225GSM_UIM *pObj = (ASNH225GSM_UIM *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GSM_UIM_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225GSM_UIMOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225GSM_UIMOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225GSM_UIM_IsIncludeOptionField( pObj, e_ASNH225GSM_UIMOptionMap_imsi ) ){
		if( (tRet=ASNH225TBCD_STRING_Decode(&(pObj->m_imsi),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GSM_UIM_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225GSM_UIM_IsIncludeOptionField( pObj, e_ASNH225GSM_UIMOptionMap_tmsi ) ){
		if( (tRet=AsnOctetString_Decode(&(pObj->m_tmsi),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GSM_UIM_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225GSM_UIM_IsIncludeOptionField( pObj, e_ASNH225GSM_UIMOptionMap_msisdn ) ){
		if( (tRet=ASNH225TBCD_STRING_Decode(&(pObj->m_msisdn),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GSM_UIM_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225GSM_UIM_IsIncludeOptionField( pObj, e_ASNH225GSM_UIMOptionMap_imei ) ){
		if( (tRet=ASNH225TBCD_STRING_Decode(&(pObj->m_imei),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GSM_UIM_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225GSM_UIM_IsIncludeOptionField( pObj, e_ASNH225GSM_UIMOptionMap_hplmn ) ){
		if( (tRet=ASNH225TBCD_STRING_Decode(&(pObj->m_hplmn),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GSM_UIM_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225GSM_UIM_IsIncludeOptionField( pObj, e_ASNH225GSM_UIMOptionMap_vplmn ) ){
		if( (tRet=ASNH225TBCD_STRING_Decode(&(pObj->m_vplmn),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GSM_UIM_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225GSM_UIM Print */
HS_RESULT ASNH225GSM_UIM_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225GSM_UIM *pObj = (ASNH225GSM_UIM *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225GSM_UIM_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225GSM_UIM_IsIncludeOptionField( pObj, e_ASNH225GSM_UIMOptionMap_imsi ) )
		ASNH225TBCD_STRING_Print( &(pObj->m_imsi), pDepth+1, "imsi" );
	if( ASNH225GSM_UIM_IsIncludeOptionField( pObj, e_ASNH225GSM_UIMOptionMap_tmsi ) )
		AsnOctetString_Print( &(pObj->m_tmsi), pDepth+1, "tmsi" );
	if( ASNH225GSM_UIM_IsIncludeOptionField( pObj, e_ASNH225GSM_UIMOptionMap_msisdn ) )
		ASNH225TBCD_STRING_Print( &(pObj->m_msisdn), pDepth+1, "msisdn" );
	if( ASNH225GSM_UIM_IsIncludeOptionField( pObj, e_ASNH225GSM_UIMOptionMap_imei ) )
		ASNH225TBCD_STRING_Print( &(pObj->m_imei), pDepth+1, "imei" );
	if( ASNH225GSM_UIM_IsIncludeOptionField( pObj, e_ASNH225GSM_UIMOptionMap_hplmn ) )
		ASNH225TBCD_STRING_Print( &(pObj->m_hplmn), pDepth+1, "hplmn" );
	if( ASNH225GSM_UIM_IsIncludeOptionField( pObj, e_ASNH225GSM_UIMOptionMap_vplmn ) )
		ASNH225TBCD_STRING_Print( &(pObj->m_vplmn), pDepth+1, "vplmn" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225MobileUIM Struct
*/
/* ASNH225MobileUIM Constructor */
HS_RESULT new_ASNH225MobileUIM( void *pObject )
{
	ASNH225MobileUIM *pObj = (ASNH225MobileUIM *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225MobileUIM(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225MobileUIMChoice_ansi_41_uim;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225MobileUIMChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225MobileUIM Destructor */
HS_RESULT delete_ASNH225MobileUIM( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225MobileUIM *pObj = (ASNH225MobileUIM *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225MobileUIM(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225MobileUIM_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225MobileUIM(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225MobileUIM SetChoice */
void* ASNH225MobileUIM_SetChoice( void *pObject, ASNH225MobileUIMChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225MobileUIM *pObj = (ASNH225MobileUIM *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225MobileUIM_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225MobileUIMChoiceSizeExt ){
		if( pChoice > (ASNH225MobileUIMChoice)(e_ASNH225MobileUIMChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225MobileUIM_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225MobileUIM_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225MobileUIM_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225MobileUIMChoice_ansi_41_uim ){
		ASNH225ANSI_41_UIM *tAlter = (ASNH225ANSI_41_UIM *)HSMalloc( sizeof(ASNH225ANSI_41_UIM) );
		new_ASNH225ANSI_41_UIM(tAlter);
		ASNH225ANSI_41_UIM_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225MobileUIMChoice_gsm_uim ){
		ASNH225GSM_UIM *tAlter = (ASNH225GSM_UIM *)HSMalloc( sizeof(ASNH225GSM_UIM) );
		new_ASNH225GSM_UIM(tAlter);
		ASNH225GSM_UIM_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225MobileUIM_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225MobileUIM DeleteAlternation */
HS_RESULT ASNH225MobileUIM_DeleteAlternation(void *pObject)
{
	ASNH225MobileUIM *pObj = (ASNH225MobileUIM *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225MobileUIM_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225MobileUIMChoice_ansi_41_uim ){
			delete_ASNH225ANSI_41_UIM(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225MobileUIMChoice_gsm_uim ){
			delete_ASNH225GSM_UIM(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225MobileUIM_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225MobileUIM_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225MobileUIM Encode */
HS_RESULT ASNH225MobileUIM_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225MobileUIM *pObj = (ASNH225MobileUIM *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225MobileUIM_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225MobileUIM_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225MobileUIMChoiceSize )
		{
			if( pObj->choice > ((ASNH225MobileUIMChoice)(e_ASNH225MobileUIMChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225MobileUIMChoiceSize)) )
	}
	else
	{
		if( e_ASNH225MobileUIMChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225MobileUIMChoice_ansi_41_uim ){
		if( (tRet=ASNH225ANSI_41_UIM_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225MobileUIM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225MobileUIMChoice_gsm_uim ){
		if( (tRet=ASNH225GSM_UIM_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225MobileUIM_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225MobileUIM_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225MobileUIM Decode */
HS_RESULT ASNH225MobileUIM_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225MobileUIM *pObj = (ASNH225MobileUIM *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225MobileUIM_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225MobileUIMChoiceSize;
	}
	else
	{
		if( e_ASNH225MobileUIMChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225MobileUIMChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225MobileUIMChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225MobileUIM_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225MobileUIM_SetChoice( pObj, (ASNH225MobileUIMChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225MobileUIM_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225MobileUIMChoice_ansi_41_uim ){
		if( (tRet=ASNH225ANSI_41_UIM_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225MobileUIM_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225MobileUIMChoice_gsm_uim ){
		if( (tRet=ASNH225GSM_UIM_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225MobileUIM_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225MobileUIM_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225MobileUIM Print */
HS_RESULT ASNH225MobileUIM_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225MobileUIM *pObj = (ASNH225MobileUIM *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225MobileUIM_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225MobileUIMChoice_ansi_41_uim ){
		ASNH225ANSI_41_UIM_Print( pObj->alter, pDepth+1, "ansi_41_uim" );
	}
	else if ( pObj->choice == e_ASNH225MobileUIMChoice_gsm_uim ){
		ASNH225GSM_UIM_Print( pObj->alter, pDepth+1, "gsm_uim" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225AliasAddress Struct
*/
/* ASNH225AliasAddress Constructor */
HS_RESULT new_ASNH225AliasAddress( void *pObject )
{
	ASNH225AliasAddress *pObj = (ASNH225AliasAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225AliasAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225AliasAddressChoice_dialedDigits;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225AliasAddressChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225AliasAddress Destructor */
HS_RESULT delete_ASNH225AliasAddress( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225AliasAddress *pObj = (ASNH225AliasAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225AliasAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225AliasAddress_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225AliasAddress(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225AliasAddress SetChoice */
void* ASNH225AliasAddress_SetChoice( void *pObject, ASNH225AliasAddressChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225AliasAddress *pObj = (ASNH225AliasAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AliasAddress_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225AliasAddressChoiceSizeExt ){
		if( pChoice > (ASNH225AliasAddressChoice)(e_ASNH225AliasAddressChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AliasAddress_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225AliasAddress_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AliasAddress_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225AliasAddressChoice_dialedDigits ){
		AsnSingleString *tAlter = (AsnSingleString *)HSMalloc( sizeof(AsnSingleString) );
		new_AsnSingleString(tAlter,e_asnTagIA5String,e_constrained,1,128,0,HS_ASN_MAX_CONSTRAINT);
		/* FROM Constraint */
		strcpy((char*)(tAlter->fromConstraint), "#*,0123456789");
		tAlter->fromSize = 13;
		tAlter->reIndexing = GetStringTypeEncodingBits(
			tAlter->fromSize,
			ASN_IA5_STRING_VMAX,
			&(tAlter->encodingBitsOfAlign),
			&(tAlter->encodingBitsOfUnalign)
		);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225AliasAddressChoice_h323_ID ){
		AsnDoubleString *tAlter = (AsnDoubleString *)HSMalloc( sizeof(AsnDoubleString) );
		new_AsnDoubleString(tAlter,e_asnTagBMPString,e_constrained,1,256,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH225AliasAddressChoice_url_ID ){
		AsnSingleString *tAlter = (AsnSingleString *)HSMalloc( sizeof(AsnSingleString) );
		new_AsnSingleString(tAlter,e_asnTagIA5String,e_constrained,1,512,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225AliasAddressChoice_transportID ){
		ASNH225TransportAddress *tAlter = (ASNH225TransportAddress *)HSMalloc( sizeof(ASNH225TransportAddress) );
		new_ASNH225TransportAddress(tAlter);
		ASNH225TransportAddress_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225AliasAddressChoice_email_ID ){
		AsnSingleString *tAlter = (AsnSingleString *)HSMalloc( sizeof(AsnSingleString) );
		new_AsnSingleString(tAlter,e_asnTagIA5String,e_constrained,1,512,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225AliasAddressChoice_partyNumber ){
		ASNH225PartyNumber *tAlter = (ASNH225PartyNumber *)HSMalloc( sizeof(ASNH225PartyNumber) );
		new_ASNH225PartyNumber(tAlter);
		ASNH225PartyNumber_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225AliasAddressChoice_mobileUIM ){
		ASNH225MobileUIM *tAlter = (ASNH225MobileUIM *)HSMalloc( sizeof(ASNH225MobileUIM) );
		new_ASNH225MobileUIM(tAlter);
		ASNH225MobileUIM_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AliasAddress_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225AliasAddress DeleteAlternation */
HS_RESULT ASNH225AliasAddress_DeleteAlternation(void *pObject)
{
	ASNH225AliasAddress *pObj = (ASNH225AliasAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AliasAddress_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225AliasAddressChoice_dialedDigits ){
			delete_AsnSingleString(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AliasAddressChoice_h323_ID ){
			delete_AsnDoubleString(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH225AliasAddressChoice_url_ID ){
			delete_AsnSingleString(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AliasAddressChoice_transportID ){
			delete_ASNH225TransportAddress(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AliasAddressChoice_email_ID ){
			delete_AsnSingleString(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AliasAddressChoice_partyNumber ){
			delete_ASNH225PartyNumber(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225AliasAddressChoice_mobileUIM ){
			delete_ASNH225MobileUIM(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AliasAddress_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225AliasAddress_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225AliasAddress Encode */
HS_RESULT ASNH225AliasAddress_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225AliasAddress *pObj = (ASNH225AliasAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AliasAddress_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AliasAddress_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225AliasAddressChoiceSize )
		{
			if( pObj->choice > ((ASNH225AliasAddressChoice)(e_ASNH225AliasAddressChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225AliasAddressChoiceSize)) )
	}
	else
	{
		if( e_ASNH225AliasAddressChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225AliasAddressChoice_dialedDigits ){
		if( (tRet=AsnSingleString_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AliasAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AliasAddressChoice_h323_ID ){
		if( (tRet=AsnDoubleString_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AliasAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225AliasAddressChoice_url_ID ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnSingleString_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AliasAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AliasAddressChoice_transportID ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH225TransportAddress_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AliasAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AliasAddressChoice_email_ID ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnSingleString_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AliasAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AliasAddressChoice_partyNumber ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH225PartyNumber_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AliasAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AliasAddressChoice_mobileUIM ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH225MobileUIM_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AliasAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AliasAddress_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225AliasAddress Decode */
HS_RESULT ASNH225AliasAddress_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225AliasAddress *pObj = (ASNH225AliasAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AliasAddress_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225AliasAddressChoiceSize;
	}
	else
	{
		if( e_ASNH225AliasAddressChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225AliasAddressChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225AliasAddressChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AliasAddress_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225AliasAddress_SetChoice( pObj, (ASNH225AliasAddressChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AliasAddress_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225AliasAddressChoice_dialedDigits ){
		if( (tRet=AsnSingleString_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AliasAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AliasAddressChoice_h323_ID ){
		if( (tRet=AsnDoubleString_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AliasAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225AliasAddressChoice_url_ID ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnSingleString_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AliasAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AliasAddressChoice_transportID ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH225TransportAddress_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AliasAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AliasAddressChoice_email_ID ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnSingleString_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AliasAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AliasAddressChoice_partyNumber ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH225PartyNumber_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AliasAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225AliasAddressChoice_mobileUIM ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH225MobileUIM_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225AliasAddress_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225AliasAddress_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225AliasAddress Print */
HS_RESULT ASNH225AliasAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225AliasAddress *pObj = (ASNH225AliasAddress *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225AliasAddress_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225AliasAddressChoice_dialedDigits ){
		AsnSingleString_Print( pObj->alter, pDepth+1, "dialedDigits" );
	}
	else if ( pObj->choice == e_ASNH225AliasAddressChoice_h323_ID ){
		AsnDoubleString_Print( pObj->alter, pDepth+1, "h323_ID" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225AliasAddressChoice_url_ID ){
		AsnSingleString_Print( pObj->alter, pDepth+1, "url_ID" );
	}
	else if ( pObj->choice == e_ASNH225AliasAddressChoice_transportID ){
		ASNH225TransportAddress_Print( pObj->alter, pDepth+1, "transportID" );
	}
	else if ( pObj->choice == e_ASNH225AliasAddressChoice_email_ID ){
		AsnSingleString_Print( pObj->alter, pDepth+1, "email_ID" );
	}
	else if ( pObj->choice == e_ASNH225AliasAddressChoice_partyNumber ){
		ASNH225PartyNumber_Print( pObj->alter, pDepth+1, "partyNumber" );
	}
	else if ( pObj->choice == e_ASNH225AliasAddressChoice_mobileUIM ){
		ASNH225MobileUIM_Print( pObj->alter, pDepth+1, "mobileUIM" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225VendorIdentifier Class
*/
/*ASNH225VendorIdentifier Constructor*/
HS_RESULT new_ASNH225VendorIdentifier(void *pObject)
{
	ASNH225VendorIdentifier *pObj = (ASNH225VendorIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225VendorIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225H221NonStandard( &(pObj->m_vendor) );
	new_AsnOctetString( &(pObj->m_productId), e_constrained, 1, 256, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnOctetString( &(pObj->m_versionId), e_constrained, 1, 256, 0, HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225VendorIdentifier Destructor */
HS_RESULT delete_ASNH225VendorIdentifier(void *pObject)
{
	ASNH225VendorIdentifier *pObj = (ASNH225VendorIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225VendorIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225H221NonStandard( &(pObj->m_vendor) );
	delete_AsnOctetString( &(pObj->m_productId) );
	delete_AsnOctetString( &(pObj->m_versionId) );
	return HS_OK;
}

/* ASNH225VendorIdentifier MakeMold */
HS_RESULT ASNH225VendorIdentifier_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225VendorIdentifier *pObj = (ASNH225VendorIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225VendorIdentifier_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225H221NonStandard_MakeMold(&(pObj->m_vendor));
	return HS_OK;
}

/* ASNH225VendorIdentifier IncludeOptionalField */
HS_RESULT ASNH225VendorIdentifier_IncludeOptionField( void *pObject, ASNH225VendorIdentifierOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225VendorIdentifier *pObj = (ASNH225VendorIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225VendorIdentifier_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225VendorIdentifierOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225VendorIdentifier IsIncludeOptionalField */
BOOL ASNH225VendorIdentifier_IsIncludeOptionField( void *pObject, ASNH225VendorIdentifierOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225VendorIdentifier *pObj = (ASNH225VendorIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225VendorIdentifier_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225VendorIdentifierOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225VendorIdentifier Encode */
HS_RESULT ASNH225VendorIdentifier_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225VendorIdentifier *pObj = (ASNH225VendorIdentifier *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225VendorIdentifier_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225VendorIdentifierOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225VendorIdentifierOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225H221NonStandard_Encode( &(pObj->m_vendor),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225VendorIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225VendorIdentifier_IsIncludeOptionField( pObj, e_ASNH225VendorIdentifierOptionMap_productId ) ){
		if( (tRet=AsnOctetString_Encode( &(pObj->m_productId),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225VendorIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225VendorIdentifier_IsIncludeOptionField( pObj, e_ASNH225VendorIdentifierOptionMap_versionId ) ){
		if( (tRet=AsnOctetString_Encode( &(pObj->m_versionId),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225VendorIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225VendorIdentifier Decode */
HS_RESULT ASNH225VendorIdentifier_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225VendorIdentifier *pObj = (ASNH225VendorIdentifier *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225VendorIdentifier_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225VendorIdentifierOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225VendorIdentifierOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225H221NonStandard_Decode(&(pObj->m_vendor),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225VendorIdentifier_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225VendorIdentifier_IsIncludeOptionField( pObj, e_ASNH225VendorIdentifierOptionMap_productId ) ){
		if( (tRet=AsnOctetString_Decode(&(pObj->m_productId),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225VendorIdentifier_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225VendorIdentifier_IsIncludeOptionField( pObj, e_ASNH225VendorIdentifierOptionMap_versionId ) ){
		if( (tRet=AsnOctetString_Decode(&(pObj->m_versionId),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225VendorIdentifier_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225VendorIdentifier Print */
HS_RESULT ASNH225VendorIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225VendorIdentifier *pObj = (ASNH225VendorIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225VendorIdentifier_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225H221NonStandard_Print( &(pObj->m_vendor), pDepth+1, "vendor" );
	if( ASNH225VendorIdentifier_IsIncludeOptionField( pObj, e_ASNH225VendorIdentifierOptionMap_productId ) )
		AsnOctetString_Print( &(pObj->m_productId), pDepth+1, "productId" );
	if( ASNH225VendorIdentifier_IsIncludeOptionField( pObj, e_ASNH225VendorIdentifierOptionMap_versionId ) )
		AsnOctetString_Print( &(pObj->m_versionId), pDepth+1, "versionId" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225GatekeeperInfo Class
*/
/*ASNH225GatekeeperInfo Constructor*/
HS_RESULT new_ASNH225GatekeeperInfo(void *pObject)
{
	ASNH225GatekeeperInfo *pObj = (ASNH225GatekeeperInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225GatekeeperInfo(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225GatekeeperInfo Destructor */
HS_RESULT delete_ASNH225GatekeeperInfo(void *pObject)
{
	ASNH225GatekeeperInfo *pObj = (ASNH225GatekeeperInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225GatekeeperInfo(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	return HS_OK;
}

/* ASNH225GatekeeperInfo MakeMold */
HS_RESULT ASNH225GatekeeperInfo_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225GatekeeperInfo *pObj = (ASNH225GatekeeperInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GatekeeperInfo_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	return HS_OK;
}

/* ASNH225GatekeeperInfo IncludeOptionalField */
HS_RESULT ASNH225GatekeeperInfo_IncludeOptionField( void *pObject, ASNH225GatekeeperInfoOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225GatekeeperInfo *pObj = (ASNH225GatekeeperInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GatekeeperInfo_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225GatekeeperInfoOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225GatekeeperInfo IsIncludeOptionalField */
BOOL ASNH225GatekeeperInfo_IsIncludeOptionField( void *pObject, ASNH225GatekeeperInfoOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225GatekeeperInfo *pObj = (ASNH225GatekeeperInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GatekeeperInfo_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225GatekeeperInfoOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225GatekeeperInfo Encode */
HS_RESULT ASNH225GatekeeperInfo_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225GatekeeperInfo *pObj = (ASNH225GatekeeperInfo *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GatekeeperInfo_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225GatekeeperInfoOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225GatekeeperInfoOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225GatekeeperInfo_IsIncludeOptionField( pObj, e_ASNH225GatekeeperInfoOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GatekeeperInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225GatekeeperInfo Decode */
HS_RESULT ASNH225GatekeeperInfo_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225GatekeeperInfo *pObj = (ASNH225GatekeeperInfo *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GatekeeperInfo_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225GatekeeperInfoOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225GatekeeperInfoOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225GatekeeperInfo_IsIncludeOptionField( pObj, e_ASNH225GatekeeperInfoOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GatekeeperInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225GatekeeperInfo Print */
HS_RESULT ASNH225GatekeeperInfo_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225GatekeeperInfo *pObj = (ASNH225GatekeeperInfo *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225GatekeeperInfo_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225GatekeeperInfo_IsIncludeOptionField( pObj, e_ASNH225GatekeeperInfoOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225DataRate Class
*/
/*ASNH225DataRate Constructor*/
HS_RESULT new_ASNH225DataRate(void *pObject)
{
	ASNH225DataRate *pObj = (ASNH225DataRate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225DataRate(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_ASNH225BandWidth( &(pObj->m_channelRate) );
	new_AsnInteger( &(pObj->m_channelMultiplier), e_constrained, 1, 256, 0, HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225DataRate Destructor */
HS_RESULT delete_ASNH225DataRate(void *pObject)
{
	ASNH225DataRate *pObj = (ASNH225DataRate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225DataRate(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_ASNH225BandWidth( &(pObj->m_channelRate) );
	delete_AsnInteger( &(pObj->m_channelMultiplier) );
	return HS_OK;
}

/* ASNH225DataRate MakeMold */
HS_RESULT ASNH225DataRate_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225DataRate *pObj = (ASNH225DataRate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DataRate_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	ASNH225BandWidth_MakeMold(&(pObj->m_channelRate));
	return HS_OK;
}

/* ASNH225DataRate IncludeOptionalField */
HS_RESULT ASNH225DataRate_IncludeOptionField( void *pObject, ASNH225DataRateOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225DataRate *pObj = (ASNH225DataRate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DataRate_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225DataRateOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225DataRate IsIncludeOptionalField */
BOOL ASNH225DataRate_IsIncludeOptionField( void *pObject, ASNH225DataRateOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225DataRate *pObj = (ASNH225DataRate *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DataRate_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225DataRateOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225DataRate Encode */
HS_RESULT ASNH225DataRate_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225DataRate *pObj = (ASNH225DataRate *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DataRate_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225DataRateOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225DataRateOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225DataRate_IsIncludeOptionField( pObj, e_ASNH225DataRateOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DataRate_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225BandWidth_Encode( &(pObj->m_channelRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DataRate_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225DataRate_IsIncludeOptionField( pObj, e_ASNH225DataRateOptionMap_channelMultiplier ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_channelMultiplier),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DataRate_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225DataRate Decode */
HS_RESULT ASNH225DataRate_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225DataRate *pObj = (ASNH225DataRate *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DataRate_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225DataRateOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225DataRateOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225DataRate_IsIncludeOptionField( pObj, e_ASNH225DataRateOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DataRate_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225BandWidth_Decode(&(pObj->m_channelRate),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225DataRate_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225DataRate_IsIncludeOptionField( pObj, e_ASNH225DataRateOptionMap_channelMultiplier ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_channelMultiplier),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225DataRate_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225DataRate Print */
HS_RESULT ASNH225DataRate_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225DataRate *pObj = (ASNH225DataRate *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225DataRate_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225DataRate_IsIncludeOptionField( pObj, e_ASNH225DataRateOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	ASNH225BandWidth_Print( &(pObj->m_channelRate), pDepth+1, "channelRate" );
	if( ASNH225DataRate_IsIncludeOptionField( pObj, e_ASNH225DataRateOptionMap_channelMultiplier ) )
		AsnInteger_Print( &(pObj->m_channelMultiplier), pDepth+1, "channelMultiplier" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225SupportedPrefix Class
*/
/*ASNH225SupportedPrefix Constructor*/
HS_RESULT new_ASNH225SupportedPrefix(void *pObject)
{
	ASNH225SupportedPrefix *pObj = (ASNH225SupportedPrefix *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225SupportedPrefix(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_ASNH225AliasAddress( &(pObj->m_prefix) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225SupportedPrefix Destructor */
HS_RESULT delete_ASNH225SupportedPrefix(void *pObject)
{
	ASNH225SupportedPrefix *pObj = (ASNH225SupportedPrefix *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225SupportedPrefix(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_ASNH225AliasAddress( &(pObj->m_prefix) );
	return HS_OK;
}

/* ASNH225SupportedPrefix MakeMold */
HS_RESULT ASNH225SupportedPrefix_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225SupportedPrefix *pObj = (ASNH225SupportedPrefix *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SupportedPrefix_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	ASNH225AliasAddress_MakeMold(&(pObj->m_prefix));
	return HS_OK;
}

/* ASNH225SupportedPrefix IncludeOptionalField */
HS_RESULT ASNH225SupportedPrefix_IncludeOptionField( void *pObject, ASNH225SupportedPrefixOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225SupportedPrefix *pObj = (ASNH225SupportedPrefix *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SupportedPrefix_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225SupportedPrefixOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225SupportedPrefix IsIncludeOptionalField */
BOOL ASNH225SupportedPrefix_IsIncludeOptionField( void *pObject, ASNH225SupportedPrefixOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225SupportedPrefix *pObj = (ASNH225SupportedPrefix *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SupportedPrefix_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225SupportedPrefixOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225SupportedPrefix Encode */
HS_RESULT ASNH225SupportedPrefix_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225SupportedPrefix *pObj = (ASNH225SupportedPrefix *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SupportedPrefix_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225SupportedPrefixOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225SupportedPrefixOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225SupportedPrefix_IsIncludeOptionField( pObj, e_ASNH225SupportedPrefixOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedPrefix_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225AliasAddress_Encode( &(pObj->m_prefix),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SupportedPrefix_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225SupportedPrefix Decode */
HS_RESULT ASNH225SupportedPrefix_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225SupportedPrefix *pObj = (ASNH225SupportedPrefix *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SupportedPrefix_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225SupportedPrefixOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225SupportedPrefixOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225SupportedPrefix_IsIncludeOptionField( pObj, e_ASNH225SupportedPrefixOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedPrefix_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225AliasAddress_Decode(&(pObj->m_prefix),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SupportedPrefix_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225SupportedPrefix Print */
HS_RESULT ASNH225SupportedPrefix_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225SupportedPrefix *pObj = (ASNH225SupportedPrefix *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225SupportedPrefix_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225SupportedPrefix_IsIncludeOptionField( pObj, e_ASNH225SupportedPrefixOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	ASNH225AliasAddress_Print( &(pObj->m_prefix), pDepth+1, "prefix" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225H310Caps Class
*/
/*ASNH225H310Caps Constructor*/
HS_RESULT new_ASNH225H310Caps(void *pObject)
{
	ASNH225H310Caps *pObj = (ASNH225H310Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225H310Caps(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_dataRatesSupported), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_supportedPrefixes), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225H310Caps Destructor */
HS_RESULT delete_ASNH225H310Caps(void *pObject)
{
	ASNH225H310Caps *pObj = (ASNH225H310Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225H310Caps(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_dataRatesSupported) );
	delete_AsnSequenceOf( &(pObj->m_supportedPrefixes) );
	return HS_OK;
}

/* ASNH225H310Caps MakeMold */
HS_RESULT ASNH225H310Caps_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225H310Caps *pObj = (ASNH225H310Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H310Caps_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225DataRate *tmold_dataRatesSupported = (ASNH225DataRate *)HSMalloc( sizeof(ASNH225DataRate) );
	new_ASNH225DataRate(tmold_dataRatesSupported);
	ASNH225DataRate_MakeMold(tmold_dataRatesSupported);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_dataRatesSupported,sizeof(ASNH225DataRate),ASNH225DataRate_MakeMold,ASNH225DataRate_Encode,ASNH225DataRate_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225DataRate_Print,
#endif
		delete_ASNH225DataRate);
	AsnSequenceOf_SetMold( &(pObj->m_dataRatesSupported), moldObject );
	}
	{
	ASNH225SupportedPrefix *tmold_supportedPrefixes = (ASNH225SupportedPrefix *)HSMalloc( sizeof(ASNH225SupportedPrefix) );
	new_ASNH225SupportedPrefix(tmold_supportedPrefixes);
	ASNH225SupportedPrefix_MakeMold(tmold_supportedPrefixes);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_supportedPrefixes,sizeof(ASNH225SupportedPrefix),ASNH225SupportedPrefix_MakeMold,ASNH225SupportedPrefix_Encode,ASNH225SupportedPrefix_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225SupportedPrefix_Print,
#endif
		delete_ASNH225SupportedPrefix);
	AsnSequenceOf_SetMold( &(pObj->m_supportedPrefixes), moldObject );
	}
	return HS_OK;
}

/* ASNH225H310Caps IncludeOptionalField */
HS_RESULT ASNH225H310Caps_IncludeOptionField( void *pObject, ASNH225H310CapsOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225H310Caps *pObj = (ASNH225H310Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H310Caps_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225H310CapsOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225H310CapsOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225H310CapsOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225H310Caps IsIncludeOptionalField */
BOOL ASNH225H310Caps_IsIncludeOptionField( void *pObject, ASNH225H310CapsOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225H310Caps *pObj = (ASNH225H310Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H310Caps_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225H310CapsOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225H310CapsOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225H310CapsOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225H310Caps Encode */
HS_RESULT ASNH225H310Caps_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225H310Caps *pObj = (ASNH225H310Caps *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H310Caps_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225H310CapsOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225H310CapsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225H310Caps_IsIncludeOptionField( pObj, e_ASNH225H310CapsOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H310Caps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225H310Caps_IsIncludeOptionField( pObj, e_ASNH225H310CapsOptionMap_dataRatesSupported ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_dataRatesSupported), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225H310Caps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225H310Caps_IsIncludeOptionField( pObj, e_ASNH225H310CapsOptionMap_supportedPrefixes ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_supportedPrefixes), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225H310Caps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225H310Caps Decode */
HS_RESULT ASNH225H310Caps_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225H310Caps *pObj = (ASNH225H310Caps *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H310Caps_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225H310CapsOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225H310CapsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225H310Caps_IsIncludeOptionField( pObj, e_ASNH225H310CapsOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H310Caps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225H310Caps_IsIncludeOptionField( pObj, e_ASNH225H310CapsOptionMap_dataRatesSupported ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_dataRatesSupported), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H310Caps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225H310Caps_IsIncludeOptionField( pObj, e_ASNH225H310CapsOptionMap_supportedPrefixes ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_supportedPrefixes), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H310Caps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225H310Caps Print */
HS_RESULT ASNH225H310Caps_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225H310Caps *pObj = (ASNH225H310Caps *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225H310Caps_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225H310Caps_IsIncludeOptionField( pObj, e_ASNH225H310CapsOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225H310Caps_IsIncludeOptionField( pObj, e_ASNH225H310CapsOptionMap_dataRatesSupported ) )
		AsnSequenceOf_Print( &(pObj->m_dataRatesSupported), pDepth+1, "dataRatesSupported" );
	if( ASNH225H310Caps_IsIncludeOptionField( pObj, e_ASNH225H310CapsOptionMap_supportedPrefixes ) )
		AsnSequenceOf_Print( &(pObj->m_supportedPrefixes), pDepth+1, "supportedPrefixes" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225H320Caps Class
*/
/*ASNH225H320Caps Constructor*/
HS_RESULT new_ASNH225H320Caps(void *pObject)
{
	ASNH225H320Caps *pObj = (ASNH225H320Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225H320Caps(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_dataRatesSupported), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_supportedPrefixes), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225H320Caps Destructor */
HS_RESULT delete_ASNH225H320Caps(void *pObject)
{
	ASNH225H320Caps *pObj = (ASNH225H320Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225H320Caps(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_dataRatesSupported) );
	delete_AsnSequenceOf( &(pObj->m_supportedPrefixes) );
	return HS_OK;
}

/* ASNH225H320Caps MakeMold */
HS_RESULT ASNH225H320Caps_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225H320Caps *pObj = (ASNH225H320Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H320Caps_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225DataRate *tmold_dataRatesSupported = (ASNH225DataRate *)HSMalloc( sizeof(ASNH225DataRate) );
	new_ASNH225DataRate(tmold_dataRatesSupported);
	ASNH225DataRate_MakeMold(tmold_dataRatesSupported);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_dataRatesSupported,sizeof(ASNH225DataRate),ASNH225DataRate_MakeMold,ASNH225DataRate_Encode,ASNH225DataRate_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225DataRate_Print,
#endif
		delete_ASNH225DataRate);
	AsnSequenceOf_SetMold( &(pObj->m_dataRatesSupported), moldObject );
	}
	{
	ASNH225SupportedPrefix *tmold_supportedPrefixes = (ASNH225SupportedPrefix *)HSMalloc( sizeof(ASNH225SupportedPrefix) );
	new_ASNH225SupportedPrefix(tmold_supportedPrefixes);
	ASNH225SupportedPrefix_MakeMold(tmold_supportedPrefixes);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_supportedPrefixes,sizeof(ASNH225SupportedPrefix),ASNH225SupportedPrefix_MakeMold,ASNH225SupportedPrefix_Encode,ASNH225SupportedPrefix_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225SupportedPrefix_Print,
#endif
		delete_ASNH225SupportedPrefix);
	AsnSequenceOf_SetMold( &(pObj->m_supportedPrefixes), moldObject );
	}
	return HS_OK;
}

/* ASNH225H320Caps IncludeOptionalField */
HS_RESULT ASNH225H320Caps_IncludeOptionField( void *pObject, ASNH225H320CapsOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225H320Caps *pObj = (ASNH225H320Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H320Caps_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225H320CapsOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225H320CapsOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225H320CapsOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225H320Caps IsIncludeOptionalField */
BOOL ASNH225H320Caps_IsIncludeOptionField( void *pObject, ASNH225H320CapsOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225H320Caps *pObj = (ASNH225H320Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H320Caps_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225H320CapsOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225H320CapsOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225H320CapsOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225H320Caps Encode */
HS_RESULT ASNH225H320Caps_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225H320Caps *pObj = (ASNH225H320Caps *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H320Caps_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225H320CapsOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225H320CapsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225H320Caps_IsIncludeOptionField( pObj, e_ASNH225H320CapsOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H320Caps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225H320Caps_IsIncludeOptionField( pObj, e_ASNH225H320CapsOptionMap_dataRatesSupported ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_dataRatesSupported), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225H320Caps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225H320Caps_IsIncludeOptionField( pObj, e_ASNH225H320CapsOptionMap_supportedPrefixes ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_supportedPrefixes), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225H320Caps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225H320Caps Decode */
HS_RESULT ASNH225H320Caps_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225H320Caps *pObj = (ASNH225H320Caps *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H320Caps_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225H320CapsOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225H320CapsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225H320Caps_IsIncludeOptionField( pObj, e_ASNH225H320CapsOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H320Caps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225H320Caps_IsIncludeOptionField( pObj, e_ASNH225H320CapsOptionMap_dataRatesSupported ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_dataRatesSupported), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H320Caps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225H320Caps_IsIncludeOptionField( pObj, e_ASNH225H320CapsOptionMap_supportedPrefixes ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_supportedPrefixes), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H320Caps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225H320Caps Print */
HS_RESULT ASNH225H320Caps_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225H320Caps *pObj = (ASNH225H320Caps *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225H320Caps_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225H320Caps_IsIncludeOptionField( pObj, e_ASNH225H320CapsOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225H320Caps_IsIncludeOptionField( pObj, e_ASNH225H320CapsOptionMap_dataRatesSupported ) )
		AsnSequenceOf_Print( &(pObj->m_dataRatesSupported), pDepth+1, "dataRatesSupported" );
	if( ASNH225H320Caps_IsIncludeOptionField( pObj, e_ASNH225H320CapsOptionMap_supportedPrefixes ) )
		AsnSequenceOf_Print( &(pObj->m_supportedPrefixes), pDepth+1, "supportedPrefixes" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225H321Caps Class
*/
/*ASNH225H321Caps Constructor*/
HS_RESULT new_ASNH225H321Caps(void *pObject)
{
	ASNH225H321Caps *pObj = (ASNH225H321Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225H321Caps(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_dataRatesSupported), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_supportedPrefixes), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225H321Caps Destructor */
HS_RESULT delete_ASNH225H321Caps(void *pObject)
{
	ASNH225H321Caps *pObj = (ASNH225H321Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225H321Caps(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_dataRatesSupported) );
	delete_AsnSequenceOf( &(pObj->m_supportedPrefixes) );
	return HS_OK;
}

/* ASNH225H321Caps MakeMold */
HS_RESULT ASNH225H321Caps_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225H321Caps *pObj = (ASNH225H321Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H321Caps_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225DataRate *tmold_dataRatesSupported = (ASNH225DataRate *)HSMalloc( sizeof(ASNH225DataRate) );
	new_ASNH225DataRate(tmold_dataRatesSupported);
	ASNH225DataRate_MakeMold(tmold_dataRatesSupported);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_dataRatesSupported,sizeof(ASNH225DataRate),ASNH225DataRate_MakeMold,ASNH225DataRate_Encode,ASNH225DataRate_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225DataRate_Print,
#endif
		delete_ASNH225DataRate);
	AsnSequenceOf_SetMold( &(pObj->m_dataRatesSupported), moldObject );
	}
	{
	ASNH225SupportedPrefix *tmold_supportedPrefixes = (ASNH225SupportedPrefix *)HSMalloc( sizeof(ASNH225SupportedPrefix) );
	new_ASNH225SupportedPrefix(tmold_supportedPrefixes);
	ASNH225SupportedPrefix_MakeMold(tmold_supportedPrefixes);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_supportedPrefixes,sizeof(ASNH225SupportedPrefix),ASNH225SupportedPrefix_MakeMold,ASNH225SupportedPrefix_Encode,ASNH225SupportedPrefix_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225SupportedPrefix_Print,
#endif
		delete_ASNH225SupportedPrefix);
	AsnSequenceOf_SetMold( &(pObj->m_supportedPrefixes), moldObject );
	}
	return HS_OK;
}

/* ASNH225H321Caps IncludeOptionalField */
HS_RESULT ASNH225H321Caps_IncludeOptionField( void *pObject, ASNH225H321CapsOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225H321Caps *pObj = (ASNH225H321Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H321Caps_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225H321CapsOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225H321CapsOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225H321CapsOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225H321Caps IsIncludeOptionalField */
BOOL ASNH225H321Caps_IsIncludeOptionField( void *pObject, ASNH225H321CapsOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225H321Caps *pObj = (ASNH225H321Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H321Caps_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225H321CapsOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225H321CapsOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225H321CapsOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225H321Caps Encode */
HS_RESULT ASNH225H321Caps_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225H321Caps *pObj = (ASNH225H321Caps *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H321Caps_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225H321CapsOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225H321CapsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225H321Caps_IsIncludeOptionField( pObj, e_ASNH225H321CapsOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H321Caps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225H321Caps_IsIncludeOptionField( pObj, e_ASNH225H321CapsOptionMap_dataRatesSupported ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_dataRatesSupported), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225H321Caps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225H321Caps_IsIncludeOptionField( pObj, e_ASNH225H321CapsOptionMap_supportedPrefixes ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_supportedPrefixes), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225H321Caps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225H321Caps Decode */
HS_RESULT ASNH225H321Caps_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225H321Caps *pObj = (ASNH225H321Caps *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H321Caps_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225H321CapsOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225H321CapsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225H321Caps_IsIncludeOptionField( pObj, e_ASNH225H321CapsOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H321Caps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225H321Caps_IsIncludeOptionField( pObj, e_ASNH225H321CapsOptionMap_dataRatesSupported ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_dataRatesSupported), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H321Caps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225H321Caps_IsIncludeOptionField( pObj, e_ASNH225H321CapsOptionMap_supportedPrefixes ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_supportedPrefixes), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H321Caps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225H321Caps Print */
HS_RESULT ASNH225H321Caps_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225H321Caps *pObj = (ASNH225H321Caps *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225H321Caps_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225H321Caps_IsIncludeOptionField( pObj, e_ASNH225H321CapsOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225H321Caps_IsIncludeOptionField( pObj, e_ASNH225H321CapsOptionMap_dataRatesSupported ) )
		AsnSequenceOf_Print( &(pObj->m_dataRatesSupported), pDepth+1, "dataRatesSupported" );
	if( ASNH225H321Caps_IsIncludeOptionField( pObj, e_ASNH225H321CapsOptionMap_supportedPrefixes ) )
		AsnSequenceOf_Print( &(pObj->m_supportedPrefixes), pDepth+1, "supportedPrefixes" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225H322Caps Class
*/
/*ASNH225H322Caps Constructor*/
HS_RESULT new_ASNH225H322Caps(void *pObject)
{
	ASNH225H322Caps *pObj = (ASNH225H322Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225H322Caps(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_dataRatesSupported), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_supportedPrefixes), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225H322Caps Destructor */
HS_RESULT delete_ASNH225H322Caps(void *pObject)
{
	ASNH225H322Caps *pObj = (ASNH225H322Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225H322Caps(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_dataRatesSupported) );
	delete_AsnSequenceOf( &(pObj->m_supportedPrefixes) );
	return HS_OK;
}

/* ASNH225H322Caps MakeMold */
HS_RESULT ASNH225H322Caps_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225H322Caps *pObj = (ASNH225H322Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H322Caps_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225DataRate *tmold_dataRatesSupported = (ASNH225DataRate *)HSMalloc( sizeof(ASNH225DataRate) );
	new_ASNH225DataRate(tmold_dataRatesSupported);
	ASNH225DataRate_MakeMold(tmold_dataRatesSupported);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_dataRatesSupported,sizeof(ASNH225DataRate),ASNH225DataRate_MakeMold,ASNH225DataRate_Encode,ASNH225DataRate_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225DataRate_Print,
#endif
		delete_ASNH225DataRate);
	AsnSequenceOf_SetMold( &(pObj->m_dataRatesSupported), moldObject );
	}
	{
	ASNH225SupportedPrefix *tmold_supportedPrefixes = (ASNH225SupportedPrefix *)HSMalloc( sizeof(ASNH225SupportedPrefix) );
	new_ASNH225SupportedPrefix(tmold_supportedPrefixes);
	ASNH225SupportedPrefix_MakeMold(tmold_supportedPrefixes);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_supportedPrefixes,sizeof(ASNH225SupportedPrefix),ASNH225SupportedPrefix_MakeMold,ASNH225SupportedPrefix_Encode,ASNH225SupportedPrefix_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225SupportedPrefix_Print,
#endif
		delete_ASNH225SupportedPrefix);
	AsnSequenceOf_SetMold( &(pObj->m_supportedPrefixes), moldObject );
	}
	return HS_OK;
}

/* ASNH225H322Caps IncludeOptionalField */
HS_RESULT ASNH225H322Caps_IncludeOptionField( void *pObject, ASNH225H322CapsOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225H322Caps *pObj = (ASNH225H322Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H322Caps_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225H322CapsOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225H322CapsOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225H322CapsOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225H322Caps IsIncludeOptionalField */
BOOL ASNH225H322Caps_IsIncludeOptionField( void *pObject, ASNH225H322CapsOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225H322Caps *pObj = (ASNH225H322Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H322Caps_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225H322CapsOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225H322CapsOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225H322CapsOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225H322Caps Encode */
HS_RESULT ASNH225H322Caps_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225H322Caps *pObj = (ASNH225H322Caps *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H322Caps_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225H322CapsOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225H322CapsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225H322Caps_IsIncludeOptionField( pObj, e_ASNH225H322CapsOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H322Caps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225H322Caps_IsIncludeOptionField( pObj, e_ASNH225H322CapsOptionMap_dataRatesSupported ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_dataRatesSupported), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225H322Caps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225H322Caps_IsIncludeOptionField( pObj, e_ASNH225H322CapsOptionMap_supportedPrefixes ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_supportedPrefixes), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225H322Caps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225H322Caps Decode */
HS_RESULT ASNH225H322Caps_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225H322Caps *pObj = (ASNH225H322Caps *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H322Caps_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225H322CapsOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225H322CapsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225H322Caps_IsIncludeOptionField( pObj, e_ASNH225H322CapsOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H322Caps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225H322Caps_IsIncludeOptionField( pObj, e_ASNH225H322CapsOptionMap_dataRatesSupported ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_dataRatesSupported), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H322Caps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225H322Caps_IsIncludeOptionField( pObj, e_ASNH225H322CapsOptionMap_supportedPrefixes ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_supportedPrefixes), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H322Caps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225H322Caps Print */
HS_RESULT ASNH225H322Caps_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225H322Caps *pObj = (ASNH225H322Caps *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225H322Caps_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225H322Caps_IsIncludeOptionField( pObj, e_ASNH225H322CapsOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225H322Caps_IsIncludeOptionField( pObj, e_ASNH225H322CapsOptionMap_dataRatesSupported ) )
		AsnSequenceOf_Print( &(pObj->m_dataRatesSupported), pDepth+1, "dataRatesSupported" );
	if( ASNH225H322Caps_IsIncludeOptionField( pObj, e_ASNH225H322CapsOptionMap_supportedPrefixes ) )
		AsnSequenceOf_Print( &(pObj->m_supportedPrefixes), pDepth+1, "supportedPrefixes" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225H323Caps Class
*/
/*ASNH225H323Caps Constructor*/
HS_RESULT new_ASNH225H323Caps(void *pObject)
{
	ASNH225H323Caps *pObj = (ASNH225H323Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225H323Caps(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_dataRatesSupported), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_supportedPrefixes), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225H323Caps Destructor */
HS_RESULT delete_ASNH225H323Caps(void *pObject)
{
	ASNH225H323Caps *pObj = (ASNH225H323Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225H323Caps(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_dataRatesSupported) );
	delete_AsnSequenceOf( &(pObj->m_supportedPrefixes) );
	return HS_OK;
}

/* ASNH225H323Caps MakeMold */
HS_RESULT ASNH225H323Caps_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225H323Caps *pObj = (ASNH225H323Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H323Caps_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225DataRate *tmold_dataRatesSupported = (ASNH225DataRate *)HSMalloc( sizeof(ASNH225DataRate) );
	new_ASNH225DataRate(tmold_dataRatesSupported);
	ASNH225DataRate_MakeMold(tmold_dataRatesSupported);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_dataRatesSupported,sizeof(ASNH225DataRate),ASNH225DataRate_MakeMold,ASNH225DataRate_Encode,ASNH225DataRate_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225DataRate_Print,
#endif
		delete_ASNH225DataRate);
	AsnSequenceOf_SetMold( &(pObj->m_dataRatesSupported), moldObject );
	}
	{
	ASNH225SupportedPrefix *tmold_supportedPrefixes = (ASNH225SupportedPrefix *)HSMalloc( sizeof(ASNH225SupportedPrefix) );
	new_ASNH225SupportedPrefix(tmold_supportedPrefixes);
	ASNH225SupportedPrefix_MakeMold(tmold_supportedPrefixes);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_supportedPrefixes,sizeof(ASNH225SupportedPrefix),ASNH225SupportedPrefix_MakeMold,ASNH225SupportedPrefix_Encode,ASNH225SupportedPrefix_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225SupportedPrefix_Print,
#endif
		delete_ASNH225SupportedPrefix);
	AsnSequenceOf_SetMold( &(pObj->m_supportedPrefixes), moldObject );
	}
	return HS_OK;
}

/* ASNH225H323Caps IncludeOptionalField */
HS_RESULT ASNH225H323Caps_IncludeOptionField( void *pObject, ASNH225H323CapsOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225H323Caps *pObj = (ASNH225H323Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H323Caps_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225H323CapsOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225H323CapsOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225H323CapsOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225H323Caps IsIncludeOptionalField */
BOOL ASNH225H323Caps_IsIncludeOptionField( void *pObject, ASNH225H323CapsOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225H323Caps *pObj = (ASNH225H323Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H323Caps_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225H323CapsOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225H323CapsOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225H323CapsOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225H323Caps Encode */
HS_RESULT ASNH225H323Caps_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225H323Caps *pObj = (ASNH225H323Caps *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H323Caps_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225H323CapsOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225H323CapsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225H323Caps_IsIncludeOptionField( pObj, e_ASNH225H323CapsOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H323Caps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225H323Caps_IsIncludeOptionField( pObj, e_ASNH225H323CapsOptionMap_dataRatesSupported ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_dataRatesSupported), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225H323Caps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225H323Caps_IsIncludeOptionField( pObj, e_ASNH225H323CapsOptionMap_supportedPrefixes ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_supportedPrefixes), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225H323Caps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225H323Caps Decode */
HS_RESULT ASNH225H323Caps_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225H323Caps *pObj = (ASNH225H323Caps *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H323Caps_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225H323CapsOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225H323CapsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225H323Caps_IsIncludeOptionField( pObj, e_ASNH225H323CapsOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H323Caps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225H323Caps_IsIncludeOptionField( pObj, e_ASNH225H323CapsOptionMap_dataRatesSupported ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_dataRatesSupported), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H323Caps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225H323Caps_IsIncludeOptionField( pObj, e_ASNH225H323CapsOptionMap_supportedPrefixes ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_supportedPrefixes), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H323Caps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225H323Caps Print */
HS_RESULT ASNH225H323Caps_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225H323Caps *pObj = (ASNH225H323Caps *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225H323Caps_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225H323Caps_IsIncludeOptionField( pObj, e_ASNH225H323CapsOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225H323Caps_IsIncludeOptionField( pObj, e_ASNH225H323CapsOptionMap_dataRatesSupported ) )
		AsnSequenceOf_Print( &(pObj->m_dataRatesSupported), pDepth+1, "dataRatesSupported" );
	if( ASNH225H323Caps_IsIncludeOptionField( pObj, e_ASNH225H323CapsOptionMap_supportedPrefixes ) )
		AsnSequenceOf_Print( &(pObj->m_supportedPrefixes), pDepth+1, "supportedPrefixes" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225H324Caps Class
*/
/*ASNH225H324Caps Constructor*/
HS_RESULT new_ASNH225H324Caps(void *pObject)
{
	ASNH225H324Caps *pObj = (ASNH225H324Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225H324Caps(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_dataRatesSupported), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_supportedPrefixes), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225H324Caps Destructor */
HS_RESULT delete_ASNH225H324Caps(void *pObject)
{
	ASNH225H324Caps *pObj = (ASNH225H324Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225H324Caps(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_dataRatesSupported) );
	delete_AsnSequenceOf( &(pObj->m_supportedPrefixes) );
	return HS_OK;
}

/* ASNH225H324Caps MakeMold */
HS_RESULT ASNH225H324Caps_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225H324Caps *pObj = (ASNH225H324Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H324Caps_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225DataRate *tmold_dataRatesSupported = (ASNH225DataRate *)HSMalloc( sizeof(ASNH225DataRate) );
	new_ASNH225DataRate(tmold_dataRatesSupported);
	ASNH225DataRate_MakeMold(tmold_dataRatesSupported);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_dataRatesSupported,sizeof(ASNH225DataRate),ASNH225DataRate_MakeMold,ASNH225DataRate_Encode,ASNH225DataRate_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225DataRate_Print,
#endif
		delete_ASNH225DataRate);
	AsnSequenceOf_SetMold( &(pObj->m_dataRatesSupported), moldObject );
	}
	{
	ASNH225SupportedPrefix *tmold_supportedPrefixes = (ASNH225SupportedPrefix *)HSMalloc( sizeof(ASNH225SupportedPrefix) );
	new_ASNH225SupportedPrefix(tmold_supportedPrefixes);
	ASNH225SupportedPrefix_MakeMold(tmold_supportedPrefixes);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_supportedPrefixes,sizeof(ASNH225SupportedPrefix),ASNH225SupportedPrefix_MakeMold,ASNH225SupportedPrefix_Encode,ASNH225SupportedPrefix_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225SupportedPrefix_Print,
#endif
		delete_ASNH225SupportedPrefix);
	AsnSequenceOf_SetMold( &(pObj->m_supportedPrefixes), moldObject );
	}
	return HS_OK;
}

/* ASNH225H324Caps IncludeOptionalField */
HS_RESULT ASNH225H324Caps_IncludeOptionField( void *pObject, ASNH225H324CapsOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225H324Caps *pObj = (ASNH225H324Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H324Caps_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225H324CapsOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225H324CapsOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225H324CapsOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225H324Caps IsIncludeOptionalField */
BOOL ASNH225H324Caps_IsIncludeOptionField( void *pObject, ASNH225H324CapsOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225H324Caps *pObj = (ASNH225H324Caps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H324Caps_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225H324CapsOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225H324CapsOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225H324CapsOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225H324Caps Encode */
HS_RESULT ASNH225H324Caps_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225H324Caps *pObj = (ASNH225H324Caps *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H324Caps_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225H324CapsOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225H324CapsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225H324Caps_IsIncludeOptionField( pObj, e_ASNH225H324CapsOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H324Caps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225H324Caps_IsIncludeOptionField( pObj, e_ASNH225H324CapsOptionMap_dataRatesSupported ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_dataRatesSupported), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225H324Caps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225H324Caps_IsIncludeOptionField( pObj, e_ASNH225H324CapsOptionMap_supportedPrefixes ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_supportedPrefixes), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225H324Caps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225H324Caps Decode */
HS_RESULT ASNH225H324Caps_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225H324Caps *pObj = (ASNH225H324Caps *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H324Caps_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225H324CapsOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225H324CapsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225H324Caps_IsIncludeOptionField( pObj, e_ASNH225H324CapsOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H324Caps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225H324Caps_IsIncludeOptionField( pObj, e_ASNH225H324CapsOptionMap_dataRatesSupported ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_dataRatesSupported), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H324Caps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225H324Caps_IsIncludeOptionField( pObj, e_ASNH225H324CapsOptionMap_supportedPrefixes ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_supportedPrefixes), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H324Caps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225H324Caps Print */
HS_RESULT ASNH225H324Caps_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225H324Caps *pObj = (ASNH225H324Caps *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225H324Caps_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225H324Caps_IsIncludeOptionField( pObj, e_ASNH225H324CapsOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225H324Caps_IsIncludeOptionField( pObj, e_ASNH225H324CapsOptionMap_dataRatesSupported ) )
		AsnSequenceOf_Print( &(pObj->m_dataRatesSupported), pDepth+1, "dataRatesSupported" );
	if( ASNH225H324Caps_IsIncludeOptionField( pObj, e_ASNH225H324CapsOptionMap_supportedPrefixes ) )
		AsnSequenceOf_Print( &(pObj->m_supportedPrefixes), pDepth+1, "supportedPrefixes" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225VoiceCaps Class
*/
/*ASNH225VoiceCaps Constructor*/
HS_RESULT new_ASNH225VoiceCaps(void *pObject)
{
	ASNH225VoiceCaps *pObj = (ASNH225VoiceCaps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225VoiceCaps(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_dataRatesSupported), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_supportedPrefixes), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225VoiceCaps Destructor */
HS_RESULT delete_ASNH225VoiceCaps(void *pObject)
{
	ASNH225VoiceCaps *pObj = (ASNH225VoiceCaps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225VoiceCaps(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_dataRatesSupported) );
	delete_AsnSequenceOf( &(pObj->m_supportedPrefixes) );
	return HS_OK;
}

/* ASNH225VoiceCaps MakeMold */
HS_RESULT ASNH225VoiceCaps_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225VoiceCaps *pObj = (ASNH225VoiceCaps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225VoiceCaps_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225DataRate *tmold_dataRatesSupported = (ASNH225DataRate *)HSMalloc( sizeof(ASNH225DataRate) );
	new_ASNH225DataRate(tmold_dataRatesSupported);
	ASNH225DataRate_MakeMold(tmold_dataRatesSupported);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_dataRatesSupported,sizeof(ASNH225DataRate),ASNH225DataRate_MakeMold,ASNH225DataRate_Encode,ASNH225DataRate_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225DataRate_Print,
#endif
		delete_ASNH225DataRate);
	AsnSequenceOf_SetMold( &(pObj->m_dataRatesSupported), moldObject );
	}
	{
	ASNH225SupportedPrefix *tmold_supportedPrefixes = (ASNH225SupportedPrefix *)HSMalloc( sizeof(ASNH225SupportedPrefix) );
	new_ASNH225SupportedPrefix(tmold_supportedPrefixes);
	ASNH225SupportedPrefix_MakeMold(tmold_supportedPrefixes);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_supportedPrefixes,sizeof(ASNH225SupportedPrefix),ASNH225SupportedPrefix_MakeMold,ASNH225SupportedPrefix_Encode,ASNH225SupportedPrefix_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225SupportedPrefix_Print,
#endif
		delete_ASNH225SupportedPrefix);
	AsnSequenceOf_SetMold( &(pObj->m_supportedPrefixes), moldObject );
	}
	return HS_OK;
}

/* ASNH225VoiceCaps IncludeOptionalField */
HS_RESULT ASNH225VoiceCaps_IncludeOptionField( void *pObject, ASNH225VoiceCapsOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225VoiceCaps *pObj = (ASNH225VoiceCaps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225VoiceCaps_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225VoiceCapsOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225VoiceCapsOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225VoiceCapsOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225VoiceCaps IsIncludeOptionalField */
BOOL ASNH225VoiceCaps_IsIncludeOptionField( void *pObject, ASNH225VoiceCapsOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225VoiceCaps *pObj = (ASNH225VoiceCaps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225VoiceCaps_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225VoiceCapsOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225VoiceCapsOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225VoiceCapsOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225VoiceCaps Encode */
HS_RESULT ASNH225VoiceCaps_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225VoiceCaps *pObj = (ASNH225VoiceCaps *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225VoiceCaps_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225VoiceCapsOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225VoiceCapsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225VoiceCaps_IsIncludeOptionField( pObj, e_ASNH225VoiceCapsOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225VoiceCaps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225VoiceCaps_IsIncludeOptionField( pObj, e_ASNH225VoiceCapsOptionMap_dataRatesSupported ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_dataRatesSupported), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225VoiceCaps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225VoiceCaps_IsIncludeOptionField( pObj, e_ASNH225VoiceCapsOptionMap_supportedPrefixes ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_supportedPrefixes), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225VoiceCaps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225VoiceCaps Decode */
HS_RESULT ASNH225VoiceCaps_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225VoiceCaps *pObj = (ASNH225VoiceCaps *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225VoiceCaps_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225VoiceCapsOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225VoiceCapsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225VoiceCaps_IsIncludeOptionField( pObj, e_ASNH225VoiceCapsOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225VoiceCaps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225VoiceCaps_IsIncludeOptionField( pObj, e_ASNH225VoiceCapsOptionMap_dataRatesSupported ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_dataRatesSupported), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225VoiceCaps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225VoiceCaps_IsIncludeOptionField( pObj, e_ASNH225VoiceCapsOptionMap_supportedPrefixes ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_supportedPrefixes), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225VoiceCaps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225VoiceCaps Print */
HS_RESULT ASNH225VoiceCaps_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225VoiceCaps *pObj = (ASNH225VoiceCaps *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225VoiceCaps_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225VoiceCaps_IsIncludeOptionField( pObj, e_ASNH225VoiceCapsOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225VoiceCaps_IsIncludeOptionField( pObj, e_ASNH225VoiceCapsOptionMap_dataRatesSupported ) )
		AsnSequenceOf_Print( &(pObj->m_dataRatesSupported), pDepth+1, "dataRatesSupported" );
	if( ASNH225VoiceCaps_IsIncludeOptionField( pObj, e_ASNH225VoiceCapsOptionMap_supportedPrefixes ) )
		AsnSequenceOf_Print( &(pObj->m_supportedPrefixes), pDepth+1, "supportedPrefixes" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225T120OnlyCaps Class
*/
/*ASNH225T120OnlyCaps Constructor*/
HS_RESULT new_ASNH225T120OnlyCaps(void *pObject)
{
	ASNH225T120OnlyCaps *pObj = (ASNH225T120OnlyCaps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225T120OnlyCaps(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_dataRatesSupported), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_supportedPrefixes), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225T120OnlyCaps Destructor */
HS_RESULT delete_ASNH225T120OnlyCaps(void *pObject)
{
	ASNH225T120OnlyCaps *pObj = (ASNH225T120OnlyCaps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225T120OnlyCaps(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_dataRatesSupported) );
	delete_AsnSequenceOf( &(pObj->m_supportedPrefixes) );
	return HS_OK;
}

/* ASNH225T120OnlyCaps MakeMold */
HS_RESULT ASNH225T120OnlyCaps_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225T120OnlyCaps *pObj = (ASNH225T120OnlyCaps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225T120OnlyCaps_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225DataRate *tmold_dataRatesSupported = (ASNH225DataRate *)HSMalloc( sizeof(ASNH225DataRate) );
	new_ASNH225DataRate(tmold_dataRatesSupported);
	ASNH225DataRate_MakeMold(tmold_dataRatesSupported);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_dataRatesSupported,sizeof(ASNH225DataRate),ASNH225DataRate_MakeMold,ASNH225DataRate_Encode,ASNH225DataRate_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225DataRate_Print,
#endif
		delete_ASNH225DataRate);
	AsnSequenceOf_SetMold( &(pObj->m_dataRatesSupported), moldObject );
	}
	{
	ASNH225SupportedPrefix *tmold_supportedPrefixes = (ASNH225SupportedPrefix *)HSMalloc( sizeof(ASNH225SupportedPrefix) );
	new_ASNH225SupportedPrefix(tmold_supportedPrefixes);
	ASNH225SupportedPrefix_MakeMold(tmold_supportedPrefixes);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_supportedPrefixes,sizeof(ASNH225SupportedPrefix),ASNH225SupportedPrefix_MakeMold,ASNH225SupportedPrefix_Encode,ASNH225SupportedPrefix_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225SupportedPrefix_Print,
#endif
		delete_ASNH225SupportedPrefix);
	AsnSequenceOf_SetMold( &(pObj->m_supportedPrefixes), moldObject );
	}
	return HS_OK;
}

/* ASNH225T120OnlyCaps IncludeOptionalField */
HS_RESULT ASNH225T120OnlyCaps_IncludeOptionField( void *pObject, ASNH225T120OnlyCapsOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225T120OnlyCaps *pObj = (ASNH225T120OnlyCaps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225T120OnlyCaps_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225T120OnlyCapsOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225T120OnlyCapsOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225T120OnlyCapsOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225T120OnlyCaps IsIncludeOptionalField */
BOOL ASNH225T120OnlyCaps_IsIncludeOptionField( void *pObject, ASNH225T120OnlyCapsOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225T120OnlyCaps *pObj = (ASNH225T120OnlyCaps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225T120OnlyCaps_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225T120OnlyCapsOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225T120OnlyCapsOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225T120OnlyCapsOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225T120OnlyCaps Encode */
HS_RESULT ASNH225T120OnlyCaps_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225T120OnlyCaps *pObj = (ASNH225T120OnlyCaps *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225T120OnlyCaps_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225T120OnlyCapsOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225T120OnlyCapsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225T120OnlyCaps_IsIncludeOptionField( pObj, e_ASNH225T120OnlyCapsOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225T120OnlyCaps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225T120OnlyCaps_IsIncludeOptionField( pObj, e_ASNH225T120OnlyCapsOptionMap_dataRatesSupported ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_dataRatesSupported), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225T120OnlyCaps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225T120OnlyCaps_IsIncludeOptionField( pObj, e_ASNH225T120OnlyCapsOptionMap_supportedPrefixes ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_supportedPrefixes), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225T120OnlyCaps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225T120OnlyCaps Decode */
HS_RESULT ASNH225T120OnlyCaps_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225T120OnlyCaps *pObj = (ASNH225T120OnlyCaps *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225T120OnlyCaps_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225T120OnlyCapsOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225T120OnlyCapsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225T120OnlyCaps_IsIncludeOptionField( pObj, e_ASNH225T120OnlyCapsOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225T120OnlyCaps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225T120OnlyCaps_IsIncludeOptionField( pObj, e_ASNH225T120OnlyCapsOptionMap_dataRatesSupported ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_dataRatesSupported), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225T120OnlyCaps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225T120OnlyCaps_IsIncludeOptionField( pObj, e_ASNH225T120OnlyCapsOptionMap_supportedPrefixes ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_supportedPrefixes), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225T120OnlyCaps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225T120OnlyCaps Print */
HS_RESULT ASNH225T120OnlyCaps_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225T120OnlyCaps *pObj = (ASNH225T120OnlyCaps *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225T120OnlyCaps_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225T120OnlyCaps_IsIncludeOptionField( pObj, e_ASNH225T120OnlyCapsOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225T120OnlyCaps_IsIncludeOptionField( pObj, e_ASNH225T120OnlyCapsOptionMap_dataRatesSupported ) )
		AsnSequenceOf_Print( &(pObj->m_dataRatesSupported), pDepth+1, "dataRatesSupported" );
	if( ASNH225T120OnlyCaps_IsIncludeOptionField( pObj, e_ASNH225T120OnlyCapsOptionMap_supportedPrefixes ) )
		AsnSequenceOf_Print( &(pObj->m_supportedPrefixes), pDepth+1, "supportedPrefixes" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225NonStandardProtocol Class
*/
/*ASNH225NonStandardProtocol Constructor*/
HS_RESULT new_ASNH225NonStandardProtocol(void *pObject)
{
	ASNH225NonStandardProtocol *pObj = (ASNH225NonStandardProtocol *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225NonStandardProtocol(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_dataRatesSupported), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_supportedPrefixes), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225NonStandardProtocol Destructor */
HS_RESULT delete_ASNH225NonStandardProtocol(void *pObject)
{
	ASNH225NonStandardProtocol *pObj = (ASNH225NonStandardProtocol *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225NonStandardProtocol(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_dataRatesSupported) );
	delete_AsnSequenceOf( &(pObj->m_supportedPrefixes) );
	return HS_OK;
}

/* ASNH225NonStandardProtocol MakeMold */
HS_RESULT ASNH225NonStandardProtocol_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225NonStandardProtocol *pObj = (ASNH225NonStandardProtocol *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardProtocol_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225DataRate *tmold_dataRatesSupported = (ASNH225DataRate *)HSMalloc( sizeof(ASNH225DataRate) );
	new_ASNH225DataRate(tmold_dataRatesSupported);
	ASNH225DataRate_MakeMold(tmold_dataRatesSupported);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_dataRatesSupported,sizeof(ASNH225DataRate),ASNH225DataRate_MakeMold,ASNH225DataRate_Encode,ASNH225DataRate_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225DataRate_Print,
#endif
		delete_ASNH225DataRate);
	AsnSequenceOf_SetMold( &(pObj->m_dataRatesSupported), moldObject );
	}
	{
	ASNH225SupportedPrefix *tmold_supportedPrefixes = (ASNH225SupportedPrefix *)HSMalloc( sizeof(ASNH225SupportedPrefix) );
	new_ASNH225SupportedPrefix(tmold_supportedPrefixes);
	ASNH225SupportedPrefix_MakeMold(tmold_supportedPrefixes);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_supportedPrefixes,sizeof(ASNH225SupportedPrefix),ASNH225SupportedPrefix_MakeMold,ASNH225SupportedPrefix_Encode,ASNH225SupportedPrefix_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225SupportedPrefix_Print,
#endif
		delete_ASNH225SupportedPrefix);
	AsnSequenceOf_SetMold( &(pObj->m_supportedPrefixes), moldObject );
	}
	return HS_OK;
}

/* ASNH225NonStandardProtocol IncludeOptionalField */
HS_RESULT ASNH225NonStandardProtocol_IncludeOptionField( void *pObject, ASNH225NonStandardProtocolOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225NonStandardProtocol *pObj = (ASNH225NonStandardProtocol *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardProtocol_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225NonStandardProtocolOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225NonStandardProtocol IsIncludeOptionalField */
BOOL ASNH225NonStandardProtocol_IsIncludeOptionField( void *pObject, ASNH225NonStandardProtocolOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225NonStandardProtocol *pObj = (ASNH225NonStandardProtocol *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardProtocol_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225NonStandardProtocolOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225NonStandardProtocol Encode */
HS_RESULT ASNH225NonStandardProtocol_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225NonStandardProtocol *pObj = (ASNH225NonStandardProtocol *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardProtocol_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225NonStandardProtocolOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225NonStandardProtocolOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225NonStandardProtocol_IsIncludeOptionField( pObj, e_ASNH225NonStandardProtocolOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225NonStandardProtocol_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225NonStandardProtocol_IsIncludeOptionField( pObj, e_ASNH225NonStandardProtocolOptionMap_dataRatesSupported ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_dataRatesSupported),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225NonStandardProtocol_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_supportedPrefixes),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardProtocol_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225NonStandardProtocol Decode */
HS_RESULT ASNH225NonStandardProtocol_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225NonStandardProtocol *pObj = (ASNH225NonStandardProtocol *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardProtocol_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225NonStandardProtocolOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225NonStandardProtocolOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225NonStandardProtocol_IsIncludeOptionField( pObj, e_ASNH225NonStandardProtocolOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225NonStandardProtocol_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225NonStandardProtocol_IsIncludeOptionField( pObj, e_ASNH225NonStandardProtocolOptionMap_dataRatesSupported ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_dataRatesSupported),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225NonStandardProtocol_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_supportedPrefixes),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225NonStandardProtocol_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225NonStandardProtocol Print */
HS_RESULT ASNH225NonStandardProtocol_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225NonStandardProtocol *pObj = (ASNH225NonStandardProtocol *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225NonStandardProtocol_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225NonStandardProtocol_IsIncludeOptionField( pObj, e_ASNH225NonStandardProtocolOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	if( ASNH225NonStandardProtocol_IsIncludeOptionField( pObj, e_ASNH225NonStandardProtocolOptionMap_dataRatesSupported ) )
		AsnSequenceOf_Print( &(pObj->m_dataRatesSupported), pDepth+1, "dataRatesSupported" );
	AsnSequenceOf_Print( &(pObj->m_supportedPrefixes), pDepth+1, "supportedPrefixes" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225T38FaxAnnexbOnlyCaps Class
*/
/*ASNH225T38FaxAnnexbOnlyCaps Constructor*/
HS_RESULT new_ASNH225T38FaxAnnexbOnlyCaps(void *pObject)
{
	ASNH225T38FaxAnnexbOnlyCaps *pObj = (ASNH225T38FaxAnnexbOnlyCaps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225T38FaxAnnexbOnlyCaps(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_dataRatesSupported), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_supportedPrefixes), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225DataProtocolCapability( &(pObj->m_t38FaxProtocol) );
	new_ASNH225T38FaxProfile( &(pObj->m_t38FaxProfile) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225T38FaxAnnexbOnlyCaps Destructor */
HS_RESULT delete_ASNH225T38FaxAnnexbOnlyCaps(void *pObject)
{
	ASNH225T38FaxAnnexbOnlyCaps *pObj = (ASNH225T38FaxAnnexbOnlyCaps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225T38FaxAnnexbOnlyCaps(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_dataRatesSupported) );
	delete_AsnSequenceOf( &(pObj->m_supportedPrefixes) );
	delete_ASNH225DataProtocolCapability( &(pObj->m_t38FaxProtocol) );
	delete_ASNH225T38FaxProfile( &(pObj->m_t38FaxProfile) );
	return HS_OK;
}

/* ASNH225T38FaxAnnexbOnlyCaps MakeMold */
HS_RESULT ASNH225T38FaxAnnexbOnlyCaps_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225T38FaxAnnexbOnlyCaps *pObj = (ASNH225T38FaxAnnexbOnlyCaps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225T38FaxAnnexbOnlyCaps_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225DataRate *tmold_dataRatesSupported = (ASNH225DataRate *)HSMalloc( sizeof(ASNH225DataRate) );
	new_ASNH225DataRate(tmold_dataRatesSupported);
	ASNH225DataRate_MakeMold(tmold_dataRatesSupported);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_dataRatesSupported,sizeof(ASNH225DataRate),ASNH225DataRate_MakeMold,ASNH225DataRate_Encode,ASNH225DataRate_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225DataRate_Print,
#endif
		delete_ASNH225DataRate);
	AsnSequenceOf_SetMold( &(pObj->m_dataRatesSupported), moldObject );
	}
	{
	ASNH225SupportedPrefix *tmold_supportedPrefixes = (ASNH225SupportedPrefix *)HSMalloc( sizeof(ASNH225SupportedPrefix) );
	new_ASNH225SupportedPrefix(tmold_supportedPrefixes);
	ASNH225SupportedPrefix_MakeMold(tmold_supportedPrefixes);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_supportedPrefixes,sizeof(ASNH225SupportedPrefix),ASNH225SupportedPrefix_MakeMold,ASNH225SupportedPrefix_Encode,ASNH225SupportedPrefix_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225SupportedPrefix_Print,
#endif
		delete_ASNH225SupportedPrefix);
	AsnSequenceOf_SetMold( &(pObj->m_supportedPrefixes), moldObject );
	}
	ASNH225DataProtocolCapability_MakeMold(&(pObj->m_t38FaxProtocol));
	ASNH225T38FaxProfile_MakeMold(&(pObj->m_t38FaxProfile));
	return HS_OK;
}

/* ASNH225T38FaxAnnexbOnlyCaps IncludeOptionalField */
HS_RESULT ASNH225T38FaxAnnexbOnlyCaps_IncludeOptionField( void *pObject, ASNH225T38FaxAnnexbOnlyCapsOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225T38FaxAnnexbOnlyCaps *pObj = (ASNH225T38FaxAnnexbOnlyCaps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225T38FaxAnnexbOnlyCaps_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225T38FaxAnnexbOnlyCapsOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225T38FaxAnnexbOnlyCaps IsIncludeOptionalField */
BOOL ASNH225T38FaxAnnexbOnlyCaps_IsIncludeOptionField( void *pObject, ASNH225T38FaxAnnexbOnlyCapsOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225T38FaxAnnexbOnlyCaps *pObj = (ASNH225T38FaxAnnexbOnlyCaps *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225T38FaxAnnexbOnlyCaps_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225T38FaxAnnexbOnlyCapsOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225T38FaxAnnexbOnlyCaps Encode */
HS_RESULT ASNH225T38FaxAnnexbOnlyCaps_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225T38FaxAnnexbOnlyCaps *pObj = (ASNH225T38FaxAnnexbOnlyCaps *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225T38FaxAnnexbOnlyCaps_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225T38FaxAnnexbOnlyCapsOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225T38FaxAnnexbOnlyCapsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225T38FaxAnnexbOnlyCaps_IsIncludeOptionField( pObj, e_ASNH225T38FaxAnnexbOnlyCapsOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225T38FaxAnnexbOnlyCaps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225T38FaxAnnexbOnlyCaps_IsIncludeOptionField( pObj, e_ASNH225T38FaxAnnexbOnlyCapsOptionMap_dataRatesSupported ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_dataRatesSupported),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225T38FaxAnnexbOnlyCaps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_supportedPrefixes),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225T38FaxAnnexbOnlyCaps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225DataProtocolCapability_Encode( &(pObj->m_t38FaxProtocol),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225T38FaxAnnexbOnlyCaps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225T38FaxProfile_Encode( &(pObj->m_t38FaxProfile),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225T38FaxAnnexbOnlyCaps_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225T38FaxAnnexbOnlyCaps Decode */
HS_RESULT ASNH225T38FaxAnnexbOnlyCaps_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225T38FaxAnnexbOnlyCaps *pObj = (ASNH225T38FaxAnnexbOnlyCaps *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225T38FaxAnnexbOnlyCaps_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225T38FaxAnnexbOnlyCapsOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225T38FaxAnnexbOnlyCapsOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225T38FaxAnnexbOnlyCaps_IsIncludeOptionField( pObj, e_ASNH225T38FaxAnnexbOnlyCapsOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225T38FaxAnnexbOnlyCaps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225T38FaxAnnexbOnlyCaps_IsIncludeOptionField( pObj, e_ASNH225T38FaxAnnexbOnlyCapsOptionMap_dataRatesSupported ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_dataRatesSupported),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225T38FaxAnnexbOnlyCaps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_supportedPrefixes),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225T38FaxAnnexbOnlyCaps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225DataProtocolCapability_Decode(&(pObj->m_t38FaxProtocol),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225T38FaxAnnexbOnlyCaps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225T38FaxProfile_Decode(&(pObj->m_t38FaxProfile),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225T38FaxAnnexbOnlyCaps_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225T38FaxAnnexbOnlyCaps Print */
HS_RESULT ASNH225T38FaxAnnexbOnlyCaps_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225T38FaxAnnexbOnlyCaps *pObj = (ASNH225T38FaxAnnexbOnlyCaps *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225T38FaxAnnexbOnlyCaps_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225T38FaxAnnexbOnlyCaps_IsIncludeOptionField( pObj, e_ASNH225T38FaxAnnexbOnlyCapsOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	if( ASNH225T38FaxAnnexbOnlyCaps_IsIncludeOptionField( pObj, e_ASNH225T38FaxAnnexbOnlyCapsOptionMap_dataRatesSupported ) )
		AsnSequenceOf_Print( &(pObj->m_dataRatesSupported), pDepth+1, "dataRatesSupported" );
	AsnSequenceOf_Print( &(pObj->m_supportedPrefixes), pDepth+1, "supportedPrefixes" );
	ASNH225DataProtocolCapability_Print( &(pObj->m_t38FaxProtocol), pDepth+1, "t38FaxProtocol" );
	ASNH225T38FaxProfile_Print( &(pObj->m_t38FaxProfile), pDepth+1, "t38FaxProfile" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225SupportedProtocols Struct
*/
/* ASNH225SupportedProtocols Constructor */
HS_RESULT new_ASNH225SupportedProtocols( void *pObject )
{
	ASNH225SupportedProtocols *pObj = (ASNH225SupportedProtocols *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225SupportedProtocols(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225SupportedProtocolsChoice_nonStandardData;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225SupportedProtocolsChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225SupportedProtocols Destructor */
HS_RESULT delete_ASNH225SupportedProtocols( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225SupportedProtocols *pObj = (ASNH225SupportedProtocols *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225SupportedProtocols(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225SupportedProtocols_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225SupportedProtocols(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225SupportedProtocols SetChoice */
void* ASNH225SupportedProtocols_SetChoice( void *pObject, ASNH225SupportedProtocolsChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225SupportedProtocols *pObj = (ASNH225SupportedProtocols *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SupportedProtocols_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225SupportedProtocolsChoiceSizeExt ){
		if( pChoice > (ASNH225SupportedProtocolsChoice)(e_ASNH225SupportedProtocolsChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225SupportedProtocols_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225SupportedProtocolsChoice_nonStandardData ){
		ASNH225NonStandardParameter *tAlter = (ASNH225NonStandardParameter *)HSMalloc( sizeof(ASNH225NonStandardParameter) );
		new_ASNH225NonStandardParameter(tAlter);
		ASNH225NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225SupportedProtocolsChoice_h310 ){
		ASNH225H310Caps *tAlter = (ASNH225H310Caps *)HSMalloc( sizeof(ASNH225H310Caps) );
		new_ASNH225H310Caps(tAlter);
		ASNH225H310Caps_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225SupportedProtocolsChoice_h320 ){
		ASNH225H320Caps *tAlter = (ASNH225H320Caps *)HSMalloc( sizeof(ASNH225H320Caps) );
		new_ASNH225H320Caps(tAlter);
		ASNH225H320Caps_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225SupportedProtocolsChoice_h321 ){
		ASNH225H321Caps *tAlter = (ASNH225H321Caps *)HSMalloc( sizeof(ASNH225H321Caps) );
		new_ASNH225H321Caps(tAlter);
		ASNH225H321Caps_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225SupportedProtocolsChoice_h322 ){
		ASNH225H322Caps *tAlter = (ASNH225H322Caps *)HSMalloc( sizeof(ASNH225H322Caps) );
		new_ASNH225H322Caps(tAlter);
		ASNH225H322Caps_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225SupportedProtocolsChoice_h323 ){
		ASNH225H323Caps *tAlter = (ASNH225H323Caps *)HSMalloc( sizeof(ASNH225H323Caps) );
		new_ASNH225H323Caps(tAlter);
		ASNH225H323Caps_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225SupportedProtocolsChoice_h324 ){
		ASNH225H324Caps *tAlter = (ASNH225H324Caps *)HSMalloc( sizeof(ASNH225H324Caps) );
		new_ASNH225H324Caps(tAlter);
		ASNH225H324Caps_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225SupportedProtocolsChoice_voice ){
		ASNH225VoiceCaps *tAlter = (ASNH225VoiceCaps *)HSMalloc( sizeof(ASNH225VoiceCaps) );
		new_ASNH225VoiceCaps(tAlter);
		ASNH225VoiceCaps_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225SupportedProtocolsChoice_t120_only ){
		ASNH225T120OnlyCaps *tAlter = (ASNH225T120OnlyCaps *)HSMalloc( sizeof(ASNH225T120OnlyCaps) );
		new_ASNH225T120OnlyCaps(tAlter);
		ASNH225T120OnlyCaps_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH225SupportedProtocolsChoice_nonStandardProtocol ){
		ASNH225NonStandardProtocol *tAlter = (ASNH225NonStandardProtocol *)HSMalloc( sizeof(ASNH225NonStandardProtocol) );
		new_ASNH225NonStandardProtocol(tAlter);
		ASNH225NonStandardProtocol_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225SupportedProtocolsChoice_t38FaxAnnexbOnly ){
		ASNH225T38FaxAnnexbOnlyCaps *tAlter = (ASNH225T38FaxAnnexbOnlyCaps *)HSMalloc( sizeof(ASNH225T38FaxAnnexbOnlyCaps) );
		new_ASNH225T38FaxAnnexbOnlyCaps(tAlter);
		ASNH225T38FaxAnnexbOnlyCaps_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SupportedProtocols_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225SupportedProtocols DeleteAlternation */
HS_RESULT ASNH225SupportedProtocols_DeleteAlternation(void *pObject)
{
	ASNH225SupportedProtocols *pObj = (ASNH225SupportedProtocols *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SupportedProtocols_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225SupportedProtocolsChoice_nonStandardData ){
			delete_ASNH225NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h310 ){
			delete_ASNH225H310Caps(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h320 ){
			delete_ASNH225H320Caps(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h321 ){
			delete_ASNH225H321Caps(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h322 ){
			delete_ASNH225H322Caps(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h323 ){
			delete_ASNH225H323Caps(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h324 ){
			delete_ASNH225H324Caps(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_voice ){
			delete_ASNH225VoiceCaps(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_t120_only ){
			delete_ASNH225T120OnlyCaps(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_nonStandardProtocol ){
			delete_ASNH225NonStandardProtocol(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_t38FaxAnnexbOnly ){
			delete_ASNH225T38FaxAnnexbOnlyCaps(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225SupportedProtocols_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225SupportedProtocols Encode */
HS_RESULT ASNH225SupportedProtocols_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225SupportedProtocols *pObj = (ASNH225SupportedProtocols *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SupportedProtocols_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SupportedProtocols_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225SupportedProtocolsChoiceSize )
		{
			if( pObj->choice > ((ASNH225SupportedProtocolsChoice)(e_ASNH225SupportedProtocolsChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225SupportedProtocolsChoiceSize)) )
	}
	else
	{
		if( e_ASNH225SupportedProtocolsChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225SupportedProtocolsChoice_nonStandardData ){
		if( (tRet=ASNH225NonStandardParameter_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h310 ){
		if( (tRet=ASNH225H310Caps_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h320 ){
		if( (tRet=ASNH225H320Caps_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h321 ){
		if( (tRet=ASNH225H321Caps_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h322 ){
		if( (tRet=ASNH225H322Caps_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h323 ){
		if( (tRet=ASNH225H323Caps_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h324 ){
		if( (tRet=ASNH225H324Caps_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_voice ){
		if( (tRet=ASNH225VoiceCaps_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_t120_only ){
		if( (tRet=ASNH225T120OnlyCaps_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_nonStandardProtocol ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH225NonStandardProtocol_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_t38FaxAnnexbOnly ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH225T38FaxAnnexbOnlyCaps_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SupportedProtocols_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225SupportedProtocols Decode */
HS_RESULT ASNH225SupportedProtocols_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225SupportedProtocols *pObj = (ASNH225SupportedProtocols *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SupportedProtocols_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225SupportedProtocolsChoiceSize;
	}
	else
	{
		if( e_ASNH225SupportedProtocolsChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225SupportedProtocolsChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225SupportedProtocolsChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225SupportedProtocols_SetChoice( pObj, (ASNH225SupportedProtocolsChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SupportedProtocols_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225SupportedProtocolsChoice_nonStandardData ){
		if( (tRet=ASNH225NonStandardParameter_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h310 ){
		if( (tRet=ASNH225H310Caps_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h320 ){
		if( (tRet=ASNH225H320Caps_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h321 ){
		if( (tRet=ASNH225H321Caps_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h322 ){
		if( (tRet=ASNH225H322Caps_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h323 ){
		if( (tRet=ASNH225H323Caps_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h324 ){
		if( (tRet=ASNH225H324Caps_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_voice ){
		if( (tRet=ASNH225VoiceCaps_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_t120_only ){
		if( (tRet=ASNH225T120OnlyCaps_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_nonStandardProtocol ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH225NonStandardProtocol_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_t38FaxAnnexbOnly ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH225T38FaxAnnexbOnlyCaps_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SupportedProtocols_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SupportedProtocols_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225SupportedProtocols Print */
HS_RESULT ASNH225SupportedProtocols_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225SupportedProtocols *pObj = (ASNH225SupportedProtocols *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225SupportedProtocols_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225SupportedProtocolsChoice_nonStandardData ){
		ASNH225NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandardData" );
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h310 ){
		ASNH225H310Caps_Print( pObj->alter, pDepth+1, "h310" );
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h320 ){
		ASNH225H320Caps_Print( pObj->alter, pDepth+1, "h320" );
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h321 ){
		ASNH225H321Caps_Print( pObj->alter, pDepth+1, "h321" );
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h322 ){
		ASNH225H322Caps_Print( pObj->alter, pDepth+1, "h322" );
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h323 ){
		ASNH225H323Caps_Print( pObj->alter, pDepth+1, "h323" );
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_h324 ){
		ASNH225H324Caps_Print( pObj->alter, pDepth+1, "h324" );
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_voice ){
		ASNH225VoiceCaps_Print( pObj->alter, pDepth+1, "voice" );
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_t120_only ){
		ASNH225T120OnlyCaps_Print( pObj->alter, pDepth+1, "t120_only" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_nonStandardProtocol ){
		ASNH225NonStandardProtocol_Print( pObj->alter, pDepth+1, "nonStandardProtocol" );
	}
	else if ( pObj->choice == e_ASNH225SupportedProtocolsChoice_t38FaxAnnexbOnly ){
		ASNH225T38FaxAnnexbOnlyCaps_Print( pObj->alter, pDepth+1, "t38FaxAnnexbOnly" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225GatewayInfo Class
*/
/*ASNH225GatewayInfo Constructor*/
HS_RESULT new_ASNH225GatewayInfo(void *pObject)
{
	ASNH225GatewayInfo *pObj = (ASNH225GatewayInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225GatewayInfo(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnSequenceOf( &(pObj->m_protocol), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225GatewayInfo Destructor */
HS_RESULT delete_ASNH225GatewayInfo(void *pObject)
{
	ASNH225GatewayInfo *pObj = (ASNH225GatewayInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225GatewayInfo(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnSequenceOf( &(pObj->m_protocol) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	return HS_OK;
}

/* ASNH225GatewayInfo MakeMold */
HS_RESULT ASNH225GatewayInfo_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225GatewayInfo *pObj = (ASNH225GatewayInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GatewayInfo_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	ASNH225SupportedProtocols *tmold_protocol = (ASNH225SupportedProtocols *)HSMalloc( sizeof(ASNH225SupportedProtocols) );
	new_ASNH225SupportedProtocols(tmold_protocol);
	ASNH225SupportedProtocols_MakeMold(tmold_protocol);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_protocol,sizeof(ASNH225SupportedProtocols),ASNH225SupportedProtocols_MakeMold,ASNH225SupportedProtocols_Encode,ASNH225SupportedProtocols_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225SupportedProtocols_Print,
#endif
		delete_ASNH225SupportedProtocols);
	AsnSequenceOf_SetMold( &(pObj->m_protocol), moldObject );
	}
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	return HS_OK;
}

/* ASNH225GatewayInfo IncludeOptionalField */
HS_RESULT ASNH225GatewayInfo_IncludeOptionField( void *pObject, ASNH225GatewayInfoOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225GatewayInfo *pObj = (ASNH225GatewayInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GatewayInfo_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225GatewayInfoOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225GatewayInfo IsIncludeOptionalField */
BOOL ASNH225GatewayInfo_IsIncludeOptionField( void *pObject, ASNH225GatewayInfoOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225GatewayInfo *pObj = (ASNH225GatewayInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GatewayInfo_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225GatewayInfoOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225GatewayInfo Encode */
HS_RESULT ASNH225GatewayInfo_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225GatewayInfo *pObj = (ASNH225GatewayInfo *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GatewayInfo_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225GatewayInfoOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225GatewayInfoOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225GatewayInfo_IsIncludeOptionField( pObj, e_ASNH225GatewayInfoOptionMap_protocol ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_protocol),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GatewayInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225GatewayInfo_IsIncludeOptionField( pObj, e_ASNH225GatewayInfoOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GatewayInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225GatewayInfo Decode */
HS_RESULT ASNH225GatewayInfo_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225GatewayInfo *pObj = (ASNH225GatewayInfo *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GatewayInfo_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225GatewayInfoOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225GatewayInfoOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225GatewayInfo_IsIncludeOptionField( pObj, e_ASNH225GatewayInfoOptionMap_protocol ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_protocol),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GatewayInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225GatewayInfo_IsIncludeOptionField( pObj, e_ASNH225GatewayInfoOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GatewayInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225GatewayInfo Print */
HS_RESULT ASNH225GatewayInfo_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225GatewayInfo *pObj = (ASNH225GatewayInfo *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225GatewayInfo_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225GatewayInfo_IsIncludeOptionField( pObj, e_ASNH225GatewayInfoOptionMap_protocol ) )
		AsnSequenceOf_Print( &(pObj->m_protocol), pDepth+1, "protocol" );
	if( ASNH225GatewayInfo_IsIncludeOptionField( pObj, e_ASNH225GatewayInfoOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225McuInfo Class
*/
/*ASNH225McuInfo Constructor*/
HS_RESULT new_ASNH225McuInfo(void *pObject)
{
	ASNH225McuInfo *pObj = (ASNH225McuInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225McuInfo(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_AsnSequenceOf( &(pObj->m_protocol), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225McuInfo Destructor */
HS_RESULT delete_ASNH225McuInfo(void *pObject)
{
	ASNH225McuInfo *pObj = (ASNH225McuInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225McuInfo(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_AsnSequenceOf( &(pObj->m_protocol) );
	return HS_OK;
}

/* ASNH225McuInfo MakeMold */
HS_RESULT ASNH225McuInfo_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225McuInfo *pObj = (ASNH225McuInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225McuInfo_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	{
	ASNH225SupportedProtocols *tmold_protocol = (ASNH225SupportedProtocols *)HSMalloc( sizeof(ASNH225SupportedProtocols) );
	new_ASNH225SupportedProtocols(tmold_protocol);
	ASNH225SupportedProtocols_MakeMold(tmold_protocol);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_protocol,sizeof(ASNH225SupportedProtocols),ASNH225SupportedProtocols_MakeMold,ASNH225SupportedProtocols_Encode,ASNH225SupportedProtocols_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225SupportedProtocols_Print,
#endif
		delete_ASNH225SupportedProtocols);
	AsnSequenceOf_SetMold( &(pObj->m_protocol), moldObject );
	}
	return HS_OK;
}

/* ASNH225McuInfo IncludeOptionalField */
HS_RESULT ASNH225McuInfo_IncludeOptionField( void *pObject, ASNH225McuInfoOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225McuInfo *pObj = (ASNH225McuInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225McuInfo_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225McuInfoOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225McuInfoOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225McuInfoOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225McuInfo IsIncludeOptionalField */
BOOL ASNH225McuInfo_IsIncludeOptionField( void *pObject, ASNH225McuInfoOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225McuInfo *pObj = (ASNH225McuInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225McuInfo_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225McuInfoOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225McuInfoOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225McuInfoOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225McuInfo Encode */
HS_RESULT ASNH225McuInfo_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225McuInfo *pObj = (ASNH225McuInfo *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225McuInfo_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225McuInfoOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225McuInfoOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225McuInfo_IsIncludeOptionField( pObj, e_ASNH225McuInfoOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225McuInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225McuInfo_IsIncludeOptionField( pObj, e_ASNH225McuInfoOptionMap_protocol ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_protocol), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225McuInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225McuInfo Decode */
HS_RESULT ASNH225McuInfo_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225McuInfo *pObj = (ASNH225McuInfo *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225McuInfo_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225McuInfoOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225McuInfoOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225McuInfo_IsIncludeOptionField( pObj, e_ASNH225McuInfoOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225McuInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225McuInfo_IsIncludeOptionField( pObj, e_ASNH225McuInfoOptionMap_protocol ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_protocol), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225McuInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225McuInfo Print */
HS_RESULT ASNH225McuInfo_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225McuInfo *pObj = (ASNH225McuInfo *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225McuInfo_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225McuInfo_IsIncludeOptionField( pObj, e_ASNH225McuInfoOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225McuInfo_IsIncludeOptionField( pObj, e_ASNH225McuInfoOptionMap_protocol ) )
		AsnSequenceOf_Print( &(pObj->m_protocol), pDepth+1, "protocol" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225TerminalInfo Class
*/
/*ASNH225TerminalInfo Constructor*/
HS_RESULT new_ASNH225TerminalInfo(void *pObject)
{
	ASNH225TerminalInfo *pObj = (ASNH225TerminalInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225TerminalInfo(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225TerminalInfo Destructor */
HS_RESULT delete_ASNH225TerminalInfo(void *pObject)
{
	ASNH225TerminalInfo *pObj = (ASNH225TerminalInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225TerminalInfo(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	return HS_OK;
}

/* ASNH225TerminalInfo MakeMold */
HS_RESULT ASNH225TerminalInfo_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225TerminalInfo *pObj = (ASNH225TerminalInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TerminalInfo_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	return HS_OK;
}

/* ASNH225TerminalInfo IncludeOptionalField */
HS_RESULT ASNH225TerminalInfo_IncludeOptionField( void *pObject, ASNH225TerminalInfoOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225TerminalInfo *pObj = (ASNH225TerminalInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TerminalInfo_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225TerminalInfoOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225TerminalInfo IsIncludeOptionalField */
BOOL ASNH225TerminalInfo_IsIncludeOptionField( void *pObject, ASNH225TerminalInfoOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225TerminalInfo *pObj = (ASNH225TerminalInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TerminalInfo_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225TerminalInfoOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225TerminalInfo Encode */
HS_RESULT ASNH225TerminalInfo_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225TerminalInfo *pObj = (ASNH225TerminalInfo *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TerminalInfo_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225TerminalInfoOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225TerminalInfoOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225TerminalInfo_IsIncludeOptionField( pObj, e_ASNH225TerminalInfoOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TerminalInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225TerminalInfo Decode */
HS_RESULT ASNH225TerminalInfo_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225TerminalInfo *pObj = (ASNH225TerminalInfo *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TerminalInfo_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225TerminalInfoOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225TerminalInfoOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225TerminalInfo_IsIncludeOptionField( pObj, e_ASNH225TerminalInfoOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TerminalInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225TerminalInfo Print */
HS_RESULT ASNH225TerminalInfo_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225TerminalInfo *pObj = (ASNH225TerminalInfo *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225TerminalInfo_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225TerminalInfo_IsIncludeOptionField( pObj, e_ASNH225TerminalInfoOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225TunnelledProtocolAlternateIdentifier Class
*/
/*ASNH225TunnelledProtocolAlternateIdentifier Constructor*/
HS_RESULT new_ASNH225TunnelledProtocolAlternateIdentifier(void *pObject)
{
	ASNH225TunnelledProtocolAlternateIdentifier *pObj = (ASNH225TunnelledProtocolAlternateIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225TunnelledProtocolAlternateIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnSingleString( &(pObj->m_protocolType), e_asnTagIA5String, e_constrained, 1, 64, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnSingleString( &(pObj->m_protocolVariant), e_asnTagIA5String, e_constrained, 1, 64, 0, HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225TunnelledProtocolAlternateIdentifier Destructor */
HS_RESULT delete_ASNH225TunnelledProtocolAlternateIdentifier(void *pObject)
{
	ASNH225TunnelledProtocolAlternateIdentifier *pObj = (ASNH225TunnelledProtocolAlternateIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225TunnelledProtocolAlternateIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnSingleString( &(pObj->m_protocolType) );
	delete_AsnSingleString( &(pObj->m_protocolVariant) );
	return HS_OK;
}

/* ASNH225TunnelledProtocolAlternateIdentifier MakeMold */
HS_RESULT ASNH225TunnelledProtocolAlternateIdentifier_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225TunnelledProtocolAlternateIdentifier *pObj = (ASNH225TunnelledProtocolAlternateIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocolAlternateIdentifier_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH225TunnelledProtocolAlternateIdentifier IncludeOptionalField */
HS_RESULT ASNH225TunnelledProtocolAlternateIdentifier_IncludeOptionField( void *pObject, ASNH225TunnelledProtocolAlternateIdentifierOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225TunnelledProtocolAlternateIdentifier *pObj = (ASNH225TunnelledProtocolAlternateIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocolAlternateIdentifier_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225TunnelledProtocolAlternateIdentifierOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225TunnelledProtocolAlternateIdentifier IsIncludeOptionalField */
BOOL ASNH225TunnelledProtocolAlternateIdentifier_IsIncludeOptionField( void *pObject, ASNH225TunnelledProtocolAlternateIdentifierOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225TunnelledProtocolAlternateIdentifier *pObj = (ASNH225TunnelledProtocolAlternateIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocolAlternateIdentifier_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225TunnelledProtocolAlternateIdentifierOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225TunnelledProtocolAlternateIdentifier Encode */
HS_RESULT ASNH225TunnelledProtocolAlternateIdentifier_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225TunnelledProtocolAlternateIdentifier *pObj = (ASNH225TunnelledProtocolAlternateIdentifier *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocolAlternateIdentifier_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225TunnelledProtocolAlternateIdentifierOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225TunnelledProtocolAlternateIdentifierOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnSingleString_Encode( &(pObj->m_protocolType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocolAlternateIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225TunnelledProtocolAlternateIdentifier_IsIncludeOptionField( pObj, e_ASNH225TunnelledProtocolAlternateIdentifierOptionMap_protocolVariant ) ){
		if( (tRet=AsnSingleString_Encode( &(pObj->m_protocolVariant),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TunnelledProtocolAlternateIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225TunnelledProtocolAlternateIdentifier Decode */
HS_RESULT ASNH225TunnelledProtocolAlternateIdentifier_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225TunnelledProtocolAlternateIdentifier *pObj = (ASNH225TunnelledProtocolAlternateIdentifier *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocolAlternateIdentifier_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225TunnelledProtocolAlternateIdentifierOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225TunnelledProtocolAlternateIdentifierOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnSingleString_Decode(&(pObj->m_protocolType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocolAlternateIdentifier_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225TunnelledProtocolAlternateIdentifier_IsIncludeOptionField( pObj, e_ASNH225TunnelledProtocolAlternateIdentifierOptionMap_protocolVariant ) ){
		if( (tRet=AsnSingleString_Decode(&(pObj->m_protocolVariant),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TunnelledProtocolAlternateIdentifier_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225TunnelledProtocolAlternateIdentifier Print */
HS_RESULT ASNH225TunnelledProtocolAlternateIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225TunnelledProtocolAlternateIdentifier *pObj = (ASNH225TunnelledProtocolAlternateIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225TunnelledProtocolAlternateIdentifier_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnSingleString_Print( &(pObj->m_protocolType), pDepth+1, "protocolType" );
	if( ASNH225TunnelledProtocolAlternateIdentifier_IsIncludeOptionField( pObj, e_ASNH225TunnelledProtocolAlternateIdentifierOptionMap_protocolVariant ) )
		AsnSingleString_Print( &(pObj->m_protocolVariant), pDepth+1, "protocolVariant" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225TunnelledProtocol_id Struct
*/
/* ASNH225TunnelledProtocol_id Constructor */
HS_RESULT new_ASNH225TunnelledProtocol_id( void *pObject )
{
	ASNH225TunnelledProtocol_id *pObj = (ASNH225TunnelledProtocol_id *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225TunnelledProtocol_id(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225TunnelledProtocol_idChoice_tunnelledProtocolObjectID;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225TunnelledProtocol_idChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225TunnelledProtocol_id Destructor */
HS_RESULT delete_ASNH225TunnelledProtocol_id( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225TunnelledProtocol_id *pObj = (ASNH225TunnelledProtocol_id *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225TunnelledProtocol_id(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225TunnelledProtocol_id_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225TunnelledProtocol_id(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225TunnelledProtocol_id SetChoice */
void* ASNH225TunnelledProtocol_id_SetChoice( void *pObject, ASNH225TunnelledProtocol_idChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225TunnelledProtocol_id *pObj = (ASNH225TunnelledProtocol_id *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocol_id_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225TunnelledProtocol_idChoiceSizeExt ){
		if( pChoice > (ASNH225TunnelledProtocol_idChoice)(e_ASNH225TunnelledProtocol_idChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TunnelledProtocol_id_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225TunnelledProtocol_id_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TunnelledProtocol_id_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225TunnelledProtocol_idChoice_tunnelledProtocolObjectID ){
		AsnObjectIdentifier *tAlter = (AsnObjectIdentifier *)HSMalloc( sizeof(AsnObjectIdentifier) );
		new_AsnObjectIdentifier(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225TunnelledProtocol_idChoice_tunnelledProtocolAlternateID ){
		ASNH225TunnelledProtocolAlternateIdentifier *tAlter = (ASNH225TunnelledProtocolAlternateIdentifier *)HSMalloc( sizeof(ASNH225TunnelledProtocolAlternateIdentifier) );
		new_ASNH225TunnelledProtocolAlternateIdentifier(tAlter);
		ASNH225TunnelledProtocolAlternateIdentifier_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocol_id_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225TunnelledProtocol_id DeleteAlternation */
HS_RESULT ASNH225TunnelledProtocol_id_DeleteAlternation(void *pObject)
{
	ASNH225TunnelledProtocol_id *pObj = (ASNH225TunnelledProtocol_id *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocol_id_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225TunnelledProtocol_idChoice_tunnelledProtocolObjectID ){
			delete_AsnObjectIdentifier(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225TunnelledProtocol_idChoice_tunnelledProtocolAlternateID ){
			delete_ASNH225TunnelledProtocolAlternateIdentifier(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TunnelledProtocol_id_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225TunnelledProtocol_id_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225TunnelledProtocol_id Encode */
HS_RESULT ASNH225TunnelledProtocol_id_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225TunnelledProtocol_id *pObj = (ASNH225TunnelledProtocol_id *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocol_id_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocol_id_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225TunnelledProtocol_idChoiceSize )
		{
			if( pObj->choice > ((ASNH225TunnelledProtocol_idChoice)(e_ASNH225TunnelledProtocol_idChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225TunnelledProtocol_idChoiceSize)) )
	}
	else
	{
		if( e_ASNH225TunnelledProtocol_idChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225TunnelledProtocol_idChoice_tunnelledProtocolObjectID ){
		if( (tRet=AsnObjectIdentifier_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TunnelledProtocol_id_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225TunnelledProtocol_idChoice_tunnelledProtocolAlternateID ){
		if( (tRet=ASNH225TunnelledProtocolAlternateIdentifier_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TunnelledProtocol_id_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocol_id_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225TunnelledProtocol_id Decode */
HS_RESULT ASNH225TunnelledProtocol_id_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225TunnelledProtocol_id *pObj = (ASNH225TunnelledProtocol_id *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocol_id_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225TunnelledProtocol_idChoiceSize;
	}
	else
	{
		if( e_ASNH225TunnelledProtocol_idChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225TunnelledProtocol_idChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225TunnelledProtocol_idChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TunnelledProtocol_id_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225TunnelledProtocol_id_SetChoice( pObj, (ASNH225TunnelledProtocol_idChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocol_id_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225TunnelledProtocol_idChoice_tunnelledProtocolObjectID ){
		if( (tRet=AsnObjectIdentifier_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TunnelledProtocol_id_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225TunnelledProtocol_idChoice_tunnelledProtocolAlternateID ){
		if( (tRet=ASNH225TunnelledProtocolAlternateIdentifier_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TunnelledProtocol_id_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocol_id_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225TunnelledProtocol_id Print */
HS_RESULT ASNH225TunnelledProtocol_id_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225TunnelledProtocol_id *pObj = (ASNH225TunnelledProtocol_id *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225TunnelledProtocol_id_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225TunnelledProtocol_idChoice_tunnelledProtocolObjectID ){
		AsnObjectIdentifier_Print( pObj->alter, pDepth+1, "tunnelledProtocolObjectID" );
	}
	else if ( pObj->choice == e_ASNH225TunnelledProtocol_idChoice_tunnelledProtocolAlternateID ){
		ASNH225TunnelledProtocolAlternateIdentifier_Print( pObj->alter, pDepth+1, "tunnelledProtocolAlternateID" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225TunnelledProtocol Class
*/
/*ASNH225TunnelledProtocol Constructor*/
HS_RESULT new_ASNH225TunnelledProtocol(void *pObject)
{
	ASNH225TunnelledProtocol *pObj = (ASNH225TunnelledProtocol *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225TunnelledProtocol(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225TunnelledProtocol_id( &(pObj->m_id) );
	new_AsnSingleString( &(pObj->m_subIdentifier), e_asnTagIA5String, e_constrained, 1, 64, 0, HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225TunnelledProtocol Destructor */
HS_RESULT delete_ASNH225TunnelledProtocol(void *pObject)
{
	ASNH225TunnelledProtocol *pObj = (ASNH225TunnelledProtocol *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225TunnelledProtocol(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225TunnelledProtocol_id( &(pObj->m_id) );
	delete_AsnSingleString( &(pObj->m_subIdentifier) );
	return HS_OK;
}

/* ASNH225TunnelledProtocol MakeMold */
HS_RESULT ASNH225TunnelledProtocol_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225TunnelledProtocol *pObj = (ASNH225TunnelledProtocol *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocol_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH225TunnelledProtocol IncludeOptionalField */
HS_RESULT ASNH225TunnelledProtocol_IncludeOptionField( void *pObject, ASNH225TunnelledProtocolOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225TunnelledProtocol *pObj = (ASNH225TunnelledProtocol *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocol_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225TunnelledProtocolOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225TunnelledProtocol IsIncludeOptionalField */
BOOL ASNH225TunnelledProtocol_IsIncludeOptionField( void *pObject, ASNH225TunnelledProtocolOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225TunnelledProtocol *pObj = (ASNH225TunnelledProtocol *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocol_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225TunnelledProtocolOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225TunnelledProtocol Encode */
HS_RESULT ASNH225TunnelledProtocol_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225TunnelledProtocol *pObj = (ASNH225TunnelledProtocol *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocol_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225TunnelledProtocolOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225TunnelledProtocolOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225TunnelledProtocol_id_Encode( &(pObj->m_id),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocol_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225TunnelledProtocol_IsIncludeOptionField( pObj, e_ASNH225TunnelledProtocolOptionMap_subIdentifier ) ){
		if( (tRet=AsnSingleString_Encode( &(pObj->m_subIdentifier),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TunnelledProtocol_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225TunnelledProtocol Decode */
HS_RESULT ASNH225TunnelledProtocol_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225TunnelledProtocol *pObj = (ASNH225TunnelledProtocol *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocol_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225TunnelledProtocolOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225TunnelledProtocolOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225TunnelledProtocol_id_Decode(&(pObj->m_id),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225TunnelledProtocol_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225TunnelledProtocol_IsIncludeOptionField( pObj, e_ASNH225TunnelledProtocolOptionMap_subIdentifier ) ){
		if( (tRet=AsnSingleString_Decode(&(pObj->m_subIdentifier),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225TunnelledProtocol_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225TunnelledProtocol Print */
HS_RESULT ASNH225TunnelledProtocol_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225TunnelledProtocol *pObj = (ASNH225TunnelledProtocol *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225TunnelledProtocol_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225TunnelledProtocol_id_Print( &(pObj->m_id), pDepth+1, "id" );
	if( ASNH225TunnelledProtocol_IsIncludeOptionField( pObj, e_ASNH225TunnelledProtocolOptionMap_subIdentifier ) )
		AsnSingleString_Print( &(pObj->m_subIdentifier), pDepth+1, "subIdentifier" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225EndpointType Class
*/
/*ASNH225EndpointType Constructor*/
HS_RESULT new_ASNH225EndpointType(void *pObject)
{
	ASNH225EndpointType *pObj = (ASNH225EndpointType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225EndpointType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	new_ASNH225VendorIdentifier( &(pObj->m_vendor) );
	new_ASNH225GatekeeperInfo( &(pObj->m_gatekeeper) );
	new_ASNH225GatewayInfo( &(pObj->m_gateway) );
	new_ASNH225McuInfo( &(pObj->m_mcu) );
	new_ASNH225TerminalInfo( &(pObj->m_terminal) );
	new_AsnBoolean( &(pObj->m_mc) );
	new_AsnBoolean( &(pObj->m_undefinedNode) );
	new_AsnBitString( &(pObj->m_set), e_constrained, 32, 32, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_supportedTunnelledProtocols), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225EndpointType Destructor */
HS_RESULT delete_ASNH225EndpointType(void *pObject)
{
	ASNH225EndpointType *pObj = (ASNH225EndpointType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225EndpointType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	delete_ASNH225VendorIdentifier( &(pObj->m_vendor) );
	delete_ASNH225GatekeeperInfo( &(pObj->m_gatekeeper) );
	delete_ASNH225GatewayInfo( &(pObj->m_gateway) );
	delete_ASNH225McuInfo( &(pObj->m_mcu) );
	delete_ASNH225TerminalInfo( &(pObj->m_terminal) );
	delete_AsnBoolean( &(pObj->m_mc) );
	delete_AsnBoolean( &(pObj->m_undefinedNode) );
	delete_AsnBitString( &(pObj->m_set) );
	delete_AsnSequenceOf( &(pObj->m_supportedTunnelledProtocols) );
	return HS_OK;
}

/* ASNH225EndpointType MakeMold */
HS_RESULT ASNH225EndpointType_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225EndpointType *pObj = (ASNH225EndpointType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225EndpointType_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	ASNH225VendorIdentifier_MakeMold(&(pObj->m_vendor));
	ASNH225GatekeeperInfo_MakeMold(&(pObj->m_gatekeeper));
	ASNH225GatewayInfo_MakeMold(&(pObj->m_gateway));
	ASNH225McuInfo_MakeMold(&(pObj->m_mcu));
	ASNH225TerminalInfo_MakeMold(&(pObj->m_terminal));
	{
	ASNH225TunnelledProtocol *tmold_supportedTunnelledProtocols = (ASNH225TunnelledProtocol *)HSMalloc( sizeof(ASNH225TunnelledProtocol) );
	new_ASNH225TunnelledProtocol(tmold_supportedTunnelledProtocols);
	ASNH225TunnelledProtocol_MakeMold(tmold_supportedTunnelledProtocols);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_supportedTunnelledProtocols,sizeof(ASNH225TunnelledProtocol),ASNH225TunnelledProtocol_MakeMold,ASNH225TunnelledProtocol_Encode,ASNH225TunnelledProtocol_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225TunnelledProtocol_Print,
#endif
		delete_ASNH225TunnelledProtocol);
	AsnSequenceOf_SetMold( &(pObj->m_supportedTunnelledProtocols), moldObject );
	}
	return HS_OK;
}

/* ASNH225EndpointType IncludeOptionalField */
HS_RESULT ASNH225EndpointType_IncludeOptionField( void *pObject, ASNH225EndpointTypeOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225EndpointType *pObj = (ASNH225EndpointType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225EndpointType_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225EndpointTypeOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225EndpointTypeOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225EndpointTypeOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225EndpointType IsIncludeOptionalField */
BOOL ASNH225EndpointType_IsIncludeOptionField( void *pObject, ASNH225EndpointTypeOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225EndpointType *pObj = (ASNH225EndpointType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225EndpointType_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225EndpointTypeOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225EndpointTypeOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225EndpointTypeOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225EndpointType Encode */
HS_RESULT ASNH225EndpointType_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225EndpointType *pObj = (ASNH225EndpointType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225EndpointType_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225EndpointTypeOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225EndpointTypeOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225EndpointType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_vendor ) ){
		if( (tRet=ASNH225VendorIdentifier_Encode( &(pObj->m_vendor),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225EndpointType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_gatekeeper ) ){
		if( (tRet=ASNH225GatekeeperInfo_Encode( &(pObj->m_gatekeeper),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225EndpointType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_gateway ) ){
		if( (tRet=ASNH225GatewayInfo_Encode( &(pObj->m_gateway),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225EndpointType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_mcu ) ){
		if( (tRet=ASNH225McuInfo_Encode( &(pObj->m_mcu),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225EndpointType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_terminal ) ){
		if( (tRet=ASNH225TerminalInfo_Encode( &(pObj->m_terminal),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225EndpointType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_mc),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225EndpointType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_undefinedNode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225EndpointType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_set ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_set), AsnBitString_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225EndpointType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_supportedTunnelledProtocols ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_supportedTunnelledProtocols), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225EndpointType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225EndpointType Decode */
HS_RESULT ASNH225EndpointType_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225EndpointType *pObj = (ASNH225EndpointType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225EndpointType_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225EndpointTypeOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225EndpointTypeOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225EndpointType_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_vendor ) ){
		if( (tRet=ASNH225VendorIdentifier_Decode(&(pObj->m_vendor),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225EndpointType_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_gatekeeper ) ){
		if( (tRet=ASNH225GatekeeperInfo_Decode(&(pObj->m_gatekeeper),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225EndpointType_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_gateway ) ){
		if( (tRet=ASNH225GatewayInfo_Decode(&(pObj->m_gateway),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225EndpointType_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_mcu ) ){
		if( (tRet=ASNH225McuInfo_Decode(&(pObj->m_mcu),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225EndpointType_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_terminal ) ){
		if( (tRet=ASNH225TerminalInfo_Decode(&(pObj->m_terminal),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225EndpointType_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_mc),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225EndpointType_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_undefinedNode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225EndpointType_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_set ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_set), AsnBitString_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225EndpointType_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_supportedTunnelledProtocols ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_supportedTunnelledProtocols), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225EndpointType_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225EndpointType Print */
HS_RESULT ASNH225EndpointType_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225EndpointType *pObj = (ASNH225EndpointType *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225EndpointType_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_vendor ) )
		ASNH225VendorIdentifier_Print( &(pObj->m_vendor), pDepth+1, "vendor" );
	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_gatekeeper ) )
		ASNH225GatekeeperInfo_Print( &(pObj->m_gatekeeper), pDepth+1, "gatekeeper" );
	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_gateway ) )
		ASNH225GatewayInfo_Print( &(pObj->m_gateway), pDepth+1, "gateway" );
	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_mcu ) )
		ASNH225McuInfo_Print( &(pObj->m_mcu), pDepth+1, "mcu" );
	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_terminal ) )
		ASNH225TerminalInfo_Print( &(pObj->m_terminal), pDepth+1, "terminal" );
	AsnBoolean_Print( &(pObj->m_mc), pDepth+1, "mc" );
	AsnBoolean_Print( &(pObj->m_undefinedNode), pDepth+1, "undefinedNode" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_set ) )
		AsnBitString_Print( &(pObj->m_set), pDepth+1, "set" );
	if( ASNH225EndpointType_IsIncludeOptionField( pObj, e_ASNH225EndpointTypeOptionMap_supportedTunnelledProtocols ) )
		AsnSequenceOf_Print( &(pObj->m_supportedTunnelledProtocols), pDepth+1, "supportedTunnelledProtocols" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225Setup_UUIE_conferenceGoal Struct
*/
/* ASNH225Setup_UUIE_conferenceGoal Constructor */
HS_RESULT new_ASNH225Setup_UUIE_conferenceGoal( void *pObject )
{
	ASNH225Setup_UUIE_conferenceGoal *pObj = (ASNH225Setup_UUIE_conferenceGoal *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225Setup_UUIE_conferenceGoal(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225Setup_UUIE_conferenceGoalChoice_create;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225Setup_UUIE_conferenceGoalChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225Setup_UUIE_conferenceGoal Destructor */
HS_RESULT delete_ASNH225Setup_UUIE_conferenceGoal( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225Setup_UUIE_conferenceGoal *pObj = (ASNH225Setup_UUIE_conferenceGoal *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225Setup_UUIE_conferenceGoal(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225Setup_UUIE_conferenceGoal_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225Setup_UUIE_conferenceGoal(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225Setup_UUIE_conferenceGoal SetChoice */
void* ASNH225Setup_UUIE_conferenceGoal_SetChoice( void *pObject, ASNH225Setup_UUIE_conferenceGoalChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225Setup_UUIE_conferenceGoal *pObj = (ASNH225Setup_UUIE_conferenceGoal *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225Setup_UUIE_conferenceGoalChoiceSizeExt ){
		if( pChoice > (ASNH225Setup_UUIE_conferenceGoalChoice)(e_ASNH225Setup_UUIE_conferenceGoalChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225Setup_UUIE_conferenceGoal_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225Setup_UUIE_conferenceGoalChoice_create ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225Setup_UUIE_conferenceGoalChoice_join ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225Setup_UUIE_conferenceGoalChoice_invite ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH225Setup_UUIE_conferenceGoalChoice_capability_negotiation ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225Setup_UUIE_conferenceGoalChoice_callIndependentSupplementaryService ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225Setup_UUIE_conferenceGoal DeleteAlternation */
HS_RESULT ASNH225Setup_UUIE_conferenceGoal_DeleteAlternation(void *pObject)
{
	ASNH225Setup_UUIE_conferenceGoal *pObj = (ASNH225Setup_UUIE_conferenceGoal *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225Setup_UUIE_conferenceGoalChoice_create ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225Setup_UUIE_conferenceGoalChoice_join ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225Setup_UUIE_conferenceGoalChoice_invite ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH225Setup_UUIE_conferenceGoalChoice_capability_negotiation ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225Setup_UUIE_conferenceGoalChoice_callIndependentSupplementaryService ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225Setup_UUIE_conferenceGoal_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225Setup_UUIE_conferenceGoal Encode */
HS_RESULT ASNH225Setup_UUIE_conferenceGoal_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225Setup_UUIE_conferenceGoal *pObj = (ASNH225Setup_UUIE_conferenceGoal *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225Setup_UUIE_conferenceGoalChoiceSize )
		{
			if( pObj->choice > ((ASNH225Setup_UUIE_conferenceGoalChoice)(e_ASNH225Setup_UUIE_conferenceGoalChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225Setup_UUIE_conferenceGoalChoiceSize)) )
	}
	else
	{
		if( e_ASNH225Setup_UUIE_conferenceGoalChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225Setup_UUIE_conferenceGoalChoice_create ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225Setup_UUIE_conferenceGoalChoice_join ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225Setup_UUIE_conferenceGoalChoice_invite ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225Setup_UUIE_conferenceGoalChoice_capability_negotiation ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225Setup_UUIE_conferenceGoalChoice_callIndependentSupplementaryService ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225Setup_UUIE_conferenceGoal Decode */
HS_RESULT ASNH225Setup_UUIE_conferenceGoal_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225Setup_UUIE_conferenceGoal *pObj = (ASNH225Setup_UUIE_conferenceGoal *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225Setup_UUIE_conferenceGoalChoiceSize;
	}
	else
	{
		if( e_ASNH225Setup_UUIE_conferenceGoalChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225Setup_UUIE_conferenceGoalChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225Setup_UUIE_conferenceGoalChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225Setup_UUIE_conferenceGoal_SetChoice( pObj, (ASNH225Setup_UUIE_conferenceGoalChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225Setup_UUIE_conferenceGoalChoice_create ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225Setup_UUIE_conferenceGoalChoice_join ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225Setup_UUIE_conferenceGoalChoice_invite ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225Setup_UUIE_conferenceGoalChoice_capability_negotiation ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225Setup_UUIE_conferenceGoalChoice_callIndependentSupplementaryService ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225Setup_UUIE_conferenceGoal Print */
HS_RESULT ASNH225Setup_UUIE_conferenceGoal_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225Setup_UUIE_conferenceGoal *pObj = (ASNH225Setup_UUIE_conferenceGoal *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225Setup_UUIE_conferenceGoal_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225Setup_UUIE_conferenceGoalChoice_create ){
		AsnNull_Print( pObj->alter, pDepth+1, "create" );
	}
	else if ( pObj->choice == e_ASNH225Setup_UUIE_conferenceGoalChoice_join ){
		AsnNull_Print( pObj->alter, pDepth+1, "join" );
	}
	else if ( pObj->choice == e_ASNH225Setup_UUIE_conferenceGoalChoice_invite ){
		AsnNull_Print( pObj->alter, pDepth+1, "invite" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225Setup_UUIE_conferenceGoalChoice_capability_negotiation ){
		AsnNull_Print( pObj->alter, pDepth+1, "capability_negotiation" );
	}
	else if ( pObj->choice == e_ASNH225Setup_UUIE_conferenceGoalChoice_callIndependentSupplementaryService ){
		AsnNull_Print( pObj->alter, pDepth+1, "callIndependentSupplementaryService" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225Q954Details Class
*/
/*ASNH225Q954Details Constructor*/
HS_RESULT new_ASNH225Q954Details(void *pObject)
{
	ASNH225Q954Details *pObj = (ASNH225Q954Details *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225Q954Details(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_conferenceCalling) );
	new_AsnBoolean( &(pObj->m_threePartyService) );

	return HS_OK;
}

/* ASNH225Q954Details Destructor */
HS_RESULT delete_ASNH225Q954Details(void *pObject)
{
	ASNH225Q954Details *pObj = (ASNH225Q954Details *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225Q954Details(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_conferenceCalling) );
	delete_AsnBoolean( &(pObj->m_threePartyService) );
	return HS_OK;
}

/* ASNH225Q954Details MakeMold */
HS_RESULT ASNH225Q954Details_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225Q954Details *pObj = (ASNH225Q954Details *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Q954Details_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH225Q954Details Encode */
HS_RESULT ASNH225Q954Details_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225Q954Details *pObj = (ASNH225Q954Details *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Q954Details_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_conferenceCalling),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Q954Details_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_threePartyService),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Q954Details_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225Q954Details Decode */
HS_RESULT ASNH225Q954Details_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225Q954Details *pObj = (ASNH225Q954Details *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Q954Details_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_conferenceCalling),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Q954Details_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_threePartyService),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Q954Details_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225Q954Details Print */
HS_RESULT ASNH225Q954Details_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225Q954Details *pObj = (ASNH225Q954Details *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225Q954Details_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_conferenceCalling), pDepth+1, "conferenceCalling" );
	AsnBoolean_Print( &(pObj->m_threePartyService), pDepth+1, "threePartyService" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225QseriesOptions Class
*/
/*ASNH225QseriesOptions Constructor*/
HS_RESULT new_ASNH225QseriesOptions(void *pObject)
{
	ASNH225QseriesOptions *pObj = (ASNH225QseriesOptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225QseriesOptions(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_q932Full) );
	new_AsnBoolean( &(pObj->m_q951Full) );
	new_AsnBoolean( &(pObj->m_q952Full) );
	new_AsnBoolean( &(pObj->m_q953Full) );
	new_AsnBoolean( &(pObj->m_q955Full) );
	new_AsnBoolean( &(pObj->m_q956Full) );
	new_AsnBoolean( &(pObj->m_q957Full) );
	new_ASNH225Q954Details( &(pObj->m_q954Info) );

	return HS_OK;
}

/* ASNH225QseriesOptions Destructor */
HS_RESULT delete_ASNH225QseriesOptions(void *pObject)
{
	ASNH225QseriesOptions *pObj = (ASNH225QseriesOptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225QseriesOptions(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_q932Full) );
	delete_AsnBoolean( &(pObj->m_q951Full) );
	delete_AsnBoolean( &(pObj->m_q952Full) );
	delete_AsnBoolean( &(pObj->m_q953Full) );
	delete_AsnBoolean( &(pObj->m_q955Full) );
	delete_AsnBoolean( &(pObj->m_q956Full) );
	delete_AsnBoolean( &(pObj->m_q957Full) );
	delete_ASNH225Q954Details( &(pObj->m_q954Info) );
	return HS_OK;
}

/* ASNH225QseriesOptions MakeMold */
HS_RESULT ASNH225QseriesOptions_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225QseriesOptions *pObj = (ASNH225QseriesOptions *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225QseriesOptions_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225Q954Details_MakeMold(&(pObj->m_q954Info));
	return HS_OK;
}

/* ASNH225QseriesOptions Encode */
HS_RESULT ASNH225QseriesOptions_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225QseriesOptions *pObj = (ASNH225QseriesOptions *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225QseriesOptions_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnBoolean_Encode( &(pObj->m_q932Full),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225QseriesOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_q951Full),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225QseriesOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_q952Full),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225QseriesOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_q953Full),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225QseriesOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_q955Full),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225QseriesOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_q956Full),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225QseriesOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_q957Full),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225QseriesOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225Q954Details_Encode( &(pObj->m_q954Info),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225QseriesOptions_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225QseriesOptions Decode */
HS_RESULT ASNH225QseriesOptions_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225QseriesOptions *pObj = (ASNH225QseriesOptions *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225QseriesOptions_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_q932Full),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225QseriesOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_q951Full),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225QseriesOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_q952Full),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225QseriesOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_q953Full),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225QseriesOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_q955Full),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225QseriesOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_q956Full),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225QseriesOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_q957Full),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225QseriesOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225Q954Details_Decode(&(pObj->m_q954Info),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225QseriesOptions_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225QseriesOptions Print */
HS_RESULT ASNH225QseriesOptions_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225QseriesOptions *pObj = (ASNH225QseriesOptions *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225QseriesOptions_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_q932Full), pDepth+1, "q932Full" );
	AsnBoolean_Print( &(pObj->m_q951Full), pDepth+1, "q951Full" );
	AsnBoolean_Print( &(pObj->m_q952Full), pDepth+1, "q952Full" );
	AsnBoolean_Print( &(pObj->m_q953Full), pDepth+1, "q953Full" );
	AsnBoolean_Print( &(pObj->m_q955Full), pDepth+1, "q955Full" );
	AsnBoolean_Print( &(pObj->m_q956Full), pDepth+1, "q956Full" );
	AsnBoolean_Print( &(pObj->m_q957Full), pDepth+1, "q957Full" );
	ASNH225Q954Details_Print( &(pObj->m_q954Info), pDepth+1, "q954Info" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225CallType Struct
*/
/* ASNH225CallType Constructor */
HS_RESULT new_ASNH225CallType( void *pObject )
{
	ASNH225CallType *pObj = (ASNH225CallType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225CallType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225CallTypeChoice_pointToPoint;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225CallTypeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225CallType Destructor */
HS_RESULT delete_ASNH225CallType( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225CallType *pObj = (ASNH225CallType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225CallType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225CallType_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225CallType(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225CallType SetChoice */
void* ASNH225CallType_SetChoice( void *pObject, ASNH225CallTypeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225CallType *pObj = (ASNH225CallType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallType_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225CallTypeChoiceSizeExt ){
		if( pChoice > (ASNH225CallTypeChoice)(e_ASNH225CallTypeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallType_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225CallType_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallType_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225CallTypeChoice_pointToPoint ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225CallTypeChoice_oneToN ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225CallTypeChoice_nToOne ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225CallTypeChoice_nToN ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallType_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225CallType DeleteAlternation */
HS_RESULT ASNH225CallType_DeleteAlternation(void *pObject)
{
	ASNH225CallType *pObj = (ASNH225CallType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallType_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225CallTypeChoice_pointToPoint ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225CallTypeChoice_oneToN ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225CallTypeChoice_nToOne ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225CallTypeChoice_nToN ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallType_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225CallType_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225CallType Encode */
HS_RESULT ASNH225CallType_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225CallType *pObj = (ASNH225CallType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallType_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallType_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225CallTypeChoiceSize )
		{
			if( pObj->choice > ((ASNH225CallTypeChoice)(e_ASNH225CallTypeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225CallTypeChoiceSize)) )
	}
	else
	{
		if( e_ASNH225CallTypeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225CallTypeChoice_pointToPoint ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225CallTypeChoice_oneToN ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225CallTypeChoice_nToOne ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225CallTypeChoice_nToN ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallType_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225CallType Decode */
HS_RESULT ASNH225CallType_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225CallType *pObj = (ASNH225CallType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallType_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225CallTypeChoiceSize;
	}
	else
	{
		if( e_ASNH225CallTypeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225CallTypeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225CallTypeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallType_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225CallType_SetChoice( pObj, (ASNH225CallTypeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallType_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225CallTypeChoice_pointToPoint ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225CallTypeChoice_oneToN ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225CallTypeChoice_nToOne ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225CallTypeChoice_nToN ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallType_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225CallType Print */
HS_RESULT ASNH225CallType_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225CallType *pObj = (ASNH225CallType *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225CallType_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225CallTypeChoice_pointToPoint ){
		AsnNull_Print( pObj->alter, pDepth+1, "pointToPoint" );
	}
	else if ( pObj->choice == e_ASNH225CallTypeChoice_oneToN ){
		AsnNull_Print( pObj->alter, pDepth+1, "oneToN" );
	}
	else if ( pObj->choice == e_ASNH225CallTypeChoice_nToOne ){
		AsnNull_Print( pObj->alter, pDepth+1, "nToOne" );
	}
	else if ( pObj->choice == e_ASNH225CallTypeChoice_nToN ){
		AsnNull_Print( pObj->alter, pDepth+1, "nToN" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225CallIdentifier Class
*/
/*ASNH225CallIdentifier Constructor*/
HS_RESULT new_ASNH225CallIdentifier(void *pObject)
{
	ASNH225CallIdentifier *pObj = (ASNH225CallIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225CallIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225GloballyUniqueID( &(pObj->m_guid) );

	return HS_OK;
}

/* ASNH225CallIdentifier Destructor */
HS_RESULT delete_ASNH225CallIdentifier(void *pObject)
{
	ASNH225CallIdentifier *pObj = (ASNH225CallIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225CallIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225GloballyUniqueID( &(pObj->m_guid) );
	return HS_OK;
}

/* ASNH225CallIdentifier MakeMold */
HS_RESULT ASNH225CallIdentifier_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225CallIdentifier *pObj = (ASNH225CallIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallIdentifier_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225GloballyUniqueID_MakeMold(&(pObj->m_guid));
	return HS_OK;
}

/* ASNH225CallIdentifier Encode */
HS_RESULT ASNH225CallIdentifier_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225CallIdentifier *pObj = (ASNH225CallIdentifier *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallIdentifier_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH225GloballyUniqueID_Encode( &(pObj->m_guid),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225CallIdentifier Decode */
HS_RESULT ASNH225CallIdentifier_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225CallIdentifier *pObj = (ASNH225CallIdentifier *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallIdentifier_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH225GloballyUniqueID_Decode(&(pObj->m_guid),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallIdentifier_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225CallIdentifier Print */
HS_RESULT ASNH225CallIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225CallIdentifier *pObj = (ASNH225CallIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225CallIdentifier_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225GloballyUniqueID_Print( &(pObj->m_guid), pDepth+1, "guid" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225SecurityServiceMode Struct
*/
/* ASNH225SecurityServiceMode Constructor */
HS_RESULT new_ASNH225SecurityServiceMode( void *pObject )
{
	ASNH225SecurityServiceMode *pObj = (ASNH225SecurityServiceMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225SecurityServiceMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225SecurityServiceModeChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225SecurityServiceModeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225SecurityServiceMode Destructor */
HS_RESULT delete_ASNH225SecurityServiceMode( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225SecurityServiceMode *pObj = (ASNH225SecurityServiceMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225SecurityServiceMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225SecurityServiceMode_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225SecurityServiceMode(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225SecurityServiceMode SetChoice */
void* ASNH225SecurityServiceMode_SetChoice( void *pObject, ASNH225SecurityServiceModeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225SecurityServiceMode *pObj = (ASNH225SecurityServiceMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SecurityServiceMode_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225SecurityServiceModeChoiceSizeExt ){
		if( pChoice > (ASNH225SecurityServiceModeChoice)(e_ASNH225SecurityServiceModeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SecurityServiceMode_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225SecurityServiceMode_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SecurityServiceMode_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225SecurityServiceModeChoice_nonStandard ){
		ASNH225NonStandardParameter *tAlter = (ASNH225NonStandardParameter *)HSMalloc( sizeof(ASNH225NonStandardParameter) );
		new_ASNH225NonStandardParameter(tAlter);
		ASNH225NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225SecurityServiceModeChoice_none ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225SecurityServiceModeChoice_default ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SecurityServiceMode_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225SecurityServiceMode DeleteAlternation */
HS_RESULT ASNH225SecurityServiceMode_DeleteAlternation(void *pObject)
{
	ASNH225SecurityServiceMode *pObj = (ASNH225SecurityServiceMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SecurityServiceMode_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225SecurityServiceModeChoice_nonStandard ){
			delete_ASNH225NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225SecurityServiceModeChoice_none ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225SecurityServiceModeChoice_default ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SecurityServiceMode_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225SecurityServiceMode_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225SecurityServiceMode Encode */
HS_RESULT ASNH225SecurityServiceMode_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225SecurityServiceMode *pObj = (ASNH225SecurityServiceMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SecurityServiceMode_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SecurityServiceMode_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225SecurityServiceModeChoiceSize )
		{
			if( pObj->choice > ((ASNH225SecurityServiceModeChoice)(e_ASNH225SecurityServiceModeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225SecurityServiceModeChoiceSize)) )
	}
	else
	{
		if( e_ASNH225SecurityServiceModeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225SecurityServiceModeChoice_nonStandard ){
		if( (tRet=ASNH225NonStandardParameter_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SecurityServiceMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SecurityServiceModeChoice_none ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SecurityServiceMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SecurityServiceModeChoice_default ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SecurityServiceMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SecurityServiceMode_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225SecurityServiceMode Decode */
HS_RESULT ASNH225SecurityServiceMode_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225SecurityServiceMode *pObj = (ASNH225SecurityServiceMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SecurityServiceMode_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225SecurityServiceModeChoiceSize;
	}
	else
	{
		if( e_ASNH225SecurityServiceModeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225SecurityServiceModeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225SecurityServiceModeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SecurityServiceMode_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225SecurityServiceMode_SetChoice( pObj, (ASNH225SecurityServiceModeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SecurityServiceMode_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225SecurityServiceModeChoice_nonStandard ){
		if( (tRet=ASNH225NonStandardParameter_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SecurityServiceMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SecurityServiceModeChoice_none ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SecurityServiceMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225SecurityServiceModeChoice_default ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SecurityServiceMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SecurityServiceMode_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225SecurityServiceMode Print */
HS_RESULT ASNH225SecurityServiceMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225SecurityServiceMode *pObj = (ASNH225SecurityServiceMode *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225SecurityServiceMode_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225SecurityServiceModeChoice_nonStandard ){
		ASNH225NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH225SecurityServiceModeChoice_none ){
		AsnNull_Print( pObj->alter, pDepth+1, "none" );
	}
	else if ( pObj->choice == e_ASNH225SecurityServiceModeChoice_default ){
		AsnNull_Print( pObj->alter, pDepth+1, "default" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225SecurityCapabilities Class
*/
/*ASNH225SecurityCapabilities Constructor*/
HS_RESULT new_ASNH225SecurityCapabilities(void *pObject)
{
	ASNH225SecurityCapabilities *pObj = (ASNH225SecurityCapabilities *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225SecurityCapabilities(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandard) );
	new_ASNH225SecurityServiceMode( &(pObj->m_encryption) );
	new_ASNH225SecurityServiceMode( &(pObj->m_authenticaton) );
	new_ASNH225SecurityServiceMode( &(pObj->m_integrity) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225SecurityCapabilities Destructor */
HS_RESULT delete_ASNH225SecurityCapabilities(void *pObject)
{
	ASNH225SecurityCapabilities *pObj = (ASNH225SecurityCapabilities *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225SecurityCapabilities(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandard) );
	delete_ASNH225SecurityServiceMode( &(pObj->m_encryption) );
	delete_ASNH225SecurityServiceMode( &(pObj->m_authenticaton) );
	delete_ASNH225SecurityServiceMode( &(pObj->m_integrity) );
	return HS_OK;
}

/* ASNH225SecurityCapabilities MakeMold */
HS_RESULT ASNH225SecurityCapabilities_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225SecurityCapabilities *pObj = (ASNH225SecurityCapabilities *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SecurityCapabilities_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandard));
	ASNH225SecurityServiceMode_MakeMold(&(pObj->m_encryption));
	ASNH225SecurityServiceMode_MakeMold(&(pObj->m_authenticaton));
	ASNH225SecurityServiceMode_MakeMold(&(pObj->m_integrity));
	return HS_OK;
}

/* ASNH225SecurityCapabilities IncludeOptionalField */
HS_RESULT ASNH225SecurityCapabilities_IncludeOptionField( void *pObject, ASNH225SecurityCapabilitiesOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225SecurityCapabilities *pObj = (ASNH225SecurityCapabilities *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SecurityCapabilities_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225SecurityCapabilitiesOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225SecurityCapabilities IsIncludeOptionalField */
BOOL ASNH225SecurityCapabilities_IsIncludeOptionField( void *pObject, ASNH225SecurityCapabilitiesOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225SecurityCapabilities *pObj = (ASNH225SecurityCapabilities *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SecurityCapabilities_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225SecurityCapabilitiesOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225SecurityCapabilities Encode */
HS_RESULT ASNH225SecurityCapabilities_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225SecurityCapabilities *pObj = (ASNH225SecurityCapabilities *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SecurityCapabilities_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225SecurityCapabilitiesOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225SecurityCapabilitiesOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225SecurityCapabilities_IsIncludeOptionField( pObj, e_ASNH225SecurityCapabilitiesOptionMap_nonStandard ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandard),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SecurityCapabilities_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225SecurityServiceMode_Encode( &(pObj->m_encryption),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SecurityCapabilities_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225SecurityServiceMode_Encode( &(pObj->m_authenticaton),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SecurityCapabilities_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225SecurityServiceMode_Encode( &(pObj->m_integrity),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SecurityCapabilities_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225SecurityCapabilities Decode */
HS_RESULT ASNH225SecurityCapabilities_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225SecurityCapabilities *pObj = (ASNH225SecurityCapabilities *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SecurityCapabilities_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225SecurityCapabilitiesOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225SecurityCapabilitiesOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225SecurityCapabilities_IsIncludeOptionField( pObj, e_ASNH225SecurityCapabilitiesOptionMap_nonStandard ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandard),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225SecurityCapabilities_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225SecurityServiceMode_Decode(&(pObj->m_encryption),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SecurityCapabilities_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225SecurityServiceMode_Decode(&(pObj->m_authenticaton),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SecurityCapabilities_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225SecurityServiceMode_Decode(&(pObj->m_integrity),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225SecurityCapabilities_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225SecurityCapabilities Print */
HS_RESULT ASNH225SecurityCapabilities_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225SecurityCapabilities *pObj = (ASNH225SecurityCapabilities *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225SecurityCapabilities_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225SecurityCapabilities_IsIncludeOptionField( pObj, e_ASNH225SecurityCapabilitiesOptionMap_nonStandard ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandard), pDepth+1, "nonStandard" );
	ASNH225SecurityServiceMode_Print( &(pObj->m_encryption), pDepth+1, "encryption" );
	ASNH225SecurityServiceMode_Print( &(pObj->m_authenticaton), pDepth+1, "authenticaton" );
	ASNH225SecurityServiceMode_Print( &(pObj->m_integrity), pDepth+1, "integrity" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225H245Security Struct
*/
/* ASNH225H245Security Constructor */
HS_RESULT new_ASNH225H245Security( void *pObject )
{
	ASNH225H245Security *pObj = (ASNH225H245Security *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225H245Security(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225H245SecurityChoice_nonStandard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225H245SecurityChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225H245Security Destructor */
HS_RESULT delete_ASNH225H245Security( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225H245Security *pObj = (ASNH225H245Security *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225H245Security(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225H245Security_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225H245Security(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225H245Security SetChoice */
void* ASNH225H245Security_SetChoice( void *pObject, ASNH225H245SecurityChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225H245Security *pObj = (ASNH225H245Security *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H245Security_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225H245SecurityChoiceSizeExt ){
		if( pChoice > (ASNH225H245SecurityChoice)(e_ASNH225H245SecurityChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H245Security_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225H245Security_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H245Security_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225H245SecurityChoice_nonStandard ){
		ASNH225NonStandardParameter *tAlter = (ASNH225NonStandardParameter *)HSMalloc( sizeof(ASNH225NonStandardParameter) );
		new_ASNH225NonStandardParameter(tAlter);
		ASNH225NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225H245SecurityChoice_noSecurity ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225H245SecurityChoice_tls ){
		ASNH225SecurityCapabilities *tAlter = (ASNH225SecurityCapabilities *)HSMalloc( sizeof(ASNH225SecurityCapabilities) );
		new_ASNH225SecurityCapabilities(tAlter);
		ASNH225SecurityCapabilities_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225H245SecurityChoice_ipsec ){
		ASNH225SecurityCapabilities *tAlter = (ASNH225SecurityCapabilities *)HSMalloc( sizeof(ASNH225SecurityCapabilities) );
		new_ASNH225SecurityCapabilities(tAlter);
		ASNH225SecurityCapabilities_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H245Security_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225H245Security DeleteAlternation */
HS_RESULT ASNH225H245Security_DeleteAlternation(void *pObject)
{
	ASNH225H245Security *pObj = (ASNH225H245Security *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H245Security_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225H245SecurityChoice_nonStandard ){
			delete_ASNH225NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225H245SecurityChoice_noSecurity ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225H245SecurityChoice_tls ){
			delete_ASNH225SecurityCapabilities(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225H245SecurityChoice_ipsec ){
			delete_ASNH225SecurityCapabilities(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H245Security_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225H245Security_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225H245Security Encode */
HS_RESULT ASNH225H245Security_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225H245Security *pObj = (ASNH225H245Security *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H245Security_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H245Security_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225H245SecurityChoiceSize )
		{
			if( pObj->choice > ((ASNH225H245SecurityChoice)(e_ASNH225H245SecurityChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225H245SecurityChoiceSize)) )
	}
	else
	{
		if( e_ASNH225H245SecurityChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225H245SecurityChoice_nonStandard ){
		if( (tRet=ASNH225NonStandardParameter_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H245Security_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225H245SecurityChoice_noSecurity ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H245Security_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225H245SecurityChoice_tls ){
		if( (tRet=ASNH225SecurityCapabilities_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H245Security_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225H245SecurityChoice_ipsec ){
		if( (tRet=ASNH225SecurityCapabilities_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H245Security_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H245Security_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225H245Security Decode */
HS_RESULT ASNH225H245Security_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225H245Security *pObj = (ASNH225H245Security *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H245Security_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225H245SecurityChoiceSize;
	}
	else
	{
		if( e_ASNH225H245SecurityChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225H245SecurityChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225H245SecurityChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H245Security_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225H245Security_SetChoice( pObj, (ASNH225H245SecurityChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H245Security_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225H245SecurityChoice_nonStandard ){
		if( (tRet=ASNH225NonStandardParameter_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H245Security_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225H245SecurityChoice_noSecurity ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H245Security_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225H245SecurityChoice_tls ){
		if( (tRet=ASNH225SecurityCapabilities_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H245Security_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225H245SecurityChoice_ipsec ){
		if( (tRet=ASNH225SecurityCapabilities_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225H245Security_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225H245Security_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225H245Security Print */
HS_RESULT ASNH225H245Security_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225H245Security *pObj = (ASNH225H245Security *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225H245Security_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225H245SecurityChoice_nonStandard ){
		ASNH225NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH225H245SecurityChoice_noSecurity ){
		AsnNull_Print( pObj->alter, pDepth+1, "noSecurity" );
	}
	else if ( pObj->choice == e_ASNH225H245SecurityChoice_tls ){
		ASNH225SecurityCapabilities_Print( pObj->alter, pDepth+1, "tls" );
	}
	else if ( pObj->choice == e_ASNH225H245SecurityChoice_ipsec ){
		ASNH225SecurityCapabilities_Print( pObj->alter, pDepth+1, "ipsec" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225ScnConnectionType Struct
*/
/* ASNH225ScnConnectionType Constructor */
HS_RESULT new_ASNH225ScnConnectionType( void *pObject )
{
	ASNH225ScnConnectionType *pObj = (ASNH225ScnConnectionType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225ScnConnectionType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225ScnConnectionTypeChoice_unknown;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225ScnConnectionTypeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225ScnConnectionType Destructor */
HS_RESULT delete_ASNH225ScnConnectionType( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225ScnConnectionType *pObj = (ASNH225ScnConnectionType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ScnConnectionType(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225ScnConnectionType_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ScnConnectionType(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225ScnConnectionType SetChoice */
void* ASNH225ScnConnectionType_SetChoice( void *pObject, ASNH225ScnConnectionTypeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225ScnConnectionType *pObj = (ASNH225ScnConnectionType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ScnConnectionType_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225ScnConnectionTypeChoiceSizeExt ){
		if( pChoice > (ASNH225ScnConnectionTypeChoice)(e_ASNH225ScnConnectionTypeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionType_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225ScnConnectionType_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionType_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225ScnConnectionTypeChoice_unknown ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ScnConnectionTypeChoice_bChannel ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ScnConnectionTypeChoice_hybrid2x64 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ScnConnectionTypeChoice_hybrid384 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ScnConnectionTypeChoice_hybrid1536 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ScnConnectionTypeChoice_hybrid1920 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ScnConnectionTypeChoice_multirate ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ScnConnectionType_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225ScnConnectionType DeleteAlternation */
HS_RESULT ASNH225ScnConnectionType_DeleteAlternation(void *pObject)
{
	ASNH225ScnConnectionType *pObj = (ASNH225ScnConnectionType *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ScnConnectionType_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225ScnConnectionTypeChoice_unknown ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_bChannel ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_hybrid2x64 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_hybrid384 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_hybrid1536 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_hybrid1920 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_multirate ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionType_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225ScnConnectionType_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225ScnConnectionType Encode */
HS_RESULT ASNH225ScnConnectionType_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225ScnConnectionType *pObj = (ASNH225ScnConnectionType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ScnConnectionType_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ScnConnectionType_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225ScnConnectionTypeChoiceSize )
		{
			if( pObj->choice > ((ASNH225ScnConnectionTypeChoice)(e_ASNH225ScnConnectionTypeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225ScnConnectionTypeChoiceSize)) )
	}
	else
	{
		if( e_ASNH225ScnConnectionTypeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ScnConnectionTypeChoice_unknown ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_bChannel ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_hybrid2x64 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_hybrid384 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_hybrid1536 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_hybrid1920 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_multirate ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionType_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ScnConnectionType_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225ScnConnectionType Decode */
HS_RESULT ASNH225ScnConnectionType_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225ScnConnectionType *pObj = (ASNH225ScnConnectionType *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ScnConnectionType_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225ScnConnectionTypeChoiceSize;
	}
	else
	{
		if( e_ASNH225ScnConnectionTypeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225ScnConnectionTypeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225ScnConnectionTypeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionType_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225ScnConnectionType_SetChoice( pObj, (ASNH225ScnConnectionTypeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ScnConnectionType_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ScnConnectionTypeChoice_unknown ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_bChannel ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_hybrid2x64 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_hybrid384 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_hybrid1536 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_hybrid1920 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_multirate ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionType_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ScnConnectionType_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225ScnConnectionType Print */
HS_RESULT ASNH225ScnConnectionType_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225ScnConnectionType *pObj = (ASNH225ScnConnectionType *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225ScnConnectionType_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ScnConnectionTypeChoice_unknown ){
		AsnNull_Print( pObj->alter, pDepth+1, "unknown" );
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_bChannel ){
		AsnNull_Print( pObj->alter, pDepth+1, "bChannel" );
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_hybrid2x64 ){
		AsnNull_Print( pObj->alter, pDepth+1, "hybrid2x64" );
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_hybrid384 ){
		AsnNull_Print( pObj->alter, pDepth+1, "hybrid384" );
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_hybrid1536 ){
		AsnNull_Print( pObj->alter, pDepth+1, "hybrid1536" );
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_hybrid1920 ){
		AsnNull_Print( pObj->alter, pDepth+1, "hybrid1920" );
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionTypeChoice_multirate ){
		AsnNull_Print( pObj->alter, pDepth+1, "multirate" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225ScnConnectionAggregation Struct
*/
/* ASNH225ScnConnectionAggregation Constructor */
HS_RESULT new_ASNH225ScnConnectionAggregation( void *pObject )
{
	ASNH225ScnConnectionAggregation *pObj = (ASNH225ScnConnectionAggregation *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225ScnConnectionAggregation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225ScnConnectionAggregationChoice_auto;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225ScnConnectionAggregationChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225ScnConnectionAggregation Destructor */
HS_RESULT delete_ASNH225ScnConnectionAggregation( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225ScnConnectionAggregation *pObj = (ASNH225ScnConnectionAggregation *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ScnConnectionAggregation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225ScnConnectionAggregation_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ScnConnectionAggregation(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225ScnConnectionAggregation SetChoice */
void* ASNH225ScnConnectionAggregation_SetChoice( void *pObject, ASNH225ScnConnectionAggregationChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225ScnConnectionAggregation *pObj = (ASNH225ScnConnectionAggregation *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ScnConnectionAggregation_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225ScnConnectionAggregationChoiceSizeExt ){
		if( pChoice > (ASNH225ScnConnectionAggregationChoice)(e_ASNH225ScnConnectionAggregationChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionAggregation_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225ScnConnectionAggregation_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionAggregation_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225ScnConnectionAggregationChoice_auto ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ScnConnectionAggregationChoice_none ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ScnConnectionAggregationChoice_h221 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ScnConnectionAggregationChoice_bonded_mode1 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ScnConnectionAggregationChoice_bonded_mode2 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ScnConnectionAggregationChoice_bonded_mode3 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ScnConnectionAggregation_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225ScnConnectionAggregation DeleteAlternation */
HS_RESULT ASNH225ScnConnectionAggregation_DeleteAlternation(void *pObject)
{
	ASNH225ScnConnectionAggregation *pObj = (ASNH225ScnConnectionAggregation *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ScnConnectionAggregation_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_auto ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_none ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_h221 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_bonded_mode1 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_bonded_mode2 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_bonded_mode3 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionAggregation_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225ScnConnectionAggregation_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225ScnConnectionAggregation Encode */
HS_RESULT ASNH225ScnConnectionAggregation_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225ScnConnectionAggregation *pObj = (ASNH225ScnConnectionAggregation *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ScnConnectionAggregation_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ScnConnectionAggregation_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225ScnConnectionAggregationChoiceSize )
		{
			if( pObj->choice > ((ASNH225ScnConnectionAggregationChoice)(e_ASNH225ScnConnectionAggregationChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225ScnConnectionAggregationChoiceSize)) )
	}
	else
	{
		if( e_ASNH225ScnConnectionAggregationChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_auto ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionAggregation_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_none ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionAggregation_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_h221 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionAggregation_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_bonded_mode1 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionAggregation_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_bonded_mode2 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionAggregation_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_bonded_mode3 ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionAggregation_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ScnConnectionAggregation_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225ScnConnectionAggregation Decode */
HS_RESULT ASNH225ScnConnectionAggregation_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225ScnConnectionAggregation *pObj = (ASNH225ScnConnectionAggregation *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ScnConnectionAggregation_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225ScnConnectionAggregationChoiceSize;
	}
	else
	{
		if( e_ASNH225ScnConnectionAggregationChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225ScnConnectionAggregationChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225ScnConnectionAggregationChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionAggregation_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225ScnConnectionAggregation_SetChoice( pObj, (ASNH225ScnConnectionAggregationChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ScnConnectionAggregation_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_auto ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionAggregation_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_none ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionAggregation_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_h221 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionAggregation_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_bonded_mode1 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionAggregation_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_bonded_mode2 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionAggregation_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_bonded_mode3 ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ScnConnectionAggregation_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ScnConnectionAggregation_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225ScnConnectionAggregation Print */
HS_RESULT ASNH225ScnConnectionAggregation_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225ScnConnectionAggregation *pObj = (ASNH225ScnConnectionAggregation *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225ScnConnectionAggregation_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_auto ){
		AsnNull_Print( pObj->alter, pDepth+1, "auto" );
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_none ){
		AsnNull_Print( pObj->alter, pDepth+1, "none" );
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_h221 ){
		AsnNull_Print( pObj->alter, pDepth+1, "h221" );
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_bonded_mode1 ){
		AsnNull_Print( pObj->alter, pDepth+1, "bonded_mode1" );
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_bonded_mode2 ){
		AsnNull_Print( pObj->alter, pDepth+1, "bonded_mode2" );
	}
	else if ( pObj->choice == e_ASNH225ScnConnectionAggregationChoice_bonded_mode3 ){
		AsnNull_Print( pObj->alter, pDepth+1, "bonded_mode3" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225Setup_UUIE_connectionParameters Class
*/
/*ASNH225Setup_UUIE_connectionParameters Constructor*/
HS_RESULT new_ASNH225Setup_UUIE_connectionParameters(void *pObject)
{
	ASNH225Setup_UUIE_connectionParameters *pObj = (ASNH225Setup_UUIE_connectionParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225Setup_UUIE_connectionParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225ScnConnectionType( &(pObj->m_connectionType) );
	new_AsnInteger( &(pObj->m_numberOfScnConnections), e_constrained, 0, 65535, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ScnConnectionAggregation( &(pObj->m_connectionAggregation) );

	return HS_OK;
}

/* ASNH225Setup_UUIE_connectionParameters Destructor */
HS_RESULT delete_ASNH225Setup_UUIE_connectionParameters(void *pObject)
{
	ASNH225Setup_UUIE_connectionParameters *pObj = (ASNH225Setup_UUIE_connectionParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225Setup_UUIE_connectionParameters(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225ScnConnectionType( &(pObj->m_connectionType) );
	delete_AsnInteger( &(pObj->m_numberOfScnConnections) );
	delete_ASNH225ScnConnectionAggregation( &(pObj->m_connectionAggregation) );
	return HS_OK;
}

/* ASNH225Setup_UUIE_connectionParameters MakeMold */
HS_RESULT ASNH225Setup_UUIE_connectionParameters_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225Setup_UUIE_connectionParameters *pObj = (ASNH225Setup_UUIE_connectionParameters *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_connectionParameters_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225ScnConnectionType_MakeMold(&(pObj->m_connectionType));
	ASNH225ScnConnectionAggregation_MakeMold(&(pObj->m_connectionAggregation));
	return HS_OK;
}

/* ASNH225Setup_UUIE_connectionParameters Encode */
HS_RESULT ASNH225Setup_UUIE_connectionParameters_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225Setup_UUIE_connectionParameters *pObj = (ASNH225Setup_UUIE_connectionParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_connectionParameters_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH225ScnConnectionType_Encode( &(pObj->m_connectionType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_connectionParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Encode( &(pObj->m_numberOfScnConnections),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_connectionParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225ScnConnectionAggregation_Encode( &(pObj->m_connectionAggregation),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_connectionParameters_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225Setup_UUIE_connectionParameters Decode */
HS_RESULT ASNH225Setup_UUIE_connectionParameters_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225Setup_UUIE_connectionParameters *pObj = (ASNH225Setup_UUIE_connectionParameters *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_connectionParameters_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH225ScnConnectionType_Decode(&(pObj->m_connectionType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_connectionParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnInteger_Decode(&(pObj->m_numberOfScnConnections),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_connectionParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225ScnConnectionAggregation_Decode(&(pObj->m_connectionAggregation),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_connectionParameters_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225Setup_UUIE_connectionParameters Print */
HS_RESULT ASNH225Setup_UUIE_connectionParameters_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225Setup_UUIE_connectionParameters *pObj = (ASNH225Setup_UUIE_connectionParameters *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225Setup_UUIE_connectionParameters_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225ScnConnectionType_Print( &(pObj->m_connectionType), pDepth+1, "connectionType" );
	AsnInteger_Print( &(pObj->m_numberOfScnConnections), pDepth+1, "numberOfScnConnections" );
	ASNH225ScnConnectionAggregation_Print( &(pObj->m_connectionAggregation), pDepth+1, "connectionAggregation" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225PresentationIndicator Struct
*/
/* ASNH225PresentationIndicator Constructor */
HS_RESULT new_ASNH225PresentationIndicator( void *pObject )
{
	ASNH225PresentationIndicator *pObj = (ASNH225PresentationIndicator *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225PresentationIndicator(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225PresentationIndicatorChoice_presentationAllowed;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225PresentationIndicatorChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225PresentationIndicator Destructor */
HS_RESULT delete_ASNH225PresentationIndicator( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225PresentationIndicator *pObj = (ASNH225PresentationIndicator *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225PresentationIndicator(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225PresentationIndicator_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225PresentationIndicator(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225PresentationIndicator SetChoice */
void* ASNH225PresentationIndicator_SetChoice( void *pObject, ASNH225PresentationIndicatorChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225PresentationIndicator *pObj = (ASNH225PresentationIndicator *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PresentationIndicator_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225PresentationIndicatorChoiceSizeExt ){
		if( pChoice > (ASNH225PresentationIndicatorChoice)(e_ASNH225PresentationIndicatorChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PresentationIndicator_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225PresentationIndicator_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PresentationIndicator_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225PresentationIndicatorChoice_presentationAllowed ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225PresentationIndicatorChoice_presentationRestricted ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225PresentationIndicatorChoice_addressNotAvailable ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PresentationIndicator_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225PresentationIndicator DeleteAlternation */
HS_RESULT ASNH225PresentationIndicator_DeleteAlternation(void *pObject)
{
	ASNH225PresentationIndicator *pObj = (ASNH225PresentationIndicator *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PresentationIndicator_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225PresentationIndicatorChoice_presentationAllowed ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225PresentationIndicatorChoice_presentationRestricted ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225PresentationIndicatorChoice_addressNotAvailable ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PresentationIndicator_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225PresentationIndicator_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225PresentationIndicator Encode */
HS_RESULT ASNH225PresentationIndicator_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225PresentationIndicator *pObj = (ASNH225PresentationIndicator *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PresentationIndicator_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PresentationIndicator_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225PresentationIndicatorChoiceSize )
		{
			if( pObj->choice > ((ASNH225PresentationIndicatorChoice)(e_ASNH225PresentationIndicatorChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225PresentationIndicatorChoiceSize)) )
	}
	else
	{
		if( e_ASNH225PresentationIndicatorChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225PresentationIndicatorChoice_presentationAllowed ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PresentationIndicator_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PresentationIndicatorChoice_presentationRestricted ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PresentationIndicator_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PresentationIndicatorChoice_addressNotAvailable ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PresentationIndicator_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PresentationIndicator_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225PresentationIndicator Decode */
HS_RESULT ASNH225PresentationIndicator_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225PresentationIndicator *pObj = (ASNH225PresentationIndicator *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PresentationIndicator_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225PresentationIndicatorChoiceSize;
	}
	else
	{
		if( e_ASNH225PresentationIndicatorChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225PresentationIndicatorChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225PresentationIndicatorChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PresentationIndicator_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225PresentationIndicator_SetChoice( pObj, (ASNH225PresentationIndicatorChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PresentationIndicator_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225PresentationIndicatorChoice_presentationAllowed ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PresentationIndicator_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PresentationIndicatorChoice_presentationRestricted ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PresentationIndicator_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225PresentationIndicatorChoice_addressNotAvailable ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225PresentationIndicator_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225PresentationIndicator_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225PresentationIndicator Print */
HS_RESULT ASNH225PresentationIndicator_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225PresentationIndicator *pObj = (ASNH225PresentationIndicator *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225PresentationIndicator_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225PresentationIndicatorChoice_presentationAllowed ){
		AsnNull_Print( pObj->alter, pDepth+1, "presentationAllowed" );
	}
	else if ( pObj->choice == e_ASNH225PresentationIndicatorChoice_presentationRestricted ){
		AsnNull_Print( pObj->alter, pDepth+1, "presentationRestricted" );
	}
	else if ( pObj->choice == e_ASNH225PresentationIndicatorChoice_addressNotAvailable ){
		AsnNull_Print( pObj->alter, pDepth+1, "addressNotAvailable" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225CallCreditServiceControl_billingMode Struct
*/
/* ASNH225CallCreditServiceControl_billingMode Constructor */
HS_RESULT new_ASNH225CallCreditServiceControl_billingMode( void *pObject )
{
	ASNH225CallCreditServiceControl_billingMode *pObj = (ASNH225CallCreditServiceControl_billingMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225CallCreditServiceControl_billingMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225CallCreditServiceControl_billingModeChoice_credit;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225CallCreditServiceControl_billingModeChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225CallCreditServiceControl_billingMode Destructor */
HS_RESULT delete_ASNH225CallCreditServiceControl_billingMode( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225CallCreditServiceControl_billingMode *pObj = (ASNH225CallCreditServiceControl_billingMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225CallCreditServiceControl_billingMode(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225CallCreditServiceControl_billingMode_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225CallCreditServiceControl_billingMode(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225CallCreditServiceControl_billingMode SetChoice */
void* ASNH225CallCreditServiceControl_billingMode_SetChoice( void *pObject, ASNH225CallCreditServiceControl_billingModeChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225CallCreditServiceControl_billingMode *pObj = (ASNH225CallCreditServiceControl_billingMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_billingMode_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225CallCreditServiceControl_billingModeChoiceSizeExt ){
		if( pChoice > (ASNH225CallCreditServiceControl_billingModeChoice)(e_ASNH225CallCreditServiceControl_billingModeChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_billingMode_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225CallCreditServiceControl_billingMode_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_billingMode_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225CallCreditServiceControl_billingModeChoice_credit ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225CallCreditServiceControl_billingModeChoice_debit ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_billingMode_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225CallCreditServiceControl_billingMode DeleteAlternation */
HS_RESULT ASNH225CallCreditServiceControl_billingMode_DeleteAlternation(void *pObject)
{
	ASNH225CallCreditServiceControl_billingMode *pObj = (ASNH225CallCreditServiceControl_billingMode *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_billingMode_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225CallCreditServiceControl_billingModeChoice_credit ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225CallCreditServiceControl_billingModeChoice_debit ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_billingMode_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225CallCreditServiceControl_billingMode_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225CallCreditServiceControl_billingMode Encode */
HS_RESULT ASNH225CallCreditServiceControl_billingMode_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225CallCreditServiceControl_billingMode *pObj = (ASNH225CallCreditServiceControl_billingMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_billingMode_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_billingMode_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225CallCreditServiceControl_billingModeChoiceSize )
		{
			if( pObj->choice > ((ASNH225CallCreditServiceControl_billingModeChoice)(e_ASNH225CallCreditServiceControl_billingModeChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225CallCreditServiceControl_billingModeChoiceSize)) )
	}
	else
	{
		if( e_ASNH225CallCreditServiceControl_billingModeChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225CallCreditServiceControl_billingModeChoice_credit ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_billingMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225CallCreditServiceControl_billingModeChoice_debit ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_billingMode_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_billingMode_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225CallCreditServiceControl_billingMode Decode */
HS_RESULT ASNH225CallCreditServiceControl_billingMode_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225CallCreditServiceControl_billingMode *pObj = (ASNH225CallCreditServiceControl_billingMode *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_billingMode_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225CallCreditServiceControl_billingModeChoiceSize;
	}
	else
	{
		if( e_ASNH225CallCreditServiceControl_billingModeChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225CallCreditServiceControl_billingModeChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225CallCreditServiceControl_billingModeChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_billingMode_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225CallCreditServiceControl_billingMode_SetChoice( pObj, (ASNH225CallCreditServiceControl_billingModeChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_billingMode_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225CallCreditServiceControl_billingModeChoice_credit ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_billingMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225CallCreditServiceControl_billingModeChoice_debit ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_billingMode_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_billingMode_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225CallCreditServiceControl_billingMode Print */
HS_RESULT ASNH225CallCreditServiceControl_billingMode_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225CallCreditServiceControl_billingMode *pObj = (ASNH225CallCreditServiceControl_billingMode *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_billingMode_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225CallCreditServiceControl_billingModeChoice_credit ){
		AsnNull_Print( pObj->alter, pDepth+1, "credit" );
	}
	else if ( pObj->choice == e_ASNH225CallCreditServiceControl_billingModeChoice_debit ){
		AsnNull_Print( pObj->alter, pDepth+1, "debit" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225CallCreditServiceControl_callStartingPoint Struct
*/
/* ASNH225CallCreditServiceControl_callStartingPoint Constructor */
HS_RESULT new_ASNH225CallCreditServiceControl_callStartingPoint( void *pObject )
{
	ASNH225CallCreditServiceControl_callStartingPoint *pObj = (ASNH225CallCreditServiceControl_callStartingPoint *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225CallCreditServiceControl_callStartingPoint(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225CallCreditServiceControl_callStartingPointChoice_alerting;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225CallCreditServiceControl_callStartingPointChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225CallCreditServiceControl_callStartingPoint Destructor */
HS_RESULT delete_ASNH225CallCreditServiceControl_callStartingPoint( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225CallCreditServiceControl_callStartingPoint *pObj = (ASNH225CallCreditServiceControl_callStartingPoint *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225CallCreditServiceControl_callStartingPoint(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225CallCreditServiceControl_callStartingPoint_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225CallCreditServiceControl_callStartingPoint(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225CallCreditServiceControl_callStartingPoint SetChoice */
void* ASNH225CallCreditServiceControl_callStartingPoint_SetChoice( void *pObject, ASNH225CallCreditServiceControl_callStartingPointChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225CallCreditServiceControl_callStartingPoint *pObj = (ASNH225CallCreditServiceControl_callStartingPoint *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_callStartingPoint_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225CallCreditServiceControl_callStartingPointChoiceSizeExt ){
		if( pChoice > (ASNH225CallCreditServiceControl_callStartingPointChoice)(e_ASNH225CallCreditServiceControl_callStartingPointChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_callStartingPoint_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225CallCreditServiceControl_callStartingPoint_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_callStartingPoint_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225CallCreditServiceControl_callStartingPointChoice_alerting ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225CallCreditServiceControl_callStartingPointChoice_connect ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_callStartingPoint_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225CallCreditServiceControl_callStartingPoint DeleteAlternation */
HS_RESULT ASNH225CallCreditServiceControl_callStartingPoint_DeleteAlternation(void *pObject)
{
	ASNH225CallCreditServiceControl_callStartingPoint *pObj = (ASNH225CallCreditServiceControl_callStartingPoint *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_callStartingPoint_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225CallCreditServiceControl_callStartingPointChoice_alerting ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225CallCreditServiceControl_callStartingPointChoice_connect ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_callStartingPoint_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225CallCreditServiceControl_callStartingPoint_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225CallCreditServiceControl_callStartingPoint Encode */
HS_RESULT ASNH225CallCreditServiceControl_callStartingPoint_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225CallCreditServiceControl_callStartingPoint *pObj = (ASNH225CallCreditServiceControl_callStartingPoint *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_callStartingPoint_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_callStartingPoint_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225CallCreditServiceControl_callStartingPointChoiceSize )
		{
			if( pObj->choice > ((ASNH225CallCreditServiceControl_callStartingPointChoice)(e_ASNH225CallCreditServiceControl_callStartingPointChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225CallCreditServiceControl_callStartingPointChoiceSize)) )
	}
	else
	{
		if( e_ASNH225CallCreditServiceControl_callStartingPointChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225CallCreditServiceControl_callStartingPointChoice_alerting ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_callStartingPoint_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225CallCreditServiceControl_callStartingPointChoice_connect ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_callStartingPoint_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_callStartingPoint_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225CallCreditServiceControl_callStartingPoint Decode */
HS_RESULT ASNH225CallCreditServiceControl_callStartingPoint_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225CallCreditServiceControl_callStartingPoint *pObj = (ASNH225CallCreditServiceControl_callStartingPoint *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_callStartingPoint_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225CallCreditServiceControl_callStartingPointChoiceSize;
	}
	else
	{
		if( e_ASNH225CallCreditServiceControl_callStartingPointChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225CallCreditServiceControl_callStartingPointChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225CallCreditServiceControl_callStartingPointChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_callStartingPoint_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225CallCreditServiceControl_callStartingPoint_SetChoice( pObj, (ASNH225CallCreditServiceControl_callStartingPointChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_callStartingPoint_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225CallCreditServiceControl_callStartingPointChoice_alerting ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_callStartingPoint_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225CallCreditServiceControl_callStartingPointChoice_connect ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_callStartingPoint_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_callStartingPoint_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225CallCreditServiceControl_callStartingPoint Print */
HS_RESULT ASNH225CallCreditServiceControl_callStartingPoint_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225CallCreditServiceControl_callStartingPoint *pObj = (ASNH225CallCreditServiceControl_callStartingPoint *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_callStartingPoint_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225CallCreditServiceControl_callStartingPointChoice_alerting ){
		AsnNull_Print( pObj->alter, pDepth+1, "alerting" );
	}
	else if ( pObj->choice == e_ASNH225CallCreditServiceControl_callStartingPointChoice_connect ){
		AsnNull_Print( pObj->alter, pDepth+1, "connect" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225CallCreditServiceControl Class
*/
/*ASNH225CallCreditServiceControl Constructor*/
HS_RESULT new_ASNH225CallCreditServiceControl(void *pObject)
{
	ASNH225CallCreditServiceControl *pObj = (ASNH225CallCreditServiceControl *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225CallCreditServiceControl(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnDoubleString( &(pObj->m_amountString), e_asnTagBMPString, e_constrained, 1, 512, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH225CallCreditServiceControl_billingMode( &(pObj->m_billingMode) );
	new_AsnInteger( &(pObj->m_callDurationLimit), e_constrained, 1, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_enforceCallDurationLimit) );
	new_ASNH225CallCreditServiceControl_callStartingPoint( &(pObj->m_callStartingPoint) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225CallCreditServiceControl Destructor */
HS_RESULT delete_ASNH225CallCreditServiceControl(void *pObject)
{
	ASNH225CallCreditServiceControl *pObj = (ASNH225CallCreditServiceControl *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225CallCreditServiceControl(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnDoubleString( &(pObj->m_amountString) );
	delete_ASNH225CallCreditServiceControl_billingMode( &(pObj->m_billingMode) );
	delete_AsnInteger( &(pObj->m_callDurationLimit) );
	delete_AsnBoolean( &(pObj->m_enforceCallDurationLimit) );
	delete_ASNH225CallCreditServiceControl_callStartingPoint( &(pObj->m_callStartingPoint) );
	return HS_OK;
}

/* ASNH225CallCreditServiceControl MakeMold */
HS_RESULT ASNH225CallCreditServiceControl_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225CallCreditServiceControl *pObj = (ASNH225CallCreditServiceControl *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH225CallCreditServiceControl IncludeOptionalField */
HS_RESULT ASNH225CallCreditServiceControl_IncludeOptionField( void *pObject, ASNH225CallCreditServiceControlOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225CallCreditServiceControl *pObj = (ASNH225CallCreditServiceControl *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225CallCreditServiceControlOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225CallCreditServiceControl IsIncludeOptionalField */
BOOL ASNH225CallCreditServiceControl_IsIncludeOptionField( void *pObject, ASNH225CallCreditServiceControlOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225CallCreditServiceControl *pObj = (ASNH225CallCreditServiceControl *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225CallCreditServiceControlOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225CallCreditServiceControl Encode */
HS_RESULT ASNH225CallCreditServiceControl_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225CallCreditServiceControl *pObj = (ASNH225CallCreditServiceControl *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225CallCreditServiceControlOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225CallCreditServiceControlOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225CallCreditServiceControl_IsIncludeOptionField( pObj, e_ASNH225CallCreditServiceControlOptionMap_amountString ) ){
		if( (tRet=AsnDoubleString_Encode( &(pObj->m_amountString),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCreditServiceControl_IsIncludeOptionField( pObj, e_ASNH225CallCreditServiceControlOptionMap_billingMode ) ){
		if( (tRet=ASNH225CallCreditServiceControl_billingMode_Encode( &(pObj->m_billingMode),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCreditServiceControl_IsIncludeOptionField( pObj, e_ASNH225CallCreditServiceControlOptionMap_callDurationLimit ) ){
		if( (tRet=AsnInteger_Encode( &(pObj->m_callDurationLimit),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCreditServiceControl_IsIncludeOptionField( pObj, e_ASNH225CallCreditServiceControlOptionMap_enforceCallDurationLimit ) ){
		if( (tRet=AsnBoolean_Encode( &(pObj->m_enforceCallDurationLimit),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCreditServiceControl_IsIncludeOptionField( pObj, e_ASNH225CallCreditServiceControlOptionMap_callStartingPoint ) ){
		if( (tRet=ASNH225CallCreditServiceControl_callStartingPoint_Encode( &(pObj->m_callStartingPoint),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225CallCreditServiceControl Decode */
HS_RESULT ASNH225CallCreditServiceControl_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225CallCreditServiceControl *pObj = (ASNH225CallCreditServiceControl *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225CallCreditServiceControlOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225CallCreditServiceControlOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225CallCreditServiceControl_IsIncludeOptionField( pObj, e_ASNH225CallCreditServiceControlOptionMap_amountString ) ){
		if( (tRet=AsnDoubleString_Decode(&(pObj->m_amountString),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCreditServiceControl_IsIncludeOptionField( pObj, e_ASNH225CallCreditServiceControlOptionMap_billingMode ) ){
		if( (tRet=ASNH225CallCreditServiceControl_billingMode_Decode(&(pObj->m_billingMode),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCreditServiceControl_IsIncludeOptionField( pObj, e_ASNH225CallCreditServiceControlOptionMap_callDurationLimit ) ){
		if( (tRet=AsnInteger_Decode(&(pObj->m_callDurationLimit),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCreditServiceControl_IsIncludeOptionField( pObj, e_ASNH225CallCreditServiceControlOptionMap_enforceCallDurationLimit ) ){
		if( (tRet=AsnBoolean_Decode(&(pObj->m_enforceCallDurationLimit),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCreditServiceControl_IsIncludeOptionField( pObj, e_ASNH225CallCreditServiceControlOptionMap_callStartingPoint ) ){
		if( (tRet=ASNH225CallCreditServiceControl_callStartingPoint_Decode(&(pObj->m_callStartingPoint),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCreditServiceControl_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225CallCreditServiceControl Print */
HS_RESULT ASNH225CallCreditServiceControl_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225CallCreditServiceControl *pObj = (ASNH225CallCreditServiceControl *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225CallCreditServiceControl_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225CallCreditServiceControl_IsIncludeOptionField( pObj, e_ASNH225CallCreditServiceControlOptionMap_amountString ) )
		AsnDoubleString_Print( &(pObj->m_amountString), pDepth+1, "amountString" );
	if( ASNH225CallCreditServiceControl_IsIncludeOptionField( pObj, e_ASNH225CallCreditServiceControlOptionMap_billingMode ) )
		ASNH225CallCreditServiceControl_billingMode_Print( &(pObj->m_billingMode), pDepth+1, "billingMode" );
	if( ASNH225CallCreditServiceControl_IsIncludeOptionField( pObj, e_ASNH225CallCreditServiceControlOptionMap_callDurationLimit ) )
		AsnInteger_Print( &(pObj->m_callDurationLimit), pDepth+1, "callDurationLimit" );
	if( ASNH225CallCreditServiceControl_IsIncludeOptionField( pObj, e_ASNH225CallCreditServiceControlOptionMap_enforceCallDurationLimit ) )
		AsnBoolean_Print( &(pObj->m_enforceCallDurationLimit), pDepth+1, "enforceCallDurationLimit" );
	if( ASNH225CallCreditServiceControl_IsIncludeOptionField( pObj, e_ASNH225CallCreditServiceControlOptionMap_callStartingPoint ) )
		ASNH225CallCreditServiceControl_callStartingPoint_Print( &(pObj->m_callStartingPoint), pDepth+1, "callStartingPoint" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225ServiceControlDescriptor Struct
*/
/* ASNH225ServiceControlDescriptor Constructor */
HS_RESULT new_ASNH225ServiceControlDescriptor( void *pObject )
{
	ASNH225ServiceControlDescriptor *pObj = (ASNH225ServiceControlDescriptor *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225ServiceControlDescriptor(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225ServiceControlDescriptorChoice_url;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225ServiceControlDescriptorChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225ServiceControlDescriptor Destructor */
HS_RESULT delete_ASNH225ServiceControlDescriptor( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225ServiceControlDescriptor *pObj = (ASNH225ServiceControlDescriptor *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ServiceControlDescriptor(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225ServiceControlDescriptor_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ServiceControlDescriptor(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225ServiceControlDescriptor SetChoice */
void* ASNH225ServiceControlDescriptor_SetChoice( void *pObject, ASNH225ServiceControlDescriptorChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225ServiceControlDescriptor *pObj = (ASNH225ServiceControlDescriptor *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlDescriptor_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225ServiceControlDescriptorChoiceSizeExt ){
		if( pChoice > (ASNH225ServiceControlDescriptorChoice)(e_ASNH225ServiceControlDescriptorChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlDescriptor_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225ServiceControlDescriptor_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlDescriptor_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225ServiceControlDescriptorChoice_url ){
		AsnSingleString *tAlter = (AsnSingleString *)HSMalloc( sizeof(AsnSingleString) );
		new_AsnSingleString(tAlter,e_asnTagIA5String,e_constrained,0,512,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ServiceControlDescriptorChoice_signal ){
		ASNH225H248SignalsDescriptor *tAlter = (ASNH225H248SignalsDescriptor *)HSMalloc( sizeof(ASNH225H248SignalsDescriptor) );
		new_ASNH225H248SignalsDescriptor(tAlter);
		ASNH225H248SignalsDescriptor_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ServiceControlDescriptorChoice_nonStandard ){
		ASNH225NonStandardParameter *tAlter = (ASNH225NonStandardParameter *)HSMalloc( sizeof(ASNH225NonStandardParameter) );
		new_ASNH225NonStandardParameter(tAlter);
		ASNH225NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ServiceControlDescriptorChoice_callCreditServiceControl ){
		ASNH225CallCreditServiceControl *tAlter = (ASNH225CallCreditServiceControl *)HSMalloc( sizeof(ASNH225CallCreditServiceControl) );
		new_ASNH225CallCreditServiceControl(tAlter);
		ASNH225CallCreditServiceControl_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlDescriptor_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225ServiceControlDescriptor DeleteAlternation */
HS_RESULT ASNH225ServiceControlDescriptor_DeleteAlternation(void *pObject)
{
	ASNH225ServiceControlDescriptor *pObj = (ASNH225ServiceControlDescriptor *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlDescriptor_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225ServiceControlDescriptorChoice_url ){
			delete_AsnSingleString(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ServiceControlDescriptorChoice_signal ){
			delete_ASNH225H248SignalsDescriptor(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ServiceControlDescriptorChoice_nonStandard ){
			delete_ASNH225NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ServiceControlDescriptorChoice_callCreditServiceControl ){
			delete_ASNH225CallCreditServiceControl(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlDescriptor_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225ServiceControlDescriptor_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225ServiceControlDescriptor Encode */
HS_RESULT ASNH225ServiceControlDescriptor_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225ServiceControlDescriptor *pObj = (ASNH225ServiceControlDescriptor *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlDescriptor_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlDescriptor_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225ServiceControlDescriptorChoiceSize )
		{
			if( pObj->choice > ((ASNH225ServiceControlDescriptorChoice)(e_ASNH225ServiceControlDescriptorChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225ServiceControlDescriptorChoiceSize)) )
	}
	else
	{
		if( e_ASNH225ServiceControlDescriptorChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ServiceControlDescriptorChoice_url ){
		if( (tRet=AsnSingleString_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlDescriptor_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ServiceControlDescriptorChoice_signal ){
		if( (tRet=ASNH225H248SignalsDescriptor_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlDescriptor_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ServiceControlDescriptorChoice_nonStandard ){
		if( (tRet=ASNH225NonStandardParameter_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlDescriptor_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ServiceControlDescriptorChoice_callCreditServiceControl ){
		if( (tRet=ASNH225CallCreditServiceControl_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlDescriptor_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlDescriptor_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225ServiceControlDescriptor Decode */
HS_RESULT ASNH225ServiceControlDescriptor_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225ServiceControlDescriptor *pObj = (ASNH225ServiceControlDescriptor *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlDescriptor_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225ServiceControlDescriptorChoiceSize;
	}
	else
	{
		if( e_ASNH225ServiceControlDescriptorChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225ServiceControlDescriptorChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225ServiceControlDescriptorChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlDescriptor_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225ServiceControlDescriptor_SetChoice( pObj, (ASNH225ServiceControlDescriptorChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlDescriptor_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ServiceControlDescriptorChoice_url ){
		if( (tRet=AsnSingleString_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlDescriptor_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ServiceControlDescriptorChoice_signal ){
		if( (tRet=ASNH225H248SignalsDescriptor_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlDescriptor_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ServiceControlDescriptorChoice_nonStandard ){
		if( (tRet=ASNH225NonStandardParameter_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlDescriptor_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ServiceControlDescriptorChoice_callCreditServiceControl ){
		if( (tRet=ASNH225CallCreditServiceControl_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlDescriptor_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlDescriptor_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225ServiceControlDescriptor Print */
HS_RESULT ASNH225ServiceControlDescriptor_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225ServiceControlDescriptor *pObj = (ASNH225ServiceControlDescriptor *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225ServiceControlDescriptor_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ServiceControlDescriptorChoice_url ){
		AsnSingleString_Print( pObj->alter, pDepth+1, "url" );
	}
	else if ( pObj->choice == e_ASNH225ServiceControlDescriptorChoice_signal ){
		ASNH225H248SignalsDescriptor_Print( pObj->alter, pDepth+1, "signal" );
	}
	else if ( pObj->choice == e_ASNH225ServiceControlDescriptorChoice_nonStandard ){
		ASNH225NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	else if ( pObj->choice == e_ASNH225ServiceControlDescriptorChoice_callCreditServiceControl ){
		ASNH225CallCreditServiceControl_Print( pObj->alter, pDepth+1, "callCreditServiceControl" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225ServiceControlSession_reason Struct
*/
/* ASNH225ServiceControlSession_reason Constructor */
HS_RESULT new_ASNH225ServiceControlSession_reason( void *pObject )
{
	ASNH225ServiceControlSession_reason *pObj = (ASNH225ServiceControlSession_reason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225ServiceControlSession_reason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225ServiceControlSession_reasonChoice_open;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225ServiceControlSession_reasonChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225ServiceControlSession_reason Destructor */
HS_RESULT delete_ASNH225ServiceControlSession_reason( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225ServiceControlSession_reason *pObj = (ASNH225ServiceControlSession_reason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ServiceControlSession_reason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225ServiceControlSession_reason_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ServiceControlSession_reason(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225ServiceControlSession_reason SetChoice */
void* ASNH225ServiceControlSession_reason_SetChoice( void *pObject, ASNH225ServiceControlSession_reasonChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225ServiceControlSession_reason *pObj = (ASNH225ServiceControlSession_reason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlSession_reason_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225ServiceControlSession_reasonChoiceSizeExt ){
		if( pChoice > (ASNH225ServiceControlSession_reasonChoice)(e_ASNH225ServiceControlSession_reasonChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlSession_reason_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225ServiceControlSession_reason_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlSession_reason_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225ServiceControlSession_reasonChoice_open ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ServiceControlSession_reasonChoice_refresh ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ServiceControlSession_reasonChoice_close ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlSession_reason_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225ServiceControlSession_reason DeleteAlternation */
HS_RESULT ASNH225ServiceControlSession_reason_DeleteAlternation(void *pObject)
{
	ASNH225ServiceControlSession_reason *pObj = (ASNH225ServiceControlSession_reason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlSession_reason_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225ServiceControlSession_reasonChoice_open ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ServiceControlSession_reasonChoice_refresh ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ServiceControlSession_reasonChoice_close ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlSession_reason_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225ServiceControlSession_reason_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225ServiceControlSession_reason Encode */
HS_RESULT ASNH225ServiceControlSession_reason_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225ServiceControlSession_reason *pObj = (ASNH225ServiceControlSession_reason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlSession_reason_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlSession_reason_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225ServiceControlSession_reasonChoiceSize )
		{
			if( pObj->choice > ((ASNH225ServiceControlSession_reasonChoice)(e_ASNH225ServiceControlSession_reasonChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225ServiceControlSession_reasonChoiceSize)) )
	}
	else
	{
		if( e_ASNH225ServiceControlSession_reasonChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ServiceControlSession_reasonChoice_open ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlSession_reason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ServiceControlSession_reasonChoice_refresh ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlSession_reason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ServiceControlSession_reasonChoice_close ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlSession_reason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlSession_reason_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225ServiceControlSession_reason Decode */
HS_RESULT ASNH225ServiceControlSession_reason_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225ServiceControlSession_reason *pObj = (ASNH225ServiceControlSession_reason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlSession_reason_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225ServiceControlSession_reasonChoiceSize;
	}
	else
	{
		if( e_ASNH225ServiceControlSession_reasonChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225ServiceControlSession_reasonChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225ServiceControlSession_reasonChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlSession_reason_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225ServiceControlSession_reason_SetChoice( pObj, (ASNH225ServiceControlSession_reasonChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlSession_reason_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ServiceControlSession_reasonChoice_open ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlSession_reason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ServiceControlSession_reasonChoice_refresh ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlSession_reason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ServiceControlSession_reasonChoice_close ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlSession_reason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlSession_reason_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225ServiceControlSession_reason Print */
HS_RESULT ASNH225ServiceControlSession_reason_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225ServiceControlSession_reason *pObj = (ASNH225ServiceControlSession_reason *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225ServiceControlSession_reason_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ServiceControlSession_reasonChoice_open ){
		AsnNull_Print( pObj->alter, pDepth+1, "open" );
	}
	else if ( pObj->choice == e_ASNH225ServiceControlSession_reasonChoice_refresh ){
		AsnNull_Print( pObj->alter, pDepth+1, "refresh" );
	}
	else if ( pObj->choice == e_ASNH225ServiceControlSession_reasonChoice_close ){
		AsnNull_Print( pObj->alter, pDepth+1, "close" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225ServiceControlSession Class
*/
/*ASNH225ServiceControlSession Constructor*/
HS_RESULT new_ASNH225ServiceControlSession(void *pObject)
{
	ASNH225ServiceControlSession *pObj = (ASNH225ServiceControlSession *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225ServiceControlSession(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_sessionId), e_constrained, 0, 255, 0, HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ServiceControlDescriptor( &(pObj->m_contents) );
	new_ASNH225ServiceControlSession_reason( &(pObj->m_reason) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225ServiceControlSession Destructor */
HS_RESULT delete_ASNH225ServiceControlSession(void *pObject)
{
	ASNH225ServiceControlSession *pObj = (ASNH225ServiceControlSession *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ServiceControlSession(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_sessionId) );
	delete_ASNH225ServiceControlDescriptor( &(pObj->m_contents) );
	delete_ASNH225ServiceControlSession_reason( &(pObj->m_reason) );
	return HS_OK;
}

/* ASNH225ServiceControlSession MakeMold */
HS_RESULT ASNH225ServiceControlSession_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225ServiceControlSession *pObj = (ASNH225ServiceControlSession *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlSession_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225ServiceControlDescriptor_MakeMold(&(pObj->m_contents));
	return HS_OK;
}

/* ASNH225ServiceControlSession IncludeOptionalField */
HS_RESULT ASNH225ServiceControlSession_IncludeOptionField( void *pObject, ASNH225ServiceControlSessionOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225ServiceControlSession *pObj = (ASNH225ServiceControlSession *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlSession_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225ServiceControlSessionOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225ServiceControlSession IsIncludeOptionalField */
BOOL ASNH225ServiceControlSession_IsIncludeOptionField( void *pObject, ASNH225ServiceControlSessionOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225ServiceControlSession *pObj = (ASNH225ServiceControlSession *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlSession_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225ServiceControlSessionOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225ServiceControlSession Encode */
HS_RESULT ASNH225ServiceControlSession_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225ServiceControlSession *pObj = (ASNH225ServiceControlSession *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlSession_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225ServiceControlSessionOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225ServiceControlSessionOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnInteger_Encode( &(pObj->m_sessionId),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlSession_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225ServiceControlSession_IsIncludeOptionField( pObj, e_ASNH225ServiceControlSessionOptionMap_contents ) ){
		if( (tRet=ASNH225ServiceControlDescriptor_Encode( &(pObj->m_contents),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlSession_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225ServiceControlSession_reason_Encode( &(pObj->m_reason),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlSession_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225ServiceControlSession Decode */
HS_RESULT ASNH225ServiceControlSession_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225ServiceControlSession *pObj = (ASNH225ServiceControlSession *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlSession_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225ServiceControlSessionOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225ServiceControlSessionOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_sessionId),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlSession_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225ServiceControlSession_IsIncludeOptionField( pObj, e_ASNH225ServiceControlSessionOptionMap_contents ) ){
		if( (tRet=ASNH225ServiceControlDescriptor_Decode(&(pObj->m_contents),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ServiceControlSession_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225ServiceControlSession_reason_Decode(&(pObj->m_reason),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ServiceControlSession_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225ServiceControlSession Print */
HS_RESULT ASNH225ServiceControlSession_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225ServiceControlSession *pObj = (ASNH225ServiceControlSession *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225ServiceControlSession_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_sessionId), pDepth+1, "sessionId" );
	if( ASNH225ServiceControlSession_IsIncludeOptionField( pObj, e_ASNH225ServiceControlSessionOptionMap_contents ) )
		ASNH225ServiceControlDescriptor_Print( &(pObj->m_contents), pDepth+1, "contents" );
	ASNH225ServiceControlSession_reason_Print( &(pObj->m_reason), pDepth+1, "reason" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225CallsAvailable Class
*/
/*ASNH225CallsAvailable Constructor*/
HS_RESULT new_ASNH225CallsAvailable(void *pObject)
{
	ASNH225CallsAvailable *pObj = (ASNH225CallsAvailable *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225CallsAvailable(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnInteger( &(pObj->m_calls), e_constrained, 0, HS_ASN_MAX_CONSTRAINT, 0, HS_ASN_MAX_CONSTRAINT );
	new_AsnSingleString( &(pObj->m_group), e_asnTagIA5String, e_constrained, 1, 128, 0, HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225CallsAvailable Destructor */
HS_RESULT delete_ASNH225CallsAvailable(void *pObject)
{
	ASNH225CallsAvailable *pObj = (ASNH225CallsAvailable *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225CallsAvailable(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnInteger( &(pObj->m_calls) );
	delete_AsnSingleString( &(pObj->m_group) );
	return HS_OK;
}

/* ASNH225CallsAvailable MakeMold */
HS_RESULT ASNH225CallsAvailable_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225CallsAvailable *pObj = (ASNH225CallsAvailable *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallsAvailable_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	return HS_OK;
}

/* ASNH225CallsAvailable IncludeOptionalField */
HS_RESULT ASNH225CallsAvailable_IncludeOptionField( void *pObject, ASNH225CallsAvailableOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225CallsAvailable *pObj = (ASNH225CallsAvailable *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallsAvailable_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225CallsAvailableOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225CallsAvailable IsIncludeOptionalField */
BOOL ASNH225CallsAvailable_IsIncludeOptionField( void *pObject, ASNH225CallsAvailableOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225CallsAvailable *pObj = (ASNH225CallsAvailable *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallsAvailable_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225CallsAvailableOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225CallsAvailable Encode */
HS_RESULT ASNH225CallsAvailable_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225CallsAvailable *pObj = (ASNH225CallsAvailable *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallsAvailable_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225CallsAvailableOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225CallsAvailableOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnInteger_Encode( &(pObj->m_calls),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallsAvailable_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225CallsAvailable_IsIncludeOptionField( pObj, e_ASNH225CallsAvailableOptionMap_group ) ){
		if( (tRet=AsnSingleString_Encode( &(pObj->m_group),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallsAvailable_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225CallsAvailable Decode */
HS_RESULT ASNH225CallsAvailable_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225CallsAvailable *pObj = (ASNH225CallsAvailable *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallsAvailable_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225CallsAvailableOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225CallsAvailableOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnInteger_Decode(&(pObj->m_calls),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallsAvailable_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225CallsAvailable_IsIncludeOptionField( pObj, e_ASNH225CallsAvailableOptionMap_group ) ){
		if( (tRet=AsnSingleString_Decode(&(pObj->m_group),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallsAvailable_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225CallsAvailable Print */
HS_RESULT ASNH225CallsAvailable_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225CallsAvailable *pObj = (ASNH225CallsAvailable *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225CallsAvailable_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnInteger_Print( &(pObj->m_calls), pDepth+1, "calls" );
	if( ASNH225CallsAvailable_IsIncludeOptionField( pObj, e_ASNH225CallsAvailableOptionMap_group ) )
		AsnSingleString_Print( &(pObj->m_group), pDepth+1, "group" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225CallCapacityInfo Class
*/
/*ASNH225CallCapacityInfo Constructor*/
HS_RESULT new_ASNH225CallCapacityInfo(void *pObject)
{
	ASNH225CallCapacityInfo *pObj = (ASNH225CallCapacityInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225CallCapacityInfo(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnSequenceOf( &(pObj->m_voiceGwCallsAvailable), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_h310GwCallsAvailable), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_h320GwCallsAvailable), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_h321GwCallsAvailable), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_h322GwCallsAvailable), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_h323GwCallsAvailable), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_h324GwCallsAvailable), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_t120OnlyGwCallsAvailable), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_t38FaxAnnexbOnlyGwCallsAvailable), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_terminalCallsAvailable), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_mcuCallsAvailable), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225CallCapacityInfo Destructor */
HS_RESULT delete_ASNH225CallCapacityInfo(void *pObject)
{
	ASNH225CallCapacityInfo *pObj = (ASNH225CallCapacityInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225CallCapacityInfo(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnSequenceOf( &(pObj->m_voiceGwCallsAvailable) );
	delete_AsnSequenceOf( &(pObj->m_h310GwCallsAvailable) );
	delete_AsnSequenceOf( &(pObj->m_h320GwCallsAvailable) );
	delete_AsnSequenceOf( &(pObj->m_h321GwCallsAvailable) );
	delete_AsnSequenceOf( &(pObj->m_h322GwCallsAvailable) );
	delete_AsnSequenceOf( &(pObj->m_h323GwCallsAvailable) );
	delete_AsnSequenceOf( &(pObj->m_h324GwCallsAvailable) );
	delete_AsnSequenceOf( &(pObj->m_t120OnlyGwCallsAvailable) );
	delete_AsnSequenceOf( &(pObj->m_t38FaxAnnexbOnlyGwCallsAvailable) );
	delete_AsnSequenceOf( &(pObj->m_terminalCallsAvailable) );
	delete_AsnSequenceOf( &(pObj->m_mcuCallsAvailable) );
	return HS_OK;
}

/* ASNH225CallCapacityInfo MakeMold */
HS_RESULT ASNH225CallCapacityInfo_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225CallCapacityInfo *pObj = (ASNH225CallCapacityInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCapacityInfo_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	ASNH225CallsAvailable *tmold_voiceGwCallsAvailable = (ASNH225CallsAvailable *)HSMalloc( sizeof(ASNH225CallsAvailable) );
	new_ASNH225CallsAvailable(tmold_voiceGwCallsAvailable);
	ASNH225CallsAvailable_MakeMold(tmold_voiceGwCallsAvailable);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_voiceGwCallsAvailable,sizeof(ASNH225CallsAvailable),ASNH225CallsAvailable_MakeMold,ASNH225CallsAvailable_Encode,ASNH225CallsAvailable_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CallsAvailable_Print,
#endif
		delete_ASNH225CallsAvailable);
	AsnSequenceOf_SetMold( &(pObj->m_voiceGwCallsAvailable), moldObject );
	}
	{
	ASNH225CallsAvailable *tmold_h310GwCallsAvailable = (ASNH225CallsAvailable *)HSMalloc( sizeof(ASNH225CallsAvailable) );
	new_ASNH225CallsAvailable(tmold_h310GwCallsAvailable);
	ASNH225CallsAvailable_MakeMold(tmold_h310GwCallsAvailable);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_h310GwCallsAvailable,sizeof(ASNH225CallsAvailable),ASNH225CallsAvailable_MakeMold,ASNH225CallsAvailable_Encode,ASNH225CallsAvailable_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CallsAvailable_Print,
#endif
		delete_ASNH225CallsAvailable);
	AsnSequenceOf_SetMold( &(pObj->m_h310GwCallsAvailable), moldObject );
	}
	{
	ASNH225CallsAvailable *tmold_h320GwCallsAvailable = (ASNH225CallsAvailable *)HSMalloc( sizeof(ASNH225CallsAvailable) );
	new_ASNH225CallsAvailable(tmold_h320GwCallsAvailable);
	ASNH225CallsAvailable_MakeMold(tmold_h320GwCallsAvailable);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_h320GwCallsAvailable,sizeof(ASNH225CallsAvailable),ASNH225CallsAvailable_MakeMold,ASNH225CallsAvailable_Encode,ASNH225CallsAvailable_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CallsAvailable_Print,
#endif
		delete_ASNH225CallsAvailable);
	AsnSequenceOf_SetMold( &(pObj->m_h320GwCallsAvailable), moldObject );
	}
	{
	ASNH225CallsAvailable *tmold_h321GwCallsAvailable = (ASNH225CallsAvailable *)HSMalloc( sizeof(ASNH225CallsAvailable) );
	new_ASNH225CallsAvailable(tmold_h321GwCallsAvailable);
	ASNH225CallsAvailable_MakeMold(tmold_h321GwCallsAvailable);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_h321GwCallsAvailable,sizeof(ASNH225CallsAvailable),ASNH225CallsAvailable_MakeMold,ASNH225CallsAvailable_Encode,ASNH225CallsAvailable_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CallsAvailable_Print,
#endif
		delete_ASNH225CallsAvailable);
	AsnSequenceOf_SetMold( &(pObj->m_h321GwCallsAvailable), moldObject );
	}
	{
	ASNH225CallsAvailable *tmold_h322GwCallsAvailable = (ASNH225CallsAvailable *)HSMalloc( sizeof(ASNH225CallsAvailable) );
	new_ASNH225CallsAvailable(tmold_h322GwCallsAvailable);
	ASNH225CallsAvailable_MakeMold(tmold_h322GwCallsAvailable);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_h322GwCallsAvailable,sizeof(ASNH225CallsAvailable),ASNH225CallsAvailable_MakeMold,ASNH225CallsAvailable_Encode,ASNH225CallsAvailable_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CallsAvailable_Print,
#endif
		delete_ASNH225CallsAvailable);
	AsnSequenceOf_SetMold( &(pObj->m_h322GwCallsAvailable), moldObject );
	}
	{
	ASNH225CallsAvailable *tmold_h323GwCallsAvailable = (ASNH225CallsAvailable *)HSMalloc( sizeof(ASNH225CallsAvailable) );
	new_ASNH225CallsAvailable(tmold_h323GwCallsAvailable);
	ASNH225CallsAvailable_MakeMold(tmold_h323GwCallsAvailable);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_h323GwCallsAvailable,sizeof(ASNH225CallsAvailable),ASNH225CallsAvailable_MakeMold,ASNH225CallsAvailable_Encode,ASNH225CallsAvailable_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CallsAvailable_Print,
#endif
		delete_ASNH225CallsAvailable);
	AsnSequenceOf_SetMold( &(pObj->m_h323GwCallsAvailable), moldObject );
	}
	{
	ASNH225CallsAvailable *tmold_h324GwCallsAvailable = (ASNH225CallsAvailable *)HSMalloc( sizeof(ASNH225CallsAvailable) );
	new_ASNH225CallsAvailable(tmold_h324GwCallsAvailable);
	ASNH225CallsAvailable_MakeMold(tmold_h324GwCallsAvailable);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_h324GwCallsAvailable,sizeof(ASNH225CallsAvailable),ASNH225CallsAvailable_MakeMold,ASNH225CallsAvailable_Encode,ASNH225CallsAvailable_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CallsAvailable_Print,
#endif
		delete_ASNH225CallsAvailable);
	AsnSequenceOf_SetMold( &(pObj->m_h324GwCallsAvailable), moldObject );
	}
	{
	ASNH225CallsAvailable *tmold_t120OnlyGwCallsAvailable = (ASNH225CallsAvailable *)HSMalloc( sizeof(ASNH225CallsAvailable) );
	new_ASNH225CallsAvailable(tmold_t120OnlyGwCallsAvailable);
	ASNH225CallsAvailable_MakeMold(tmold_t120OnlyGwCallsAvailable);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_t120OnlyGwCallsAvailable,sizeof(ASNH225CallsAvailable),ASNH225CallsAvailable_MakeMold,ASNH225CallsAvailable_Encode,ASNH225CallsAvailable_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CallsAvailable_Print,
#endif
		delete_ASNH225CallsAvailable);
	AsnSequenceOf_SetMold( &(pObj->m_t120OnlyGwCallsAvailable), moldObject );
	}
	{
	ASNH225CallsAvailable *tmold_t38FaxAnnexbOnlyGwCallsAvailable = (ASNH225CallsAvailable *)HSMalloc( sizeof(ASNH225CallsAvailable) );
	new_ASNH225CallsAvailable(tmold_t38FaxAnnexbOnlyGwCallsAvailable);
	ASNH225CallsAvailable_MakeMold(tmold_t38FaxAnnexbOnlyGwCallsAvailable);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_t38FaxAnnexbOnlyGwCallsAvailable,sizeof(ASNH225CallsAvailable),ASNH225CallsAvailable_MakeMold,ASNH225CallsAvailable_Encode,ASNH225CallsAvailable_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CallsAvailable_Print,
#endif
		delete_ASNH225CallsAvailable);
	AsnSequenceOf_SetMold( &(pObj->m_t38FaxAnnexbOnlyGwCallsAvailable), moldObject );
	}
	{
	ASNH225CallsAvailable *tmold_terminalCallsAvailable = (ASNH225CallsAvailable *)HSMalloc( sizeof(ASNH225CallsAvailable) );
	new_ASNH225CallsAvailable(tmold_terminalCallsAvailable);
	ASNH225CallsAvailable_MakeMold(tmold_terminalCallsAvailable);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_terminalCallsAvailable,sizeof(ASNH225CallsAvailable),ASNH225CallsAvailable_MakeMold,ASNH225CallsAvailable_Encode,ASNH225CallsAvailable_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CallsAvailable_Print,
#endif
		delete_ASNH225CallsAvailable);
	AsnSequenceOf_SetMold( &(pObj->m_terminalCallsAvailable), moldObject );
	}
	{
	ASNH225CallsAvailable *tmold_mcuCallsAvailable = (ASNH225CallsAvailable *)HSMalloc( sizeof(ASNH225CallsAvailable) );
	new_ASNH225CallsAvailable(tmold_mcuCallsAvailable);
	ASNH225CallsAvailable_MakeMold(tmold_mcuCallsAvailable);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_mcuCallsAvailable,sizeof(ASNH225CallsAvailable),ASNH225CallsAvailable_MakeMold,ASNH225CallsAvailable_Encode,ASNH225CallsAvailable_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CallsAvailable_Print,
#endif
		delete_ASNH225CallsAvailable);
	AsnSequenceOf_SetMold( &(pObj->m_mcuCallsAvailable), moldObject );
	}
	return HS_OK;
}

/* ASNH225CallCapacityInfo IncludeOptionalField */
HS_RESULT ASNH225CallCapacityInfo_IncludeOptionField( void *pObject, ASNH225CallCapacityInfoOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225CallCapacityInfo *pObj = (ASNH225CallCapacityInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCapacityInfo_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225CallCapacityInfoOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225CallCapacityInfo IsIncludeOptionalField */
BOOL ASNH225CallCapacityInfo_IsIncludeOptionField( void *pObject, ASNH225CallCapacityInfoOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225CallCapacityInfo *pObj = (ASNH225CallCapacityInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCapacityInfo_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225CallCapacityInfoOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225CallCapacityInfo Encode */
HS_RESULT ASNH225CallCapacityInfo_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225CallCapacityInfo *pObj = (ASNH225CallCapacityInfo *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCapacityInfo_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225CallCapacityInfoOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225CallCapacityInfoOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_voiceGwCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_voiceGwCallsAvailable),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_h310GwCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_h310GwCallsAvailable),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_h320GwCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_h320GwCallsAvailable),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_h321GwCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_h321GwCallsAvailable),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_h322GwCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_h322GwCallsAvailable),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_h323GwCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_h323GwCallsAvailable),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_h324GwCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_h324GwCallsAvailable),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_t120OnlyGwCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_t120OnlyGwCallsAvailable),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_t38FaxAnnexbOnlyGwCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_t38FaxAnnexbOnlyGwCallsAvailable),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_terminalCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_terminalCallsAvailable),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_mcuCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_mcuCallsAvailable),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225CallCapacityInfo Decode */
HS_RESULT ASNH225CallCapacityInfo_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225CallCapacityInfo *pObj = (ASNH225CallCapacityInfo *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCapacityInfo_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225CallCapacityInfoOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225CallCapacityInfoOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_voiceGwCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_voiceGwCallsAvailable),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_h310GwCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_h310GwCallsAvailable),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_h320GwCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_h320GwCallsAvailable),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_h321GwCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_h321GwCallsAvailable),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_h322GwCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_h322GwCallsAvailable),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_h323GwCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_h323GwCallsAvailable),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_h324GwCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_h324GwCallsAvailable),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_t120OnlyGwCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_t120OnlyGwCallsAvailable),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_t38FaxAnnexbOnlyGwCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_t38FaxAnnexbOnlyGwCallsAvailable),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_terminalCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_terminalCallsAvailable),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_mcuCallsAvailable ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_mcuCallsAvailable),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacityInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225CallCapacityInfo Print */
HS_RESULT ASNH225CallCapacityInfo_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225CallCapacityInfo *pObj = (ASNH225CallCapacityInfo *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225CallCapacityInfo_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_voiceGwCallsAvailable ) )
		AsnSequenceOf_Print( &(pObj->m_voiceGwCallsAvailable), pDepth+1, "voiceGwCallsAvailable" );
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_h310GwCallsAvailable ) )
		AsnSequenceOf_Print( &(pObj->m_h310GwCallsAvailable), pDepth+1, "h310GwCallsAvailable" );
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_h320GwCallsAvailable ) )
		AsnSequenceOf_Print( &(pObj->m_h320GwCallsAvailable), pDepth+1, "h320GwCallsAvailable" );
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_h321GwCallsAvailable ) )
		AsnSequenceOf_Print( &(pObj->m_h321GwCallsAvailable), pDepth+1, "h321GwCallsAvailable" );
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_h322GwCallsAvailable ) )
		AsnSequenceOf_Print( &(pObj->m_h322GwCallsAvailable), pDepth+1, "h322GwCallsAvailable" );
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_h323GwCallsAvailable ) )
		AsnSequenceOf_Print( &(pObj->m_h323GwCallsAvailable), pDepth+1, "h323GwCallsAvailable" );
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_h324GwCallsAvailable ) )
		AsnSequenceOf_Print( &(pObj->m_h324GwCallsAvailable), pDepth+1, "h324GwCallsAvailable" );
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_t120OnlyGwCallsAvailable ) )
		AsnSequenceOf_Print( &(pObj->m_t120OnlyGwCallsAvailable), pDepth+1, "t120OnlyGwCallsAvailable" );
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_t38FaxAnnexbOnlyGwCallsAvailable ) )
		AsnSequenceOf_Print( &(pObj->m_t38FaxAnnexbOnlyGwCallsAvailable), pDepth+1, "t38FaxAnnexbOnlyGwCallsAvailable" );
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_terminalCallsAvailable ) )
		AsnSequenceOf_Print( &(pObj->m_terminalCallsAvailable), pDepth+1, "terminalCallsAvailable" );
	if( ASNH225CallCapacityInfo_IsIncludeOptionField( pObj, e_ASNH225CallCapacityInfoOptionMap_mcuCallsAvailable ) )
		AsnSequenceOf_Print( &(pObj->m_mcuCallsAvailable), pDepth+1, "mcuCallsAvailable" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225CallCapacity Class
*/
/*ASNH225CallCapacity Constructor*/
HS_RESULT new_ASNH225CallCapacity(void *pObject)
{
	ASNH225CallCapacity *pObj = (ASNH225CallCapacity *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225CallCapacity(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225CallCapacityInfo( &(pObj->m_maximumCallCapacity) );
	new_ASNH225CallCapacityInfo( &(pObj->m_currentCallCapacity) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225CallCapacity Destructor */
HS_RESULT delete_ASNH225CallCapacity(void *pObject)
{
	ASNH225CallCapacity *pObj = (ASNH225CallCapacity *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225CallCapacity(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225CallCapacityInfo( &(pObj->m_maximumCallCapacity) );
	delete_ASNH225CallCapacityInfo( &(pObj->m_currentCallCapacity) );
	return HS_OK;
}

/* ASNH225CallCapacity MakeMold */
HS_RESULT ASNH225CallCapacity_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225CallCapacity *pObj = (ASNH225CallCapacity *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCapacity_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225CallCapacityInfo_MakeMold(&(pObj->m_maximumCallCapacity));
	ASNH225CallCapacityInfo_MakeMold(&(pObj->m_currentCallCapacity));
	return HS_OK;
}

/* ASNH225CallCapacity IncludeOptionalField */
HS_RESULT ASNH225CallCapacity_IncludeOptionField( void *pObject, ASNH225CallCapacityOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225CallCapacity *pObj = (ASNH225CallCapacity *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCapacity_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225CallCapacityOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225CallCapacity IsIncludeOptionalField */
BOOL ASNH225CallCapacity_IsIncludeOptionField( void *pObject, ASNH225CallCapacityOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225CallCapacity *pObj = (ASNH225CallCapacity *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCapacity_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225CallCapacityOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225CallCapacity Encode */
HS_RESULT ASNH225CallCapacity_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225CallCapacity *pObj = (ASNH225CallCapacity *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCapacity_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225CallCapacityOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225CallCapacityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225CallCapacity_IsIncludeOptionField( pObj, e_ASNH225CallCapacityOptionMap_maximumCallCapacity ) ){
		if( (tRet=ASNH225CallCapacityInfo_Encode( &(pObj->m_maximumCallCapacity),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacity_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacity_IsIncludeOptionField( pObj, e_ASNH225CallCapacityOptionMap_currentCallCapacity ) ){
		if( (tRet=ASNH225CallCapacityInfo_Encode( &(pObj->m_currentCallCapacity),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacity_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225CallCapacity Decode */
HS_RESULT ASNH225CallCapacity_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225CallCapacity *pObj = (ASNH225CallCapacity *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallCapacity_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225CallCapacityOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225CallCapacityOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225CallCapacity_IsIncludeOptionField( pObj, e_ASNH225CallCapacityOptionMap_maximumCallCapacity ) ){
		if( (tRet=ASNH225CallCapacityInfo_Decode(&(pObj->m_maximumCallCapacity),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacity_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallCapacity_IsIncludeOptionField( pObj, e_ASNH225CallCapacityOptionMap_currentCallCapacity ) ){
		if( (tRet=ASNH225CallCapacityInfo_Decode(&(pObj->m_currentCallCapacity),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallCapacity_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225CallCapacity Print */
HS_RESULT ASNH225CallCapacity_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225CallCapacity *pObj = (ASNH225CallCapacity *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225CallCapacity_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225CallCapacity_IsIncludeOptionField( pObj, e_ASNH225CallCapacityOptionMap_maximumCallCapacity ) )
		ASNH225CallCapacityInfo_Print( &(pObj->m_maximumCallCapacity), pDepth+1, "maximumCallCapacity" );
	if( ASNH225CallCapacity_IsIncludeOptionField( pObj, e_ASNH225CallCapacityOptionMap_currentCallCapacity ) )
		ASNH225CallCapacityInfo_Print( &(pObj->m_currentCallCapacity), pDepth+1, "currentCallCapacity" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225CicInfo Class
*/
/*ASNH225CicInfo Constructor*/
HS_RESULT new_ASNH225CicInfo(void *pObject)
{
	ASNH225CicInfo *pObj = (ASNH225CicInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225CicInfo(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnSequenceOf( &(pObj->m_cic), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnOctetString( &(pObj->m_pointCode), e_constrained, 2, 5, 0, HS_ASN_MAX_CONSTRAINT );

	return HS_OK;
}

/* ASNH225CicInfo Destructor */
HS_RESULT delete_ASNH225CicInfo(void *pObject)
{
	ASNH225CicInfo *pObj = (ASNH225CicInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225CicInfo(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnSequenceOf( &(pObj->m_cic) );
	delete_AsnOctetString( &(pObj->m_pointCode) );
	return HS_OK;
}

/* ASNH225CicInfo MakeMold */
HS_RESULT ASNH225CicInfo_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225CicInfo *pObj = (ASNH225CicInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CicInfo_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	AsnOctetString *tmold_cic = (AsnOctetString *)HSMalloc( sizeof(AsnOctetString) );
	new_AsnOctetString(tmold_cic,e_constrained,2,4,0,HS_ASN_MAX_CONSTRAINT);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cic,sizeof(AsnOctetString),AsnOctetString_MakeMold,AsnOctetString_Encode,AsnOctetString_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		AsnOctetString_Print,
#endif
		delete_AsnOctetString);
	AsnSequenceOf_SetMold( &(pObj->m_cic), moldObject );
	}
	return HS_OK;
}

/* ASNH225CicInfo Encode */
HS_RESULT ASNH225CicInfo_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225CicInfo *pObj = (ASNH225CicInfo *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CicInfo_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=AsnSequenceOf_Encode( &(pObj->m_cic),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CicInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Encode( &(pObj->m_pointCode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CicInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225CicInfo Decode */
HS_RESULT ASNH225CicInfo_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225CicInfo *pObj = (ASNH225CicInfo *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CicInfo_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=AsnSequenceOf_Decode(&(pObj->m_cic),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CicInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=AsnOctetString_Decode(&(pObj->m_pointCode),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CicInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225CicInfo Print */
HS_RESULT ASNH225CicInfo_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225CicInfo *pObj = (ASNH225CicInfo *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225CicInfo_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnSequenceOf_Print( &(pObj->m_cic), pDepth+1, "cic" );
	AsnOctetString_Print( &(pObj->m_pointCode), pDepth+1, "pointCode" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225GroupID Class
*/
/*ASNH225GroupID Constructor*/
HS_RESULT new_ASNH225GroupID(void *pObject)
{
	ASNH225GroupID *pObj = (ASNH225GroupID *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225GroupID(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnSequenceOf( &(pObj->m_member), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSingleString( &(pObj->m_group), e_asnTagIA5String, e_constrained, 1, 128, 0, HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225GroupID Destructor */
HS_RESULT delete_ASNH225GroupID(void *pObject)
{
	ASNH225GroupID *pObj = (ASNH225GroupID *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225GroupID(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnSequenceOf( &(pObj->m_member) );
	delete_AsnSingleString( &(pObj->m_group) );
	return HS_OK;
}

/* ASNH225GroupID MakeMold */
HS_RESULT ASNH225GroupID_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225GroupID *pObj = (ASNH225GroupID *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GroupID_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	AsnInteger *tmold_member = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
	new_AsnInteger(tmold_member,e_constrained,0,65535,0,HS_ASN_MAX_CONSTRAINT);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_member,sizeof(AsnInteger),AsnInteger_MakeMold,AsnInteger_Encode,AsnInteger_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		AsnInteger_Print,
#endif
		delete_AsnInteger);
	AsnSequenceOf_SetMold( &(pObj->m_member), moldObject );
	}
	return HS_OK;
}

/* ASNH225GroupID IncludeOptionalField */
HS_RESULT ASNH225GroupID_IncludeOptionField( void *pObject, ASNH225GroupIDOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225GroupID *pObj = (ASNH225GroupID *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GroupID_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225GroupIDOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225GroupID IsIncludeOptionalField */
BOOL ASNH225GroupID_IsIncludeOptionField( void *pObject, ASNH225GroupIDOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225GroupID *pObj = (ASNH225GroupID *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GroupID_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225GroupIDOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225GroupID Encode */
HS_RESULT ASNH225GroupID_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225GroupID *pObj = (ASNH225GroupID *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GroupID_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225GroupIDOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225GroupIDOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225GroupID_IsIncludeOptionField( pObj, e_ASNH225GroupIDOptionMap_member ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_member),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GroupID_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnSingleString_Encode( &(pObj->m_group),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GroupID_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

/* ASNH225GroupID Decode */
HS_RESULT ASNH225GroupID_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225GroupID *pObj = (ASNH225GroupID *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GroupID_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225GroupIDOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225GroupIDOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225GroupID_IsIncludeOptionField( pObj, e_ASNH225GroupIDOptionMap_member ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_member),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GroupID_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnSingleString_Decode(&(pObj->m_group),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GroupID_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225GroupID Print */
HS_RESULT ASNH225GroupID_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225GroupID *pObj = (ASNH225GroupID *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225GroupID_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225GroupID_IsIncludeOptionField( pObj, e_ASNH225GroupIDOptionMap_member ) )
		AsnSequenceOf_Print( &(pObj->m_member), pDepth+1, "member" );
	AsnSingleString_Print( &(pObj->m_group), pDepth+1, "group" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225CircuitIdentifier Struct
*/
/* ASNH225CircuitIdentifier Constructor */
HS_RESULT new_ASNH225CircuitIdentifier( void *pObject )
{
	ASNH225CircuitIdentifier *pObj = (ASNH225CircuitIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225CircuitIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225CircuitIdentifierChoice_cic;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225CircuitIdentifierChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225CircuitIdentifier Destructor */
HS_RESULT delete_ASNH225CircuitIdentifier( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225CircuitIdentifier *pObj = (ASNH225CircuitIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225CircuitIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225CircuitIdentifier_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225CircuitIdentifier(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225CircuitIdentifier SetChoice */
void* ASNH225CircuitIdentifier_SetChoice( void *pObject, ASNH225CircuitIdentifierChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225CircuitIdentifier *pObj = (ASNH225CircuitIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CircuitIdentifier_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225CircuitIdentifierChoiceSizeExt ){
		if( pChoice > (ASNH225CircuitIdentifierChoice)(e_ASNH225CircuitIdentifierChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CircuitIdentifier_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225CircuitIdentifier_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CircuitIdentifier_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225CircuitIdentifierChoice_cic ){
		ASNH225CicInfo *tAlter = (ASNH225CicInfo *)HSMalloc( sizeof(ASNH225CicInfo) );
		new_ASNH225CicInfo(tAlter);
		ASNH225CicInfo_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225CircuitIdentifierChoice_group ){
		ASNH225GroupID *tAlter = (ASNH225GroupID *)HSMalloc( sizeof(ASNH225GroupID) );
		new_ASNH225GroupID(tAlter);
		ASNH225GroupID_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CircuitIdentifier_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225CircuitIdentifier DeleteAlternation */
HS_RESULT ASNH225CircuitIdentifier_DeleteAlternation(void *pObject)
{
	ASNH225CircuitIdentifier *pObj = (ASNH225CircuitIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CircuitIdentifier_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225CircuitIdentifierChoice_cic ){
			delete_ASNH225CicInfo(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225CircuitIdentifierChoice_group ){
			delete_ASNH225GroupID(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CircuitIdentifier_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225CircuitIdentifier_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225CircuitIdentifier Encode */
HS_RESULT ASNH225CircuitIdentifier_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225CircuitIdentifier *pObj = (ASNH225CircuitIdentifier *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CircuitIdentifier_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CircuitIdentifier_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225CircuitIdentifierChoiceSize )
		{
			if( pObj->choice > ((ASNH225CircuitIdentifierChoice)(e_ASNH225CircuitIdentifierChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225CircuitIdentifierChoiceSize)) )
	}
	else
	{
		if( e_ASNH225CircuitIdentifierChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225CircuitIdentifierChoice_cic ){
		if( (tRet=ASNH225CicInfo_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CircuitIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225CircuitIdentifierChoice_group ){
		if( (tRet=ASNH225GroupID_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CircuitIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CircuitIdentifier_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225CircuitIdentifier Decode */
HS_RESULT ASNH225CircuitIdentifier_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225CircuitIdentifier *pObj = (ASNH225CircuitIdentifier *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CircuitIdentifier_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225CircuitIdentifierChoiceSize;
	}
	else
	{
		if( e_ASNH225CircuitIdentifierChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225CircuitIdentifierChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225CircuitIdentifierChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CircuitIdentifier_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225CircuitIdentifier_SetChoice( pObj, (ASNH225CircuitIdentifierChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CircuitIdentifier_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225CircuitIdentifierChoice_cic ){
		if( (tRet=ASNH225CicInfo_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CircuitIdentifier_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225CircuitIdentifierChoice_group ){
		if( (tRet=ASNH225GroupID_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CircuitIdentifier_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CircuitIdentifier_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225CircuitIdentifier Print */
HS_RESULT ASNH225CircuitIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225CircuitIdentifier *pObj = (ASNH225CircuitIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225CircuitIdentifier_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225CircuitIdentifierChoice_cic ){
		ASNH225CicInfo_Print( pObj->alter, pDepth+1, "cic" );
	}
	else if ( pObj->choice == e_ASNH225CircuitIdentifierChoice_group ){
		ASNH225GroupID_Print( pObj->alter, pDepth+1, "group" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225GenericIdentifier Struct
*/
/* ASNH225GenericIdentifier Constructor */
HS_RESULT new_ASNH225GenericIdentifier( void *pObject )
{
	ASNH225GenericIdentifier *pObj = (ASNH225GenericIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225GenericIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225GenericIdentifierChoice_standard;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225GenericIdentifierChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225GenericIdentifier Destructor */
HS_RESULT delete_ASNH225GenericIdentifier( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225GenericIdentifier *pObj = (ASNH225GenericIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225GenericIdentifier(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225GenericIdentifier_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225GenericIdentifier(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225GenericIdentifier SetChoice */
void* ASNH225GenericIdentifier_SetChoice( void *pObject, ASNH225GenericIdentifierChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225GenericIdentifier *pObj = (ASNH225GenericIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GenericIdentifier_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225GenericIdentifierChoiceSizeExt ){
		if( pChoice > (ASNH225GenericIdentifierChoice)(e_ASNH225GenericIdentifierChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GenericIdentifier_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225GenericIdentifier_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GenericIdentifier_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225GenericIdentifierChoice_standard ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrainedExt,0,16383,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225GenericIdentifierChoice_oid ){
		AsnObjectIdentifier *tAlter = (AsnObjectIdentifier *)HSMalloc( sizeof(AsnObjectIdentifier) );
		new_AsnObjectIdentifier(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225GenericIdentifierChoice_nonStandard ){
		ASNH225GloballyUniqueID *tAlter = (ASNH225GloballyUniqueID *)HSMalloc( sizeof(ASNH225GloballyUniqueID) );
		new_ASNH225GloballyUniqueID(tAlter);
		ASNH225GloballyUniqueID_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GenericIdentifier_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225GenericIdentifier DeleteAlternation */
HS_RESULT ASNH225GenericIdentifier_DeleteAlternation(void *pObject)
{
	ASNH225GenericIdentifier *pObj = (ASNH225GenericIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GenericIdentifier_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225GenericIdentifierChoice_standard ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225GenericIdentifierChoice_oid ){
			delete_AsnObjectIdentifier(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225GenericIdentifierChoice_nonStandard ){
			delete_ASNH225GloballyUniqueID(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GenericIdentifier_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225GenericIdentifier_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225GenericIdentifier Encode */
HS_RESULT ASNH225GenericIdentifier_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225GenericIdentifier *pObj = (ASNH225GenericIdentifier *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GenericIdentifier_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GenericIdentifier_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225GenericIdentifierChoiceSize )
		{
			if( pObj->choice > ((ASNH225GenericIdentifierChoice)(e_ASNH225GenericIdentifierChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225GenericIdentifierChoiceSize)) )
	}
	else
	{
		if( e_ASNH225GenericIdentifierChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225GenericIdentifierChoice_standard ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GenericIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225GenericIdentifierChoice_oid ){
		if( (tRet=AsnObjectIdentifier_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GenericIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225GenericIdentifierChoice_nonStandard ){
		if( (tRet=ASNH225GloballyUniqueID_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GenericIdentifier_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GenericIdentifier_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225GenericIdentifier Decode */
HS_RESULT ASNH225GenericIdentifier_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225GenericIdentifier *pObj = (ASNH225GenericIdentifier *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GenericIdentifier_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225GenericIdentifierChoiceSize;
	}
	else
	{
		if( e_ASNH225GenericIdentifierChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225GenericIdentifierChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225GenericIdentifierChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GenericIdentifier_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225GenericIdentifier_SetChoice( pObj, (ASNH225GenericIdentifierChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GenericIdentifier_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225GenericIdentifierChoice_standard ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GenericIdentifier_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225GenericIdentifierChoice_oid ){
		if( (tRet=AsnObjectIdentifier_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GenericIdentifier_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225GenericIdentifierChoice_nonStandard ){
		if( (tRet=ASNH225GloballyUniqueID_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GenericIdentifier_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GenericIdentifier_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225GenericIdentifier Print */
HS_RESULT ASNH225GenericIdentifier_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225GenericIdentifier *pObj = (ASNH225GenericIdentifier *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225GenericIdentifier_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225GenericIdentifierChoice_standard ){
		AsnInteger_Print( pObj->alter, pDepth+1, "standard" );
	}
	else if ( pObj->choice == e_ASNH225GenericIdentifierChoice_oid ){
		AsnObjectIdentifier_Print( pObj->alter, pDepth+1, "oid" );
	}
	else if ( pObj->choice == e_ASNH225GenericIdentifierChoice_nonStandard ){
		ASNH225GloballyUniqueID_Print( pObj->alter, pDepth+1, "nonStandard" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225Content Struct
*/
/* ASNH225Content Constructor */
HS_RESULT new_ASNH225Content( void *pObject )
{
	ASNH225Content *pObj = (ASNH225Content *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225Content(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225ContentChoice_raw;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225ContentChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225Content Destructor */
HS_RESULT delete_ASNH225Content( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225Content *pObj = (ASNH225Content *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225Content(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225Content_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225Content(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225Content SetChoice */
void* ASNH225Content_SetChoice( void *pObject, ASNH225ContentChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225Content *pObj = (ASNH225Content *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Content_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225ContentChoiceSizeExt ){
		if( pChoice > (ASNH225ContentChoice)(e_ASNH225ContentChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225Content_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225ContentChoice_raw ){
		AsnOctetString *tAlter = (AsnOctetString *)HSMalloc( sizeof(AsnOctetString) );
		new_AsnOctetString(tAlter,e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ContentChoice_text ){
		AsnSingleString *tAlter = (AsnSingleString *)HSMalloc( sizeof(AsnSingleString) );
		new_AsnSingleString(tAlter,e_asnTagIA5String,e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ContentChoice_unicode ){
		AsnDoubleString *tAlter = (AsnDoubleString *)HSMalloc( sizeof(AsnDoubleString) );
		new_AsnDoubleString(tAlter,e_asnTagBMPString,e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ContentChoice_bool ){
		AsnBoolean *tAlter = (AsnBoolean *)HSMalloc( sizeof(AsnBoolean) );
		new_AsnBoolean(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ContentChoice_number8 ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,0,255,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ContentChoice_number16 ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,0,65535,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ContentChoice_number32 ){
		AsnInteger *tAlter = (AsnInteger *)HSMalloc( sizeof(AsnInteger) );
		new_AsnInteger(tAlter,e_constrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ContentChoice_id ){
		ASNH225GenericIdentifier *tAlter = (ASNH225GenericIdentifier *)HSMalloc( sizeof(ASNH225GenericIdentifier) );
		new_ASNH225GenericIdentifier(tAlter);
		ASNH225GenericIdentifier_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ContentChoice_alias ){
		ASNH225AliasAddress *tAlter = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
		new_ASNH225AliasAddress(tAlter);
		ASNH225AliasAddress_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ContentChoice_transport ){
		ASNH225TransportAddress *tAlter = (ASNH225TransportAddress *)HSMalloc( sizeof(ASNH225TransportAddress) );
		new_ASNH225TransportAddress(tAlter);
		ASNH225TransportAddress_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ContentChoice_compound ){
		ASNH225EnumeratedParameter *tAlter = (ASNH225EnumeratedParameter *)HSMalloc( sizeof(ASNH225EnumeratedParameter) );
		new_ASNH225EnumeratedParameter(tAlter);
		ASNH225EnumeratedParameter_MakeMold(tAlter);
		aso = (AsnSequenceOf *)HSMalloc( sizeof(AsnSequenceOf) );
		new_AsnSequenceOf(aso,e_constrained,1,512,0,HS_ASN_MAX_CONSTRAINT);
		tmold = (AsnObject *)HSMalloc( sizeof(AsnObject) );
		new_AsnObject(tmold,tAlter,sizeof(ASNH225EnumeratedParameter),ASNH225EnumeratedParameter_MakeMold,ASNH225EnumeratedParameter_Encode,ASNH225EnumeratedParameter_Decode,
#ifdef HS_DEBUG_ASN_PRINT
			ASNH225EnumeratedParameter_Print,
#endif
			delete_ASNH225EnumeratedParameter );
		AsnSequenceOf_SetMold(aso,tmold);
		/* Sequence Of constraint */
		aso->constraint.type = e_constrained;
		aso->constraint.minValue = 1;
		aso->constraint.maxValue = 512;
		aso->extMinValue = 0;
		aso->extMaxValue = HS_ASN_MAX_CONSTRAINT;
		pObj->alter = aso;
	}
	else if ( pChoice == e_ASNH225ContentChoice_nested ){
		ASNH225GenericData *tAlter = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
		new_ASNH225GenericData(tAlter);
		ASNH225GenericData_MakeMold(tAlter);
		aso = (AsnSequenceOf *)HSMalloc( sizeof(AsnSequenceOf) );
		new_AsnSequenceOf(aso,e_constrained,1,16,0,HS_ASN_MAX_CONSTRAINT);
		tmold = (AsnObject *)HSMalloc( sizeof(AsnObject) );
		new_AsnObject(tmold,tAlter,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
			ASNH225GenericData_Print,
#endif
			delete_ASNH225GenericData );
		AsnSequenceOf_SetMold(aso,tmold);
		/* Sequence Of constraint */
		aso->constraint.type = e_constrained;
		aso->constraint.minValue = 1;
		aso->constraint.maxValue = 16;
		aso->extMinValue = 0;
		aso->extMaxValue = HS_ASN_MAX_CONSTRAINT;
		pObj->alter = aso;
	}
	/*...,*/
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Content_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225Content DeleteAlternation */
HS_RESULT ASNH225Content_DeleteAlternation(void *pObject)
{
	ASNH225Content *pObj = (ASNH225Content *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Content_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225ContentChoice_raw ){
			delete_AsnOctetString(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ContentChoice_text ){
			delete_AsnSingleString(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ContentChoice_unicode ){
			delete_AsnDoubleString(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ContentChoice_bool ){
			delete_AsnBoolean(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ContentChoice_number8 ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ContentChoice_number16 ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ContentChoice_number32 ){
			delete_AsnInteger(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ContentChoice_id ){
			delete_ASNH225GenericIdentifier(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ContentChoice_alias ){
			delete_ASNH225AliasAddress(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ContentChoice_transport ){
			delete_ASNH225TransportAddress(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ContentChoice_compound ){
			delete_AsnSequenceOf(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ContentChoice_nested ){
			delete_AsnSequenceOf(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225Content_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225Content Encode */
HS_RESULT ASNH225Content_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225Content *pObj = (ASNH225Content *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Content_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Content_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225ContentChoiceSize )
		{
			if( pObj->choice > ((ASNH225ContentChoice)(e_ASNH225ContentChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225ContentChoiceSize)) )
	}
	else
	{
		if( e_ASNH225ContentChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ContentChoice_raw ){
		if( (tRet=AsnOctetString_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_text ){
		if( (tRet=AsnSingleString_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_unicode ){
		if( (tRet=AsnDoubleString_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_bool ){
		if( (tRet=AsnBoolean_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_number8 ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_number16 ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_number32 ){
		if( (tRet=AsnInteger_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_id ){
		if( (tRet=ASNH225GenericIdentifier_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_alias ){
		if( (tRet=ASNH225AliasAddress_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_transport ){
		if( (tRet=ASNH225TransportAddress_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_compound ){
		if( (tRet=AsnSequenceOf_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_nested ){
		if( (tRet=AsnSequenceOf_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Content_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225Content Decode */
HS_RESULT ASNH225Content_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225Content *pObj = (ASNH225Content *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Content_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225ContentChoiceSize;
	}
	else
	{
		if( e_ASNH225ContentChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225ContentChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225ContentChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225Content_SetChoice( pObj, (ASNH225ContentChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Content_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ContentChoice_raw ){
		if( (tRet=AsnOctetString_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_text ){
		if( (tRet=AsnSingleString_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_unicode ){
		if( (tRet=AsnDoubleString_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_bool ){
		if( (tRet=AsnBoolean_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_number8 ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_number16 ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_number32 ){
		if( (tRet=AsnInteger_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_id ){
		if( (tRet=ASNH225GenericIdentifier_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_alias ){
		if( (tRet=ASNH225AliasAddress_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_transport ){
		if( (tRet=ASNH225TransportAddress_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_compound ){
		if( (tRet=AsnSequenceOf_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_nested ){
		if( (tRet=AsnSequenceOf_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Content_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Content_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225Content Print */
HS_RESULT ASNH225Content_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225Content *pObj = (ASNH225Content *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225Content_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ContentChoice_raw ){
		AsnOctetString_Print( pObj->alter, pDepth+1, "raw" );
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_text ){
		AsnSingleString_Print( pObj->alter, pDepth+1, "text" );
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_unicode ){
		AsnDoubleString_Print( pObj->alter, pDepth+1, "unicode" );
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_bool ){
		AsnBoolean_Print( pObj->alter, pDepth+1, "bool" );
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_number8 ){
		AsnInteger_Print( pObj->alter, pDepth+1, "number8" );
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_number16 ){
		AsnInteger_Print( pObj->alter, pDepth+1, "number16" );
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_number32 ){
		AsnInteger_Print( pObj->alter, pDepth+1, "number32" );
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_id ){
		ASNH225GenericIdentifier_Print( pObj->alter, pDepth+1, "id" );
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_alias ){
		ASNH225AliasAddress_Print( pObj->alter, pDepth+1, "alias" );
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_transport ){
		ASNH225TransportAddress_Print( pObj->alter, pDepth+1, "transport" );
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_compound ){
		AsnSequenceOf_Print( pObj->alter, pDepth+1, "compound" );
	}
	else if ( pObj->choice == e_ASNH225ContentChoice_nested ){
		AsnSequenceOf_Print( pObj->alter, pDepth+1, "nested" );
	}
	/*...,*/
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225EnumeratedParameter Class
*/
/*ASNH225EnumeratedParameter Constructor*/
HS_RESULT new_ASNH225EnumeratedParameter(void *pObject)
{
	ASNH225EnumeratedParameter *pObj = (ASNH225EnumeratedParameter *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225EnumeratedParameter(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225GenericIdentifier( &(pObj->m_id) );
	new_ASNH225Content( &(pObj->m_content) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225EnumeratedParameter Destructor */
HS_RESULT delete_ASNH225EnumeratedParameter(void *pObject)
{
	ASNH225EnumeratedParameter *pObj = (ASNH225EnumeratedParameter *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225EnumeratedParameter(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225GenericIdentifier( &(pObj->m_id) );
	delete_ASNH225Content( &(pObj->m_content) );
	return HS_OK;
}

/* ASNH225EnumeratedParameter MakeMold */
HS_RESULT ASNH225EnumeratedParameter_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225EnumeratedParameter *pObj = (ASNH225EnumeratedParameter *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225EnumeratedParameter_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225GenericIdentifier_MakeMold(&(pObj->m_id));
	ASNH225Content_MakeMold(&(pObj->m_content));
	return HS_OK;
}

/* ASNH225EnumeratedParameter IncludeOptionalField */
HS_RESULT ASNH225EnumeratedParameter_IncludeOptionField( void *pObject, ASNH225EnumeratedParameterOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225EnumeratedParameter *pObj = (ASNH225EnumeratedParameter *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225EnumeratedParameter_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225EnumeratedParameterOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225EnumeratedParameter IsIncludeOptionalField */
BOOL ASNH225EnumeratedParameter_IsIncludeOptionField( void *pObject, ASNH225EnumeratedParameterOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225EnumeratedParameter *pObj = (ASNH225EnumeratedParameter *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225EnumeratedParameter_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225EnumeratedParameterOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225EnumeratedParameter Encode */
HS_RESULT ASNH225EnumeratedParameter_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225EnumeratedParameter *pObj = (ASNH225EnumeratedParameter *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225EnumeratedParameter_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225EnumeratedParameterOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225EnumeratedParameterOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225GenericIdentifier_Encode( &(pObj->m_id),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225EnumeratedParameter_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225EnumeratedParameter_IsIncludeOptionField( pObj, e_ASNH225EnumeratedParameterOptionMap_content ) ){
		if( (tRet=ASNH225Content_Encode( &(pObj->m_content),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225EnumeratedParameter_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225EnumeratedParameter Decode */
HS_RESULT ASNH225EnumeratedParameter_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225EnumeratedParameter *pObj = (ASNH225EnumeratedParameter *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225EnumeratedParameter_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225EnumeratedParameterOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225EnumeratedParameterOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225GenericIdentifier_Decode(&(pObj->m_id),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225EnumeratedParameter_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225EnumeratedParameter_IsIncludeOptionField( pObj, e_ASNH225EnumeratedParameterOptionMap_content ) ){
		if( (tRet=ASNH225Content_Decode(&(pObj->m_content),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225EnumeratedParameter_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225EnumeratedParameter Print */
HS_RESULT ASNH225EnumeratedParameter_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225EnumeratedParameter *pObj = (ASNH225EnumeratedParameter *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225EnumeratedParameter_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225GenericIdentifier_Print( &(pObj->m_id), pDepth+1, "id" );
	if( ASNH225EnumeratedParameter_IsIncludeOptionField( pObj, e_ASNH225EnumeratedParameterOptionMap_content ) )
		ASNH225Content_Print( &(pObj->m_content), pDepth+1, "content" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225GenericData Class
*/
/*ASNH225GenericData Constructor*/
HS_RESULT new_ASNH225GenericData(void *pObject)
{
	ASNH225GenericData *pObj = (ASNH225GenericData *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225GenericData(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225GenericIdentifier( &(pObj->m_id) );
	new_AsnSequenceOf( &(pObj->m_parameters), e_constrained,1,512,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225GenericData Destructor */
HS_RESULT delete_ASNH225GenericData(void *pObject)
{
	ASNH225GenericData *pObj = (ASNH225GenericData *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225GenericData(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225GenericIdentifier( &(pObj->m_id) );
	delete_AsnSequenceOf( &(pObj->m_parameters) );
	return HS_OK;
}

/* ASNH225GenericData MakeMold */
HS_RESULT ASNH225GenericData_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225GenericData *pObj = (ASNH225GenericData *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GenericData_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225GenericIdentifier_MakeMold(&(pObj->m_id));
	{
	ASNH225EnumeratedParameter *tmold_parameters = (ASNH225EnumeratedParameter *)HSMalloc( sizeof(ASNH225EnumeratedParameter) );
	new_ASNH225EnumeratedParameter(tmold_parameters);
	ASNH225EnumeratedParameter_MakeMold(tmold_parameters);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_parameters,sizeof(ASNH225EnumeratedParameter),ASNH225EnumeratedParameter_MakeMold,ASNH225EnumeratedParameter_Encode,ASNH225EnumeratedParameter_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225EnumeratedParameter_Print,
#endif
		delete_ASNH225EnumeratedParameter);
	AsnSequenceOf_SetMold( &(pObj->m_parameters), moldObject );
	}
	/* Sequence Of constraint */
	pObj->m_parameters.constraint.type = e_constrained;
	pObj->m_parameters.constraint.minValue = 1;
	pObj->m_parameters.constraint.maxValue = 512;
	pObj->m_parameters.extMinValue = 0;
	pObj->m_parameters.extMaxValue = HS_ASN_MAX_CONSTRAINT;
	return HS_OK;
}

/* ASNH225GenericData IncludeOptionalField */
HS_RESULT ASNH225GenericData_IncludeOptionField( void *pObject, ASNH225GenericDataOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225GenericData *pObj = (ASNH225GenericData *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GenericData_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225GenericDataOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225GenericData IsIncludeOptionalField */
BOOL ASNH225GenericData_IsIncludeOptionField( void *pObject, ASNH225GenericDataOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225GenericData *pObj = (ASNH225GenericData *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GenericData_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225GenericDataOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225GenericData Encode */
HS_RESULT ASNH225GenericData_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225GenericData *pObj = (ASNH225GenericData *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GenericData_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225GenericDataOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225GenericDataOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225GenericIdentifier_Encode( &(pObj->m_id),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GenericData_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225GenericData_IsIncludeOptionField( pObj, e_ASNH225GenericDataOptionMap_parameters ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_parameters),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GenericData_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225GenericData Decode */
HS_RESULT ASNH225GenericData_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225GenericData *pObj = (ASNH225GenericData *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GenericData_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225GenericDataOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225GenericDataOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225GenericIdentifier_Decode(&(pObj->m_id),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225GenericData_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225GenericData_IsIncludeOptionField( pObj, e_ASNH225GenericDataOptionMap_parameters ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_parameters),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225GenericData_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225GenericData Print */
HS_RESULT ASNH225GenericData_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225GenericData *pObj = (ASNH225GenericData *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225GenericData_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225GenericIdentifier_Print( &(pObj->m_id), pDepth+1, "id" );
	if( ASNH225GenericData_IsIncludeOptionField( pObj, e_ASNH225GenericDataOptionMap_parameters ) )
		AsnSequenceOf_Print( &(pObj->m_parameters), pDepth+1, "parameters" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225CircuitInfo Class
*/
/*ASNH225CircuitInfo Constructor*/
HS_RESULT new_ASNH225CircuitInfo(void *pObject)
{
	ASNH225CircuitInfo *pObj = (ASNH225CircuitInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225CircuitInfo(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225CircuitIdentifier( &(pObj->m_sourceCircuitID) );
	new_ASNH225CircuitIdentifier( &(pObj->m_destinationCircuitID) );
	new_AsnSequenceOf( &(pObj->m_genericData), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225CircuitInfo Destructor */
HS_RESULT delete_ASNH225CircuitInfo(void *pObject)
{
	ASNH225CircuitInfo *pObj = (ASNH225CircuitInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225CircuitInfo(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225CircuitIdentifier( &(pObj->m_sourceCircuitID) );
	delete_ASNH225CircuitIdentifier( &(pObj->m_destinationCircuitID) );
	delete_AsnSequenceOf( &(pObj->m_genericData) );
	return HS_OK;
}

/* ASNH225CircuitInfo MakeMold */
HS_RESULT ASNH225CircuitInfo_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225CircuitInfo *pObj = (ASNH225CircuitInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CircuitInfo_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225CircuitIdentifier_MakeMold(&(pObj->m_sourceCircuitID));
	ASNH225CircuitIdentifier_MakeMold(&(pObj->m_destinationCircuitID));
	{
	ASNH225GenericData *tmold_genericData = (ASNH225GenericData *)HSMalloc( sizeof(ASNH225GenericData) );
	new_ASNH225GenericData(tmold_genericData);
	ASNH225GenericData_MakeMold(tmold_genericData);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_genericData,sizeof(ASNH225GenericData),ASNH225GenericData_MakeMold,ASNH225GenericData_Encode,ASNH225GenericData_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225GenericData_Print,
#endif
		delete_ASNH225GenericData);
	AsnSequenceOf_SetMold( &(pObj->m_genericData), moldObject );
	}
	return HS_OK;
}

/* ASNH225CircuitInfo IncludeOptionalField */
HS_RESULT ASNH225CircuitInfo_IncludeOptionField( void *pObject, ASNH225CircuitInfoOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225CircuitInfo *pObj = (ASNH225CircuitInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CircuitInfo_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225CircuitInfoOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225CircuitInfo IsIncludeOptionalField */
BOOL ASNH225CircuitInfo_IsIncludeOptionField( void *pObject, ASNH225CircuitInfoOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225CircuitInfo *pObj = (ASNH225CircuitInfo *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CircuitInfo_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225CircuitInfoOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225CircuitInfo Encode */
HS_RESULT ASNH225CircuitInfo_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225CircuitInfo *pObj = (ASNH225CircuitInfo *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CircuitInfo_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225CircuitInfoOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225CircuitInfoOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225CircuitInfo_IsIncludeOptionField( pObj, e_ASNH225CircuitInfoOptionMap_sourceCircuitID ) ){
		if( (tRet=ASNH225CircuitIdentifier_Encode( &(pObj->m_sourceCircuitID),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CircuitInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CircuitInfo_IsIncludeOptionField( pObj, e_ASNH225CircuitInfoOptionMap_destinationCircuitID ) ){
		if( (tRet=ASNH225CircuitIdentifier_Encode( &(pObj->m_destinationCircuitID),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CircuitInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CircuitInfo_IsIncludeOptionField( pObj, e_ASNH225CircuitInfoOptionMap_genericData ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_genericData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CircuitInfo_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225CircuitInfo Decode */
HS_RESULT ASNH225CircuitInfo_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225CircuitInfo *pObj = (ASNH225CircuitInfo *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CircuitInfo_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225CircuitInfoOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225CircuitInfoOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225CircuitInfo_IsIncludeOptionField( pObj, e_ASNH225CircuitInfoOptionMap_sourceCircuitID ) ){
		if( (tRet=ASNH225CircuitIdentifier_Decode(&(pObj->m_sourceCircuitID),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CircuitInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CircuitInfo_IsIncludeOptionField( pObj, e_ASNH225CircuitInfoOptionMap_destinationCircuitID ) ){
		if( (tRet=ASNH225CircuitIdentifier_Decode(&(pObj->m_destinationCircuitID),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CircuitInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CircuitInfo_IsIncludeOptionField( pObj, e_ASNH225CircuitInfoOptionMap_genericData ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_genericData),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CircuitInfo_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225CircuitInfo Print */
HS_RESULT ASNH225CircuitInfo_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225CircuitInfo *pObj = (ASNH225CircuitInfo *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225CircuitInfo_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225CircuitInfo_IsIncludeOptionField( pObj, e_ASNH225CircuitInfoOptionMap_sourceCircuitID ) )
		ASNH225CircuitIdentifier_Print( &(pObj->m_sourceCircuitID), pDepth+1, "sourceCircuitID" );
	if( ASNH225CircuitInfo_IsIncludeOptionField( pObj, e_ASNH225CircuitInfoOptionMap_destinationCircuitID ) )
		ASNH225CircuitIdentifier_Print( &(pObj->m_destinationCircuitID), pDepth+1, "destinationCircuitID" );
	if( ASNH225CircuitInfo_IsIncludeOptionField( pObj, e_ASNH225CircuitInfoOptionMap_genericData ) )
		AsnSequenceOf_Print( &(pObj->m_genericData), pDepth+1, "genericData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225ExtendedAliasAddress Class
*/
/*ASNH225ExtendedAliasAddress Constructor*/
HS_RESULT new_ASNH225ExtendedAliasAddress(void *pObject)
{
	ASNH225ExtendedAliasAddress *pObj = (ASNH225ExtendedAliasAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225ExtendedAliasAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225AliasAddress( &(pObj->m_address) );
	new_ASNH225PresentationIndicator( &(pObj->m_presentationIndicator) );
	new_ASNH225ScreeningIndicator( &(pObj->m_screeningIndicator) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225ExtendedAliasAddress Destructor */
HS_RESULT delete_ASNH225ExtendedAliasAddress(void *pObject)
{
	ASNH225ExtendedAliasAddress *pObj = (ASNH225ExtendedAliasAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ExtendedAliasAddress(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225AliasAddress( &(pObj->m_address) );
	delete_ASNH225PresentationIndicator( &(pObj->m_presentationIndicator) );
	delete_ASNH225ScreeningIndicator( &(pObj->m_screeningIndicator) );
	return HS_OK;
}

/* ASNH225ExtendedAliasAddress MakeMold */
HS_RESULT ASNH225ExtendedAliasAddress_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225ExtendedAliasAddress *pObj = (ASNH225ExtendedAliasAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ExtendedAliasAddress_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225AliasAddress_MakeMold(&(pObj->m_address));
	ASNH225PresentationIndicator_MakeMold(&(pObj->m_presentationIndicator));
	ASNH225ScreeningIndicator_MakeMold(&(pObj->m_screeningIndicator));
	return HS_OK;
}

/* ASNH225ExtendedAliasAddress IncludeOptionalField */
HS_RESULT ASNH225ExtendedAliasAddress_IncludeOptionField( void *pObject, ASNH225ExtendedAliasAddressOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225ExtendedAliasAddress *pObj = (ASNH225ExtendedAliasAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ExtendedAliasAddress_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225ExtendedAliasAddressOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225ExtendedAliasAddress IsIncludeOptionalField */
BOOL ASNH225ExtendedAliasAddress_IsIncludeOptionField( void *pObject, ASNH225ExtendedAliasAddressOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225ExtendedAliasAddress *pObj = (ASNH225ExtendedAliasAddress *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ExtendedAliasAddress_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225ExtendedAliasAddressOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225ExtendedAliasAddress Encode */
HS_RESULT ASNH225ExtendedAliasAddress_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225ExtendedAliasAddress *pObj = (ASNH225ExtendedAliasAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ExtendedAliasAddress_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225ExtendedAliasAddressOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225ExtendedAliasAddressOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225AliasAddress_Encode( &(pObj->m_address),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ExtendedAliasAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225ExtendedAliasAddress_IsIncludeOptionField( pObj, e_ASNH225ExtendedAliasAddressOptionMap_presentationIndicator ) ){
		if( (tRet=ASNH225PresentationIndicator_Encode( &(pObj->m_presentationIndicator),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ExtendedAliasAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ExtendedAliasAddress_IsIncludeOptionField( pObj, e_ASNH225ExtendedAliasAddressOptionMap_screeningIndicator ) ){
		if( (tRet=ASNH225ScreeningIndicator_Encode( &(pObj->m_screeningIndicator),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ExtendedAliasAddress_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225ExtendedAliasAddress Decode */
HS_RESULT ASNH225ExtendedAliasAddress_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225ExtendedAliasAddress *pObj = (ASNH225ExtendedAliasAddress *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ExtendedAliasAddress_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225ExtendedAliasAddressOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225ExtendedAliasAddressOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225AliasAddress_Decode(&(pObj->m_address),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ExtendedAliasAddress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225ExtendedAliasAddress_IsIncludeOptionField( pObj, e_ASNH225ExtendedAliasAddressOptionMap_presentationIndicator ) ){
		if( (tRet=ASNH225PresentationIndicator_Decode(&(pObj->m_presentationIndicator),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ExtendedAliasAddress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ExtendedAliasAddress_IsIncludeOptionField( pObj, e_ASNH225ExtendedAliasAddressOptionMap_screeningIndicator ) ){
		if( (tRet=ASNH225ScreeningIndicator_Decode(&(pObj->m_screeningIndicator),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ExtendedAliasAddress_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225ExtendedAliasAddress Print */
HS_RESULT ASNH225ExtendedAliasAddress_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225ExtendedAliasAddress *pObj = (ASNH225ExtendedAliasAddress *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225ExtendedAliasAddress_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225AliasAddress_Print( &(pObj->m_address), pDepth+1, "address" );
	if( ASNH225ExtendedAliasAddress_IsIncludeOptionField( pObj, e_ASNH225ExtendedAliasAddressOptionMap_presentationIndicator ) )
		ASNH225PresentationIndicator_Print( &(pObj->m_presentationIndicator), pDepth+1, "presentationIndicator" );
	if( ASNH225ExtendedAliasAddress_IsIncludeOptionField( pObj, e_ASNH225ExtendedAliasAddressOptionMap_screeningIndicator ) )
		ASNH225ScreeningIndicator_Print( &(pObj->m_screeningIndicator), pDepth+1, "screeningIndicator" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225Setup_UUIE Class
*/
/*ASNH225Setup_UUIE Constructor*/
HS_RESULT new_ASNH225Setup_UUIE(void *pObject)
{
	ASNH225Setup_UUIE *pObj = (ASNH225Setup_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225Setup_UUIE(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225ProtocolIdentifier( &(pObj->m_protocolIdentifier) );
	new_ASNH225TransportAddress( &(pObj->m_h245Address) );
	new_AsnSequenceOf( &(pObj->m_sourceAddress), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225EndpointType( &(pObj->m_sourceInfo) );
	new_AsnSequenceOf( &(pObj->m_destinationAddress), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225TransportAddress( &(pObj->m_destCallSignalAddress) );
	new_AsnSequenceOf( &(pObj->m_destExtraCallInfo), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_destExtraCRV), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_activeMC) );
	new_ASNH225ConferenceIdentifier( &(pObj->m_conferenceID) );
	new_ASNH225Setup_UUIE_conferenceGoal( &(pObj->m_conferenceGoal) );
	new_ASNH225QseriesOptions( &(pObj->m_callServices) );
	new_ASNH225CallType( &(pObj->m_callType) );
	new_ASNH225TransportAddress( &(pObj->m_sourceCallSignalAddress) );
	new_ASNH225AliasAddress( &(pObj->m_remoteExtensionAddress) );
	new_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	new_AsnSequenceOf( &(pObj->m_h245SecurityCapability), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_fastStart), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_mediaWaitForConnect) );
	new_AsnBoolean( &(pObj->m_canOverlapSend) );
	new_ASNH225EndpointIdentifier( &(pObj->m_endpointIdentifier) );
	new_AsnBoolean( &(pObj->m_multipleCalls) );
	new_AsnBoolean( &(pObj->m_maintainConnection) );
	new_ASNH225Setup_UUIE_connectionParameters( &(pObj->m_connectionParameters) );
	new_AsnSequenceOf( &(pObj->m_language), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225PresentationIndicator( &(pObj->m_presentationIndicator) );
	new_ASNH225ScreeningIndicator( &(pObj->m_screeningIndicator) );
	new_AsnSequenceOf( &(pObj->m_serviceControl), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnNull( &(pObj->m_symmetricOperationRequired) );
	new_ASNH225CallCapacity( &(pObj->m_capacity) );
	new_ASNH225CircuitInfo( &(pObj->m_circuitInfo) );
	new_AsnSequenceOf( &(pObj->m_desiredProtocols), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_neededFeatures), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_desiredFeatures), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_supportedFeatures), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_parallelH245Control), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_additionalSourceAddresses), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225Setup_UUIE Destructor */
HS_RESULT delete_ASNH225Setup_UUIE(void *pObject)
{
	ASNH225Setup_UUIE *pObj = (ASNH225Setup_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225Setup_UUIE(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225ProtocolIdentifier( &(pObj->m_protocolIdentifier) );
	delete_ASNH225TransportAddress( &(pObj->m_h245Address) );
	delete_AsnSequenceOf( &(pObj->m_sourceAddress) );
	delete_ASNH225EndpointType( &(pObj->m_sourceInfo) );
	delete_AsnSequenceOf( &(pObj->m_destinationAddress) );
	delete_ASNH225TransportAddress( &(pObj->m_destCallSignalAddress) );
	delete_AsnSequenceOf( &(pObj->m_destExtraCallInfo) );
	delete_AsnSequenceOf( &(pObj->m_destExtraCRV) );
	delete_AsnBoolean( &(pObj->m_activeMC) );
	delete_ASNH225ConferenceIdentifier( &(pObj->m_conferenceID) );
	delete_ASNH225Setup_UUIE_conferenceGoal( &(pObj->m_conferenceGoal) );
	delete_ASNH225QseriesOptions( &(pObj->m_callServices) );
	delete_ASNH225CallType( &(pObj->m_callType) );
	delete_ASNH225TransportAddress( &(pObj->m_sourceCallSignalAddress) );
	delete_ASNH225AliasAddress( &(pObj->m_remoteExtensionAddress) );
	delete_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	delete_AsnSequenceOf( &(pObj->m_h245SecurityCapability) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_AsnSequenceOf( &(pObj->m_fastStart) );
	delete_AsnBoolean( &(pObj->m_mediaWaitForConnect) );
	delete_AsnBoolean( &(pObj->m_canOverlapSend) );
	delete_ASNH225EndpointIdentifier( &(pObj->m_endpointIdentifier) );
	delete_AsnBoolean( &(pObj->m_multipleCalls) );
	delete_AsnBoolean( &(pObj->m_maintainConnection) );
	delete_ASNH225Setup_UUIE_connectionParameters( &(pObj->m_connectionParameters) );
	delete_AsnSequenceOf( &(pObj->m_language) );
	delete_ASNH225PresentationIndicator( &(pObj->m_presentationIndicator) );
	delete_ASNH225ScreeningIndicator( &(pObj->m_screeningIndicator) );
	delete_AsnSequenceOf( &(pObj->m_serviceControl) );
	delete_AsnNull( &(pObj->m_symmetricOperationRequired) );
	delete_ASNH225CallCapacity( &(pObj->m_capacity) );
	delete_ASNH225CircuitInfo( &(pObj->m_circuitInfo) );
	delete_AsnSequenceOf( &(pObj->m_desiredProtocols) );
	delete_AsnSequenceOf( &(pObj->m_neededFeatures) );
	delete_AsnSequenceOf( &(pObj->m_desiredFeatures) );
	delete_AsnSequenceOf( &(pObj->m_supportedFeatures) );
	delete_AsnSequenceOf( &(pObj->m_parallelH245Control) );
	delete_AsnSequenceOf( &(pObj->m_additionalSourceAddresses) );
	return HS_OK;
}

/* ASNH225Setup_UUIE MakeMold */
HS_RESULT ASNH225Setup_UUIE_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225Setup_UUIE *pObj = (ASNH225Setup_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225ProtocolIdentifier_MakeMold(&(pObj->m_protocolIdentifier));
	ASNH225TransportAddress_MakeMold(&(pObj->m_h245Address));
	{
	ASNH225AliasAddress *tmold_sourceAddress = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
	new_ASNH225AliasAddress(tmold_sourceAddress);
	ASNH225AliasAddress_MakeMold(tmold_sourceAddress);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_sourceAddress,sizeof(ASNH225AliasAddress),ASNH225AliasAddress_MakeMold,ASNH225AliasAddress_Encode,ASNH225AliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225AliasAddress_Print,
#endif
		delete_ASNH225AliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_sourceAddress), moldObject );
	}
	ASNH225EndpointType_MakeMold(&(pObj->m_sourceInfo));
	{
	ASNH225AliasAddress *tmold_destinationAddress = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
	new_ASNH225AliasAddress(tmold_destinationAddress);
	ASNH225AliasAddress_MakeMold(tmold_destinationAddress);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_destinationAddress,sizeof(ASNH225AliasAddress),ASNH225AliasAddress_MakeMold,ASNH225AliasAddress_Encode,ASNH225AliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225AliasAddress_Print,
#endif
		delete_ASNH225AliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_destinationAddress), moldObject );
	}
	ASNH225TransportAddress_MakeMold(&(pObj->m_destCallSignalAddress));
	{
	ASNH225AliasAddress *tmold_destExtraCallInfo = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
	new_ASNH225AliasAddress(tmold_destExtraCallInfo);
	ASNH225AliasAddress_MakeMold(tmold_destExtraCallInfo);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_destExtraCallInfo,sizeof(ASNH225AliasAddress),ASNH225AliasAddress_MakeMold,ASNH225AliasAddress_Encode,ASNH225AliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225AliasAddress_Print,
#endif
		delete_ASNH225AliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_destExtraCallInfo), moldObject );
	}
	{
	ASNH225CallReferenceValue *tmold_destExtraCRV = (ASNH225CallReferenceValue *)HSMalloc( sizeof(ASNH225CallReferenceValue) );
	new_ASNH225CallReferenceValue(tmold_destExtraCRV);
	ASNH225CallReferenceValue_MakeMold(tmold_destExtraCRV);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_destExtraCRV,sizeof(ASNH225CallReferenceValue),ASNH225CallReferenceValue_MakeMold,ASNH225CallReferenceValue_Encode,ASNH225CallReferenceValue_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CallReferenceValue_Print,
#endif
		delete_ASNH225CallReferenceValue);
	AsnSequenceOf_SetMold( &(pObj->m_destExtraCRV), moldObject );
	}
	ASNH225ConferenceIdentifier_MakeMold(&(pObj->m_conferenceID));
	ASNH225QseriesOptions_MakeMold(&(pObj->m_callServices));
	ASNH225CallType_MakeMold(&(pObj->m_callType));
	ASNH225TransportAddress_MakeMold(&(pObj->m_sourceCallSignalAddress));
	ASNH225AliasAddress_MakeMold(&(pObj->m_remoteExtensionAddress));
	ASNH225CallIdentifier_MakeMold(&(pObj->m_callIdentifier));
	{
	ASNH225H245Security *tmold_h245SecurityCapability = (ASNH225H245Security *)HSMalloc( sizeof(ASNH225H245Security) );
	new_ASNH225H245Security(tmold_h245SecurityCapability);
	ASNH225H245Security_MakeMold(tmold_h245SecurityCapability);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_h245SecurityCapability,sizeof(ASNH225H245Security),ASNH225H245Security_MakeMold,ASNH225H245Security_Encode,ASNH225H245Security_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225H245Security_Print,
#endif
		delete_ASNH225H245Security);
	AsnSequenceOf_SetMold( &(pObj->m_h245SecurityCapability), moldObject );
	}
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	{
	AsnOctetString *tmold_fastStart = (AsnOctetString *)HSMalloc( sizeof(AsnOctetString) );
	new_AsnOctetString(tmold_fastStart,e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_fastStart,sizeof(AsnOctetString),AsnOctetString_MakeMold,AsnOctetString_Encode,AsnOctetString_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		AsnOctetString_Print,
#endif
		delete_AsnOctetString);
	AsnSequenceOf_SetMold( &(pObj->m_fastStart), moldObject );
	}
	ASNH225EndpointIdentifier_MakeMold(&(pObj->m_endpointIdentifier));
	ASNH225Setup_UUIE_connectionParameters_MakeMold(&(pObj->m_connectionParameters));
	{
	AsnSingleString *tmold_language = (AsnSingleString *)HSMalloc( sizeof(AsnSingleString) );
	new_AsnSingleString(tmold_language,e_asnTagIA5String,e_constrained,1,32,0,HS_ASN_MAX_CONSTRAINT);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_language,sizeof(AsnSingleString),AsnSingleString_MakeMold,AsnSingleString_Encode,AsnSingleString_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		AsnSingleString_Print,
#endif
		delete_AsnSingleString);
	AsnSequenceOf_SetMold( &(pObj->m_language), moldObject );
	}
	ASNH225PresentationIndicator_MakeMold(&(pObj->m_presentationIndicator));
	ASNH225ScreeningIndicator_MakeMold(&(pObj->m_screeningIndicator));
	{
	ASNH225ServiceControlSession *tmold_serviceControl = (ASNH225ServiceControlSession *)HSMalloc( sizeof(ASNH225ServiceControlSession) );
	new_ASNH225ServiceControlSession(tmold_serviceControl);
	ASNH225ServiceControlSession_MakeMold(tmold_serviceControl);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_serviceControl,sizeof(ASNH225ServiceControlSession),ASNH225ServiceControlSession_MakeMold,ASNH225ServiceControlSession_Encode,ASNH225ServiceControlSession_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ServiceControlSession_Print,
#endif
		delete_ASNH225ServiceControlSession);
	AsnSequenceOf_SetMold( &(pObj->m_serviceControl), moldObject );
	}
	ASNH225CallCapacity_MakeMold(&(pObj->m_capacity));
	ASNH225CircuitInfo_MakeMold(&(pObj->m_circuitInfo));
	{
	ASNH225SupportedProtocols *tmold_desiredProtocols = (ASNH225SupportedProtocols *)HSMalloc( sizeof(ASNH225SupportedProtocols) );
	new_ASNH225SupportedProtocols(tmold_desiredProtocols);
	ASNH225SupportedProtocols_MakeMold(tmold_desiredProtocols);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_desiredProtocols,sizeof(ASNH225SupportedProtocols),ASNH225SupportedProtocols_MakeMold,ASNH225SupportedProtocols_Encode,ASNH225SupportedProtocols_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225SupportedProtocols_Print,
#endif
		delete_ASNH225SupportedProtocols);
	AsnSequenceOf_SetMold( &(pObj->m_desiredProtocols), moldObject );
	}
	{
	ASNH225FeatureDescriptor *tmold_neededFeatures = (ASNH225FeatureDescriptor *)HSMalloc( sizeof(ASNH225FeatureDescriptor) );
	new_ASNH225FeatureDescriptor(tmold_neededFeatures);
	ASNH225FeatureDescriptor_MakeMold(tmold_neededFeatures);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_neededFeatures,sizeof(ASNH225FeatureDescriptor),ASNH225FeatureDescriptor_MakeMold,ASNH225FeatureDescriptor_Encode,ASNH225FeatureDescriptor_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225FeatureDescriptor_Print,
#endif
		delete_ASNH225FeatureDescriptor);
	AsnSequenceOf_SetMold( &(pObj->m_neededFeatures), moldObject );
	}
	{
	ASNH225FeatureDescriptor *tmold_desiredFeatures = (ASNH225FeatureDescriptor *)HSMalloc( sizeof(ASNH225FeatureDescriptor) );
	new_ASNH225FeatureDescriptor(tmold_desiredFeatures);
	ASNH225FeatureDescriptor_MakeMold(tmold_desiredFeatures);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_desiredFeatures,sizeof(ASNH225FeatureDescriptor),ASNH225FeatureDescriptor_MakeMold,ASNH225FeatureDescriptor_Encode,ASNH225FeatureDescriptor_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225FeatureDescriptor_Print,
#endif
		delete_ASNH225FeatureDescriptor);
	AsnSequenceOf_SetMold( &(pObj->m_desiredFeatures), moldObject );
	}
	{
	ASNH225FeatureDescriptor *tmold_supportedFeatures = (ASNH225FeatureDescriptor *)HSMalloc( sizeof(ASNH225FeatureDescriptor) );
	new_ASNH225FeatureDescriptor(tmold_supportedFeatures);
	ASNH225FeatureDescriptor_MakeMold(tmold_supportedFeatures);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_supportedFeatures,sizeof(ASNH225FeatureDescriptor),ASNH225FeatureDescriptor_MakeMold,ASNH225FeatureDescriptor_Encode,ASNH225FeatureDescriptor_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225FeatureDescriptor_Print,
#endif
		delete_ASNH225FeatureDescriptor);
	AsnSequenceOf_SetMold( &(pObj->m_supportedFeatures), moldObject );
	}
	{
	AsnOctetString *tmold_parallelH245Control = (AsnOctetString *)HSMalloc( sizeof(AsnOctetString) );
	new_AsnOctetString(tmold_parallelH245Control,e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_parallelH245Control,sizeof(AsnOctetString),AsnOctetString_MakeMold,AsnOctetString_Encode,AsnOctetString_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		AsnOctetString_Print,
#endif
		delete_AsnOctetString);
	AsnSequenceOf_SetMold( &(pObj->m_parallelH245Control), moldObject );
	}
	{
	ASNH225ExtendedAliasAddress *tmold_additionalSourceAddresses = (ASNH225ExtendedAliasAddress *)HSMalloc( sizeof(ASNH225ExtendedAliasAddress) );
	new_ASNH225ExtendedAliasAddress(tmold_additionalSourceAddresses);
	ASNH225ExtendedAliasAddress_MakeMold(tmold_additionalSourceAddresses);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_additionalSourceAddresses,sizeof(ASNH225ExtendedAliasAddress),ASNH225ExtendedAliasAddress_MakeMold,ASNH225ExtendedAliasAddress_Encode,ASNH225ExtendedAliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ExtendedAliasAddress_Print,
#endif
		delete_ASNH225ExtendedAliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_additionalSourceAddresses), moldObject );
	}
	return HS_OK;
}

/* ASNH225Setup_UUIE IncludeOptionalField */
HS_RESULT ASNH225Setup_UUIE_IncludeOptionField( void *pObject, ASNH225Setup_UUIEOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225Setup_UUIE *pObj = (ASNH225Setup_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225Setup_UUIEOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225Setup_UUIEOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225Setup_UUIEOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225Setup_UUIE IsIncludeOptionalField */
BOOL ASNH225Setup_UUIE_IsIncludeOptionField( void *pObject, ASNH225Setup_UUIEOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225Setup_UUIE *pObj = (ASNH225Setup_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225Setup_UUIEOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225Setup_UUIEOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225Setup_UUIEOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}


/* ASNH225Setup_UUIE Encode */
HS_RESULT ASNH225Setup_UUIE_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225Setup_UUIE *pObj = (ASNH225Setup_UUIE *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225Setup_UUIEOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225Setup_UUIEOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225ProtocolIdentifier_Encode( &(pObj->m_protocolIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_h245Address ) ){
		if( (tRet=ASNH225TransportAddress_Encode( &(pObj->m_h245Address),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_sourceAddress ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_sourceAddress),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225EndpointType_Encode( &(pObj->m_sourceInfo),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_destinationAddress ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_destinationAddress),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_destCallSignalAddress ) ){
		if( (tRet=ASNH225TransportAddress_Encode( &(pObj->m_destCallSignalAddress),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_destExtraCallInfo ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_destExtraCallInfo),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_destExtraCRV ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_destExtraCRV),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnBoolean_Encode( &(pObj->m_activeMC),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225ConferenceIdentifier_Encode( &(pObj->m_conferenceID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225Setup_UUIE_conferenceGoal_Encode( &(pObj->m_conferenceGoal),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_callServices ) ){
		if( (tRet=ASNH225QseriesOptions_Encode( &(pObj->m_callServices),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225CallType_Encode( &(pObj->m_callType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_sourceCallSignalAddress ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_sourceCallSignalAddress), ASNH225TransportAddress_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_remoteExtensionAddress ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_remoteExtensionAddress), ASNH225AliasAddress_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_callIdentifier ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_h245SecurityCapability ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_h245SecurityCapability), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_fastStart ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_fastStart), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_mediaWaitForConnect ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_mediaWaitForConnect), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_canOverlapSend ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_canOverlapSend), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_endpointIdentifier ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_endpointIdentifier), ASNH225EndpointIdentifier_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_multipleCalls ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_multipleCalls), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_maintainConnection ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_maintainConnection), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_connectionParameters ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_connectionParameters), ASNH225Setup_UUIE_connectionParameters_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_language ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_language), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_presentationIndicator ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_presentationIndicator), ASNH225PresentationIndicator_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_screeningIndicator ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_screeningIndicator), ASNH225ScreeningIndicator_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_serviceControl ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_serviceControl), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_symmetricOperationRequired ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_symmetricOperationRequired), AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_capacity ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_capacity), ASNH225CallCapacity_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_circuitInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_circuitInfo), ASNH225CircuitInfo_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_desiredProtocols ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_desiredProtocols), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_neededFeatures ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_neededFeatures), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_desiredFeatures ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_desiredFeatures), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_supportedFeatures ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_supportedFeatures), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_parallelH245Control ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_parallelH245Control), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_additionalSourceAddresses ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_additionalSourceAddresses), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Setup_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225Setup_UUIE Decode */
HS_RESULT ASNH225Setup_UUIE_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225Setup_UUIE *pObj = (ASNH225Setup_UUIE *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225Setup_UUIEOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225Setup_UUIEOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225ProtocolIdentifier_Decode(&(pObj->m_protocolIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_h245Address ) ){
		if( (tRet=ASNH225TransportAddress_Decode(&(pObj->m_h245Address),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_sourceAddress ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_sourceAddress),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225EndpointType_Decode(&(pObj->m_sourceInfo),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_destinationAddress ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_destinationAddress),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_destCallSignalAddress ) ){
		if( (tRet=ASNH225TransportAddress_Decode(&(pObj->m_destCallSignalAddress),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_destExtraCallInfo ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_destExtraCallInfo),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_destExtraCRV ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_destExtraCRV),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=AsnBoolean_Decode(&(pObj->m_activeMC),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225ConferenceIdentifier_Decode(&(pObj->m_conferenceID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225Setup_UUIE_conferenceGoal_Decode(&(pObj->m_conferenceGoal),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_callServices ) ){
		if( (tRet=ASNH225QseriesOptions_Decode(&(pObj->m_callServices),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225CallType_Decode(&(pObj->m_callType),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_sourceCallSignalAddress ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_sourceCallSignalAddress), ASNH225TransportAddress_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_remoteExtensionAddress ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_remoteExtensionAddress), ASNH225AliasAddress_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_callIdentifier ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_h245SecurityCapability ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_h245SecurityCapability), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_fastStart ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_fastStart), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_mediaWaitForConnect ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_mediaWaitForConnect), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_canOverlapSend ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_canOverlapSend), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_endpointIdentifier ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_endpointIdentifier), ASNH225EndpointIdentifier_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_multipleCalls ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_multipleCalls), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_maintainConnection ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_maintainConnection), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_connectionParameters ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_connectionParameters), ASNH225Setup_UUIE_connectionParameters_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_language ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_language), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_presentationIndicator ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_presentationIndicator), ASNH225PresentationIndicator_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_screeningIndicator ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_screeningIndicator), ASNH225ScreeningIndicator_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_serviceControl ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_serviceControl), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_symmetricOperationRequired ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_symmetricOperationRequired), AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_capacity ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_capacity), ASNH225CallCapacity_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_circuitInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_circuitInfo), ASNH225CircuitInfo_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_desiredProtocols ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_desiredProtocols), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_neededFeatures ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_neededFeatures), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_desiredFeatures ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_desiredFeatures), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_supportedFeatures ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_supportedFeatures), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_parallelH245Control ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_parallelH245Control), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_additionalSourceAddresses ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_additionalSourceAddresses), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Setup_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225Setup_UUIE Print */
HS_RESULT ASNH225Setup_UUIE_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225Setup_UUIE *pObj = (ASNH225Setup_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225Setup_UUIE_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225ProtocolIdentifier_Print( &(pObj->m_protocolIdentifier), pDepth+1, "protocolIdentifier" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_h245Address ) )
		ASNH225TransportAddress_Print( &(pObj->m_h245Address), pDepth+1, "h245Address" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_sourceAddress ) )
		AsnSequenceOf_Print( &(pObj->m_sourceAddress), pDepth+1, "sourceAddress" );
	ASNH225EndpointType_Print( &(pObj->m_sourceInfo), pDepth+1, "sourceInfo" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_destinationAddress ) )
		AsnSequenceOf_Print( &(pObj->m_destinationAddress), pDepth+1, "destinationAddress" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_destCallSignalAddress ) )
		ASNH225TransportAddress_Print( &(pObj->m_destCallSignalAddress), pDepth+1, "destCallSignalAddress" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_destExtraCallInfo ) )
		AsnSequenceOf_Print( &(pObj->m_destExtraCallInfo), pDepth+1, "destExtraCallInfo" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_destExtraCRV ) )
		AsnSequenceOf_Print( &(pObj->m_destExtraCRV), pDepth+1, "destExtraCRV" );
	AsnBoolean_Print( &(pObj->m_activeMC), pDepth+1, "activeMC" );
	ASNH225ConferenceIdentifier_Print( &(pObj->m_conferenceID), pDepth+1, "conferenceID" );
	ASNH225Setup_UUIE_conferenceGoal_Print( &(pObj->m_conferenceGoal), pDepth+1, "conferenceGoal" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_callServices ) )
		ASNH225QseriesOptions_Print( &(pObj->m_callServices), pDepth+1, "callServices" );
	ASNH225CallType_Print( &(pObj->m_callType), pDepth+1, "callType" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_sourceCallSignalAddress ) )
		ASNH225TransportAddress_Print( &(pObj->m_sourceCallSignalAddress), pDepth+1, "sourceCallSignalAddress" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_remoteExtensionAddress ) )
		ASNH225AliasAddress_Print( &(pObj->m_remoteExtensionAddress), pDepth+1, "remoteExtensionAddress" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_callIdentifier ) )
		ASNH225CallIdentifier_Print( &(pObj->m_callIdentifier), pDepth+1, "callIdentifier" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_h245SecurityCapability ) )
		AsnSequenceOf_Print( &(pObj->m_h245SecurityCapability), pDepth+1, "h245SecurityCapability" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_fastStart ) )
		AsnSequenceOf_Print( &(pObj->m_fastStart), pDepth+1, "fastStart" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_mediaWaitForConnect ) )
		AsnBoolean_Print( &(pObj->m_mediaWaitForConnect), pDepth+1, "mediaWaitForConnect" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_canOverlapSend ) )
		AsnBoolean_Print( &(pObj->m_canOverlapSend), pDepth+1, "canOverlapSend" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_endpointIdentifier ) )
		ASNH225EndpointIdentifier_Print( &(pObj->m_endpointIdentifier), pDepth+1, "endpointIdentifier" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_multipleCalls ) )
		AsnBoolean_Print( &(pObj->m_multipleCalls), pDepth+1, "multipleCalls" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_maintainConnection ) )
		AsnBoolean_Print( &(pObj->m_maintainConnection), pDepth+1, "maintainConnection" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_connectionParameters ) )
		ASNH225Setup_UUIE_connectionParameters_Print( &(pObj->m_connectionParameters), pDepth+1, "connectionParameters" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_language ) )
		AsnSequenceOf_Print( &(pObj->m_language), pDepth+1, "language" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_presentationIndicator ) )
		ASNH225PresentationIndicator_Print( &(pObj->m_presentationIndicator), pDepth+1, "presentationIndicator" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_screeningIndicator ) )
		ASNH225ScreeningIndicator_Print( &(pObj->m_screeningIndicator), pDepth+1, "screeningIndicator" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_serviceControl ) )
		AsnSequenceOf_Print( &(pObj->m_serviceControl), pDepth+1, "serviceControl" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_symmetricOperationRequired ) )
		AsnNull_Print( &(pObj->m_symmetricOperationRequired), pDepth+1, "symmetricOperationRequired" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_capacity ) )
		ASNH225CallCapacity_Print( &(pObj->m_capacity), pDepth+1, "capacity" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_circuitInfo ) )
		ASNH225CircuitInfo_Print( &(pObj->m_circuitInfo), pDepth+1, "circuitInfo" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_desiredProtocols ) )
		AsnSequenceOf_Print( &(pObj->m_desiredProtocols), pDepth+1, "desiredProtocols" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_neededFeatures ) )
		AsnSequenceOf_Print( &(pObj->m_neededFeatures), pDepth+1, "neededFeatures" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_desiredFeatures ) )
		AsnSequenceOf_Print( &(pObj->m_desiredFeatures), pDepth+1, "desiredFeatures" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_supportedFeatures ) )
		AsnSequenceOf_Print( &(pObj->m_supportedFeatures), pDepth+1, "supportedFeatures" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_parallelH245Control ) )
		AsnSequenceOf_Print( &(pObj->m_parallelH245Control), pDepth+1, "parallelH245Control" );
	if( ASNH225Setup_UUIE_IsIncludeOptionField( pObj, e_ASNH225Setup_UUIEOptionMap_additionalSourceAddresses ) )
		AsnSequenceOf_Print( &(pObj->m_additionalSourceAddresses), pDepth+1, "additionalSourceAddresses" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225FeatureSet Class
*/
/*ASNH225FeatureSet Constructor*/
HS_RESULT new_ASNH225FeatureSet(void *pObject)
{
	ASNH225FeatureSet *pObj = (ASNH225FeatureSet *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225FeatureSet(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_AsnBoolean( &(pObj->m_replacementFeatureSet) );
	new_AsnSequenceOf( &(pObj->m_neededFeatures), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_desiredFeatures), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_supportedFeatures), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225FeatureSet Destructor */
HS_RESULT delete_ASNH225FeatureSet(void *pObject)
{
	ASNH225FeatureSet *pObj = (ASNH225FeatureSet *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225FeatureSet(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_AsnBoolean( &(pObj->m_replacementFeatureSet) );
	delete_AsnSequenceOf( &(pObj->m_neededFeatures) );
	delete_AsnSequenceOf( &(pObj->m_desiredFeatures) );
	delete_AsnSequenceOf( &(pObj->m_supportedFeatures) );
	return HS_OK;
}

/* ASNH225FeatureSet MakeMold */
HS_RESULT ASNH225FeatureSet_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225FeatureSet *pObj = (ASNH225FeatureSet *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225FeatureSet_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	{
	ASNH225FeatureDescriptor *tmold_neededFeatures = (ASNH225FeatureDescriptor *)HSMalloc( sizeof(ASNH225FeatureDescriptor) );
	new_ASNH225FeatureDescriptor(tmold_neededFeatures);
	ASNH225FeatureDescriptor_MakeMold(tmold_neededFeatures);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_neededFeatures,sizeof(ASNH225FeatureDescriptor),ASNH225FeatureDescriptor_MakeMold,ASNH225FeatureDescriptor_Encode,ASNH225FeatureDescriptor_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225FeatureDescriptor_Print,
#endif
		delete_ASNH225FeatureDescriptor);
	AsnSequenceOf_SetMold( &(pObj->m_neededFeatures), moldObject );
	}
	{
	ASNH225FeatureDescriptor *tmold_desiredFeatures = (ASNH225FeatureDescriptor *)HSMalloc( sizeof(ASNH225FeatureDescriptor) );
	new_ASNH225FeatureDescriptor(tmold_desiredFeatures);
	ASNH225FeatureDescriptor_MakeMold(tmold_desiredFeatures);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_desiredFeatures,sizeof(ASNH225FeatureDescriptor),ASNH225FeatureDescriptor_MakeMold,ASNH225FeatureDescriptor_Encode,ASNH225FeatureDescriptor_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225FeatureDescriptor_Print,
#endif
		delete_ASNH225FeatureDescriptor);
	AsnSequenceOf_SetMold( &(pObj->m_desiredFeatures), moldObject );
	}
	{
	ASNH225FeatureDescriptor *tmold_supportedFeatures = (ASNH225FeatureDescriptor *)HSMalloc( sizeof(ASNH225FeatureDescriptor) );
	new_ASNH225FeatureDescriptor(tmold_supportedFeatures);
	ASNH225FeatureDescriptor_MakeMold(tmold_supportedFeatures);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_supportedFeatures,sizeof(ASNH225FeatureDescriptor),ASNH225FeatureDescriptor_MakeMold,ASNH225FeatureDescriptor_Encode,ASNH225FeatureDescriptor_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225FeatureDescriptor_Print,
#endif
		delete_ASNH225FeatureDescriptor);
	AsnSequenceOf_SetMold( &(pObj->m_supportedFeatures), moldObject );
	}
	return HS_OK;
}

/* ASNH225FeatureSet IncludeOptionalField */
HS_RESULT ASNH225FeatureSet_IncludeOptionField( void *pObject, ASNH225FeatureSetOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225FeatureSet *pObj = (ASNH225FeatureSet *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225FeatureSet_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225FeatureSetOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225FeatureSet IsIncludeOptionalField */
BOOL ASNH225FeatureSet_IsIncludeOptionField( void *pObject, ASNH225FeatureSetOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225FeatureSet *pObj = (ASNH225FeatureSet *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225FeatureSet_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225FeatureSetOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225FeatureSet Encode */
HS_RESULT ASNH225FeatureSet_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225FeatureSet *pObj = (ASNH225FeatureSet *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225FeatureSet_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225FeatureSetOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225FeatureSetOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnBoolean_Encode( &(pObj->m_replacementFeatureSet),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225FeatureSet_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225FeatureSet_IsIncludeOptionField( pObj, e_ASNH225FeatureSetOptionMap_neededFeatures ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_neededFeatures),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FeatureSet_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225FeatureSet_IsIncludeOptionField( pObj, e_ASNH225FeatureSetOptionMap_desiredFeatures ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_desiredFeatures),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FeatureSet_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225FeatureSet_IsIncludeOptionField( pObj, e_ASNH225FeatureSetOptionMap_supportedFeatures ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_supportedFeatures),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FeatureSet_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225FeatureSet Decode */
HS_RESULT ASNH225FeatureSet_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225FeatureSet *pObj = (ASNH225FeatureSet *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225FeatureSet_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225FeatureSetOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225FeatureSetOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=AsnBoolean_Decode(&(pObj->m_replacementFeatureSet),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225FeatureSet_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225FeatureSet_IsIncludeOptionField( pObj, e_ASNH225FeatureSetOptionMap_neededFeatures ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_neededFeatures),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FeatureSet_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225FeatureSet_IsIncludeOptionField( pObj, e_ASNH225FeatureSetOptionMap_desiredFeatures ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_desiredFeatures),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FeatureSet_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225FeatureSet_IsIncludeOptionField( pObj, e_ASNH225FeatureSetOptionMap_supportedFeatures ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_supportedFeatures),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FeatureSet_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225FeatureSet Print */
HS_RESULT ASNH225FeatureSet_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225FeatureSet *pObj = (ASNH225FeatureSet *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225FeatureSet_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	AsnBoolean_Print( &(pObj->m_replacementFeatureSet), pDepth+1, "replacementFeatureSet" );
	if( ASNH225FeatureSet_IsIncludeOptionField( pObj, e_ASNH225FeatureSetOptionMap_neededFeatures ) )
		AsnSequenceOf_Print( &(pObj->m_neededFeatures), pDepth+1, "neededFeatures" );
	if( ASNH225FeatureSet_IsIncludeOptionField( pObj, e_ASNH225FeatureSetOptionMap_desiredFeatures ) )
		AsnSequenceOf_Print( &(pObj->m_desiredFeatures), pDepth+1, "desiredFeatures" );
	if( ASNH225FeatureSet_IsIncludeOptionField( pObj, e_ASNH225FeatureSetOptionMap_supportedFeatures ) )
		AsnSequenceOf_Print( &(pObj->m_supportedFeatures), pDepth+1, "supportedFeatures" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225CallProceeding_UUIE Class
*/
/*ASNH225CallProceeding_UUIE Constructor*/
HS_RESULT new_ASNH225CallProceeding_UUIE(void *pObject)
{
	ASNH225CallProceeding_UUIE *pObj = (ASNH225CallProceeding_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225CallProceeding_UUIE(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225ProtocolIdentifier( &(pObj->m_protocolIdentifier) );
	new_ASNH225EndpointType( &(pObj->m_destinationInfo) );
	new_ASNH225TransportAddress( &(pObj->m_h245Address) );
	new_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	new_ASNH225H245Security( &(pObj->m_h245SecurityMode) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_fastStart), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_multipleCalls) );
	new_AsnBoolean( &(pObj->m_maintainConnection) );
	new_AsnNull( &(pObj->m_fastConnectRefused) );
	new_ASNH225FeatureSet( &(pObj->m_featureSet) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225CallProceeding_UUIE Destructor */
HS_RESULT delete_ASNH225CallProceeding_UUIE(void *pObject)
{
	ASNH225CallProceeding_UUIE *pObj = (ASNH225CallProceeding_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225CallProceeding_UUIE(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225ProtocolIdentifier( &(pObj->m_protocolIdentifier) );
	delete_ASNH225EndpointType( &(pObj->m_destinationInfo) );
	delete_ASNH225TransportAddress( &(pObj->m_h245Address) );
	delete_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	delete_ASNH225H245Security( &(pObj->m_h245SecurityMode) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_AsnSequenceOf( &(pObj->m_fastStart) );
	delete_AsnBoolean( &(pObj->m_multipleCalls) );
	delete_AsnBoolean( &(pObj->m_maintainConnection) );
	delete_AsnNull( &(pObj->m_fastConnectRefused) );
	delete_ASNH225FeatureSet( &(pObj->m_featureSet) );
	return HS_OK;
}

/* ASNH225CallProceeding_UUIE MakeMold */
HS_RESULT ASNH225CallProceeding_UUIE_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225CallProceeding_UUIE *pObj = (ASNH225CallProceeding_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallProceeding_UUIE_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225ProtocolIdentifier_MakeMold(&(pObj->m_protocolIdentifier));
	ASNH225EndpointType_MakeMold(&(pObj->m_destinationInfo));
	ASNH225TransportAddress_MakeMold(&(pObj->m_h245Address));
	ASNH225CallIdentifier_MakeMold(&(pObj->m_callIdentifier));
	ASNH225H245Security_MakeMold(&(pObj->m_h245SecurityMode));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	{
	AsnOctetString *tmold_fastStart = (AsnOctetString *)HSMalloc( sizeof(AsnOctetString) );
	new_AsnOctetString(tmold_fastStart,e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_fastStart,sizeof(AsnOctetString),AsnOctetString_MakeMold,AsnOctetString_Encode,AsnOctetString_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		AsnOctetString_Print,
#endif
		delete_AsnOctetString);
	AsnSequenceOf_SetMold( &(pObj->m_fastStart), moldObject );
	}
	ASNH225FeatureSet_MakeMold(&(pObj->m_featureSet));
	return HS_OK;
}

/* ASNH225CallProceeding_UUIE IncludeOptionalField */
HS_RESULT ASNH225CallProceeding_UUIE_IncludeOptionField( void *pObject, ASNH225CallProceeding_UUIEOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225CallProceeding_UUIE *pObj = (ASNH225CallProceeding_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallProceeding_UUIE_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225CallProceeding_UUIEOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225CallProceeding_UUIEOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225CallProceeding_UUIEOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225CallProceeding_UUIE IsIncludeOptionalField */
BOOL ASNH225CallProceeding_UUIE_IsIncludeOptionField( void *pObject, ASNH225CallProceeding_UUIEOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225CallProceeding_UUIE *pObj = (ASNH225CallProceeding_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallProceeding_UUIE_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225CallProceeding_UUIEOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225CallProceeding_UUIEOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225CallProceeding_UUIEOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225CallProceeding_UUIE Encode */
HS_RESULT ASNH225CallProceeding_UUIE_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225CallProceeding_UUIE *pObj = (ASNH225CallProceeding_UUIE *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225CallProceeding_UUIEOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225CallProceeding_UUIEOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225ProtocolIdentifier_Encode( &(pObj->m_protocolIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225EndpointType_Encode( &(pObj->m_destinationInfo),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_h245Address ) ){
		if( (tRet=ASNH225TransportAddress_Encode( &(pObj->m_h245Address),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_callIdentifier ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_h245SecurityMode ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_h245SecurityMode), ASNH225H245Security_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_fastStart ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_fastStart), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_multipleCalls ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_multipleCalls), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_maintainConnection ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_maintainConnection), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_fastConnectRefused ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_fastConnectRefused), AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_featureSet ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_featureSet), ASNH225FeatureSet_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225CallProceeding_UUIE Decode */
HS_RESULT ASNH225CallProceeding_UUIE_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225CallProceeding_UUIE *pObj = (ASNH225CallProceeding_UUIE *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225CallProceeding_UUIEOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225CallProceeding_UUIEOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225ProtocolIdentifier_Decode(&(pObj->m_protocolIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225EndpointType_Decode(&(pObj->m_destinationInfo),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_h245Address ) ){
		if( (tRet=ASNH225TransportAddress_Decode(&(pObj->m_h245Address),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_callIdentifier ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_h245SecurityMode ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_h245SecurityMode), ASNH225H245Security_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_fastStart ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_fastStart), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_multipleCalls ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_multipleCalls), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_maintainConnection ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_maintainConnection), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_fastConnectRefused ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_fastConnectRefused), AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_featureSet ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_featureSet), ASNH225FeatureSet_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225CallProceeding_UUIE Print */
HS_RESULT ASNH225CallProceeding_UUIE_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225CallProceeding_UUIE *pObj = (ASNH225CallProceeding_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225CallProceeding_UUIE_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225ProtocolIdentifier_Print( &(pObj->m_protocolIdentifier), pDepth+1, "protocolIdentifier" );
	ASNH225EndpointType_Print( &(pObj->m_destinationInfo), pDepth+1, "destinationInfo" );
	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_h245Address ) )
		ASNH225TransportAddress_Print( &(pObj->m_h245Address), pDepth+1, "h245Address" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_callIdentifier ) )
		ASNH225CallIdentifier_Print( &(pObj->m_callIdentifier), pDepth+1, "callIdentifier" );
	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_h245SecurityMode ) )
		ASNH225H245Security_Print( &(pObj->m_h245SecurityMode), pDepth+1, "h245SecurityMode" );
	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_fastStart ) )
		AsnSequenceOf_Print( &(pObj->m_fastStart), pDepth+1, "fastStart" );
	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_multipleCalls ) )
		AsnBoolean_Print( &(pObj->m_multipleCalls), pDepth+1, "multipleCalls" );
	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_maintainConnection ) )
		AsnBoolean_Print( &(pObj->m_maintainConnection), pDepth+1, "maintainConnection" );
	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_fastConnectRefused ) )
		AsnNull_Print( &(pObj->m_fastConnectRefused), pDepth+1, "fastConnectRefused" );
	if( ASNH225CallProceeding_UUIE_IsIncludeOptionField( pObj, e_ASNH225CallProceeding_UUIEOptionMap_featureSet ) )
		ASNH225FeatureSet_Print( &(pObj->m_featureSet), pDepth+1, "featureSet" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225Connect_UUIE Class
*/
/*ASNH225Connect_UUIE Constructor*/
HS_RESULT new_ASNH225Connect_UUIE(void *pObject)
{
	ASNH225Connect_UUIE *pObj = (ASNH225Connect_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225Connect_UUIE(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225ProtocolIdentifier( &(pObj->m_protocolIdentifier) );
	new_ASNH225TransportAddress( &(pObj->m_h245Address) );
	new_ASNH225EndpointType( &(pObj->m_destinationInfo) );
	new_ASNH225ConferenceIdentifier( &(pObj->m_conferenceID) );
	new_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	new_ASNH225H245Security( &(pObj->m_h245SecurityMode) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_fastStart), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_multipleCalls) );
	new_AsnBoolean( &(pObj->m_maintainConnection) );
	new_AsnSequenceOf( &(pObj->m_language), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_connectedAddress), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225PresentationIndicator( &(pObj->m_presentationIndicator) );
	new_ASNH225ScreeningIndicator( &(pObj->m_screeningIndicator) );
	new_AsnNull( &(pObj->m_fastConnectRefused) );
	new_AsnSequenceOf( &(pObj->m_serviceControl), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225CallCapacity( &(pObj->m_capacity) );
	new_ASNH225FeatureSet( &(pObj->m_featureSet) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225Connect_UUIE Destructor */
HS_RESULT delete_ASNH225Connect_UUIE(void *pObject)
{
	ASNH225Connect_UUIE *pObj = (ASNH225Connect_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225Connect_UUIE(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225ProtocolIdentifier( &(pObj->m_protocolIdentifier) );
	delete_ASNH225TransportAddress( &(pObj->m_h245Address) );
	delete_ASNH225EndpointType( &(pObj->m_destinationInfo) );
	delete_ASNH225ConferenceIdentifier( &(pObj->m_conferenceID) );
	delete_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	delete_ASNH225H245Security( &(pObj->m_h245SecurityMode) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_AsnSequenceOf( &(pObj->m_fastStart) );
	delete_AsnBoolean( &(pObj->m_multipleCalls) );
	delete_AsnBoolean( &(pObj->m_maintainConnection) );
	delete_AsnSequenceOf( &(pObj->m_language) );
	delete_AsnSequenceOf( &(pObj->m_connectedAddress) );
	delete_ASNH225PresentationIndicator( &(pObj->m_presentationIndicator) );
	delete_ASNH225ScreeningIndicator( &(pObj->m_screeningIndicator) );
	delete_AsnNull( &(pObj->m_fastConnectRefused) );
	delete_AsnSequenceOf( &(pObj->m_serviceControl) );
	delete_ASNH225CallCapacity( &(pObj->m_capacity) );
	delete_ASNH225FeatureSet( &(pObj->m_featureSet) );
	return HS_OK;
}

/* ASNH225Connect_UUIE MakeMold */
HS_RESULT ASNH225Connect_UUIE_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225Connect_UUIE *pObj = (ASNH225Connect_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Connect_UUIE_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225ProtocolIdentifier_MakeMold(&(pObj->m_protocolIdentifier));
	ASNH225TransportAddress_MakeMold(&(pObj->m_h245Address));
	ASNH225EndpointType_MakeMold(&(pObj->m_destinationInfo));
	ASNH225ConferenceIdentifier_MakeMold(&(pObj->m_conferenceID));
	ASNH225CallIdentifier_MakeMold(&(pObj->m_callIdentifier));
	ASNH225H245Security_MakeMold(&(pObj->m_h245SecurityMode));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	{
	AsnOctetString *tmold_fastStart = (AsnOctetString *)HSMalloc( sizeof(AsnOctetString) );
	new_AsnOctetString(tmold_fastStart,e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_fastStart,sizeof(AsnOctetString),AsnOctetString_MakeMold,AsnOctetString_Encode,AsnOctetString_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		AsnOctetString_Print,
#endif
		delete_AsnOctetString);
	AsnSequenceOf_SetMold( &(pObj->m_fastStart), moldObject );
	}
	{
	AsnSingleString *tmold_language = (AsnSingleString *)HSMalloc( sizeof(AsnSingleString) );
	new_AsnSingleString(tmold_language,e_asnTagIA5String,e_constrained,1,32,0,HS_ASN_MAX_CONSTRAINT);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_language,sizeof(AsnSingleString),AsnSingleString_MakeMold,AsnSingleString_Encode,AsnSingleString_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		AsnSingleString_Print,
#endif
		delete_AsnSingleString);
	AsnSequenceOf_SetMold( &(pObj->m_language), moldObject );
	}
	{
	ASNH225AliasAddress *tmold_connectedAddress = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
	new_ASNH225AliasAddress(tmold_connectedAddress);
	ASNH225AliasAddress_MakeMold(tmold_connectedAddress);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_connectedAddress,sizeof(ASNH225AliasAddress),ASNH225AliasAddress_MakeMold,ASNH225AliasAddress_Encode,ASNH225AliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225AliasAddress_Print,
#endif
		delete_ASNH225AliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_connectedAddress), moldObject );
	}
	ASNH225PresentationIndicator_MakeMold(&(pObj->m_presentationIndicator));
	ASNH225ScreeningIndicator_MakeMold(&(pObj->m_screeningIndicator));
	{
	ASNH225ServiceControlSession *tmold_serviceControl = (ASNH225ServiceControlSession *)HSMalloc( sizeof(ASNH225ServiceControlSession) );
	new_ASNH225ServiceControlSession(tmold_serviceControl);
	ASNH225ServiceControlSession_MakeMold(tmold_serviceControl);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_serviceControl,sizeof(ASNH225ServiceControlSession),ASNH225ServiceControlSession_MakeMold,ASNH225ServiceControlSession_Encode,ASNH225ServiceControlSession_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ServiceControlSession_Print,
#endif
		delete_ASNH225ServiceControlSession);
	AsnSequenceOf_SetMold( &(pObj->m_serviceControl), moldObject );
	}
	ASNH225CallCapacity_MakeMold(&(pObj->m_capacity));
	ASNH225FeatureSet_MakeMold(&(pObj->m_featureSet));
	return HS_OK;
}

/* ASNH225Connect_UUIE IncludeOptionalField */
HS_RESULT ASNH225Connect_UUIE_IncludeOptionField( void *pObject, ASNH225Connect_UUIEOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225Connect_UUIE *pObj = (ASNH225Connect_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Connect_UUIE_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225Connect_UUIEOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225Connect_UUIEOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225Connect_UUIEOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225Connect_UUIE IsIncludeOptionalField */
BOOL ASNH225Connect_UUIE_IsIncludeOptionField( void *pObject, ASNH225Connect_UUIEOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225Connect_UUIE *pObj = (ASNH225Connect_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Connect_UUIE_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225Connect_UUIEOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225Connect_UUIEOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225Connect_UUIEOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225Connect_UUIE Encode */
HS_RESULT ASNH225Connect_UUIE_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225Connect_UUIE *pObj = (ASNH225Connect_UUIE *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Connect_UUIE_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225Connect_UUIEOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225Connect_UUIEOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225ProtocolIdentifier_Encode( &(pObj->m_protocolIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Connect_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_h245Address ) ){
		if( (tRet=ASNH225TransportAddress_Encode( &(pObj->m_h245Address),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Connect_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225EndpointType_Encode( &(pObj->m_destinationInfo),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Connect_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225ConferenceIdentifier_Encode( &(pObj->m_conferenceID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Connect_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_callIdentifier ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Connect_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_h245SecurityMode ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_h245SecurityMode), ASNH225H245Security_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Connect_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Connect_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Connect_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_fastStart ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_fastStart), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Connect_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_multipleCalls ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_multipleCalls), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Connect_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_maintainConnection ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_maintainConnection), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Connect_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_language ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_language), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Connect_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_connectedAddress ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_connectedAddress), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Connect_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_presentationIndicator ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_presentationIndicator), ASNH225PresentationIndicator_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Connect_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_screeningIndicator ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_screeningIndicator), ASNH225ScreeningIndicator_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Connect_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_fastConnectRefused ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_fastConnectRefused), AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Connect_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_serviceControl ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_serviceControl), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Connect_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_capacity ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_capacity), ASNH225CallCapacity_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Connect_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_featureSet ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_featureSet), ASNH225FeatureSet_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Connect_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225Connect_UUIE Decode */
HS_RESULT ASNH225Connect_UUIE_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225Connect_UUIE *pObj = (ASNH225Connect_UUIE *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Connect_UUIE_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225Connect_UUIEOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225Connect_UUIEOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225ProtocolIdentifier_Decode(&(pObj->m_protocolIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Connect_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_h245Address ) ){
		if( (tRet=ASNH225TransportAddress_Decode(&(pObj->m_h245Address),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Connect_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225EndpointType_Decode(&(pObj->m_destinationInfo),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Connect_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225ConferenceIdentifier_Decode(&(pObj->m_conferenceID),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Connect_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_callIdentifier ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Connect_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_h245SecurityMode ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_h245SecurityMode), ASNH225H245Security_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Connect_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Connect_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Connect_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_fastStart ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_fastStart), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Connect_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_multipleCalls ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_multipleCalls), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Connect_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_maintainConnection ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_maintainConnection), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Connect_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_language ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_language), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Connect_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_connectedAddress ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_connectedAddress), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Connect_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_presentationIndicator ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_presentationIndicator), ASNH225PresentationIndicator_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Connect_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_screeningIndicator ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_screeningIndicator), ASNH225ScreeningIndicator_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Connect_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_fastConnectRefused ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_fastConnectRefused), AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Connect_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_serviceControl ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_serviceControl), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Connect_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_capacity ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_capacity), ASNH225CallCapacity_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Connect_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_featureSet ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_featureSet), ASNH225FeatureSet_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Connect_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225Connect_UUIE Print */
HS_RESULT ASNH225Connect_UUIE_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225Connect_UUIE *pObj = (ASNH225Connect_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225Connect_UUIE_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225ProtocolIdentifier_Print( &(pObj->m_protocolIdentifier), pDepth+1, "protocolIdentifier" );
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_h245Address ) )
		ASNH225TransportAddress_Print( &(pObj->m_h245Address), pDepth+1, "h245Address" );
	ASNH225EndpointType_Print( &(pObj->m_destinationInfo), pDepth+1, "destinationInfo" );
	ASNH225ConferenceIdentifier_Print( &(pObj->m_conferenceID), pDepth+1, "conferenceID" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_callIdentifier ) )
		ASNH225CallIdentifier_Print( &(pObj->m_callIdentifier), pDepth+1, "callIdentifier" );
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_h245SecurityMode ) )
		ASNH225H245Security_Print( &(pObj->m_h245SecurityMode), pDepth+1, "h245SecurityMode" );
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_fastStart ) )
		AsnSequenceOf_Print( &(pObj->m_fastStart), pDepth+1, "fastStart" );
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_multipleCalls ) )
		AsnBoolean_Print( &(pObj->m_multipleCalls), pDepth+1, "multipleCalls" );
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_maintainConnection ) )
		AsnBoolean_Print( &(pObj->m_maintainConnection), pDepth+1, "maintainConnection" );
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_language ) )
		AsnSequenceOf_Print( &(pObj->m_language), pDepth+1, "language" );
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_connectedAddress ) )
		AsnSequenceOf_Print( &(pObj->m_connectedAddress), pDepth+1, "connectedAddress" );
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_presentationIndicator ) )
		ASNH225PresentationIndicator_Print( &(pObj->m_presentationIndicator), pDepth+1, "presentationIndicator" );
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_screeningIndicator ) )
		ASNH225ScreeningIndicator_Print( &(pObj->m_screeningIndicator), pDepth+1, "screeningIndicator" );
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_fastConnectRefused ) )
		AsnNull_Print( &(pObj->m_fastConnectRefused), pDepth+1, "fastConnectRefused" );
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_serviceControl ) )
		AsnSequenceOf_Print( &(pObj->m_serviceControl), pDepth+1, "serviceControl" );
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_capacity ) )
		ASNH225CallCapacity_Print( &(pObj->m_capacity), pDepth+1, "capacity" );
	if( ASNH225Connect_UUIE_IsIncludeOptionField( pObj, e_ASNH225Connect_UUIEOptionMap_featureSet ) )
		ASNH225FeatureSet_Print( &(pObj->m_featureSet), pDepth+1, "featureSet" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225Alerting_UUIE Class
*/
/*ASNH225Alerting_UUIE Constructor*/
HS_RESULT new_ASNH225Alerting_UUIE(void *pObject)
{
	ASNH225Alerting_UUIE *pObj = (ASNH225Alerting_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225Alerting_UUIE(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225ProtocolIdentifier( &(pObj->m_protocolIdentifier) );
	new_ASNH225EndpointType( &(pObj->m_destinationInfo) );
	new_ASNH225TransportAddress( &(pObj->m_h245Address) );
	new_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	new_ASNH225H245Security( &(pObj->m_h245SecurityMode) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_fastStart), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_multipleCalls) );
	new_AsnBoolean( &(pObj->m_maintainConnection) );
	new_AsnSequenceOf( &(pObj->m_alertingAddress), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225PresentationIndicator( &(pObj->m_presentationIndicator) );
	new_ASNH225ScreeningIndicator( &(pObj->m_screeningIndicator) );
	new_AsnNull( &(pObj->m_fastConnectRefused) );
	new_AsnSequenceOf( &(pObj->m_serviceControl), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225CallCapacity( &(pObj->m_capacity) );
	new_ASNH225FeatureSet( &(pObj->m_featureSet) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225Alerting_UUIE Destructor */
HS_RESULT delete_ASNH225Alerting_UUIE(void *pObject)
{
	ASNH225Alerting_UUIE *pObj = (ASNH225Alerting_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225Alerting_UUIE(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225ProtocolIdentifier( &(pObj->m_protocolIdentifier) );
	delete_ASNH225EndpointType( &(pObj->m_destinationInfo) );
	delete_ASNH225TransportAddress( &(pObj->m_h245Address) );
	delete_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	delete_ASNH225H245Security( &(pObj->m_h245SecurityMode) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_AsnSequenceOf( &(pObj->m_fastStart) );
	delete_AsnBoolean( &(pObj->m_multipleCalls) );
	delete_AsnBoolean( &(pObj->m_maintainConnection) );
	delete_AsnSequenceOf( &(pObj->m_alertingAddress) );
	delete_ASNH225PresentationIndicator( &(pObj->m_presentationIndicator) );
	delete_ASNH225ScreeningIndicator( &(pObj->m_screeningIndicator) );
	delete_AsnNull( &(pObj->m_fastConnectRefused) );
	delete_AsnSequenceOf( &(pObj->m_serviceControl) );
	delete_ASNH225CallCapacity( &(pObj->m_capacity) );
	delete_ASNH225FeatureSet( &(pObj->m_featureSet) );
	return HS_OK;
}

/* ASNH225Alerting_UUIE MakeMold */
HS_RESULT ASNH225Alerting_UUIE_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225Alerting_UUIE *pObj = (ASNH225Alerting_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Alerting_UUIE_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225ProtocolIdentifier_MakeMold(&(pObj->m_protocolIdentifier));
	ASNH225EndpointType_MakeMold(&(pObj->m_destinationInfo));
	ASNH225TransportAddress_MakeMold(&(pObj->m_h245Address));
	ASNH225CallIdentifier_MakeMold(&(pObj->m_callIdentifier));
	ASNH225H245Security_MakeMold(&(pObj->m_h245SecurityMode));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	{
	AsnOctetString *tmold_fastStart = (AsnOctetString *)HSMalloc( sizeof(AsnOctetString) );
	new_AsnOctetString(tmold_fastStart,e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_fastStart,sizeof(AsnOctetString),AsnOctetString_MakeMold,AsnOctetString_Encode,AsnOctetString_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		AsnOctetString_Print,
#endif
		delete_AsnOctetString);
	AsnSequenceOf_SetMold( &(pObj->m_fastStart), moldObject );
	}
	{
	ASNH225AliasAddress *tmold_alertingAddress = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
	new_ASNH225AliasAddress(tmold_alertingAddress);
	ASNH225AliasAddress_MakeMold(tmold_alertingAddress);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_alertingAddress,sizeof(ASNH225AliasAddress),ASNH225AliasAddress_MakeMold,ASNH225AliasAddress_Encode,ASNH225AliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225AliasAddress_Print,
#endif
		delete_ASNH225AliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_alertingAddress), moldObject );
	}
	ASNH225PresentationIndicator_MakeMold(&(pObj->m_presentationIndicator));
	ASNH225ScreeningIndicator_MakeMold(&(pObj->m_screeningIndicator));
	{
	ASNH225ServiceControlSession *tmold_serviceControl = (ASNH225ServiceControlSession *)HSMalloc( sizeof(ASNH225ServiceControlSession) );
	new_ASNH225ServiceControlSession(tmold_serviceControl);
	ASNH225ServiceControlSession_MakeMold(tmold_serviceControl);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_serviceControl,sizeof(ASNH225ServiceControlSession),ASNH225ServiceControlSession_MakeMold,ASNH225ServiceControlSession_Encode,ASNH225ServiceControlSession_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ServiceControlSession_Print,
#endif
		delete_ASNH225ServiceControlSession);
	AsnSequenceOf_SetMold( &(pObj->m_serviceControl), moldObject );
	}
	ASNH225CallCapacity_MakeMold(&(pObj->m_capacity));
	ASNH225FeatureSet_MakeMold(&(pObj->m_featureSet));
	return HS_OK;
}

/* ASNH225Alerting_UUIE IncludeOptionalField */
HS_RESULT ASNH225Alerting_UUIE_IncludeOptionField( void *pObject, ASNH225Alerting_UUIEOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225Alerting_UUIE *pObj = (ASNH225Alerting_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Alerting_UUIE_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225Alerting_UUIEOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225Alerting_UUIEOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225Alerting_UUIEOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225Alerting_UUIE IsIncludeOptionalField */
BOOL ASNH225Alerting_UUIE_IsIncludeOptionField( void *pObject, ASNH225Alerting_UUIEOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225Alerting_UUIE *pObj = (ASNH225Alerting_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Alerting_UUIE_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225Alerting_UUIEOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225Alerting_UUIEOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225Alerting_UUIEOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225Alerting_UUIE Encode */
HS_RESULT ASNH225Alerting_UUIE_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225Alerting_UUIE *pObj = (ASNH225Alerting_UUIE *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Alerting_UUIE_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225Alerting_UUIEOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225Alerting_UUIEOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225ProtocolIdentifier_Encode( &(pObj->m_protocolIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Alerting_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225EndpointType_Encode( &(pObj->m_destinationInfo),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Alerting_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_h245Address ) ){
		if( (tRet=ASNH225TransportAddress_Encode( &(pObj->m_h245Address),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Alerting_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_callIdentifier ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Alerting_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_h245SecurityMode ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_h245SecurityMode), ASNH225H245Security_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Alerting_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Alerting_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Alerting_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_fastStart ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_fastStart), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Alerting_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_multipleCalls ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_multipleCalls), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Alerting_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_maintainConnection ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_maintainConnection), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Alerting_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_alertingAddress ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_alertingAddress), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Alerting_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_presentationIndicator ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_presentationIndicator), ASNH225PresentationIndicator_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Alerting_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_screeningIndicator ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_screeningIndicator), ASNH225ScreeningIndicator_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Alerting_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_fastConnectRefused ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_fastConnectRefused), AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Alerting_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_serviceControl ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_serviceControl), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Alerting_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_capacity ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_capacity), ASNH225CallCapacity_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Alerting_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_featureSet ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_featureSet), ASNH225FeatureSet_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Alerting_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225Alerting_UUIE Decode */
HS_RESULT ASNH225Alerting_UUIE_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225Alerting_UUIE *pObj = (ASNH225Alerting_UUIE *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Alerting_UUIE_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225Alerting_UUIEOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225Alerting_UUIEOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225ProtocolIdentifier_Decode(&(pObj->m_protocolIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Alerting_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( (tRet=ASNH225EndpointType_Decode(&(pObj->m_destinationInfo),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Alerting_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_h245Address ) ){
		if( (tRet=ASNH225TransportAddress_Decode(&(pObj->m_h245Address),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Alerting_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_callIdentifier ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Alerting_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_h245SecurityMode ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_h245SecurityMode), ASNH225H245Security_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Alerting_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Alerting_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Alerting_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_fastStart ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_fastStart), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Alerting_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_multipleCalls ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_multipleCalls), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Alerting_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_maintainConnection ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_maintainConnection), AsnBoolean_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Alerting_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_alertingAddress ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_alertingAddress), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Alerting_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_presentationIndicator ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_presentationIndicator), ASNH225PresentationIndicator_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Alerting_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_screeningIndicator ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_screeningIndicator), ASNH225ScreeningIndicator_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Alerting_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_fastConnectRefused ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_fastConnectRefused), AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Alerting_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_serviceControl ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_serviceControl), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Alerting_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_capacity ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_capacity), ASNH225CallCapacity_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Alerting_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_featureSet ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_featureSet), ASNH225FeatureSet_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Alerting_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225Alerting_UUIE Print */
HS_RESULT ASNH225Alerting_UUIE_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225Alerting_UUIE *pObj = (ASNH225Alerting_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225Alerting_UUIE_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225ProtocolIdentifier_Print( &(pObj->m_protocolIdentifier), pDepth+1, "protocolIdentifier" );
	ASNH225EndpointType_Print( &(pObj->m_destinationInfo), pDepth+1, "destinationInfo" );
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_h245Address ) )
		ASNH225TransportAddress_Print( &(pObj->m_h245Address), pDepth+1, "h245Address" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_callIdentifier ) )
		ASNH225CallIdentifier_Print( &(pObj->m_callIdentifier), pDepth+1, "callIdentifier" );
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_h245SecurityMode ) )
		ASNH225H245Security_Print( &(pObj->m_h245SecurityMode), pDepth+1, "h245SecurityMode" );
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_fastStart ) )
		AsnSequenceOf_Print( &(pObj->m_fastStart), pDepth+1, "fastStart" );
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_multipleCalls ) )
		AsnBoolean_Print( &(pObj->m_multipleCalls), pDepth+1, "multipleCalls" );
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_maintainConnection ) )
		AsnBoolean_Print( &(pObj->m_maintainConnection), pDepth+1, "maintainConnection" );
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_alertingAddress ) )
		AsnSequenceOf_Print( &(pObj->m_alertingAddress), pDepth+1, "alertingAddress" );
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_presentationIndicator ) )
		ASNH225PresentationIndicator_Print( &(pObj->m_presentationIndicator), pDepth+1, "presentationIndicator" );
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_screeningIndicator ) )
		ASNH225ScreeningIndicator_Print( &(pObj->m_screeningIndicator), pDepth+1, "screeningIndicator" );
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_fastConnectRefused ) )
		AsnNull_Print( &(pObj->m_fastConnectRefused), pDepth+1, "fastConnectRefused" );
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_serviceControl ) )
		AsnSequenceOf_Print( &(pObj->m_serviceControl), pDepth+1, "serviceControl" );
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_capacity ) )
		ASNH225CallCapacity_Print( &(pObj->m_capacity), pDepth+1, "capacity" );
	if( ASNH225Alerting_UUIE_IsIncludeOptionField( pObj, e_ASNH225Alerting_UUIEOptionMap_featureSet ) )
		ASNH225FeatureSet_Print( &(pObj->m_featureSet), pDepth+1, "featureSet" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225Information_UUIE Class
*/
/*ASNH225Information_UUIE Constructor*/
HS_RESULT new_ASNH225Information_UUIE(void *pObject)
{
	ASNH225Information_UUIE *pObj = (ASNH225Information_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225Information_UUIE(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225ProtocolIdentifier( &(pObj->m_protocolIdentifier) );
	new_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_fastStart), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnNull( &(pObj->m_fastConnectRefused) );
	new_ASNH225CircuitInfo( &(pObj->m_circuitInfo) );

	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225Information_UUIE Destructor */
HS_RESULT delete_ASNH225Information_UUIE(void *pObject)
{
	ASNH225Information_UUIE *pObj = (ASNH225Information_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225Information_UUIE(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225ProtocolIdentifier( &(pObj->m_protocolIdentifier) );
	delete_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_AsnSequenceOf( &(pObj->m_fastStart) );
	delete_AsnNull( &(pObj->m_fastConnectRefused) );
	delete_ASNH225CircuitInfo( &(pObj->m_circuitInfo) );
	return HS_OK;
}

/* ASNH225Information_UUIE MakeMold */
HS_RESULT ASNH225Information_UUIE_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225Information_UUIE *pObj = (ASNH225Information_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Information_UUIE_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225ProtocolIdentifier_MakeMold(&(pObj->m_protocolIdentifier));
	ASNH225CallIdentifier_MakeMold(&(pObj->m_callIdentifier));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	{
	AsnOctetString *tmold_fastStart = (AsnOctetString *)HSMalloc( sizeof(AsnOctetString) );
	new_AsnOctetString(tmold_fastStart,e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_fastStart,sizeof(AsnOctetString),AsnOctetString_MakeMold,AsnOctetString_Encode,AsnOctetString_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		AsnOctetString_Print,
#endif
		delete_AsnOctetString);
	AsnSequenceOf_SetMold( &(pObj->m_fastStart), moldObject );
	}
	ASNH225CircuitInfo_MakeMold(&(pObj->m_circuitInfo));
	return HS_OK;
}

/* ASNH225Information_UUIE IncludeOptionalField */
HS_RESULT ASNH225Information_UUIE_IncludeOptionField( void *pObject, ASNH225Information_UUIEOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225Information_UUIE *pObj = (ASNH225Information_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Information_UUIE_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225Information_UUIEOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225Information_UUIEOptionMapSize ;
	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);
	pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

	if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;
	if( pObj->extOptionMapSize ) pObj->extended = TRUE;

	return HS_OK;
}

/* ASNH225Information_UUIE IsIncludeOptionalField */
BOOL ASNH225Information_UUIE_IsIncludeOptionField( void *pObject, ASNH225Information_UUIEOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225Information_UUIE *pObj = (ASNH225Information_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Information_UUIE_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225Information_UUIEOptionMapSizeExt -1 ) return FALSE;

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225Information_UUIEOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225Information_UUIE Encode */
HS_RESULT ASNH225Information_UUIE_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225Information_UUIE *pObj = (ASNH225Information_UUIE *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Information_UUIE_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	if( (tRet=ASNH225ProtocolIdentifier_Encode( &(pObj->m_protocolIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Information_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225Information_UUIE_IsIncludeOptionField( pObj, e_ASNH225Information_UUIEOptionMap_callIdentifier ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Information_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Information_UUIE_IsIncludeOptionField( pObj, e_ASNH225Information_UUIEOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Information_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Information_UUIE_IsIncludeOptionField( pObj, e_ASNH225Information_UUIEOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Information_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Information_UUIE_IsIncludeOptionField( pObj, e_ASNH225Information_UUIEOptionMap_fastStart ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_fastStart), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Information_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Information_UUIE_IsIncludeOptionField( pObj, e_ASNH225Information_UUIEOptionMap_fastConnectRefused ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_fastConnectRefused), AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Information_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Information_UUIE_IsIncludeOptionField( pObj, e_ASNH225Information_UUIEOptionMap_circuitInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_circuitInfo), ASNH225CircuitInfo_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Information_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225Information_UUIE Decode */
HS_RESULT ASNH225Information_UUIE_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT tRet;

	ASNH225Information_UUIE *pObj = (ASNH225Information_UUIE *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Information_UUIE_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* root field datas */
	if( (tRet=ASNH225ProtocolIdentifier_Decode(&(pObj->m_protocolIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Information_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225Information_UUIE_IsIncludeOptionField( pObj, e_ASNH225Information_UUIEOptionMap_callIdentifier ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Information_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Information_UUIE_IsIncludeOptionField( pObj, e_ASNH225Information_UUIEOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Information_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Information_UUIE_IsIncludeOptionField( pObj, e_ASNH225Information_UUIEOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Information_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Information_UUIE_IsIncludeOptionField( pObj, e_ASNH225Information_UUIEOptionMap_fastStart ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_fastStart), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Information_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Information_UUIE_IsIncludeOptionField( pObj, e_ASNH225Information_UUIEOptionMap_fastConnectRefused ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_fastConnectRefused), AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Information_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Information_UUIE_IsIncludeOptionField( pObj, e_ASNH225Information_UUIEOptionMap_circuitInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_circuitInfo), ASNH225CircuitInfo_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Information_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225Information_UUIE Print */
HS_RESULT ASNH225Information_UUIE_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225Information_UUIE *pObj = (ASNH225Information_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225Information_UUIE_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225ProtocolIdentifier_Print( &(pObj->m_protocolIdentifier), pDepth+1, "protocolIdentifier" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225Information_UUIE_IsIncludeOptionField( pObj, e_ASNH225Information_UUIEOptionMap_callIdentifier ) )
		ASNH225CallIdentifier_Print( &(pObj->m_callIdentifier), pDepth+1, "callIdentifier" );
	if( ASNH225Information_UUIE_IsIncludeOptionField( pObj, e_ASNH225Information_UUIEOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225Information_UUIE_IsIncludeOptionField( pObj, e_ASNH225Information_UUIEOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225Information_UUIE_IsIncludeOptionField( pObj, e_ASNH225Information_UUIEOptionMap_fastStart ) )
		AsnSequenceOf_Print( &(pObj->m_fastStart), pDepth+1, "fastStart" );
	if( ASNH225Information_UUIE_IsIncludeOptionField( pObj, e_ASNH225Information_UUIEOptionMap_fastConnectRefused ) )
		AsnNull_Print( &(pObj->m_fastConnectRefused), pDepth+1, "fastConnectRefused" );
	if( ASNH225Information_UUIE_IsIncludeOptionField( pObj, e_ASNH225Information_UUIEOptionMap_circuitInfo ) )
		ASNH225CircuitInfo_Print( &(pObj->m_circuitInfo), pDepth+1, "circuitInfo" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225ReleaseCompleteReason Struct
*/
/* ASNH225ReleaseCompleteReason Constructor */
HS_RESULT new_ASNH225ReleaseCompleteReason( void *pObject )
{
	ASNH225ReleaseCompleteReason *pObj = (ASNH225ReleaseCompleteReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225ReleaseCompleteReason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225ReleaseCompleteReasonChoice_noBandwidth;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225ReleaseCompleteReasonChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225ReleaseCompleteReason Destructor */
HS_RESULT delete_ASNH225ReleaseCompleteReason( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225ReleaseCompleteReason *pObj = (ASNH225ReleaseCompleteReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ReleaseCompleteReason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225ReleaseCompleteReason_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ReleaseCompleteReason(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225ReleaseCompleteReason SetChoice */
void* ASNH225ReleaseCompleteReason_SetChoice( void *pObject, ASNH225ReleaseCompleteReasonChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225ReleaseCompleteReason *pObj = (ASNH225ReleaseCompleteReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ReleaseCompleteReason_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225ReleaseCompleteReasonChoiceSizeExt ){
		if( pChoice > (ASNH225ReleaseCompleteReasonChoice)(e_ASNH225ReleaseCompleteReasonChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225ReleaseCompleteReason_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225ReleaseCompleteReasonChoice_noBandwidth ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_gatekeeperResources ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_unreachableDestination ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_destinationRejection ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_invalidRevision ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_noPermission ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_unreachableGatekeeper ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_gatewayResources ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_badFormatAddress ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_adaptiveBusy ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_inConf ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_undefinedReason ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_facilityCallDeflection ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_securityDenied ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_calledPartyNotRegistered ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_callerNotRegistered ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_newConnectionNeeded ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_nonStandardReason ){
		ASNH225NonStandardParameter *tAlter = (ASNH225NonStandardParameter *)HSMalloc( sizeof(ASNH225NonStandardParameter) );
		new_ASNH225NonStandardParameter(tAlter);
		ASNH225NonStandardParameter_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_replaceWithConferenceInvite ){
		ASNH225ConferenceIdentifier *tAlter = (ASNH225ConferenceIdentifier *)HSMalloc( sizeof(ASNH225ConferenceIdentifier) );
		new_ASNH225ConferenceIdentifier(tAlter);
		ASNH225ConferenceIdentifier_MakeMold(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_genericDataReason ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_neededFeatureNotSupported ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225ReleaseCompleteReasonChoice_tunnelledSignallingRejected ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ReleaseCompleteReason_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225ReleaseCompleteReason DeleteAlternation */
HS_RESULT ASNH225ReleaseCompleteReason_DeleteAlternation(void *pObject)
{
	ASNH225ReleaseCompleteReason *pObj = (ASNH225ReleaseCompleteReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ReleaseCompleteReason_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_noBandwidth ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_gatekeeperResources ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_unreachableDestination ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_destinationRejection ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_invalidRevision ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_noPermission ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_unreachableGatekeeper ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_gatewayResources ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_badFormatAddress ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_adaptiveBusy ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_inConf ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_undefinedReason ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_facilityCallDeflection ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_securityDenied ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_calledPartyNotRegistered ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_callerNotRegistered ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_newConnectionNeeded ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_nonStandardReason ){
			delete_ASNH225NonStandardParameter(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_replaceWithConferenceInvite ){
			delete_ASNH225ConferenceIdentifier(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_genericDataReason ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_neededFeatureNotSupported ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_tunnelledSignallingRejected ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225ReleaseCompleteReason_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225ReleaseCompleteReason Encode */
HS_RESULT ASNH225ReleaseCompleteReason_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225ReleaseCompleteReason *pObj = (ASNH225ReleaseCompleteReason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225ReleaseCompleteReasonChoiceSize )
		{
			if( pObj->choice > ((ASNH225ReleaseCompleteReasonChoice)(e_ASNH225ReleaseCompleteReasonChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225ReleaseCompleteReasonChoiceSize)) )
	}
	else
	{
		if( e_ASNH225ReleaseCompleteReasonChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_noBandwidth ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_gatekeeperResources ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_unreachableDestination ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_destinationRejection ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_invalidRevision ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_noPermission ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_unreachableGatekeeper ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_gatewayResources ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_badFormatAddress ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_adaptiveBusy ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_inConf ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_undefinedReason ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_facilityCallDeflection ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_securityDenied ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_calledPartyNotRegistered ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_callerNotRegistered ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_newConnectionNeeded ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_nonStandardReason ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH225NonStandardParameter_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_replaceWithConferenceInvite ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, ASNH225ConferenceIdentifier_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_genericDataReason ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_neededFeatureNotSupported ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_tunnelledSignallingRejected ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225ReleaseCompleteReason Decode */
HS_RESULT ASNH225ReleaseCompleteReason_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225ReleaseCompleteReason *pObj = (ASNH225ReleaseCompleteReason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225ReleaseCompleteReasonChoiceSize;
	}
	else
	{
		if( e_ASNH225ReleaseCompleteReasonChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225ReleaseCompleteReasonChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225ReleaseCompleteReasonChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225ReleaseCompleteReason_SetChoice( pObj, (ASNH225ReleaseCompleteReasonChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_noBandwidth ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_gatekeeperResources ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_unreachableDestination ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_destinationRejection ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_invalidRevision ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_noPermission ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_unreachableGatekeeper ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_gatewayResources ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_badFormatAddress ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_adaptiveBusy ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_inConf ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_undefinedReason ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_facilityCallDeflection ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_securityDenied ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_calledPartyNotRegistered ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_callerNotRegistered ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_newConnectionNeeded ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_nonStandardReason ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH225NonStandardParameter_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_replaceWithConferenceInvite ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, ASNH225ConferenceIdentifier_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_genericDataReason ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_neededFeatureNotSupported ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_tunnelledSignallingRejected ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225ReleaseCompleteReason Print */
HS_RESULT ASNH225ReleaseCompleteReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225ReleaseCompleteReason *pObj = (ASNH225ReleaseCompleteReason *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225ReleaseCompleteReason_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_noBandwidth ){
		AsnNull_Print( pObj->alter, pDepth+1, "noBandwidth" );
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_gatekeeperResources ){
		AsnNull_Print( pObj->alter, pDepth+1, "gatekeeperResources" );
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_unreachableDestination ){
		AsnNull_Print( pObj->alter, pDepth+1, "unreachableDestination" );
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_destinationRejection ){
		AsnNull_Print( pObj->alter, pDepth+1, "destinationRejection" );
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_invalidRevision ){
		AsnNull_Print( pObj->alter, pDepth+1, "invalidRevision" );
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_noPermission ){
		AsnNull_Print( pObj->alter, pDepth+1, "noPermission" );
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_unreachableGatekeeper ){
		AsnNull_Print( pObj->alter, pDepth+1, "unreachableGatekeeper" );
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_gatewayResources ){
		AsnNull_Print( pObj->alter, pDepth+1, "gatewayResources" );
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_badFormatAddress ){
		AsnNull_Print( pObj->alter, pDepth+1, "badFormatAddress" );
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_adaptiveBusy ){
		AsnNull_Print( pObj->alter, pDepth+1, "adaptiveBusy" );
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_inConf ){
		AsnNull_Print( pObj->alter, pDepth+1, "inConf" );
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_undefinedReason ){
		AsnNull_Print( pObj->alter, pDepth+1, "undefinedReason" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_facilityCallDeflection ){
		AsnNull_Print( pObj->alter, pDepth+1, "facilityCallDeflection" );
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_securityDenied ){
		AsnNull_Print( pObj->alter, pDepth+1, "securityDenied" );
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_calledPartyNotRegistered ){
		AsnNull_Print( pObj->alter, pDepth+1, "calledPartyNotRegistered" );
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_callerNotRegistered ){
		AsnNull_Print( pObj->alter, pDepth+1, "callerNotRegistered" );
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_newConnectionNeeded ){
		AsnNull_Print( pObj->alter, pDepth+1, "newConnectionNeeded" );
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_nonStandardReason ){
		ASNH225NonStandardParameter_Print( pObj->alter, pDepth+1, "nonStandardReason" );
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_replaceWithConferenceInvite ){
		ASNH225ConferenceIdentifier_Print( pObj->alter, pDepth+1, "replaceWithConferenceInvite" );
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_genericDataReason ){
		AsnNull_Print( pObj->alter, pDepth+1, "genericDataReason" );
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_neededFeatureNotSupported ){
		AsnNull_Print( pObj->alter, pDepth+1, "neededFeatureNotSupported" );
	}
	else if ( pObj->choice == e_ASNH225ReleaseCompleteReasonChoice_tunnelledSignallingRejected ){
		AsnNull_Print( pObj->alter, pDepth+1, "tunnelledSignallingRejected" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225ReleaseComplete_UUIE Class
*/
/*ASNH225ReleaseComplete_UUIE Constructor*/
HS_RESULT new_ASNH225ReleaseComplete_UUIE(void *pObject)
{
	ASNH225ReleaseComplete_UUIE *pObj = (ASNH225ReleaseComplete_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225ReleaseComplete_UUIE(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225ProtocolIdentifier( &(pObj->m_protocolIdentifier) );
	new_ASNH225ReleaseCompleteReason( &(pObj->m_reason) );
	new_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_busyAddress), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225PresentationIndicator( &(pObj->m_presentationIndicator) );
	new_ASNH225ScreeningIndicator( &(pObj->m_screeningIndicator) );
	new_ASNH225CallCapacity( &(pObj->m_capacity) );
	new_AsnSequenceOf( &(pObj->m_serviceControl), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225FeatureSet( &(pObj->m_featureSet) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225ReleaseComplete_UUIE Destructor */
HS_RESULT delete_ASNH225ReleaseComplete_UUIE(void *pObject)
{
	ASNH225ReleaseComplete_UUIE *pObj = (ASNH225ReleaseComplete_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ReleaseComplete_UUIE(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225ProtocolIdentifier( &(pObj->m_protocolIdentifier) );
	delete_ASNH225ReleaseCompleteReason( &(pObj->m_reason) );
	delete_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_AsnSequenceOf( &(pObj->m_busyAddress) );
	delete_ASNH225PresentationIndicator( &(pObj->m_presentationIndicator) );
	delete_ASNH225ScreeningIndicator( &(pObj->m_screeningIndicator) );
	delete_ASNH225CallCapacity( &(pObj->m_capacity) );
	delete_AsnSequenceOf( &(pObj->m_serviceControl) );
	delete_ASNH225FeatureSet( &(pObj->m_featureSet) );
	return HS_OK;
}

/* ASNH225ReleaseComplete_UUIE MakeMold */
HS_RESULT ASNH225ReleaseComplete_UUIE_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225ReleaseComplete_UUIE *pObj = (ASNH225ReleaseComplete_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225ProtocolIdentifier_MakeMold(&(pObj->m_protocolIdentifier));
	ASNH225ReleaseCompleteReason_MakeMold(&(pObj->m_reason));
	ASNH225CallIdentifier_MakeMold(&(pObj->m_callIdentifier));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	{
	ASNH225AliasAddress *tmold_busyAddress = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
	new_ASNH225AliasAddress(tmold_busyAddress);
	ASNH225AliasAddress_MakeMold(tmold_busyAddress);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_busyAddress,sizeof(ASNH225AliasAddress),ASNH225AliasAddress_MakeMold,ASNH225AliasAddress_Encode,ASNH225AliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225AliasAddress_Print,
#endif
		delete_ASNH225AliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_busyAddress), moldObject );
	}
	ASNH225PresentationIndicator_MakeMold(&(pObj->m_presentationIndicator));
	ASNH225ScreeningIndicator_MakeMold(&(pObj->m_screeningIndicator));
	ASNH225CallCapacity_MakeMold(&(pObj->m_capacity));
	{
	ASNH225ServiceControlSession *tmold_serviceControl = (ASNH225ServiceControlSession *)HSMalloc( sizeof(ASNH225ServiceControlSession) );
	new_ASNH225ServiceControlSession(tmold_serviceControl);
	ASNH225ServiceControlSession_MakeMold(tmold_serviceControl);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_serviceControl,sizeof(ASNH225ServiceControlSession),ASNH225ServiceControlSession_MakeMold,ASNH225ServiceControlSession_Encode,ASNH225ServiceControlSession_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ServiceControlSession_Print,
#endif
		delete_ASNH225ServiceControlSession);
	AsnSequenceOf_SetMold( &(pObj->m_serviceControl), moldObject );
	}
	ASNH225FeatureSet_MakeMold(&(pObj->m_featureSet));
	return HS_OK;
}

/* ASNH225ReleaseComplete_UUIE IncludeOptionalField */
HS_RESULT ASNH225ReleaseComplete_UUIE_IncludeOptionField( void *pObject, ASNH225ReleaseComplete_UUIEOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225ReleaseComplete_UUIE *pObj = (ASNH225ReleaseComplete_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225ReleaseComplete_UUIEOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225ReleaseComplete_UUIEOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225ReleaseComplete_UUIEOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225ReleaseComplete_UUIE IsIncludeOptionalField */
BOOL ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( void *pObject, ASNH225ReleaseComplete_UUIEOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225ReleaseComplete_UUIE *pObj = (ASNH225ReleaseComplete_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225ReleaseComplete_UUIEOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225ReleaseComplete_UUIEOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225ReleaseComplete_UUIEOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225ReleaseComplete_UUIE Encode */
HS_RESULT ASNH225ReleaseComplete_UUIE_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225ReleaseComplete_UUIE *pObj = (ASNH225ReleaseComplete_UUIE *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225ReleaseComplete_UUIEOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225ReleaseComplete_UUIEOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225ProtocolIdentifier_Encode( &(pObj->m_protocolIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_reason ) ){
		if( (tRet=ASNH225ReleaseCompleteReason_Encode( &(pObj->m_reason),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_callIdentifier ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_busyAddress ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_busyAddress), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_presentationIndicator ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_presentationIndicator), ASNH225PresentationIndicator_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_screeningIndicator ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_screeningIndicator), ASNH225ScreeningIndicator_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_capacity ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_capacity), ASNH225CallCapacity_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_serviceControl ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_serviceControl), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_featureSet ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_featureSet), ASNH225FeatureSet_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225ReleaseComplete_UUIE Decode */
HS_RESULT ASNH225ReleaseComplete_UUIE_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225ReleaseComplete_UUIE *pObj = (ASNH225ReleaseComplete_UUIE *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225ReleaseComplete_UUIEOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225ReleaseComplete_UUIEOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225ProtocolIdentifier_Decode(&(pObj->m_protocolIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_reason ) ){
		if( (tRet=ASNH225ReleaseCompleteReason_Decode(&(pObj->m_reason),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_callIdentifier ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_busyAddress ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_busyAddress), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_presentationIndicator ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_presentationIndicator), ASNH225PresentationIndicator_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_screeningIndicator ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_screeningIndicator), ASNH225ScreeningIndicator_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_capacity ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_capacity), ASNH225CallCapacity_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_serviceControl ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_serviceControl), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_featureSet ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_featureSet), ASNH225FeatureSet_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225ReleaseComplete_UUIE Print */
HS_RESULT ASNH225ReleaseComplete_UUIE_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225ReleaseComplete_UUIE *pObj = (ASNH225ReleaseComplete_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225ReleaseComplete_UUIE_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	ASNH225ProtocolIdentifier_Print( &(pObj->m_protocolIdentifier), pDepth+1, "protocolIdentifier" );
	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_reason ) )
		ASNH225ReleaseCompleteReason_Print( &(pObj->m_reason), pDepth+1, "reason" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_callIdentifier ) )
		ASNH225CallIdentifier_Print( &(pObj->m_callIdentifier), pDepth+1, "callIdentifier" );
	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_tokens ) )
		AsnSequenceOf_Print( &(pObj->m_tokens), pDepth+1, "tokens" );
	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_cryptoTokens ) )
		AsnSequenceOf_Print( &(pObj->m_cryptoTokens), pDepth+1, "cryptoTokens" );
	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_busyAddress ) )
		AsnSequenceOf_Print( &(pObj->m_busyAddress), pDepth+1, "busyAddress" );
	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_presentationIndicator ) )
		ASNH225PresentationIndicator_Print( &(pObj->m_presentationIndicator), pDepth+1, "presentationIndicator" );
	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_screeningIndicator ) )
		ASNH225ScreeningIndicator_Print( &(pObj->m_screeningIndicator), pDepth+1, "screeningIndicator" );
	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_capacity ) )
		ASNH225CallCapacity_Print( &(pObj->m_capacity), pDepth+1, "capacity" );
	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_serviceControl ) )
		AsnSequenceOf_Print( &(pObj->m_serviceControl), pDepth+1, "serviceControl" );
	if( ASNH225ReleaseComplete_UUIE_IsIncludeOptionField( pObj, e_ASNH225ReleaseComplete_UUIEOptionMap_featureSet ) )
		ASNH225FeatureSet_Print( &(pObj->m_featureSet), pDepth+1, "featureSet" );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225FacilityReason Struct
*/
/* ASNH225FacilityReason Constructor */
HS_RESULT new_ASNH225FacilityReason( void *pObject )
{
	ASNH225FacilityReason *pObj = (ASNH225FacilityReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225FacilityReason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->alter		 = HS_NULL;
	pObj->extensible = TRUE;
	pObj->choice	 = e_ASNH225FacilityReasonChoice_routeCallToGatekeeper;
	new_AsnInteger( &(pObj->choiceInteger), e_constrained, 0, e_ASNH225FacilityReasonChoiceSize -1, 0, HS_UINT_MAX );
	return HS_OK;
}
/* ASNH225FacilityReason Destructor */
HS_RESULT delete_ASNH225FacilityReason( void *pObject )
{
	HS_RESULT	tRet;

	ASNH225FacilityReason *pObj = (ASNH225FacilityReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225FacilityReason(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( (tRet=ASNH225FacilityReason_DeleteAlternation(pObj)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225FacilityReason(), tRet(%u)", tRet );
#endif
		return tRet;
	}
	return HS_OK;
}
/* ASNH225FacilityReason SetChoice */
void* ASNH225FacilityReason_SetChoice( void *pObject, ASNH225FacilityReasonChoice pChoice)
{
	HS_RESULT	tRet;
	AsnObject *tmold = HS_NULL;
	AsnSequenceOf *aso = HS_NULL;

	ASNH225FacilityReason *pObj = (ASNH225FacilityReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225FacilityReason_SetChoice(NULL,%d) -> null parameter", (int)pChoice );
#endif
		return HS_NULL;
	}

	if( e_ASNH225FacilityReasonChoiceSizeExt ){
		if( pChoice > (ASNH225FacilityReasonChoice)(e_ASNH225FacilityReasonChoiceSizeExt-1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_SetChoice(%d) -> invalid alternation value", (int)pChoice );
#endif
			return HS_NULL;
		}
	}

	if( pObj->alter != HS_NULL )
	{
		if( (tRet=ASNH225FacilityReason_DeleteAlternation(pObj)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_SetChoice(%d), tRet(%u)", (int)pChoice, tRet );
#endif
			return HS_NULL;
		}
	}
	pObj->choice = pChoice;

	if		( pChoice == e_ASNH225FacilityReasonChoice_routeCallToGatekeeper ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225FacilityReasonChoice_callForwarded ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225FacilityReasonChoice_routeCallToMC ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225FacilityReasonChoice_undefinedReason ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	/*...,*/
	else if ( pChoice == e_ASNH225FacilityReasonChoice_conferenceListChoice ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225FacilityReasonChoice_startH245 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225FacilityReasonChoice_noH245 ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225FacilityReasonChoice_newTokens ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225FacilityReasonChoice_featureSetUpdate ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225FacilityReasonChoice_forwardedElements ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else if ( pChoice == e_ASNH225FacilityReasonChoice_transportedInformation ){
		AsnNull *tAlter = (AsnNull *)HSMalloc( sizeof(AsnNull) );
		new_AsnNull(tAlter);
		pObj->alter = tAlter;
	}
	else{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225FacilityReason_SetChoice(%d) -> out of choice", (int)pChoice );
#endif
		return HS_NULL;
	}

	return pObj->alter;
}

/* ASNH225FacilityReason DeleteAlternation */
HS_RESULT ASNH225FacilityReason_DeleteAlternation(void *pObject)
{
	ASNH225FacilityReason *pObj = (ASNH225FacilityReason *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225FacilityReason_DeleteAlternation(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( pObj->alter != HS_NULL )
	{
		/* root field datas */
		if		( pObj->choice == e_ASNH225FacilityReasonChoice_routeCallToGatekeeper ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225FacilityReasonChoice_callForwarded ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225FacilityReasonChoice_routeCallToMC ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225FacilityReasonChoice_undefinedReason ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		/*...,*/
		else if ( pObj->choice == e_ASNH225FacilityReasonChoice_conferenceListChoice ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225FacilityReasonChoice_startH245 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225FacilityReasonChoice_noH245 ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225FacilityReasonChoice_newTokens ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225FacilityReasonChoice_featureSetUpdate ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225FacilityReasonChoice_forwardedElements ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else if ( pObj->choice == e_ASNH225FacilityReasonChoice_transportedInformation ){
			delete_AsnNull(pObj->alter);
			HSFree(pObj->alter);
		}
		else
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_DeleteAlternation() -> out of choice, choice(%d)", (int)(pObj->choice) );
#endif
			pObj->alter = HS_NULL;
			return HS_ERR_ASN_OUTOF_RANGE;
		}

		pObj->alter = HS_NULL;
	}

	return HS_OK;
}

HS_RESULT ASNH225FacilityReason_MakeMold( void *pObject ){return HS_OK;};

/* ASNH225FacilityReason Encode */
HS_RESULT ASNH225FacilityReason_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	BOOL		tExtended = FALSE;

	ASNH225FacilityReason *pObj = (ASNH225FacilityReason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225FacilityReason_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}
	if(pObj->alter == HS_NULL)
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225FacilityReason_Encode(pStrm) -> there is no choice" );
#endif
		return HS_ERR_ASN_NOCHOICE;
	}

	/* extension bit */
	if( pObj->extensible )
	{
		if( e_ASNH225FacilityReasonChoiceSize )
		{
			if( pObj->choice > ((ASNH225FacilityReasonChoice)(e_ASNH225FacilityReasonChoiceSize-1)) ) tExtended = TRUE;
			else tExtended = FALSE;

			AsnStream_BitEncoding( pStrm, tExtended );
		}
		else tExtended = TRUE;
	}

	/* alternation encoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberEncoding(pStrm, ((HS_UINT)(pObj->choice) - (HS_UINT)e_ASNH225FacilityReasonChoiceSize)) )
	}
	else
	{
		if( e_ASNH225FacilityReasonChoiceSize > 1 )
		{
			AsnInteger_SetValue( &(pObj->choiceInteger), (HS_UINT)(pObj->choice) );
			HS_TRY( AsnInteger_Encode( &(pObj->choiceInteger), pStrm ) )
		}
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225FacilityReasonChoice_routeCallToGatekeeper ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_callForwarded ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_routeCallToMC ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_undefinedReason ){
		if( (tRet=AsnNull_Encode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_conferenceListChoice ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_startH245 ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_noH245 ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_newTokens ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_featureSetUpdate ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_forwardedElements ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_transportedInformation ){
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		if( (tRet=WellKnownExtensionEncoding( pObj->alter, AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225FacilityReason_Encode(pObj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}

/* ASNH225FacilityReason Decode */
HS_RESULT ASNH225FacilityReason_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;
	HS_UINT		tChoice = 0;
	BOOL		tExtended = FALSE;

	ASNH225FacilityReason *pObj = (ASNH225FacilityReason *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225FacilityReason_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &tExtended );

	/* alternation decoding */
	if( tExtended )
	{
		HS_TRY( SmallNumberDecoding(pStrm,&tChoice) )
		tChoice += e_ASNH225FacilityReasonChoiceSize;
	}
	else
	{
		if( e_ASNH225FacilityReasonChoiceSize > 1 )
		{
			HS_TRY( AsnInteger_Decode( &(pObj->choiceInteger), pStrm ) )
			tChoice = pObj->choiceInteger.value;
		}
	}

	if( e_ASNH225FacilityReasonChoiceSizeExt )
	{
		if( tChoice > (HS_UINT)(e_ASNH225FacilityReasonChoiceSizeExt - 1) )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Decode(pStrm) -> asn range over" );
#endif
			return HS_ERR_ASN_OUTOF_RANGE;
		}
	}

	if( ASNH225FacilityReason_SetChoice( pObj, (ASNH225FacilityReasonChoice)tChoice ) == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225FacilityReason_Decode(pObj,pStrm) -> SetChoice Fail, choice(%d)", tChoice );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225FacilityReasonChoice_routeCallToGatekeeper ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_callForwarded ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_routeCallToMC ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_undefinedReason ){
		if( (tRet=AsnNull_Decode(pObj->alter,pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_conferenceListChoice ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_startH245 ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_noH245 ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_newTokens ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_featureSetUpdate ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_forwardedElements ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_transportedInformation ){
		if( (tRet=WellKnownExtensionDecoding( pObj->alter, AsnNull_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225FacilityReason_Decode(Obj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	else
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225FacilityReason_Decode(Obj,pStrm) -> out of choice" );
#endif
		return HS_ERR_ASN_OUTOF_RANGE;
	}

	return HS_OK;
}


#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225FacilityReason Print */
HS_RESULT ASNH225FacilityReason_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225FacilityReason *pObj = (ASNH225FacilityReason *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225FacilityReason_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<CHOICE> = {" );

	if( pObj->alter == HS_NULL )
	{
		HSPrint( "  Error : No Value\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	/* root field datas */
	if		( pObj->choice == e_ASNH225FacilityReasonChoice_routeCallToGatekeeper ){
		AsnNull_Print( pObj->alter, pDepth+1, "routeCallToGatekeeper" );
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_callForwarded ){
		AsnNull_Print( pObj->alter, pDepth+1, "callForwarded" );
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_routeCallToMC ){
		AsnNull_Print( pObj->alter, pDepth+1, "routeCallToMC" );
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_undefinedReason ){
		AsnNull_Print( pObj->alter, pDepth+1, "undefinedReason" );
	}
	/*...,*/
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_conferenceListChoice ){
		AsnNull_Print( pObj->alter, pDepth+1, "conferenceListChoice" );
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_startH245 ){
		AsnNull_Print( pObj->alter, pDepth+1, "startH245" );
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_noH245 ){
		AsnNull_Print( pObj->alter, pDepth+1, "noH245" );
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_newTokens ){
		AsnNull_Print( pObj->alter, pDepth+1, "newTokens" );
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_featureSetUpdate ){
		AsnNull_Print( pObj->alter, pDepth+1, "featureSetUpdate" );
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_forwardedElements ){
		AsnNull_Print( pObj->alter, pDepth+1, "forwardedElements" );
	}
	else if ( pObj->choice == e_ASNH225FacilityReasonChoice_transportedInformation ){
		AsnNull_Print( pObj->alter, pDepth+1, "transportedInformation" );
	}
	else
	{
		HSPrint( "  Error : Unknown Choice\n" );
		for( i=0; i<pDepth; i++ ) HSPrint( "  " );
		HSPrint( "}" );
		return HS_OK;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225ConferenceList Class
*/
/*ASNH225ConferenceList Constructor*/
HS_RESULT new_ASNH225ConferenceList(void *pObject)
{
	ASNH225ConferenceList *pObj = (ASNH225ConferenceList *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225ConferenceList(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225ConferenceIdentifier( &(pObj->m_conferenceID) );
	new_ASNH225AliasAddress( &(pObj->m_conferenceAlias) );
	new_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	return HS_OK;
}

/* ASNH225ConferenceList Destructor */
HS_RESULT delete_ASNH225ConferenceList(void *pObject)
{
	ASNH225ConferenceList *pObj = (ASNH225ConferenceList *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225ConferenceList(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225ConferenceIdentifier( &(pObj->m_conferenceID) );
	delete_ASNH225AliasAddress( &(pObj->m_conferenceAlias) );
	delete_ASNH225NonStandardParameter( &(pObj->m_nonStandardData) );
	return HS_OK;
}

/* ASNH225ConferenceList MakeMold */
HS_RESULT ASNH225ConferenceList_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225ConferenceList *pObj = (ASNH225ConferenceList *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ConferenceList_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225ConferenceIdentifier_MakeMold(&(pObj->m_conferenceID));
	ASNH225AliasAddress_MakeMold(&(pObj->m_conferenceAlias));
	ASNH225NonStandardParameter_MakeMold(&(pObj->m_nonStandardData));
	return HS_OK;
}

/* ASNH225ConferenceList IncludeOptionalField */
HS_RESULT ASNH225ConferenceList_IncludeOptionField( void *pObject, ASNH225ConferenceListOptionMap pOptionMap )
{
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225ConferenceList *pObj = (ASNH225ConferenceList *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ConferenceList_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225ConferenceListOptionMapSize -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);

	return HS_OK;
}

/* ASNH225ConferenceList IsIncludeOptionalField */
BOOL ASNH225ConferenceList_IsIncludeOptionField( void *pObject, ASNH225ConferenceListOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tByteOffset, tBitOffset;

	ASNH225ConferenceList *pObj = (ASNH225ConferenceList *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ConferenceList_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225ConferenceListOptionMapSize -1 ) return FALSE;

	tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)pOptionMap)%8);
	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225ConferenceList Encode */
HS_RESULT ASNH225ConferenceList_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225ConferenceList *pObj = (ASNH225ConferenceList *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ConferenceList_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225ConferenceListOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225ConferenceListOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225ConferenceList_IsIncludeOptionField( pObj, e_ASNH225ConferenceListOptionMap_conferenceID ) ){
		if( (tRet=ASNH225ConferenceIdentifier_Encode( &(pObj->m_conferenceID),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ConferenceList_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ConferenceList_IsIncludeOptionField( pObj, e_ASNH225ConferenceListOptionMap_conferenceAlias ) ){
		if( (tRet=ASNH225AliasAddress_Encode( &(pObj->m_conferenceAlias),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ConferenceList_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ConferenceList_IsIncludeOptionField( pObj, e_ASNH225ConferenceListOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Encode( &(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ConferenceList_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

/* ASNH225ConferenceList Decode */
HS_RESULT ASNH225ConferenceList_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225ConferenceList *pObj = (ASNH225ConferenceList *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225ConferenceList_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225ConferenceListOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225ConferenceListOptionMapSize, e_alignLeft );

	/* root field datas */
	if( ASNH225ConferenceList_IsIncludeOptionField( pObj, e_ASNH225ConferenceListOptionMap_conferenceID ) ){
		if( (tRet=ASNH225ConferenceIdentifier_Decode(&(pObj->m_conferenceID),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ConferenceList_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ConferenceList_IsIncludeOptionField( pObj, e_ASNH225ConferenceListOptionMap_conferenceAlias ) ){
		if( (tRet=ASNH225AliasAddress_Decode(&(pObj->m_conferenceAlias),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ConferenceList_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225ConferenceList_IsIncludeOptionField( pObj, e_ASNH225ConferenceListOptionMap_nonStandardData ) ){
		if( (tRet=ASNH225NonStandardParameter_Decode(&(pObj->m_nonStandardData),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225ConferenceList_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}

	return HS_OK;
}

#ifdef HS_DEBUG_ASN_PRINT
/* ASNH225ConferenceList Print */
HS_RESULT ASNH225ConferenceList_Print( void *pObject, HS_UINT pDepth, char *pTypeName )
{
	HS_UINT i;

	ASNH225ConferenceList *pObj = (ASNH225ConferenceList *)pObject;
	if( pObj == HS_NULL )
	{
		HSPrint( "\n Error on ASNH225ConferenceList_Print(NULL,%u,%s) -> null parameter", pDepth, pTypeName==HS_NULL? "":pTypeName );
		return HS_ERR_NULL_PARAM;
	}

	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );

	if( pTypeName != HS_NULL ) HSPrint( "%s", pTypeName );
	HSPrint( "<SEQUENCE> = {" );

	if( ASNH225ConferenceList_IsIncludeOptionField( pObj, e_ASNH225ConferenceListOptionMap_conferenceID ) )
		ASNH225ConferenceIdentifier_Print( &(pObj->m_conferenceID), pDepth+1, "conferenceID" );
	if( ASNH225ConferenceList_IsIncludeOptionField( pObj, e_ASNH225ConferenceListOptionMap_conferenceAlias ) )
		ASNH225AliasAddress_Print( &(pObj->m_conferenceAlias), pDepth+1, "conferenceAlias" );
	if( ASNH225ConferenceList_IsIncludeOptionField( pObj, e_ASNH225ConferenceListOptionMap_nonStandardData ) )
		ASNH225NonStandardParameter_Print( &(pObj->m_nonStandardData), pDepth+1, "nonStandardData" );
	HSPrint( "\n" );
	for( i=0; i<pDepth+1; i++ ) HSPrint( "  " );
	HSPrint( "...," );
	HSPrint( "\n" );
	for( i=0; i<pDepth; i++ ) HSPrint( "  " );
	HSPrint("}");

	return HS_OK;
}
#endif

/***************************************************************************************/
/* ASNH225Facility_UUIE Class
*/
/*ASNH225Facility_UUIE Constructor*/
HS_RESULT new_ASNH225Facility_UUIE(void *pObject)
{
	ASNH225Facility_UUIE *pObj = (ASNH225Facility_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on new_ASNH225Facility_UUIE(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	pObj->extensible = TRUE;
	pObj->extended = FALSE;
	new_ASNH225ProtocolIdentifier( &(pObj->m_protocolIdentifier) );
	new_ASNH225TransportAddress( &(pObj->m_alternativeAddress) );
	new_AsnSequenceOf( &(pObj->m_alternativeAliasAddress), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225ConferenceIdentifier( &(pObj->m_conferenceID) );
	new_ASNH225FacilityReason( &(pObj->m_reason) );
	new_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	new_AsnSequenceOf( &(pObj->m_destExtraCallInfo), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225AliasAddress( &(pObj->m_remoteExtensionAddress) );
	new_AsnSequenceOf( &(pObj->m_tokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_cryptoTokens), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnSequenceOf( &(pObj->m_conferences), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225TransportAddress( &(pObj->m_h245Address) );
	new_AsnSequenceOf( &(pObj->m_fastStart), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_AsnBoolean( &(pObj->m_multipleCalls) );
	new_AsnBoolean( &(pObj->m_maintainConnection) );
	new_AsnNull( &(pObj->m_fastConnectRefused) );
	new_AsnSequenceOf( &(pObj->m_serviceControl), e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT );
	new_ASNH225CircuitInfo( &(pObj->m_circuitInfo) );
	new_ASNH225FeatureSet( &(pObj->m_featureSet) );
	new_ASNH225EndpointType( &(pObj->m_destinationInfo) );
	new_ASNH225H245Security( &(pObj->m_h245SecurityMode) );

	memset( pObj->optionMap, 0, HS_ASN_OPTION_MAP_MAX );
	memset( pObj->extOptionMap, 0, HS_ASN_OPTION_MAP_MAX );
	pObj->extOptionMapSize = 0;
	return HS_OK;
}

/* ASNH225Facility_UUIE Destructor */
HS_RESULT delete_ASNH225Facility_UUIE(void *pObject)
{
	ASNH225Facility_UUIE *pObj = (ASNH225Facility_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on delete_ASNH225Facility_UUIE(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}
	delete_ASNH225ProtocolIdentifier( &(pObj->m_protocolIdentifier) );
	delete_ASNH225TransportAddress( &(pObj->m_alternativeAddress) );
	delete_AsnSequenceOf( &(pObj->m_alternativeAliasAddress) );
	delete_ASNH225ConferenceIdentifier( &(pObj->m_conferenceID) );
	delete_ASNH225FacilityReason( &(pObj->m_reason) );
	delete_ASNH225CallIdentifier( &(pObj->m_callIdentifier) );
	delete_AsnSequenceOf( &(pObj->m_destExtraCallInfo) );
	delete_ASNH225AliasAddress( &(pObj->m_remoteExtensionAddress) );
	delete_AsnSequenceOf( &(pObj->m_tokens) );
	delete_AsnSequenceOf( &(pObj->m_cryptoTokens) );
	delete_AsnSequenceOf( &(pObj->m_conferences) );
	delete_ASNH225TransportAddress( &(pObj->m_h245Address) );
	delete_AsnSequenceOf( &(pObj->m_fastStart) );
	delete_AsnBoolean( &(pObj->m_multipleCalls) );
	delete_AsnBoolean( &(pObj->m_maintainConnection) );
	delete_AsnNull( &(pObj->m_fastConnectRefused) );
	delete_AsnSequenceOf( &(pObj->m_serviceControl) );
	delete_ASNH225CircuitInfo( &(pObj->m_circuitInfo) );
	delete_ASNH225FeatureSet( &(pObj->m_featureSet) );
	delete_ASNH225EndpointType( &(pObj->m_destinationInfo) );
	delete_ASNH225H245Security( &(pObj->m_h245SecurityMode) );
	return HS_OK;
}

/* ASNH225Facility_UUIE MakeMold */
HS_RESULT ASNH225Facility_UUIE_MakeMold(void *pObject)
{
	AsnObject *moldObject = HS_NULL;
	ASNH225Facility_UUIE *pObj = (ASNH225Facility_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Facility_UUIE_MakeMold(NULL) -> null parameter" );
#endif
		return HS_ERR_NULL_PARAM;
	}

	ASNH225ProtocolIdentifier_MakeMold(&(pObj->m_protocolIdentifier));
	ASNH225TransportAddress_MakeMold(&(pObj->m_alternativeAddress));
	{
	ASNH225AliasAddress *tmold_alternativeAliasAddress = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
	new_ASNH225AliasAddress(tmold_alternativeAliasAddress);
	ASNH225AliasAddress_MakeMold(tmold_alternativeAliasAddress);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_alternativeAliasAddress,sizeof(ASNH225AliasAddress),ASNH225AliasAddress_MakeMold,ASNH225AliasAddress_Encode,ASNH225AliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225AliasAddress_Print,
#endif
		delete_ASNH225AliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_alternativeAliasAddress), moldObject );
	}
	ASNH225ConferenceIdentifier_MakeMold(&(pObj->m_conferenceID));
	ASNH225FacilityReason_MakeMold(&(pObj->m_reason));
	ASNH225CallIdentifier_MakeMold(&(pObj->m_callIdentifier));
	{
	ASNH225AliasAddress *tmold_destExtraCallInfo = (ASNH225AliasAddress *)HSMalloc( sizeof(ASNH225AliasAddress) );
	new_ASNH225AliasAddress(tmold_destExtraCallInfo);
	ASNH225AliasAddress_MakeMold(tmold_destExtraCallInfo);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_destExtraCallInfo,sizeof(ASNH225AliasAddress),ASNH225AliasAddress_MakeMold,ASNH225AliasAddress_Encode,ASNH225AliasAddress_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225AliasAddress_Print,
#endif
		delete_ASNH225AliasAddress);
	AsnSequenceOf_SetMold( &(pObj->m_destExtraCallInfo), moldObject );
	}
	ASNH225AliasAddress_MakeMold(&(pObj->m_remoteExtensionAddress));
	{
	ASNH225ClearToken *tmold_tokens = (ASNH225ClearToken *)HSMalloc( sizeof(ASNH225ClearToken) );
	new_ASNH225ClearToken(tmold_tokens);
	ASNH225ClearToken_MakeMold(tmold_tokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_tokens,sizeof(ASNH225ClearToken),ASNH225ClearToken_MakeMold,ASNH225ClearToken_Encode,ASNH225ClearToken_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ClearToken_Print,
#endif
		delete_ASNH225ClearToken);
	AsnSequenceOf_SetMold( &(pObj->m_tokens), moldObject );
	}
	{
	ASNH225CryptoH323Token *tmold_cryptoTokens = (ASNH225CryptoH323Token *)HSMalloc( sizeof(ASNH225CryptoH323Token) );
	new_ASNH225CryptoH323Token(tmold_cryptoTokens);
	ASNH225CryptoH323Token_MakeMold(tmold_cryptoTokens);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_cryptoTokens,sizeof(ASNH225CryptoH323Token),ASNH225CryptoH323Token_MakeMold,ASNH225CryptoH323Token_Encode,ASNH225CryptoH323Token_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225CryptoH323Token_Print,
#endif
		delete_ASNH225CryptoH323Token);
	AsnSequenceOf_SetMold( &(pObj->m_cryptoTokens), moldObject );
	}
	{
	ASNH225ConferenceList *tmold_conferences = (ASNH225ConferenceList *)HSMalloc( sizeof(ASNH225ConferenceList) );
	new_ASNH225ConferenceList(tmold_conferences);
	ASNH225ConferenceList_MakeMold(tmold_conferences);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_conferences,sizeof(ASNH225ConferenceList),ASNH225ConferenceList_MakeMold,ASNH225ConferenceList_Encode,ASNH225ConferenceList_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ConferenceList_Print,
#endif
		delete_ASNH225ConferenceList);
	AsnSequenceOf_SetMold( &(pObj->m_conferences), moldObject );
	}
	ASNH225TransportAddress_MakeMold(&(pObj->m_h245Address));
	{
	AsnOctetString *tmold_fastStart = (AsnOctetString *)HSMalloc( sizeof(AsnOctetString) );
	new_AsnOctetString(tmold_fastStart,e_unconstrained,0,HS_ASN_MAX_CONSTRAINT,0,HS_ASN_MAX_CONSTRAINT);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_fastStart,sizeof(AsnOctetString),AsnOctetString_MakeMold,AsnOctetString_Encode,AsnOctetString_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		AsnOctetString_Print,
#endif
		delete_AsnOctetString);
	AsnSequenceOf_SetMold( &(pObj->m_fastStart), moldObject );
	}
	{
	ASNH225ServiceControlSession *tmold_serviceControl = (ASNH225ServiceControlSession *)HSMalloc( sizeof(ASNH225ServiceControlSession) );
	new_ASNH225ServiceControlSession(tmold_serviceControl);
	ASNH225ServiceControlSession_MakeMold(tmold_serviceControl);
	moldObject = (AsnObject*)HSMalloc( sizeof(AsnObject) );
	new_AsnObject(moldObject,tmold_serviceControl,sizeof(ASNH225ServiceControlSession),ASNH225ServiceControlSession_MakeMold,ASNH225ServiceControlSession_Encode,ASNH225ServiceControlSession_Decode,
#ifdef HS_DEBUG_ASN_PRINT
		ASNH225ServiceControlSession_Print,
#endif
		delete_ASNH225ServiceControlSession);
	AsnSequenceOf_SetMold( &(pObj->m_serviceControl), moldObject );
	}
	ASNH225CircuitInfo_MakeMold(&(pObj->m_circuitInfo));
	ASNH225FeatureSet_MakeMold(&(pObj->m_featureSet));
	ASNH225EndpointType_MakeMold(&(pObj->m_destinationInfo));
	ASNH225H245Security_MakeMold(&(pObj->m_h245SecurityMode));
	return HS_OK;
}

/* ASNH225Facility_UUIE IncludeOptionalField */
HS_RESULT ASNH225Facility_UUIE_IncludeOptionField( void *pObject, ASNH225Facility_UUIEOptionMap pOptionMap )
{
	HS_UINT	tExtOptionMap;
	HS_UINT	tByteOffset, tBitOffset;

	ASNH225Facility_UUIE *pObj = (ASNH225Facility_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Facility_UUIE_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return HS_ERR_NULL_PARAM;
	}

	if( ((int)pOptionMap) > e_ASNH225Facility_UUIEOptionMapSizeExt -1 ) return HS_ERR_ASN_OUTOF_RANGE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225Facility_UUIEOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		pObj->optionMap[tByteOffset] |= 1<<(7-tBitOffset);
	}
	else
	{
		tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225Facility_UUIEOptionMapSize ;

		tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

		pObj->extOptionMap[tByteOffset] |= 1<<(7-tBitOffset);

		if( pObj->extOptionMapSize < (tExtOptionMap+1) ) pObj->extOptionMapSize = tExtOptionMap + 1 ;

		pObj->extended = TRUE;
	}

	return HS_OK;
}

/* ASNH225Facility_UUIE IsIncludeOptionalField */
BOOL ASNH225Facility_UUIE_IsIncludeOptionField( void *pObject, ASNH225Facility_UUIEOptionMap pOptionMap )
{
	HS_UCHAR tByte;

	HS_UINT tExtOptionMap;
	HS_UINT tByteOffset, tBitOffset;

	ASNH225Facility_UUIE *pObj = (ASNH225Facility_UUIE *)pObject;
	if( pObj == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Facility_UUIE_IncludeOptionField(NULL,%d) -> null parameter", (int)pOptionMap );
#endif
		return FALSE;
	}

	if( ((int)pOptionMap) > e_ASNH225Facility_UUIEOptionMapSizeExt -1 ) return FALSE;

	if( ((HS_UINT)pOptionMap) < e_ASNH225Facility_UUIEOptionMapSize )
	{
		tByteOffset = (HS_UINT)(((int)pOptionMap)/8);
		tBitOffset = (HS_UINT)(((int)pOptionMap)%8);

		tByte = 1<<(7-tBitOffset);

		if( tByte & pObj->optionMap[tByteOffset] ) return TRUE;
		return FALSE;
	}

	tExtOptionMap = ((HS_UINT)pOptionMap) - e_ASNH225Facility_UUIEOptionMapSize ;

	tByteOffset = (HS_UINT)(((int)tExtOptionMap)/8);
	tBitOffset = (HS_UINT)(((int)tExtOptionMap)%8);

	tByte = 1<<(7-tBitOffset);

	if( tByte & pObj->extOptionMap[tByteOffset] ) return TRUE;
	return FALSE;
}

/* ASNH225Facility_UUIE Encode */
HS_RESULT ASNH225Facility_UUIE_Encode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225Facility_UUIE *pObj = (ASNH225Facility_UUIE *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitEncoding( pStrm, pObj->extended );

	/* option map bits */
	if( e_ASNH225Facility_UUIEOptionMapSize != 0 )
		AsnStream_BitsEncoding( pStrm, pObj->optionMap, e_ASNH225Facility_UUIEOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225ProtocolIdentifier_Encode( &(pObj->m_protocolIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_alternativeAddress ) ){
		if( (tRet=ASNH225TransportAddress_Encode( &(pObj->m_alternativeAddress),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_alternativeAliasAddress ) ){
		if( (tRet=AsnSequenceOf_Encode( &(pObj->m_alternativeAliasAddress),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_conferenceID ) ){
		if( (tRet=ASNH225ConferenceIdentifier_Encode( &(pObj->m_conferenceID),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225FacilityReason_Encode( &(pObj->m_reason),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( pObj->extOptionMapSize )
	{
		AsnStream tTempStrm;
		new_AsnStream(&tTempStrm,HS_ASN_MAX_EXTENSION_OCTET,TRUE);
		/* extension bitMap size */
		SmallNumberEncoding( pStrm, (pObj->extOptionMapSize-1) );
		/* option bitMap encoding */
		AsnStream_BitsEncoding( pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft );

		/* datas */
		if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_callIdentifier ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_destExtraCallInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_destExtraCallInfo), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_remoteExtensionAddress ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_remoteExtensionAddress), ASNH225AliasAddress_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_tokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_tokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_cryptoTokens ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_conferences ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_conferences), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_h245Address ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_h245Address), ASNH225TransportAddress_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_fastStart ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_fastStart), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_multipleCalls ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_multipleCalls), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_maintainConnection ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_maintainConnection), AsnBoolean_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_fastConnectRefused ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_fastConnectRefused), AsnNull_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_serviceControl ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_serviceControl), AsnSequenceOf_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_circuitInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_circuitInfo), ASNH225CircuitInfo_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_featureSet ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_featureSet), ASNH225FeatureSet_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_destinationInfo ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_destinationInfo), ASNH225EndpointType_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
		if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_h245SecurityMode ) ){
			if( (tRet=WellKnownExtensionEncoding( &(pObj->m_h245SecurityMode), ASNH225H245Security_Encode, pStrm, &tTempStrm )) != HS_OK )
			{
#ifdef HS_DEBUG_ASN_MEMBER
				HSPrint( "\n Error on ASNH225Facility_UUIE_Encode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
				return tRet;
			}
		}
	}	
	return HS_OK;
}

/* ASNH225Facility_UUIE Decode */
HS_RESULT ASNH225Facility_UUIE_Decode( void *pObject, AsnStream *pStrm )
{
	HS_RESULT	tRet;

	ASNH225Facility_UUIE *pObj = (ASNH225Facility_UUIE *)pObject;
	if( pObj == HS_NULL || pStrm == HS_NULL )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Facility_UUIE_Decode(%x,%x) -> null parameter", pObj, pStrm );
#endif
		return HS_ERR_NULL_PARAM;
	}

	/* extension bit */
	if( pObj->extensible ) AsnStream_BitDecoding( pStrm, &(pObj->extended) );

	/* option map bits */
	if( e_ASNH225Facility_UUIEOptionMapSize != 0 )
		AsnStream_BitsDecoding( pStrm, pObj->optionMap, e_ASNH225Facility_UUIEOptionMapSize, e_alignLeft );

	/* root field datas */
	if( (tRet=ASNH225ProtocolIdentifier_Decode(&(pObj->m_protocolIdentifier),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Facility_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}
	if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_alternativeAddress ) ){
		if( (tRet=ASNH225TransportAddress_Decode(&(pObj->m_alternativeAddress),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Facility_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_alternativeAliasAddress ) ){
		if( (tRet=AsnSequenceOf_Decode( &(pObj->m_alternativeAliasAddress),pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Facility_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_conferenceID ) ){
		if( (tRet=ASNH225ConferenceIdentifier_Decode(&(pObj->m_conferenceID),pStrm)) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Facility_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( (tRet=ASNH225FacilityReason_Decode(&(pObj->m_reason),pStrm)) != HS_OK )
	{
#ifdef HS_DEBUG_ASN_MEMBER
		HSPrint( "\n Error on ASNH225Facility_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
		return tRet;
	}

	/* extension field datas */
	if( ! pObj->extended ) return HS_OK;
	if( SmallNumberDecoding(pStrm, &(pObj->extOptionMapSize)) != HS_OK )
	{
		pObj->extOptionMapSize = 0;
		return HS_OK;
	}
	pObj->extOptionMapSize++;
	/* option bitMap encoding */
	HS_TRY_OK( AsnStream_BitsDecoding(pStrm, pObj->extOptionMap, pObj->extOptionMapSize, e_alignLeft) )

	if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_callIdentifier ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_callIdentifier), ASNH225CallIdentifier_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Facility_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_destExtraCallInfo ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_destExtraCallInfo), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Facility_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_remoteExtensionAddress ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_remoteExtensionAddress), ASNH225AliasAddress_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Facility_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_tokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_tokens), AsnSequenceOf_Decode, pStrm )) != HS_OK )
		{
#ifdef HS_DEBUG_ASN_MEMBER
			HSPrint( "\n Error on ASNH225Facility_UUIE_Decode(pObj,pStrm) -> tRet(%d)", tRet );
#endif
			return tRet;
		}
	}
	if( ASNH225Facility_UUIE_IsIncludeOptionField( pObj, e_ASNH225Facility_UUIEOptionMap_cryptoTokens ) ){
		if( (tRet=WellKnownExtensionDecoding( &(pObj->m_cryptoTokens), AsnSequenceOf_Decode, pStr