/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<handship.h>	2005-02-20,19:27

*/

#ifndef __2005_02_20__19_27__HANDSHIP_H__
#define __2005_02_20__19_27__HANDSHIP_H__

#include "H323Define.h"
#include "asnPrime.h"






/* ASNScreeningIndicator Class */
typedef enum
{
	e_enum_userProvidedNotScreened,
	e_enum_userProvidedVerifiedAndPassed,
	e_enum_userProvidedVerifiedAndFailed,
	e_enum_networkProvided
} ASNScreeningIndicator_AsnEnumerated;


#ifdef HS_CPLUSPLUS
class ASNH225ScreeningIndicator : public AsnObject
#else
typedef struct
#endif
{
#ifdef HS_CPLUSPLUS
public:
	ASNH225ScreeningIndicator();
	~ASNH225ScreeningIndicator();

#ifdef HS_DEBUG_ASN_PRINT
	HS_RESULT Print( HS_UINT pDepth, char *pTypeName );
#endif

	HS_RESULT Encode( AsnStream *pStrm );
	HS_RESULT Decode( AsnStream *pStrm );

	HS_RESULT AddEnumValue( int pEnumValue );
	HS_RESULT GetEnumValue( HS_UINT pPoint, int *pEnumValue );

	HS_RESULT SetValue( ASNScreeningIndicator_AsnEnumerated pEnum );
#endif

	ASNScreeningIndicator_AsnEnumerated	extensionPoint;
	ASNScreeningIndicator_AsnEnumerated	value;

	int							enumValue[HS_MAX_ENUMERATED];
	HS_UINT						enumSize;
#ifdef HS_CPLUSPLUS
};
#else
} ASNH225ScreeningIndicator;
HS_RESULT new_ASNH225ScreeningIndicator( void *pObject );
HS_RESULT delete_ASNH225ScreeningIndicator( void *pObject );
HS_RESULT ASNH225ScreeningIndicator_MakeMold( void *pObject );
#ifdef HS_DEBUG_ASN_PRINT
HS_RESULT ASNH225ScreeningIndicator_Print( void *pObject, HS_UINT pDepth, char *pTypeName );
#endif
HS_RESULT ASNH225ScreeningIndicator_Encode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ScreeningIndicator_Decode( void *pObject, AsnStream *pStrm );
HS_RESULT ASNH225ScreeningIndicator_AddEnumValue( void *pObject, int pEnumValue );
HS_RESULT ASNH225ScreeningIndicator_GetEnumValue( void *pObject, HS_UINT pPoint, int *pEnumValue );
HS_RESULT ASNH225ScreeningIndicator_SetValue( void *pObject, ASNScreeningIndicator_AsnEnumerated pEnum );
#endif/*HS_CPLUSPLUS*/






#endif/*__2005_02_20__19_27__HANDSHIP_H__*/


