/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<H323Define.h>	2004-07-03,12:02

*/

#ifndef __2004_07_03__12_02__H323DEFINE_H__
#define __2004_07_03__12_02__H323DEFINE_H__


#include <malloc.h>
#include <memory.h>
#include <stdio.h>
#include <string.h>


/***********************/
/* Compile Definitions
 */
#define HS_OS_WINDOWS
#define HS_BIG_ENDIAN
#undef HS_CPLUSPLUS

#define HS_DEBUG_ASN
#define HS_DEBUG_ASN_MEMBER
#define HS_DEBUG_ASN_PRINT





#ifndef HS_COMMONDEF_BASE
#define HS_COMMONDEF_BASE
	typedef char			HS_CHAR;
	typedef unsigned char	HS_UCHAR;
	#define HS_UCHAR_MAX	0xff
	typedef short			HS_SHORT;
	typedef unsigned short	HS_USHORT;
	#define HS_USHORT_MAX	0xffff
	typedef int				HS_INT;
	typedef unsigned int	HS_UINT;
	#define HS_UINT_MAX		0xffffffff
	#define HS_ASN_MAX_CONSTRAINT	HS_UINT_MAX
	typedef signed __int64		HS_INT64;
	typedef unsigned __int64	HS_UINT64;

	typedef HS_UINT			HS_RESULT;


	#ifndef BOOL
	#define BOOL			int
	#endif
	#ifndef FALSE
	#define FALSE			0
	#endif
	#ifndef TRUE
	#define TRUE			1
	#endif
	#ifndef NULL
	#define NULL			0
	#endif

	#define HS_QID							HS_UINT
	#define HS_TIMER_ID						HS_UINT
	#define HS_INVALID_HANDLE				HS_UINT_MAX
	#define HS_INVALID_TSAP_PORT			HS_USHORT_MAX
	#define HS_INVALID_POS					HS_UINT_MAX
	#define HS_INVALID_QID					HS_UINT_MAX

	#define HS_QM								1200
	/* wparam: 0
	   lparam: any value
	*/
	#define HS_QM_START							HS_QM+1
	/* wparam: 0
	   lparam: null
	*/
	#define HS_QM_STOP							HS_QM_START+1
	#define HS_QM_USER							HS_QM_STOP+1

	#define HS_OK								0
	#define HS_ERR								1
	#define HS_ERR_NULL							2
	#define HS_ERR_NULL_PARAM					3
	#define HS_ERR_MALLOC						4
	#define HS_ERR_INVALID						5
	#define HS_ERR_INVALID_PARAM				6
	#define HS_ERR_INVALID_VALUE				7
	#define HS_ERR_CONFLICT						8
	#define HS_ERR_NO_EXIST						9
	#define HS_ERR_OVER							10
	#define HS_ERR_EMPTY						11
	
	#define HS_ERR_NOT_SUPPORT_YET				99
	#define HS_ERR_LICENCE						100

	#define HS_TRY(t)					{if( (tRet=t) != HS_OK ) return tRet;}
	#define HS_TRY_OK(t)				{if(    t    != HS_OK ) return HS_OK;}
#endif/*HS_COMMONDEF_BASE*/



	

#define HS_NULL						NULL
	
#define	HS_ASCII_SIZE				256
#define HS_MAX_DIGIT				256
#define HS_MAX_LETTER				256
#define HS_MAX_ENUMERATED			256
#define HS_ASN_MAX_EXTENSION_OCTET	512


	


#define HS_ERR_ASN							HS_ERR+100
#define HS_ERR_ASN_STREAM_OVERFLOW			HS_ERR_ASN+1
#define HS_ERR_ASN_LENGTH					HS_ERR_ASN+2
#define HS_ERR_ASN_NOCHOICE					HS_ERR_ASN+3
#define HS_ERR_ASN_OUTOF_RANGE				HS_ERR_ASN+4
#define HS_ERR_ASN_CONFLICT					HS_ERR_ASN+5
#define HS_ERR_ASN_NO_MOLD					HS_ERR_ASN+6
#define HS_ERR_ASN_NOUSEYET					HS_ERR_ASN+7
#define HS_ERR_ASN_ENUMFULL					HS_ERR_ASN+8



#ifndef HS_DEFINE_PRINT
#define HS_DEFINE_PRINT
void HSPrint(char *pLog, ...);
void OpenHSPrint(char *pTargetIp);
void CloseHSPrint();
#endif





#endif/*__2004_07_03__12_02__H323DEFINE_H__*/

