/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<asnClass.h>	/AsnParser Project

*/

#ifndef __ASNPARSER__ASNCLASS_H__
#define __ASNPARSER__ASNCLASS_H__



#include "asnContent.h"



#define PARSER_CHECK_OK(checked)	if( ! checked ) return 0



typedef enum
{
	e_extension,
	e_choice,
	e_set,
	e_sequence,
	e_class,
	e_boolean,
	e_integer,
	e_bitString,
	e_octetString,
	e_null,
	e_objectIdentifier,
	e_enumerated,
	e_printableString,
	e_ia5String,
	e_numericString,
	e_generalString,
	e_bmpString
} AsnType;

typedef enum
{
	e_readyClass,
	e_readyType,
	e_readyBrecisOf,
	e_readyBrecis,
	e_readyMember,
	e_readyMType,
	e_readyCommaOf,
	e_readyComma
} ParseState;






class AsnClass;
class AsnMember
{
public:
	AsnMember();
	~AsnMember();

	void SetMemberName( char *pName );
	void SetClassName( char *pName, const char *pFile );
	void SetClassName( AsnType at );
	void SetClassName();

	AsnClass		*mother;

	char			mName[256];
	char			cName[256];
	char			from[256];

	AsnType			type;
	Constraint		cons;
	Constraint		consOf;

	bool			of;
	bool			optional;
	bool			extended;
};






class AsnClassBox;
class AsnClass
{
public:
	AsnClass();
	~AsnClass();

	void PrintToFile(FILE *pFp);
	bool MakeClass(AsnClassBox *acb, AsnContent *ctnt, ParseState pps, const char *pFile);

	char			cName[256];
	char			sName[256];
	char			from[256];

	AsnType			type;
	Constraint		cons;
	Constraint		consOf;

	bool			of;
	bool			optional;
	bool			extendable;

	AsnMember		member[256];
	int				mSize;

	bool			sorted;
	bool			handship;
};






#define MAX_ASNCLASS	4096
class AsnClassBox
{
public:
	AsnClassBox();
	~AsnClassBox();

	void AddClass(AsnClass *c);
	unsigned int FindClass( char *cName );
	void PrintToFile(FILE *pFp);

	void *ac[MAX_ASNCLASS];
	unsigned int acSize;

	unsigned int handshipSize;
};






AsnClassBox *MakeClasses(unsigned char *p,AsnClassBox *acb);
AsnClassBox *AsnClassBoxSort( AsnClassBox *acb, CommandSet *cs );

const char *GetAsnTypeName( AsnType at );

#endif/*__ASNPARSER__ASNCLASS_H__*/