/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<AsnContent.cpp>	/AsnParser Project

*/

#include "asnContent.h"



char *gKeyWord[e_kword_max] =
{
"END",			"BEGIN",			"OPTIONAL",				"CHOICE",			"SET",
"SEQUENCE",		"BOOLEAN",			"INTEGER",				"NULL",				"ENUMERATED",
"PrintableString",	"IA5String",	"NumericString",		"GeneralString",	"BMPString",
"OBJECT",		"IDENTIFIER",		"BIT",					"OCTET",			"STRING",
"SIZE",			"FROM",				"OF",
};
char *gOperator[e_optr_max - e_kword_max] =
{
"--",	"::=",	"{",	"}",	"(",	")",	",",	".",	"..",	"...", "^"
};



bool SortToFrom( char *from, char *token )
{
	int i, j;
	unsigned char temp;
	int len = strlen(token);

	strcpy(from,token);

	for( i=0; i<len; i++ )
	{
		for( j=0; j<len-1; j++ )
		{
			if( from[j] > from[j+1] )
			{
				temp = from[j];
				from[j] = from[j+1];
				from[j+1] = temp;
			}
		}
	}

	return true;
}






/***************************************************/
/* AsnContent
*/
bool IsNumeric( char *pWord )
{
	int i, len = strlen(pWord);
	for( i=0; i<len; i++ )
	{
		if(!i)
		{
			if(pWord[i] == '-') continue;
		}
		
		if(pWord[i]<0x30 || pWord[i]>0x39 ) return false;
	}

	return true;
}
bool IsString( char *pWord )
{
	char tString[256];
	int len = strlen(pWord);

	if( pWord[0] == '\"' && pWord[len-1] == '\"' )
	{
		memcpy( tString, pWord+1, len-2 );
		memcpy( pWord, tString, len-2 );
		pWord[len-2] = 0;
		return true;
	}

	return false;
}


AsnContent::AsnContent(unsigned char *pPoint)
{
	words = 0;
	word = 0;

	int line = 1;
	bool out = true;
	while( out )
	{
		out = GetNextToken(&pPoint,&line);
	}
	word = words;
	printf( "\n AsnContent() -> Content List Making Complete" );
}
AsnContent::~AsnContent()
{
	AsnWord *deleter;
	AsnWord *rounder = words;

	while( rounder )
	{
		deleter = rounder;
		rounder = rounder->GetNext();
		delete deleter;
	}
}

void AsnContent::AddWord( AsnWord *aw )
{
	if(aw)
	{
		if(word)
		{
			word->next = aw;
			word = aw;
		}
		else
		{
			word = aw;
			words = aw;
		}
	}
}

bool AsnContent::GetNextToken(unsigned char **pp, int *pLine)
{
	char t[256];
	AsnWord *aw = 0;
	int line = *pLine;
	int i, len, tPos=0;
	bool found = false;
	unsigned char *p = *pp;

	/*Find Word*/
	while(1)
	{
		if( *p == 0 )
		{
			*pp = p;
			*pLine = line;
			return false;
		}
		if( *p == '\n' ) line++;
		if( *p > 0x20 && *p < 0x7f ) break;
		p++;
	}

	while(1)
	{
		t[tPos++] = *p;		p++;
		
		if( t[0]=='\"' )
		{
			if(tPos>1)
			{
				if(t[tPos-1] == '\"')
				{
					*pp = p;
					*pLine = line;
					t[tPos] = 0;
					IsString(t);
					AddWord( new AsnWord(t,e_word_string,line) );
					return true;
				}
			}
		}
		else
		{
			for( i=0; i<e_kword_max; i++ )
			{
				if( strlen(gKeyWord[i])==tPos && !memcmp( gKeyWord[i], t, tPos) )
				{
					*pp = p;
					*pLine = line;
					t[tPos] = 0;
					AddWord(new AsnWord(t,i,line));

					if( i == e_kword_end ) return false;
					return true;
				}
			}

			for( i=e_kword_max; i<e_optr_max; i++ )
			{
				len = strlen(gOperator[i-e_kword_max]);
				if( len<=tPos && !memcmp( gOperator[i-e_kword_max], t+tPos-len, len) )
				{
					if( i==e_optr_dot1 )
					{
						if( *p == '.' )
						{
							t[tPos++] = '.';
							i=e_optr_dot2;	p++;	len++;

							if( *p == '.' )
							{
								t[tPos++] = '.';
								i=e_optr_dot3;	p++;	len++;
							}
						}
					}

					if(len<tPos)
					{
						char temp[256];
						memcpy(temp,t,tPos-len);
						temp[tPos-len]=0;
						if( IsString(temp) ) AddWord(new AsnWord(temp,e_word_string,line));
						else if( IsNumeric(temp) ) AddWord(new AsnWord(temp,e_word_numeric,line));
						else
						{
							int j, jLen;
							jLen = strlen(temp);
							for(j=0; j<jLen; j++)
							{
								if( temp[j]=='-' ) temp[j] = '_';
							}

							AddWord(new AsnWord(temp,e_word_normal,line));
						}

					}

					t[tPos] = 0;
					if( i == e_optr_note )
					{
						GoToNextLine(&p);
						line++;
					}
					else
						AddWord(new AsnWord(t+tPos-len,i,line));

					*pp = p;
					*pLine = line;
					return true;
				}
			}
		}
		if( *p < 0x21 || *p > 0x7e )
		{
			t[tPos] = 0;
			if( IsNumeric(t) ) AddWord( new AsnWord(t,e_word_numeric,line) );
			else if( IsString(t) ) AddWord( new AsnWord(t,e_word_string,line) );
			else
			{
				int j, jLen;
				jLen = strlen(t);
				for(j=0; j<jLen; j++)
				{
					if( t[j]=='-' ) t[j] = '_';
				}
				
				AddWord( new AsnWord(t,e_word_normal,line) );
			}

			*pp = p;
			*pLine = line;
			if(*p) return true;
			return false;
		}
	}/*while(1)*/

	*pp = p;
	*pLine = line;
	return true;
}


void AsnContent::GoToNextLine(unsigned char **pp)
{
	unsigned char *p = *pp;

	while(1)
	{
		if(*p=='\n') break;
		p++;
	}
	p++;

	*pp = p;
}

bool AsnContent::GoToBrecisClose()
{
	unsigned int bDepth = 1;

	if( ! GetNext() ) return false;
	
	while(bDepth)
	{
		if( ! GetNext() ) return false;
		if(word->kind==e_optr_brecisOpen) bDepth++;
		else if(word->kind==e_optr_brecisClose) bDepth--;
	}

	return true;
}

bool AsnContent::GetNext()
{
	word=word->GetNext();
	if(word) return true;
	return false;
}

bool AsnContent::GetSizeConstraint( Constraint* pCons )
{
	if(word==0)
	{
		printf( "GetSizeConstraint() -> word is zero", word->line );
		return false;
	}
	pCons->type = e_cons;
	if( word->kind != e_optr_blankOpen )
	{
		printf( "GetSizeConstraint() -> line(%d): need '(' next of 'SIZE' keyword", word->line );
		return false;
	}

	if( (word=word->GetNext()) == 0 )
	{
		printf( "GetSizeConstraint() -> line(%d): uncompleted : need numeric next of 'SIZE(' keyword", word->line );
		return false;
	}
	if( word->kind != e_word_numeric )
	{
		printf( "GetSizeConstraint() -> line(%d) : need numeric next of 'SIZE(' keyword", word->line );
		return false;
	}
	pCons->nMin = atoi(word->str);

	if( (word=word->GetNext()) == 0 )
	{
		printf( "GetSizeConstraint() -> line(%d) : uncompleted : need '..' or ')' next of minimum constraint", word->line );
		return false;
	}
	if( word->kind == e_optr_blankClose )
	{
		pCons->nMax = pCons->nMin;
		return true;
	}
	if( word->kind != e_optr_dot2 )
	{
		printf( "GetSizeConstraint() -> line(%d) : need '..' next of minimum constraint", word->line );
		return false;
	}

	if( (word=word->GetNext()) == 0 )
	{
		printf( "GetSizeConstraint() -> line(%d) : uncompleted : need numeric next of '..' keyword", word->line );
		return false;
	}
	if( word->kind != e_word_numeric )
	{
		printf( "GetSizeConstraint() -> line(%d) : need numeric next of '..' keyword", word->line );
		return false;
	}
	pCons->nMax = atoi(word->str);

	if( (word=word->GetNext()) == 0 )
	{
		printf( "GetSizeConstraint() -> line(%d) : uncompleted : need ',' or ')' next of '...' keyword", word->line );
		return false;
	}
	if( word->kind == e_optr_blankClose )
		return true;

	else if( word->kind == e_optr_comma )
	{
		pCons->type = e_extcons;
		if( (word=word->GetNext()) == 0 )
		{
			printf( "GetSizeConstraint() -> line(%d) : uncompleted : need '...' next of ',' keyword", word->line );
			return false;
		}
		if( word->kind != e_optr_dot3 )
		{
			printf( "GetSizeConstraint() -> line(%d) : need '...' next of ',' keyword", word->line );
			return false;
		}

		if( (word=word->GetNext()) == 0 )
		{
			printf( "GetSizeConstraint() -> line(%d) : uncompleted : need ',' or ')' next of '...' keyword", word->line );
			return false;
		}
		if( word->kind == e_optr_blankClose )
			return true;

		else if( word->kind == e_optr_comma )
		{
			if( (word=word->GetNext()) == 0 )
			{
				printf( "GetSizeConstraint() -> line(%d) : uncompleted : need numeric next of ',' keyword", word->line );
				return false;
			}
			if( word->kind != e_word_numeric )
			{
				printf( "GetSizeConstraint() -> line(%d) : need numeric next of ',' keyword", word->line );
				return false;
			}
			pCons->eMin = atoi(word->str);

			if( (word=word->GetNext()) == 0 )
			{
				printf( "GetSizeConstraint() -> line(%d) : uncompleted : need '..' next of minimum extConstraint", word->line );
				return false;
			}
			if( word->kind != e_optr_dot2 )
			{
				printf( "GetSizeConstraint() -> line(%d) : need '..' next of minimum extConstraint", word->line );
				return false;
			}

			if( (word=word->GetNext()) == 0 )
			{
				printf( "GetSizeConstraint() -> line(%d) : uncompleted : need numeric next of '..' keyword", word->line );
				return false;
			}
			if( word->kind != e_word_numeric )
			{
				printf( "GetSizeConstraint() -> line(%d) : need numeric next of '..' keyword", word->line );
				return false;
			}
			pCons->eMax = atoi(word->str);

			if( (word=word->GetNext()) == 0 )
			{
				printf( "GetSizeConstraint() -> line(%d) : uncompleted : need ')'", word->line );
				return false;
			}
			if( word->kind != e_optr_blankClose )
			{
				printf( "GetSizeConstraint() -> line(%d) : need ')' ", word->line );
				return false;
			}
			return true;
		}
		else
		{
			printf( "GetSizeConstraint() -> line(%d) : need ',' or ')' next of '...' keyword", word->line );
			return false;
		}
	}
	else
	{
		printf( "GetSizeConstraint() -> line(%d) : need ')' or ',' next of constraint", word->line );
		return false;
	}
}

bool AsnContent::GetFromConstraint( char *pFrom )
{
	if(word==0)
	{
		printf( "GetSizeConstraint() -> word is zero", word->line );
		return false;
	}
	if( word->kind != e_optr_blankOpen )
	{
		printf( "GetSizeConstraint() -> line(%d): need '(' next of 'FROM' keyword", word->line );
		return false;
	}

	if( (word=word->GetNext()) == 0 )
	{
		printf( "GetSizeConstraint() -> line(%d): uncompleted : need string next of 'FROM(' keyword", word->line );
		return false;
	}
	if( word->kind != e_word_string )
	{
		printf( "GetSizeConstraint() -> line(%d) : need string next of 'FROM(' keyword", word->line );
		return false;
	}
	SortToFrom((char*)pFrom,word->str);

	if( (word=word->GetNext()) == 0 )
	{
		printf( "GetSizeConstraint() -> line(%d) : uncompleted : need ')'", word->line );
		return false;
	}
	if( word->kind != e_optr_blankClose )
	{
		printf( "GetSizeConstraint() -> line(%d) : need ')'", word->line );
		return false;
	}

	return true;
}









