/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/


/*

	<asnContent.h>		/AsnParser project

*/

#ifndef __ASNPARSER__ASNCONTENT_H__
#define __ASNPARSER__ASNCONTENT_H__



#include "commandSet.h"

#include <string>



typedef enum
{
	e_kword_end,
	e_kword_begin,
	e_kword_optional,
	e_kword_choice,
	e_kword_set,
	e_kword_sequence,
	e_kword_boolean,
	e_kword_integer,
	e_kword_null,
	e_kword_enumerated,
	e_kword_printableString,
	e_kword_ia5String,
	e_kword_numericString,
	e_kword_generalString,
	e_kword_bmpString,
	e_kword_object,
	e_kword_identifier,
	e_kword_bit,
	e_kword_octet,
	e_kword_string,
	e_kword_size,
	e_kword_from,
	e_kword_of,
	e_kword_max
} AsnKeyword;


typedef enum
{
	e_optr_note = e_kword_max,
	e_optr_class,
	e_optr_brecisOpen,
	e_optr_brecisClose,
	e_optr_blankOpen,
	e_optr_blankClose,
	e_optr_comma,
	e_optr_dot1,
	e_optr_dot2,
	e_optr_dot3,
	e_optr_arrow,
	e_optr_max
} AsnOperator;


typedef enum
{
	e_word_normal = e_optr_max,
	e_word_string,
	e_word_numeric
} AsnKind;



typedef enum
{
	e_uncons,
	e_semicons,
	e_cons,
	e_extcons
} ConstType;


typedef struct
{
	ConstType		type;
	int				nMin;
	unsigned int	nMax;
	int				eMin;
	unsigned int	eMax;
} Constraint;



class AsnWord
{
public:
	AsnWord(char *pWord,int pKind,int pLine)
	{
		str = (char*)HSMalloc( strlen(pWord)+1 );
		strcpy( str, pWord );
		kind = pKind;
		line = pLine;
		next = 0;
	}
	~AsnWord()
	{
		HSFree(str);
	}
	AsnWord *GetNext()
	{
		if( next == 0 ) return 0;
		if( !strcmp(next->str,"END") ) return 0;
		return next;
	}
	
	int kind;
	char *str;
	int line;
	AsnWord *next;
};






class AsnContent
{
public:
	AsnContent(unsigned char *pPoint);
	~AsnContent();

	void AddWord( AsnWord *aw );
	bool GetNextToken(unsigned char **pp, int *pLine);
	void GoToNextLine(unsigned char **pp);
	bool GoToBrecisClose();
	bool GetNext();

	bool GetSizeConstraint( Constraint* pCons );
	bool GetFromConstraint( char *pFrom );

	AsnWord *words;
	AsnWord *word;
};






bool SortToFrom( char *from, char *token );

#endif/*__ASNPARSER__ASNCONTENT_H__*/