/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<EpDefine.h>	2005-03-13,09:48

*/
/*
  Stack Supportable List:

    AliasAddress Type:
      dialedDigit,
	  h323-ID,
	  url-ID,
	  transportID,
	  email-ID

    Capability Negociation:
	  Audio:
        g711Alaw64k
        g711Alaw56k
        g711Ulaw64k
        g711Ulaw56k
        g722-64k
        g722-56k
        g722-48k
        g728
        g729
        g729AnnexA
        g729wAnnexB
        g729AnnexAwAnnexB
	  Video:
        _None
	  DataApplication:
        _None
*/


#ifndef __2005_03_13__09_49__EPDEFINE_H__
#define __2005_03_13__09_49__EPDEFINE_H__

#include "H323Define.h"

#ifdef _WIN32
#ifndef _WIN32_WCE
#include <process.h>
#endif
#endif




#define HS_DEBUG_H323
#define HS_DEBUG_H323DEMON
#define HS_DEBUG_ENETDEMON
#define HS_DEBUG_UI

#define HS_LICENCE_LOCK_H323



#define HS_YES				TRUE
#define HS_NO				FALSE
#define HS_PRIVATE			static


#define HS_SOCKET			SOCKET
#define HS_INVALID_PORT		HS_UINT_MAX
#define HS_INVALID_INDEX	HS_UINT_MAX


#define HS_MAX_CALL				HS_USHORT_MAX
#define HS_CALL_HANDLE			HS_UINT
#define HS_INVALID_CALL_HANDLE	HS_MAX_CALL+1



#define RasMsg			ASNH225RasMessage
#define new_RasMsg		new_ASNH225RasMessage
#define delete_RasMsg	delete_ASNH225RasMessage
#define RasMsg_MakeMold	ASNH225RasMessage_MakeMold
#define RasMsg_Print	ASNH225RasMessage_Print
#define RasMsg_Encode	ASNH225RasMessage_Encode
#define RasMsg_Decode	ASNH225RasMessage_Decode
#define RasMsg_Choice	ASNH225RasMessage_SetChoice

#define SignalMsg			ASNH225H323_UserInformation
#define new_SignalMsg		new_ASNH225H323_UserInformation
#define delete_SignalMsg	delete_ASNH225H323_UserInformation
#define SignalMsg_MakeMold	ASNH225H323_UserInformation_MakeMold
#define SignalMsg_Print		ASNH225H323_UserInformation_Print
#define SignalMsg_Encode	ASNH225H323_UserInformation_Encode
#define SignalMsg_Decode	ASNH225H323_UserInformation_Decode
#define SignalMsg_Option	ASNH225H323_UserInformation_IncludeOptionField
#define SignalMsg_IsOption	ASNH225H323_UserInformation_Decode_IsIncludeOptionField

#define ControlMsg			ASNH245MultimediaSystemControlMessage
#define new_ControlMsg		new_ASNH245MultimediaSystemControlMessage
#define delete_ControlMsg	delete_ASNH245MultimediaSystemControlMessage
#define ControlMsg_MakeMold	ASNH245MultimediaSystemControlMessage_MakeMold
#define ControlMsg_Print	ASNH245MultimediaSystemControlMessage_Print
#define ControlMsg_Encode	ASNH245MultimediaSystemControlMessage_Encode
#define ControlMsg_Decode	ASNH245MultimediaSystemControlMessage_Decode
#define ControlMsg_Choice	ASNH245MultimediaSystemControlMessage_SetChoice



#define HS_MAX_PACKET				4096

#define HS_RAS_RETRY_COUNT			2
#define HS_RAS_RETRY_TIMER			1000/* milli second */
#define HS_BANDWIDTH_DEFAULT		640

#define HS_COUNTRYCODE_KOREA		97
#define HS_MANUFACTURECODE_DEFAULT	1120
#define HS_TTL_DEFAULT				600
#define HS_TTL_EXTRA_TIME			3

#define HS_CALL_LISTEN_DEFAULT		1720
#define HS_RAS_LISTEN_DEFAULT		1719

/*************************************************/
/* UI Definition : IP Port Range {
*/
#define HS_H245_LISTEN_PORT_RANGE_MIN	10000
#define HS_H245_LISTEN_PORT_RANGE_MAX	19999
#define HS_RTP_LISTEN_PORT_RANGE_MIN	20000
#define HS_RTP_LISTEN_PORT_RANGE_MAX	29999
/* UI Definition : IP Port Range } */
/***********************************/

#define HS_DEFAULT_LOGICAL_CHANNEL_NUMBER		100
#define HS_INVALID_LOGICAL_CHANNEL_NUMBER		0
#define HS_INVALID_RAS_SEQUENCE_NUMBER			0
#define HS_MASTER_SLAVE_MAX_VALUE				16777216


#define gPID_H225_V2		0x00,0x08,0x91,0x4a,0x00,0x02
#define gSize_PID_H225_V2	6
#define gPID_H245_V7		0x00,0x08,0x81,0x75,0x00,0x07
#define gSize_PID_H245_V7	6


/*exceptions*/
typedef enum
{
	e_exceptionMin,
	e_exception_h245close,
	e_exception_disengage,
	e_exception_q931close,
	e_exception_q931closed,
	e_exceptionMax
} HSException;


/* OS Dependancy
*/
typedef struct
{
	HS_QID		h323DemonQ;
	HS_QID		enetDemonQ;

	/*	IEndpoint, NoLockList(callList), NoLockList(rasWaitList) 's pointer
		using JUST show the state, READ ONLY on #HapiStateXXXXX# functions.
		NEVER handle the memory space! (alloc, free, ..)
	*/
	void			*endpoint;
	void			*calls;
	void			*waits;
} StackInfo;

HS_RESULT new_StackInfo( StackInfo *pObj );
HS_RESULT delete_StackInfo( StackInfo *pObj );
StackInfo *StackInfo_Clone( StackInfo *pObj );

/* Use Winodws Rtp Program
*/
#define HS_EXTERNAL_MEDIA_PROGRAM




/* Timer Id
*/
#define HS_TID_BASE					1000
#define HS_TID_RAS_TRANSACTION		HS_TID_BASE+1
#define HS_TID_REGISTER				HS_TID_BASE+2
#define HS_TID_IRR					HS_TID_BASE+3


/* Result */
#define HS_OK_SAVE_IN_OLC			HS_OK+1
#define HS_OK_SAVE_IN_TCS			HS_OK+2

#define HS_ERR_H323					HS_ERR_ASN+900
#define HS_ERR_H323_MAKE_HANDLE		HS_ERR_H323+1
#define HS_ERR_H323_MALLOC			HS_ERR_H323+2
#define HS_ERR_H323_SOCKET			HS_ERR_H323+3
#define HS_ERR_H323_WINSOCK_START	HS_ERR_H323+4
#define HS_ERR_H323_H323DEMON		HS_ERR_H323+5
#define HS_ERR_H323_ENETDEMON		HS_ERR_H323+6
#define HS_ERR_H323_INVALID_HANDLE	HS_ERR_H323+7
#define HS_ERR_H323_INVALID_VALUE	HS_ERR_H323+8
#define HS_ERR_H323_NOT_STARTED		HS_ERR_H323+9
#define HS_ERR_H323_MAKE_MESSAGE	HS_ERR_H323+10
#define HS_ERR_H323_MAKE_QMESSAGE	HS_ERR_H323+11
#define HS_ERR_H323_LIST_ADD		HS_ERR_H323+12
#define HS_ERR_H323_NOTFOUND		HS_ERR_H323+13
#define HS_ERR_H323_NOUNIT			HS_ERR_H323+14
#define HS_ERR_H323_CONFLICT		HS_ERR_H323+15



#endif/*__2005_03_13__09_49__EPDEFINE_H__*/


