/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<H323DemonHandler.h>	2005-03-27,10:37

*/

#ifndef __2005_03_27__10_37__H323DEMONHANDLER_H__
#define __2005_03_27__10_37__H323DEMONHANDLER_H__



#include "H323Define.h"
#include "EpDefine.h"
#include "MessageHandler.h"
#include "TimerHandler.h"



/****************************************************************************************/
/*
	User Command Messages : Event Handler {
*/
HS_RESULT H323DemonEventMakeCall		(long pParam, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits);
HS_RESULT H323DemonEventChangeGk		(long pParam, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pWaits);
HS_RESULT H323DemonEventAcceptCall		(long pParam, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits);
HS_RESULT H323DemonEventRemoveCall		(long pParam, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits);
HS_RESULT H323DemonEventChangeBandwidth	(long pParam, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits);
HS_RESULT H323DemonEventH245UserInputIndication(long pParam, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits);
HS_RESULT H323DemonEventChangeAliases	(long pParam, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits);
/*
	User Command Messages : Event Handler }
*/
/****************************************************************************************/



/* timer timeout message
*/
HS_RESULT H323DemonEventTimer				(long pParam, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits);

/* network TCP session event
*/
HS_RESULT H323DemonEventQ931Connected		(long pParam, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits);
HS_RESULT H323DemonEventH245Connected		(long pParam, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits);
HS_RESULT H323DemonEventQ931Accepted		(long pParam, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls);
HS_RESULT H323DemonEventH245Accepted		(long pParam, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits);
HS_RESULT H323DemonEventQ931Close			(long pParam, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits);
HS_RESULT H323DemonEventH245Close			(long pParam, NoLockList *pCalls);

/* H.323 message event
*/
HS_RESULT H323DemonEventReceiveRasMessage	(long pParam, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits);
HS_RESULT H323DemonEventReceiveQ931Message	(long pParam, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits);
HS_RESULT H323DemonEventReceiveH245Message	(long pParam, StackInfo *pStack, IEndpoint *pEndpoint, NoLockList *pCalls, NoLockList *pWaits);



#endif/*__2005_03_27__10_37__H323DEMONHANDLER_H__*/


