/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<H323Utility.h>		2005-03-13,11:24

*/

#ifndef __2005_03_13__11_24__H323UTILITY_H__
#define __2005_03_13__11_24__H323UTILITY_H__



#include "H323Define.h"
#include "EpDefine.h"
#include "guid.h"

#include "Q931Message.h"



typedef enum
{
	e_CallCloseReason_Undefined,
	e_CallCloseReason_UnknownDestination,
	e_CallCloseReason_Admission,
	e_CallCloseReason_Connection,
	e_CallCloseReason_H245Session,
	e_CallCloseReason_MasterSlaveConflict,
	e_CallCloseReason_ForceDrop,/* call is dropped by DRQ from GK */
	e_CallCloseReason_Normal
	,
	e_CallCloseReason_Busy,
	e_CallCloseReason_NoAnswer,
	e_CallCloseReason_InvalidNumber,
	e_CallCloseReasonMax
} CallCloseReason;



#define AliasAddresses			NoLockList
#define TransportAddresses		NoLockList



/***********************************************************************/
/* Copy / Clone / Convert Functions
    #copy : just copy data.
	#clone : copy with new memory allocation.
*/
HS_RESULT ASNH225AliasAddress_Copy(ASNH225AliasAddress *pTo, ASNH225AliasAddress *pFrom);
HS_RESULT ASNH225AliasAddresses_Copy(NoLockList *pTo, NoLockList *pFrom);
HS_RESULT AliasAddresses2AsnSequenceOf(AsnSequenceOf *pTo, NoLockList *pList);
HS_RESULT AsnSequenceOf2AliasAddresses(NoLockList *pList, AsnSequenceOf *pFrom);

HS_RESULT ASNH225TransportAddress_Copy(ASNH225TransportAddress *pTo, ASNH225TransportAddress *pFrom);
HS_RESULT ASNH225TransportAddress_CopyWithPort(ASNH225TransportAddress *pTo, ASNH225TransportAddress *pFrom, HS_USHORT pPort);
HS_RESULT ASNH245TransportAddress_Copy(ASNH245TransportAddress *pTo, ASNH245TransportAddress *pFrom);
HS_RESULT ASNH245TransportAddress_CopyWithPort(ASNH245TransportAddress *pTo, ASNH245TransportAddress *pFrom, HS_USHORT pPort);
HS_RESULT TransportAddresses2AsnSequenceOf(AsnSequenceOf *pTo, NoLockList *pList );

HS_RESULT ASNH225TransportAddress2ASNH245TransportAddress(ASNH245TransportAddress *pTo, ASNH225TransportAddress *pFrom);
HS_RESULT ASNH225TransportAddress2ASNH245TransportAddress_WithPort(ASNH245TransportAddress *pTo, ASNH225TransportAddress *pFrom, HS_USHORT pPort);
HS_RESULT ASNH245TransportAddress2ASNH225TransportAddress(ASNH225TransportAddress *pTo, ASNH245TransportAddress *pFrom);
HS_RESULT Tsap2ASNH225TransportAddress(ASNH225TransportAddress *pTo, HS_UCHAR *pIp, HS_USHORT pPort);
HS_RESULT ASNH225TransportAddress2Tsap(HS_UCHAR *pIp, HS_USHORT *pPort, ASNH225TransportAddress *pFrom);
HS_RESULT ASNH245TransportAddress2SockAddrIn(struct sockaddr_in *pTo, ASNH245TransportAddress *pFrom);

HS_RESULT String2SockAddrEx( struct sockaddr_in *pTo, char *pFrom );
HS_RESULT ASNH225GatekeeperIdentifier_Copy( ASNH225GatekeeperIdentifier *pTo, ASNH225GatekeeperIdentifier *pFrom );
HS_RESULT ASNH225EndpointIdentifier_Copy( ASNH225EndpointIdentifier *pTo, ASNH225EndpointIdentifier *pFrom );
HS_RESULT ASNH225H323_UU_PDU_Copy( ASNH225H323_UU_PDU *pTo, ASNH225H323_UU_PDU *pFrom );

HS_RESULT ASNH245Capability_Copy( ASNH245Capability *pTo, ASNH245Capability *pFrom );
HS_RESULT ASNH245VideoCapability_Copy( ASNH245VideoCapability *pTo, ASNH245VideoCapability *pFrom );
HS_RESULT ASNH245AudioCapability_Copy( ASNH245AudioCapability *pTo, ASNH245AudioCapability *pFrom );



/***********************************************************************/
/* Check Functions
*/
/*check that this string is e164 format or not*/
BOOL IsE164( char *pE164 );
/*check that this string is ip address format or not*/
BOOL IsIp(char *pIp);
/*check that this address is valid or not*/
BOOL IsASNH245TransportAddress( ASNH245TransportAddress *pAddr );



/************************************************************************/
/* Get Functions
*/
HS_RESULT GetTsapPortFromOpenLogicalChannelAck(ASNH245OpenLogicalChannelAck *pOlcAck, HS_UINT *pMediaPort, HS_UINT *pMediaControlPort);
HS_RESULT GetSockAddrInFromOpenLogicalChannelAck(
	ASNH245OpenLogicalChannelAck *pOlcAck,
	struct sockaddr_in *pMediaIn,
	struct sockaddr_in *pMediaControlIn
);



#endif/*__2005_03_13__11_24__H323UTILITY_H__*/


