/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<IEndpoint.c>	2005-03-13,15:02

*/

#include "IEndpoint.h"



/***************************************************************/
/* IEndpoint member
*/
/* new_IEndpoint */
HS_RESULT new_IEndpoint( IEndpoint *pObj )
{
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;

	new_IGatekeeper( &(pObj->gatekeeper) );
	pObj->type = e_EndpointType_terminal;
	
	new_ASNH225TransportAddress( &(pObj->csaTsap) );
	ASNH225TransportAddress_MakeMold( &(pObj->csaTsap) );
	new_ASNH225TransportAddress( &(pObj->rasTsap) );
	ASNH225TransportAddress_MakeMold( &(pObj->rasTsap) );
	pObj->callListenPort = HS_CALL_LISTEN_DEFAULT;
	pObj->rasListenPort = HS_RAS_LISTEN_DEFAULT;

	new_NoLockList( &(pObj->aliases), delete_ASNH225AliasAddress );

	pObj->countryCode = HS_COUNTRYCODE_KOREA;
	pObj->extensionCode = 0;
	pObj->manufactureCode = HS_MANUFACTURECODE_DEFAULT;
	memset(pObj->productId,0,HS_MAX_LETTER);
	memset(pObj->versionId,0,HS_MAX_LETTER);

	pObj->rasSN = 1;
	pObj->h245ListenPort = HS_H245_LISTEN_PORT_RANGE_MIN;
	pObj->rtpListenPort = HS_RTP_LISTEN_PORT_RANGE_MIN;

	pObj->CallbackStackError = HS_NULL;
	pObj->CallbackReceiveRasRawData = HS_NULL;
	pObj->CallbackReceiveRasMessage = HS_NULL;
	pObj->CallbackReceiveQ931RawData = HS_NULL;
	pObj->CallbackReceiveQ931Message = HS_NULL;
	pObj->CallbackReceiveH245RawData = HS_NULL;
	pObj->CallbackReceiveH245Message = HS_NULL;
	pObj->CallbackSendRasMessage = HS_NULL;
	pObj->CallbackSendRasRawData = HS_NULL;
	pObj->CallbackSendQ931Message = HS_NULL;
	pObj->CallbackSendQ931RawData = HS_NULL;
	pObj->CallbackSendH245Message = HS_NULL;
	pObj->CallbackSendH245RawData = HS_NULL;

	pObj->CallbackAsnDecodingError = HS_NULL;

	pObj->CallbackRasMessageTimeout = HS_NULL;
	pObj->CallbackRegistrationTimeout = HS_NULL;

	pObj->CallbackCheckFastStart = HS_NULL;
	pObj->CallbackCheckTerminalCapabilitySet = HS_NULL;
	pObj->CallbackOpenReceiveMedia = HS_NULL;
	pObj->CallbackOpenSendMedia = HS_NULL;
	pObj->CallbackCloseReceiveMedia = HS_NULL;
	pObj->CallbackCloseSendMedia = HS_NULL;

	pObj->CallbackCallIncoming = HS_NULL;
	pObj->CallbackCallRemoved = HS_NULL;

	return HS_OK;
}


/* newm_IEndpoint */
IEndpoint *newm_IEndpoint()
{
	IEndpoint *tResult = NULL;

	if( (tResult=(IEndpoint*)HSMalloc(sizeof(IEndpoint)))==NULL )
		return NULL;
	if( new_IEndpoint(tResult)!=HS_OK )
	{
		HSFree(tResult);
		return NULL;
	}

	return tResult;
}


/* delete_IEndpoint */
HS_RESULT delete_IEndpoint( IEndpoint *pObj )
{
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;

	delete_IGatekeeper( &(pObj->gatekeeper) );
	
	delete_ASNH225TransportAddress( &(pObj->csaTsap) );
	delete_ASNH225TransportAddress( &(pObj->rasTsap) );

	delete_NoLockList( &(pObj->aliases) );

	return HS_OK;
}


/* IEndpoint_MakeRasRequestSequenceNumber */
HS_USHORT IEndpoint_MakeRasRequestSequenceNumber( IEndpoint *pObj )
{
	if( pObj == HS_NULL ) return HS_INVALID_RAS_SEQUENCE_NUMBER;

	pObj->rasSN++;
	if( pObj->rasSN == HS_INVALID_RAS_SEQUENCE_NUMBER ) pObj->rasSN = 1;

	return pObj->rasSN;
}


/* IEndpoint_MakeIdentifierOfCall */
HS_RESULT IEndpoint_MakeIdentifierOfCall( IEndpoint *pObj, HS_UCHAR *pCallId, HS_UCHAR *pConfId )
{
	HS_RESULT tRet = HS_OK;

	if( pObj == HS_NULL || pCallId == HS_NULL || pConfId == HS_NULL )
		return HS_ERR_NULL_PARAM;

	if( (tRet=GetGloballyUniqueID(pCallId)) != HS_OK ) return tRet;
	if( (tRet=GetGloballyUniqueID(pConfId)) != HS_OK ) return tRet;

	return HS_OK;
}


/* IEndpoint_MakeH245ListenTsap */
HS_UINT IEndpoint_MakeH245ListenPort( IEndpoint *pObj )
{
	if( pObj == HS_NULL ) return HS_INVALID_PORT;

	pObj->h245ListenPort++;
	if( pObj->h245ListenPort > HS_H245_LISTEN_PORT_RANGE_MAX )
		pObj->h245ListenPort = HS_H245_LISTEN_PORT_RANGE_MIN;

	return pObj->h245ListenPort;
}


/* IEndpoint_MakeRTPListenPort */
HS_UINT IEndpoint_MakeRTPListenPort( IEndpoint *pObj )
{
	if( pObj == HS_NULL ) return HS_INVALID_PORT;

	pObj->rtpListenPort += 6;	/* audio,video,data * rtp,rtcp = 6 */
	if( pObj->rtpListenPort > HS_RTP_LISTEN_PORT_RANGE_MAX-6 )
		pObj->rtpListenPort = HS_RTP_LISTEN_PORT_RANGE_MIN;

	return pObj->rtpListenPort;
}


