/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<QMessage.c>	2005-03-20,11:47

*/

#include "QMessage.h"



QMRemoveCall *new_QMRemoveCall(CallCloseReason pReason, HS_CALL_HANDLE pHandle )
{
	QMRemoveCall *result = (QMRemoveCall*)HSMalloc( sizeof(QMRemoveCall) );
	if( result != HS_NULL )
	{
		result->reason = pReason;
		result->handle = pHandle;
	}
	return result;
}
void delete_QMRemoveCall( QMRemoveCall *pObj )
{
	if( pObj != HS_NULL ) HSFree(pObj);
}



QMBandwidth *new_QMBandwidth( HS_UINT pBandwidth, HS_CALL_HANDLE pHandle )
{
	QMBandwidth *result = HS_NULL;

	if( (result=(QMBandwidth*)HSMalloc(sizeof(QMBandwidth))) == HS_NULL ) return HS_NULL;

	result->bandwidth = pBandwidth;
	result->handle = pHandle;
	return result;
}
void delete_QMBandwidth( QMBandwidth *pObj )
{
	if( pObj != HS_NULL ) HSFree(pObj);
}



QMH245UserInputIndication *new_QMH245UserInputIndication(ControlMsg *pMsg, HS_CALL_HANDLE pHandle)
{
	QMH245UserInputIndication *result = HS_NULL;

	if( pMsg == HS_NULL ) return HS_NULL;
	if( (result=(QMH245UserInputIndication*)HSMalloc(sizeof(QMH245UserInputIndication))) == HS_NULL ) return HS_NULL;

	result->msg = pMsg;
	result->handle = pHandle;
	return result;
}
void delete_QMH245UserInputIndication( QMH245UserInputIndication* pObj )
{
	if( pObj == HS_NULL ) return;
	if( pObj->msg != HS_NULL )
	{
		delete_ControlMsg(pObj->msg);
		HSFree(pObj->msg);
	}
	
	HSFree(pObj);
}



QMRasMessage *new_QMRasMessage( HS_UCHAR *pRaw, int pLen )
{
	QMRasMessage *result;

	if(pRaw==HS_NULL || pLen==0) return HS_NULL;

	result = (QMRasMessage*)HSMalloc( sizeof(QMRasMessage) );
	if( result != HS_NULL )
	{
		if( (result->raw=(HS_UCHAR*)HSMalloc(pLen)) != HS_NULL )
		{
			result->len = pLen;
			memcpy(result->raw,pRaw,pLen);
		}
		else
		{
			HSFree(result);
			result = HS_NULL;
		}
	}
	return result;
}
void delete_QMRasMessage( QMRasMessage *pObj )
{
	if( pObj != HS_NULL )
	{
		if( pObj->raw != HS_NULL ) HSFree( pObj->raw );
		HSFree( pObj );
	}
}



QMTcpMessage *new_QMTcpMessage( HS_UCHAR *pRaw, int pLen, HS_CALL_HANDLE pHandle )
{
	QMTcpMessage *result = (QMTcpMessage*)HSMalloc( sizeof(QMTcpMessage) );
	if( result != HS_NULL )
	{
		result->raw = pRaw;
		result->len = pLen;
		result->handle = pHandle;
	}
	return result;
}
void delete_QMTcpMessage( QMTcpMessage *pObj )
{
	if(pObj != HS_NULL)
	{
		if(pObj->raw != HS_NULL) HSFree( pObj->raw );
		HSFree(pObj);
	}
}



QMAccepted *new_QMAccepted( HS_SOCKET pSocket, HS_CALL_HANDLE pHandle )
{
	QMAccepted *result = (QMAccepted*)HSMalloc( sizeof(QMAccepted) );
	if( result != HS_NULL )
	{
		result->socket = pSocket;
		result->handle = pHandle;
	}
	return result;
}
void delete_QMAccepted( QMAccepted *pObj )
{
	if(pObj!=HS_NULL) HSFree(pObj);
}
HS_RESULT SockAddr2QMAccepted( QMAccepted *pTo, struct sockaddr_in *pFrom )
{
	HS_UCHAR *tIp = HS_NULL;

	if( pTo == HS_NULL || pFrom == HS_NULL ) return HS_ERR_NULL_PARAM;

	tIp = (HS_UCHAR*)(&(pFrom->sin_addr.s_addr));
	pTo->ip[0] = tIp[0];
	pTo->ip[1] = tIp[1];
	pTo->ip[2] = tIp[2];
	pTo->ip[3] = tIp[3];
	pTo->port = pFrom->sin_port;
	return HS_OK;
}
