/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/
/*

	<SocketSet.c>	2005-03-13,14:56

*/

#include "SocketSet.h"



/*************************************************************/
/* TpktBuffer members
*/
/* new_TpktBuffer */
HS_RESULT new_TpktBuffer( TpktBuffer *pObj )
{
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;

	pObj->buffer = HS_NULL;
	pObj->maxLen = 0;
	pObj->nowLen = 0;

	return HS_OK;
}


/* delete_TpktBuffer */
HS_RESULT delete_TpktBuffer( TpktBuffer *pObj )
{
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->buffer != HS_NULL )
	{
		HSFree(pObj->buffer);
		pObj->buffer = HS_NULL;
	}

	pObj->maxLen = 0;
	pObj->nowLen = 0;

	return HS_OK;
}


/* TpktBuffer_Check */
HS_UCHAR *TpktBuffer_Check( TpktBuffer *pObj, HS_UCHAR *pBuffer, int pLen, HS_UINT *pPos, int *pSize )
{
	HS_UINT tPos = 0;
	HS_USHORT tpktLen = 0;
	HS_UCHAR *result = HS_NULL;

	int tLen;
	HS_UCHAR *tBuffer = HS_NULL;

	if( pObj == HS_NULL ) return HS_NULL;
	if( *pPos >= (HS_UINT)pLen ) return HS_NULL;

	tLen	= pLen - *pPos;
	tBuffer = pBuffer + *pPos;

	/* Start TPKT packet count : there is TPKT header */
	if( pObj->maxLen == 0 )
	{
		while( 1 )	/* Get TPKT Header */
		{
			if( tLen < HS_TPKT_HEADER_SIZE ) return HS_NULL;	/* tpkt header size error */
			if( tBuffer[0] != 0x03 || tBuffer[1] != 0x00 ) return HS_NULL;	/* tpkt header format error */
			Uchar2Ushort( &tpktLen, tBuffer+2 );

			tPos += HS_TPKT_HEADER_SIZE;
			tLen -= HS_TPKT_HEADER_SIZE;
			tBuffer += HS_TPKT_HEADER_SIZE;

			if( tpktLen < HS_TPKT_HEADER_SIZE ) return HS_NULL;	/* tpkt length error */
			else if( tpktLen > HS_TPKT_HEADER_SIZE ) break;
		}

		tpktLen -= HS_TPKT_HEADER_SIZE;
		if( tLen >= tpktLen )/* n TPKT per 1 Packet */
		{
			result = (HS_UCHAR*)HSMalloc(tpktLen);
			if(result==HS_NULL) return HS_NULL;

			tPos += tpktLen;
			memcpy(result,tBuffer,tpktLen);
			*pSize = tpktLen;
			*pPos += tPos;
			return result;
		}
		else/* Short Frame */
		{
			pObj->buffer = (HS_UCHAR*)HSMalloc(tpktLen);
			if( pObj->buffer != HS_NULL )
			{
				pObj->maxLen = tpktLen;
				pObj->nowLen = tLen;
				memcpy(pObj->buffer,tBuffer,tLen);
			}
			return HS_NULL;
		}
	}

	/* Read Tpkt Payload : There is no Tpkt Header */
	else
	{
		if( tLen >= (int)(pObj->maxLen - pObj->nowLen) )/* n TPKT per 1 Packet */
		{
			tPos += (pObj->maxLen - pObj->nowLen);
			memcpy(pObj->buffer,tBuffer,(pObj->maxLen - pObj->nowLen));
			*pSize = pObj->maxLen;
			*pPos += tPos;

			result = pObj->buffer;
			pObj->buffer = HS_NULL;
			pObj->maxLen = 0;
			pObj->nowLen = 0;
			return result;
		}
		else/* Short Frame */
		{
			memcpy(pObj->buffer + pObj->nowLen, tBuffer, tLen);
			pObj->nowLen += tLen;
			return HS_NULL;
		}
	}

	return HS_NULL;
}



/*************************************************************/
/* H323SocketSet members
*/
/* new_H323SocketSet */
HS_RESULT new_H323SocketSet( H323SocketSet *pObj, HS_CALL_HANDLE pHandle )
{
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;

	pObj->q931 = HS_INVALID_SOCKET;
	pObj->h245 = HS_INVALID_SOCKET;
	pObj->h245Listen = HS_INVALID_SOCKET;
	pObj->handle = pHandle;

	new_TpktBuffer( &(pObj->q931Buffer) );
	new_TpktBuffer( &(pObj->h245Buffer) );

	return HS_OK;
}


/* delete_H323SocketSet */
HS_RESULT delete_H323SocketSet( H323SocketSet *pObj )
{
	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->q931 != HS_INVALID_SOCKET )
	{
		closesocket(pObj->q931);
		pObj->q931 = HS_INVALID_SOCKET;
	}

	if( pObj->h245 != HS_INVALID_SOCKET ) closesocket(pObj->h245);
	{
		closesocket(pObj->h245);
		pObj->h245 = HS_INVALID_SOCKET;
	}

	if( pObj->h245Listen != HS_INVALID_SOCKET ) closesocket(pObj->h245Listen);
	{
		closesocket(pObj->h245Listen);
		pObj->h245Listen = HS_INVALID_SOCKET;
	}

	delete_TpktBuffer( &(pObj->q931Buffer) );
	delete_TpktBuffer( &(pObj->h245Buffer) );

	return HS_OK;
}


/* H323SocketSet_FdSet */
HS_RESULT H323SocketSet_FdSet( H323SocketSet *pObj, fd_set *pSet, unsigned int *pMax )
{
	unsigned int tMax;

	if( pObj == HS_NULL || pSet == HS_NULL || pMax == HS_NULL ) return HS_ERR_NULL_PARAM;

	tMax = *pMax;

	if( pObj->q931 != HS_INVALID_SOCKET )
	{
		FD_SET(pObj->q931,pSet);
		if( pObj->q931 > tMax ) tMax = pObj->q931;
	}
	if( pObj->h245 != HS_INVALID_SOCKET )
	{
		FD_SET(pObj->h245,pSet);
		if( pObj->h245 > tMax ) tMax = pObj->h245;
	}
	else if( pObj->h245Listen != HS_INVALID_SOCKET )
	{
		FD_SET(pObj->h245Listen,pSet);
		if( pObj->h245Listen > tMax ) tMax = pObj->h245Listen;
	}
	
	*pMax = tMax;
	return HS_OK;
}


/* H323SocketSet_FdIsSet */
HS_RESULT H323SocketSet_FdIsSet( H323SocketSet *pObj, fd_set *pSet, HS_QID pDestQ, unsigned char *pBuffer, int pLen )
{
	int rLen;

	if( pObj == HS_NULL || pSet == HS_NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->q931 != HS_INVALID_SOCKET )
	{
		if( FD_ISSET(pObj->q931,pSet) )
		{
			if( (rLen = recv(pObj->q931, pBuffer, pLen, 0)) < 1 )
			{
#ifdef HS_SOCKET_DEBUG
				HSPrint( "\n q931 socket Closed" );
#endif
				closesocket(pObj->q931);
				pObj->q931 = HS_INVALID_SOCKET;
				_HSThreadSendMessage( pDestQ, HS_QMESSAGE_Q931_CLOSE, 0, pObj->handle );
			}
			else
			{
				int tpktLen;
				HS_UINT tPos = 0;
				HS_UCHAR *tpktBuffer;
				QMTcpMessage *tQ931Message;

#ifdef HS_SOCKET_DEBUG
				HSPrint( "\n q931 packet received (%d)", rLen );
#endif
				tpktBuffer = TpktBuffer_Check( &(pObj->q931Buffer), pBuffer, rLen, &tPos, &tpktLen );
				while( tpktBuffer != HS_NULL )
				{
					tQ931Message = new_QMTcpMessage( tpktBuffer, tpktLen, pObj->handle );
					if( tQ931Message != HS_NULL )
						_HSThreadSendMessage( pDestQ, HS_QMESSAGE_Q931_MESSAGE, 0, (LPARAM)tQ931Message );
					else
						HSFree(tpktBuffer);

					tpktBuffer = TpktBuffer_Check( &(pObj->q931Buffer), pBuffer, rLen, &tPos, &tpktLen );
				}
			}
		}
	}
	if( pObj->h245 != HS_INVALID_SOCKET )
	{
		if( FD_ISSET(pObj->h245,pSet) )
		{
			if( (rLen = recv(pObj->h245, pBuffer, pLen, 0)) < 1 )
			{
#ifdef HS_SOCKET_DEBUG
				HSPrint( "\n h245 socket Closed" );
#endif
				closesocket(pObj->h245);
				pObj->h245 = HS_INVALID_SOCKET;
				_HSThreadSendMessage( pDestQ, HS_QMESSAGE_H245_CLOSE, 0, pObj->handle );
			}
			else
			{
				int tpktLen;
				HS_UINT tPos = 0;
				HS_UCHAR *tpktBuffer;
				QMTcpMessage *tH245Message;
	
#ifdef HS_SOCKET_DEBUG
				HSPrint( "\n H245 packet received (%d)", rLen );
#endif
				tpktBuffer = TpktBuffer_Check( &(pObj->h245Buffer), pBuffer, rLen, &tPos, &tpktLen );
				while( tpktBuffer != HS_NULL )
				{
					tH245Message = new_QMTcpMessage( tpktBuffer, tpktLen, pObj->handle );
					if( tH245Message != HS_NULL )
						_HSThreadSendMessage( pDestQ, HS_QMESSAGE_H245_MESSAGE, 0, (LPARAM)tH245Message );
					else
						HSFree(tpktBuffer);

					tpktBuffer = TpktBuffer_Check( &(pObj->h245Buffer), pBuffer, rLen, &tPos, &tpktLen );
				}
			}
		}
	}
	else if( pObj->h245Listen != HS_INVALID_SOCKET )
	{
		if( FD_ISSET(pObj->h245Listen,pSet) )
		{
			int sockLen;
			struct sockaddr_in	tSockAddr;

			pObj->h245 = -1;
			sockLen = sizeof(tSockAddr);

			pObj->h245 = accept( pObj->h245Listen, (struct sockaddr *)(&tSockAddr), &(sockLen) );

			if( pObj->h245 < 0 )
				pObj->h245 = accept( pObj->h245Listen, (struct sockaddr *)(&tSockAddr), &(sockLen) );

			if( pObj->h245 < 0 )
			{
				pObj->h245 = HS_INVALID_SOCKET;
#ifdef HS_SOCKET_DEBUG
				HSPrint( "\n Error on h245 accept" );
#endif
			}
			else
			{
#ifdef HS_SOCKET_DEBUG
				HSPrint( "\n h245 accepted from %x:%u", tSockAddr.sin_addr.s_addr, tSockAddr.sin_port );
#endif
				closesocket(pObj->h245Listen);
				pObj->h245Listen = HS_INVALID_SOCKET;
			}

			if( pObj->h245 != HS_INVALID_SOCKET )
			{
				QMAccepted *tH245Accepted = new_QMAccepted( pObj->h245, pObj->handle );
				if( tH245Accepted != HS_NULL )
				{
					SockAddr2QMAccepted( tH245Accepted, &(tSockAddr) );
					_HSThreadSendMessage( pDestQ, HS_QMESSAGE_H245_ACCEPTED, 0, (LPARAM)tH245Accepted );
				}
			}
		}
	}

	return HS_OK;
}



/******************************************************************/
/* NoLockList member
*/
/* NoLockList_FindH323SocketSetByCallId */
ChainUnit *NoLockList_FindH323SocketSetByHandle( NoLockList *pObj, HS_CALL_HANDLE pHandle )
{
	HS_UINT i;
	ChainUnit *rounder = HS_NULL;
	H323SocketSet *tSocketSet = HS_NULL;

	if( pObj == HS_NULL ) return HS_NULL;
	if( pObj->size == 0 ) return HS_NULL;

	rounder = pObj->units;
	for( i=0; i<pObj->size; i++ )
	{
		if( rounder == HS_NULL ) return HS_NULL;
		if( rounder->data == HS_NULL ) return HS_NULL;

		tSocketSet = (H323SocketSet*)(rounder->data);
		if( tSocketSet->handle == pHandle )
			return rounder;

		rounder = rounder->next;
	}

	return HS_NULL;
}


/* NoLockList_FdSet */
HS_RESULT NoLockList_FdSet( NoLockList *pObj, fd_set *pSet, unsigned int *pMax )
{
	HS_UINT i;
	ChainUnit *rounder = HS_NULL;

	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->size == 0 ) return HS_OK;

	rounder = pObj->units;
	for( i=0; i<pObj->size; i++ )
	{
		if( rounder == HS_NULL ) return HS_ERR_ASN_CONFLICT;
		if( rounder->data == HS_NULL ) return HS_ERR_ASN_CONFLICT;

		H323SocketSet_FdSet( rounder->data, pSet, pMax );
		rounder = rounder->next;
	}

	return HS_OK;
}


/* NoLockList_FdIsSet */
HS_RESULT NoLockList_FdIsSet( NoLockList *pObj, fd_set *pSet, HS_QID pH323DemonMessageQ, unsigned char *pBuffer, int pLen )
{
	HS_UINT i;
	ChainUnit *rounder = HS_NULL;

	if( pObj == HS_NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->size == 0 ) return HS_OK;

	rounder = pObj->units;
	for( i=0; i<pObj->size; i++ )
	{
		if( rounder == HS_NULL ) return HS_ERR_ASN_CONFLICT;
		if( rounder->data == HS_NULL ) return HS_ERR_ASN_CONFLICT;

		H323SocketSet_FdIsSet( rounder->data, pSet, pH323DemonMessageQ, pBuffer, pLen );
		rounder = rounder->next;
	}

	return HS_OK;
}





