/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<RtpDtmf.c>		2006-02-11,21:34

*/

#include <math.h>

#include "RtpDefine.h"
#include "RtpDtmf.h"





HS_RESULT new_RtpDtmf(void *pObject, DtmfSignal pSignal, HS_UINT pBPS, HS_UINT pVolume)
{
	RtpDtmf *pObj = (RtpDtmf*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	pObj->mSignal = pSignal;
	pObj->mPos = 0;
	pObj->mBytesPerSec = pBPS;
	pObj->mVolume = (pVolume>60)? 60:pVolume;

	pObj->mTimeX = 1000;
	pObj->mTimeY = 0;

	switch(pObj->mSignal)
	{
		case e_DtmfSignal_1:
			pObj->mFreqX = HS_DTMF_FREQ_X1;	pObj->mFreqY = HS_DTMF_FREQ_Y1;	break;
		case e_DtmfSignal_2:
			pObj->mFreqX = HS_DTMF_FREQ_X1;	pObj->mFreqY = HS_DTMF_FREQ_Y2;	break;
		case e_DtmfSignal_3:
			pObj->mFreqX = HS_DTMF_FREQ_X1;	pObj->mFreqY = HS_DTMF_FREQ_Y3;	break;
		case e_DtmfSignal_4:
			pObj->mFreqX = HS_DTMF_FREQ_X2;	pObj->mFreqY = HS_DTMF_FREQ_Y1;	break;
		case e_DtmfSignal_5:
			pObj->mFreqX = HS_DTMF_FREQ_X2;	pObj->mFreqY = HS_DTMF_FREQ_Y2;	break;
		case e_DtmfSignal_6:
			pObj->mFreqX = HS_DTMF_FREQ_X2;	pObj->mFreqY = HS_DTMF_FREQ_Y3;	break;
		case e_DtmfSignal_7:
			pObj->mFreqX = HS_DTMF_FREQ_X3;	pObj->mFreqY = HS_DTMF_FREQ_Y1;	break;
		case e_DtmfSignal_8:
			pObj->mFreqX = HS_DTMF_FREQ_X3;	pObj->mFreqY = HS_DTMF_FREQ_Y2;	break;
		case e_DtmfSignal_9:
			pObj->mFreqX = HS_DTMF_FREQ_X3;	pObj->mFreqY = HS_DTMF_FREQ_Y3;	break;
		case e_DtmfSignal_Star:
			pObj->mFreqX = HS_DTMF_FREQ_X4;	pObj->mFreqY = HS_DTMF_FREQ_Y1;	break;
		case e_DtmfSignal_0:
			pObj->mFreqX = HS_DTMF_FREQ_X4;	pObj->mFreqY = HS_DTMF_FREQ_Y2;	break;
		case e_DtmfSignal_Shap:
			pObj->mFreqX = HS_DTMF_FREQ_X4;	pObj->mFreqY = HS_DTMF_FREQ_Y3;	break;
		case e_DtmfSignal_FlashOverride:
			pObj->mFreqX = HS_DTMF_FREQ_X1;	pObj->mFreqY = HS_DTMF_FREQ_Y4;	break;
		case e_DtmfSignal_Flash:
			pObj->mFreqX = HS_DTMF_FREQ_X2;	pObj->mFreqY = HS_DTMF_FREQ_Y4;	break;
		case e_DtmfSignal_Priority:
			pObj->mFreqX = HS_DTMF_FREQ_X3;	pObj->mFreqY = HS_DTMF_FREQ_Y4;	break;
		case e_DtmfSignal_Dial:
			pObj->mFreqX = HS_CPT_DIAL_FREQ_X;
			pObj->mFreqY = HS_CPT_DIAL_FREQ_Y;
			pObj->mTimeX = HS_CPT_DIAL_TIME_X*pObj->mBytesPerSec/500;
			pObj->mTimeY = HS_CPT_DIAL_TIME_Y*pObj->mBytesPerSec/500;
			break;
		case e_DtmfSignal_Ringback:
			pObj->mFreqX = HS_CPT_RINGBACK_FREQ_X;
			pObj->mFreqY = HS_CPT_RINGBACK_FREQ_Y;
			pObj->mTimeX = HS_CPT_RINGBACK_TIME_X*pObj->mBytesPerSec/500;
			pObj->mTimeY = HS_CPT_RINGBACK_TIME_Y*pObj->mBytesPerSec/500;
			break;
		case e_DtmfSignal_Busy:
			pObj->mFreqX = HS_CPT_BUSY_FREQ_X;
			pObj->mFreqY = HS_CPT_BUSY_FREQ_Y;
			pObj->mTimeX = HS_CPT_BUSY_TIME_X*pObj->mBytesPerSec/500;
			pObj->mTimeY = HS_CPT_BUSY_TIME_Y*pObj->mBytesPerSec/500;
			break;
		case e_DtmfSignal_Reorder:
			pObj->mFreqX = HS_CPT_REORDER_FREQ_X;
			pObj->mFreqY = HS_CPT_REORDER_FREQ_Y;
			pObj->mTimeX = HS_CPT_REORDER_TIME_X*pObj->mBytesPerSec/500;
			pObj->mTimeY = HS_CPT_REORDER_TIME_Y*pObj->mBytesPerSec/500;
			break;
		default:
			return HS_ERR_NO_EXIST;
	}

	return HS_OK;
}


HS_RESULT delete_RtpDtmf(void *pObject)
{
	RtpDtmf *pObj = (RtpDtmf*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	return HS_OK;
}


RtpDtmf *newm_RtpDtmf(DtmfSignal pSignal, HS_UINT pBPS, HS_UINT pVolume)
{
	RtpDtmf *tResult = NULL;

	if( (tResult=(RtpDtmf*)HSMalloc(sizeof(RtpDtmf)))==NULL ) return NULL;

	if( new_RtpDtmf(tResult,pSignal,pBPS,pVolume) != HS_OK )
	{
		HSFree(tResult);
		return NULL;
	}

	return tResult;
}


HS_RESULT deletem_RtpDtmf(void *pObject)
{
	RtpDtmf *pObj = (RtpDtmf*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	delete_RtpDtmf(pObj);
	HSFree(pObj);

	return HS_OK;
}


HS_RESULT RtpDtmf_Generate(void *pObject, HS_UCHAR *pData, HS_UINT pSize)
{
	HS_UINT i;
	RtpDtmf *pObj = (RtpDtmf*)pObject;

	if( pObj==NULL || pData==NULL ) return HS_ERR_NULL_PARAM;

	for(i=0;i<pSize;i++)
	{
		pObj->mPos++;
		if( (pObj->mPos % (pObj->mTimeX+pObj->mTimeY)) > pObj->mTimeX )
			pData[i] = 0x00;
		else
			pData[i] = DTMF_SIN(pObj->mPos,pObj->mFreqX,pObj->mFreqY,pObj->mBytesPerSec,pObj->mVolume);
	}

	return HS_OK;
}