/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<RtpRcver.h>	2006-01-11,23:31

*/

#ifndef __2005_01_11__23_31__RTPRCVER_H__
#define __2005_01_11__23_31__RTPRCVER_H__





#include "RtpDefine.h"
#include "RtpSnder.h"





/* put to Speaker-out receive from network
*/
typedef struct
{
	BOOL				mIsActive;

	SOCKET				mSocket;
	HS_USHORT			mLocalPort;
	SOCKET				mSenderSocket;

	HS_QID				mMyQ;
	HS_QID				mSpeakerQ;

	RtpPayloadType		mType;
	HS_UINT				mFpp;
	HS_UINT				mSleep;
	HS_UINT				mSeqNum;
	HS_UINT				mTimeStamp;
	HS_UINT				mSsrc;

	BOOL				mHold;

#ifdef _WIN32_WCE
	void*				m729Handle;
#endif
	void*				mGsm;
	void*				mIlbc;
} RtpRcver;


HS_RESULT new_RtpRcver(void *pObject);
RtpRcver *newm_RtpRcver();
HS_RESULT delete_RtpRcver(void *pObject);
HS_RESULT deletem_RtpRcver(void *pObject);

BOOL RtpRcver_IsActive(void *pObject);

HS_RESULT RtpRcver_OpenCodec(void *pObject);
HS_RESULT RtpRcver_CloseCodec(void *pObject);
HS_UINT RtpRcver_GetFrameSize(void *pObject);
HS_RESULT RtpRcver_CheckRtpHeader(void *pObject,HS_UCHAR *pHeader);
HS_UCHAR *RtpRcver_Decode(void *pObject,HS_UINT *pOut,HS_UCHAR *pIn,HS_UINT pSize);

/* thread
*/
void RtpRcver_Demon(void *pObject);
unsigned __stdcall RtpRcver_Thread(void* pArg);

HS_QID RtpRcver_Start(void *pObject);
HS_RESULT RtpRcver_Stop(void *pObject);

HS_RESULT RtpRcver_Hold(void *pObject);
HS_RESULT RtpRcver_Resume(void *pObject);

HS_RESULT RtpRcver_Check(void *pObject);
HS_RESULT RtpRcver_SendSocket(void *pObject,SOCKET pSocket);





#endif/*__2005_01_11__23_31__RTPRCVER_H__*/
