/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<RtpSpeakerout.h>	2006-01-11,01:27

*/

#ifndef __2006_01_11__01_27__RTPSPEAKEROUT_H__
#define __2006_01_11__01_27__RTPSPEAKEROUT_H__





#include "RtpDefine.h"
#include "RtpMicin.h"
#include "RtpDtmf.h"





typedef struct
{
	HWAVEOUT		mHandle;
	WAVEFORMATEX	mFormat;
	HS_QID			mMyQ;

	BOOL			mStopping;
	BOOL			mDevOpened;
	HS_UINT			mWaveHeaderNumber;

	UcharRing	mRing;
	RtpDtmf		*mCpt;/*call progress tone*/
} RtpSpeakerout;

HS_RESULT new_RtpSpeakerout(void *pObject,int mHertz);
RtpSpeakerout *newm_RtpSpeakerout(int mHertz);
HS_RESULT delete_RtpSpeakerout(void *pObject);
HS_RESULT deletem_RtpSpeakerout(void *pObject);
HS_RESULT RtpSpeakerout_PutPcmToSpeaker(void *pObject,HS_UINT pReadSize);

/* thread
*/
void RtpSpeakerout_Demon(void *pObject);
void RtpSpeakerout_CptDemon(void *pObject);/*call progress tone*/
unsigned __stdcall RtpSpeakerout_Thread(void* pArg);

HS_QID RtpSpeakerout_Start(void *pObject);
HS_RESULT RtpSpeakerout_Stop(void *pObject);

HS_RESULT RtpSpeakerout_Check(void *pObject);

/* Call-Progress-Tone/DTMF-Tone control
*/
HS_RESULT RtpSpeakerout_StartTone(void *pObject,RtpDtmf *pDtmf);
HS_RESULT RtpSpeakerout_StopTone(void *pObject);





#endif/*__2006_01_11__01_27__RTPSPEAKEROUT_H__*/