/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<RtpUI.c>		2006-01-16,21:06

*/

#include "RtpUI.h"





#define RTP_SENDER_PORT_MIN		40000
#define RTP_SENDER_PORT_MAX		50000





typedef struct
{
	HS_USHORT mSenderPort;

	RtpMicin *mMicin;
	RtpSpeakerout *mSpeakerout;
	RtpSnder *mSnder;
	RtpRcver *mRcver;
} IRtp;





HS_RTP_HANDLE OpenRtp()
{
	IRtp *tResult = NULL;

	if( (tResult=(IRtp*)HSMalloc(sizeof(IRtp)))==NULL ) return NULL;

	tResult->mSenderPort = RTP_SENDER_PORT_MIN;
	tResult->mMicin = NULL;
	tResult->mSnder = NULL;
	tResult->mRcver = NULL;
	tResult->mSpeakerout = NULL;
	return tResult;
}


HS_RESULT CloseRtp(HS_RTP_HANDLE pHandle)
{
	IRtp *pObj = (IRtp*)pHandle;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	StopForwardRtp(pHandle);
	StopReverseRtp(pHandle);

	HSFree(pObj);
	return HS_OK;
}


HS_RESULT CheckRtp(HS_RTP_HANDLE pHandle)
{
	IRtp *pObj = (IRtp*)pHandle;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mMicin==NULL )	HSPrint("\nthread check> RtpMicin-null");
	else						RtpMicin_Check(pObj->mMicin);
	if( pObj->mSnder==NULL )	HSPrint("\nthread check> RtpSnder-null");
	else						RtpSnder_Check(pObj->mSnder);
	if( pObj->mRcver==NULL )	HSPrint("\nthread check> RtpRcver-null");
	else						RtpRcver_Check(pObj->mRcver);
	if( pObj->mSpeakerout==NULL )	HSPrint("\nthread check> RtpSpeaker-null");
	else							RtpSpeakerout_Check(pObj->mSpeakerout);

	return HS_OK;
}


static HS_USHORT IRtp_GetNextSenderPort(void *pObject)
{
	IRtp *pObj = (IRtp*)pObject;

	if( pObj==NULL ) return 0;

	pObj->mSenderPort++;

	if( pObj->mSenderPort==RTP_SENDER_PORT_MAX )
		pObj->mSenderPort = RTP_SENDER_PORT_MIN;

	return pObj->mSenderPort;
}


HS_RESULT StartForwardRtp(
	HS_RTP_HANDLE pHandle,
	RtpPayloadType pCodec,
	char *pIp,
	HS_USHORT pPort,
	HS_UINT pFpp
)
{
	struct sockaddr_in tAddrIn;

	if( pIp==NULL ) return HS_ERR_INVALID_PARAM;

	tAddrIn.sin_family = AF_INET;
	tAddrIn.sin_addr.s_addr = inet_addr(pIp);
	tAddrIn.sin_port = htons(pPort);

	return StartForwardRtpEx(pHandle,pCodec,tAddrIn,pFpp);
}


HS_RESULT StartForwardRtpEx(
	HS_RTP_HANDLE pHandle,
	RtpPayloadType pCodec,
	struct sockaddr_in pAddrIn,
	HS_UINT pFpp
)
{
	HS_UINT i;
	RtpSnder *tSnder = NULL;
	RtpMicin *tMicin = NULL;
	struct sockaddr_in tAddrIn;
	IRtp *pObj = (IRtp*)pHandle;

	if( pObj==NULL ) return HS_ERR_INVALID_PARAM;
	if( pObj->mSnder != NULL || pObj->mMicin != NULL ) return HS_ERR;

	if( (tSnder=newm_RtpSnder(8000,pFpp))==NULL ) return HS_ERR_MALLOC;
	if( (tSnder->mSocket=socket(AF_INET,SOCK_DGRAM,IPPROTO_UDP))==INVALID_SOCKET )
	{
		deletem_RtpSnder(tSnder);
		return HS_ERR;
	}

	memset(&tAddrIn,0,sizeof(tAddrIn));
	tAddrIn.sin_family = AF_INET;
	tAddrIn.sin_addr.s_addr = INADDR_ANY;
	tAddrIn.sin_port = htons( IRtp_GetNextSenderPort(pObj) );
	if( bind(tSnder->mSocket,(SOCKADDR*)&tAddrIn,sizeof(tAddrIn)) != 0 )
	{
		deletem_RtpSnder(tSnder);
		return HS_ERR;
	}

	if( (tMicin=newm_RtpMicin(8000))==NULL )
	{
		deletem_RtpSnder(tSnder);
		return HS_ERR;
	}

	if( pObj->mRcver != NULL )
	{
		for(i=0;i<10;i++)
		{
			if( RtpRcver_IsActive(pObj->mRcver)==TRUE )
				break;
			Sleep(100);
		}

		if( i==10 )
		{
			deletem_RtpSnder(tSnder);
			return HS_ERR;
		}

		RtpRcver_SendSocket(pObj->mRcver,tSnder->mSocket);
	}

	tSnder->mType = pCodec;
	tSnder->mRemoteIn = pAddrIn;

	RtpSnder_Start(tSnder);
	tMicin->mIntoQ = tSnder->mMyQ;
	RtpMicin_Start(tMicin);

	pObj->mMicin = tMicin;
	pObj->mSnder = tSnder;
	return HS_OK;
}


HS_RESULT StartReverseRtp(
	HS_RTP_HANDLE pHandle,
	RtpPayloadType pCodec,
	HS_USHORT pPort
)
{
	RtpRcver *tRcver = NULL;
	RtpSpeakerout *tSpeakerout = NULL;
	IRtp *pObj = (IRtp*)pHandle;
	struct sockaddr_in tAddrIn;

	if( pObj==NULL ) return HS_ERR_INVALID_PARAM;
	if( pObj->mRcver != NULL || pObj->mSpeakerout != NULL ) return HS_ERR;

	if( (tRcver=newm_RtpRcver())==NULL ) return HS_ERR_MALLOC;

	if( (tRcver->mSocket=socket(AF_INET,SOCK_DGRAM,IPPROTO_UDP))==INVALID_SOCKET )
	{
		deletem_RtpRcver(tRcver);
		return HS_ERR;
	}

	tAddrIn.sin_family = AF_INET;
	tAddrIn.sin_addr.s_addr = htonl(INADDR_ANY);
	tAddrIn.sin_port = htons(pPort);
	if( bind(tRcver->mSocket,(SOCKADDR*)(&tAddrIn),sizeof(tAddrIn)) != 0 )
	{
		deletem_RtpRcver(tRcver);
		return HS_ERR;
	}

	if( (tSpeakerout=newm_RtpSpeakerout(8000))==NULL )
	{
		deletem_RtpRcver(tRcver);
		return HS_ERR_MALLOC;
	}

	if( pObj->mSnder != NULL )
		tRcver->mSenderSocket = pObj->mSnder->mSocket;
	tRcver->mType = pCodec;

	RtpSpeakerout_Start(tSpeakerout);
	tRcver->mSpeakerQ = tSpeakerout->mMyQ;
	RtpRcver_Start(tRcver);

	pObj->mSpeakerout = tSpeakerout;
	pObj->mRcver = tRcver;
	return HS_OK;
}


HS_RESULT StopForwardRtp(HS_RTP_HANDLE pHandle)
{
	HS_UINT i;
	IRtp *pObj = (IRtp*)pHandle;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mSnder!=NULL )
	{
		if( pObj->mRcver != NULL )
		{
			for(i=0;i<10;i++)
			{
				if( RtpRcver_IsActive(pObj->mRcver)==TRUE )
					break;
				Sleep(100);
			}

			RtpRcver_SendSocket(pObj->mRcver,INVALID_SOCKET);
		}

		RtpMicin_Stop(pObj->mMicin);
		RtpSnder_Stop(pObj->mSnder);
		Sleep(100);
	}

	pObj->mMicin = NULL;
	pObj->mSnder = NULL;
	return HS_OK;
}


HS_RESULT StopReverseRtp(HS_RTP_HANDLE pHandle)
{
	IRtp *pObj = (IRtp*)pHandle;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mRcver!=NULL )
	{
		RtpRcver_Stop(pObj->mRcver);
		RtpSpeakerout_Stop(pObj->mSpeakerout);
		Sleep(100);
	}

	pObj->mRcver = NULL;
	pObj->mSpeakerout = NULL;
	return HS_OK;
}


HS_RESULT HoldForwardRtp(HS_RTP_HANDLE pHandle)
{
	IRtp *pObj = (IRtp*)pHandle;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mSnder==NULL ) return HS_ERR;

	return RtpSnder_Hold(pObj->mSnder);
}


HS_RESULT ResumeForwardRtp(HS_RTP_HANDLE pHandle)
{
	IRtp *pObj = (IRtp*)pHandle;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mSnder==NULL ) return HS_ERR;

	return RtpSnder_Resume(pObj->mSnder);
}


HS_RESULT HoldReverseRtp(HS_RTP_HANDLE pHandle)
{
	IRtp *pObj = (IRtp*)pHandle;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mRcver==NULL ) return HS_ERR;

	return RtpRcver_Hold(pObj->mRcver);
}


HS_RESULT ResumeReverseRtp(HS_RTP_HANDLE pHandle)
{
	IRtp *pObj = (IRtp*)pHandle;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mRcver==NULL ) return HS_ERR;

	return RtpRcver_Resume(pObj->mRcver);
}


HS_RESULT RtpCommandAddDtmfInband(HS_RTP_HANDLE pHandle,char pSignal,HS_UINT pVolume)
{
	IRtp *pObj = (IRtp*)pHandle;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mSnder==NULL ) return HS_ERR;

	if(pSignal=='*') pSignal = 0x0a;
	else if(pSignal=='#') pSignal = 0x0b;
	else if(pSignal>0x2f && pSignal<0x3a) pSignal -= 0x30;
	else return HS_ERR_INVALID_PARAM;

	return RtpSnder_AddDtmfInband(pObj->mSnder,(HS_UCHAR)pSignal,pVolume);
}


HS_RESULT RtpCommandAddDtmfRfc2833(HS_RTP_HANDLE pHandle,char pSignal)
{
	IRtp *pObj = (IRtp*)pHandle;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( pObj->mSnder==NULL ) return HS_ERR;

	if(pSignal=='*') pSignal = 0x0a;
	else if(pSignal=='#') pSignal = 0x0b;
	else if(pSignal>0x2f && pSignal<0x3a) pSignal -= 0x30;
	else return HS_ERR_INVALID_PARAM;

	return RtpSnder_AddDtmfRfc2833(pObj->mSnder,(HS_UCHAR)pSignal);
}





/* Call-Progress-Tone/DTMF-Tone control
*/
tone_handle OpenToneHandle()
{
	RtpSpeakerout *tSpeakerout = NULL;

	if( (tSpeakerout=newm_RtpSpeakerout(8000))==NULL )
		return NULL;

	RtpSpeakerout_Start(tSpeakerout);
	return tSpeakerout;
}


HS_RESULT CloseToneHandle(tone_handle pHandle)
{
	if( pHandle==NULL ) return HS_ERR_NULL_PARAM;

	RtpSpeakerout_Stop(pHandle);
	return HS_OK;
}


HS_RESULT StartCptTone(tone_handle pHandle,DtmfSignal pSignal,HS_UINT pVolume)
{
	RtpDtmf *tDtmf = NULL;

	if( pHandle==NULL ) return HS_ERR_NULL_PARAM;
	if( (tDtmf=newm_RtpDtmf(pSignal,8000,pVolume))==NULL )
		return HS_ERR_MALLOC;

	return RtpSpeakerout_StartTone(pHandle,tDtmf);
}


HS_RESULT StopCptTone(tone_handle pHandle)
{
	if( pHandle==NULL ) return HS_ERR_NULL_PARAM;

	return RtpSpeakerout_StopTone(pHandle);
}