/*

	<HashMac.c>		2005-12-07,23:53

*/

#include <string.h>

#include "HashMac.h"





int Md5Hash(unsigned char *pHash, unsigned char *pData, unsigned int pLen)
{
	MD_CTX tCtx;

	if( pHash==NULL || pData==NULL ) return 2/*null param*/;

	MDInit(&tCtx);
	MDUpdate(&tCtx,pData,pLen);
	MDFinal(pHash,&tCtx);
	return 0;
}


int Sha1Hash(unsigned char *pHash, unsigned char *pData, unsigned int pLen)
{
	int tRet;
	SHA1Context tCtx;

	if( pHash==NULL || pData==NULL ) return 2/*null param*/;

	if( (tRet=SHA1Reset(&tCtx)) != 0 ) return tRet;
	if( (tRet=SHA1Input(&tCtx,pData,pLen)) != 0 ) return tRet;
	if( (tRet=SHA1Result(&tCtx,pHash)) != 0 ) return tRet;
	return 0;
}


/* HMAC (Keyed Hash) implemented by RFC 2104 'HMAC'
   detail step is described on RFC 2104 - Section 2. Definition of HMAC
*/
int Md5Hmac(unsigned char *pMac,
	unsigned char *pKey, unsigned int pKeyLen,
	unsigned char *pData, unsigned int pDataLen
)
{
	unsigned int i;
	unsigned char tHash[16];
	unsigned char _K0[MD5_CBLOCK];
	unsigned char _K0Pad[MD5_CBLOCK];

	MD_CTX tCtx0, tCtx1;


	/* step (1) : make K0 value.
	*/
	memset(_K0,0,MD5_CBLOCK);
	if( MD5_CBLOCK < pKeyLen )
	{
		Md5Hash(tHash,pKey,pKeyLen);
		memcpy(_K0,tHash,16);
	}
	else
	{
		memcpy(_K0,pKey,pKeyLen);
	}
	/* step (2) : K0Pad = K0 xor iPad
	*/
	for(i=0; i<MD5_CBLOCK; i++) _K0Pad[i] = _K0[i] ^ 0x36;
	/* step (3),(4) :
		(3) append data to K0Pad.
		(4) H0 = Hash the '(3)' data.
	*/
	MD5Init(&tCtx0);
	MD5Update(&tCtx0,_K0Pad,MD5_CBLOCK);
	MD5Update(&tCtx0,pData,pDataLen);
	MD5Final(tHash,&tCtx0);
	/* step (5) : K0Pad = K0 xor oPad
	*/
	for(i=0; i<MD5_CBLOCK; i++) _K0Pad[i] = _K0[i] ^ 0x5c;
	/* step (6),(7) :
		(6) append H0 to K0Pad.
		(7) Hash the '(6)' data.
	*/
	MD5Init(&tCtx1);
	MD5Update(&tCtx1,_K0Pad,MD5_CBLOCK);
	MD5Update(&tCtx1,tHash,16);
	MD5Final(pMac,&tCtx1);

	return 0;
}


int Sha1Hmac(unsigned char *pMac,
	unsigned char *pKey, unsigned int pKeyLen,
	unsigned char *pData, unsigned int pDataLen
)
{
	unsigned int i;
	unsigned char tHash[20];
	unsigned char _K0[SHA_CBLOCK];
	unsigned char _K0Pad[SHA_CBLOCK];

	SHA1Context tCtx0, tCtx1;


	/* step (1) : make K0 value.
	*/
	memset(_K0,0,SHA_CBLOCK);
	if( SHA_CBLOCK < pKeyLen )
	{
		Sha1Hash(tHash,pKey,pKeyLen);
		memcpy(_K0,tHash,20);
	}
	else
	{
		memcpy(_K0,pKey,pKeyLen);
	}
	/* step (2) : K0Pad = K0 xor iPad
	*/
	for(i=0; i<SHA_CBLOCK; i++) _K0Pad[i] = _K0[i] ^ 0x36;
	/* step (3),(4) :
		(3) append data to K0Pad.
		(4) H0 = Hash the '(3)' data.
	*/
	SHA1Reset(&tCtx0);
	SHA1Input(&tCtx0,_K0Pad,SHA_CBLOCK);
	SHA1Input(&tCtx0,pData,pDataLen);
	SHA1Result(&tCtx0,tHash);
	/* step (5) : K0Pad = K0 xor oPad
	*/
	for(i=0; i<SHA_CBLOCK; i++) _K0Pad[i] = _K0[i] ^ 0x5c;
	/* step (6),(7) :
		(6) append H0 to K0Pad.
		(7) Hash the '(6)' data.
	*/
	SHA1Reset(&tCtx1);
	SHA1Input(&tCtx1,_K0Pad,SHA_CBLOCK);
	SHA1Input(&tCtx1,tHash,20);
	SHA1Result(&tCtx1,pMac);

	return 0;
}
