/*

	<SipAuth.c>		2005-10-29,12:08

*/

#include <stdio.h>
#include "md5global.h"
#include "md5.h"
#include "string.h"
#include "SipAuth.h"

void CvtHex(
    IN HASH Bin,
    OUT HASHHEX Hex
    )
{
    unsigned short i;
    unsigned char j;

    for (i = 0; i < HASHLEN; i++) {
        j = (Bin[i] >> 4) & 0xf;
        if (j <= 9)
            Hex[i*2] = (j + '0');
         else
            Hex[i*2] = (j + 'a' - 10);
        j = Bin[i] & 0xf;
        if (j <= 9)
            Hex[i*2+1] = (j + '0');
         else
            Hex[i*2+1] = (j + 'a' - 10);
    };
    Hex[HASHHEXLEN] = '\0';
};

/* calculate H(A1) as per spec */
void DigestCalcHA1(
    IN char * pszAlg,
    IN char * pszUserName,
    IN char * pszRealm,
    IN char * pszPassword,
    IN char * pszNonce,
    IN char * pszCNonce,
    OUT HASHHEX SessionKey
    )
{
	MD5_CTX Md5Ctx;
	HASH HA1;

	MD5Init(&Md5Ctx);
	MD5Update(&Md5Ctx, pszUserName, strlen(pszUserName));
	MD5Update(&Md5Ctx, ":", 1);
	MD5Update(&Md5Ctx, pszRealm, strlen(pszRealm));
	MD5Update(&Md5Ctx, ":", 1);
	MD5Update(&Md5Ctx, pszPassword, strlen(pszPassword));
	MD5Final(HA1, &Md5Ctx);
	if( pszAlg != NULL )
	{
#ifdef _WIN32_WCE
		if( !wcsicmp((wchar_t*)pszAlg,(wchar_t*)"md5-sess") )
#else
		if( !stricmp(pszAlg,"md5-sess") )
#endif
		{
			MD5Init(&Md5Ctx);
			MD5Update(&Md5Ctx, HA1, HASHLEN);
			MD5Update(&Md5Ctx, ":", 1);
			MD5Update(&Md5Ctx, pszNonce, strlen(pszNonce));
			MD5Update(&Md5Ctx, ":", 1);
			MD5Update(&Md5Ctx, pszCNonce, strlen(pszCNonce));
			MD5Final(HA1, &Md5Ctx);
		}
	}
	CvtHex(HA1, SessionKey);
};

/* calculate request-digest/response-digest as per HTTP Digest spec */
void DigestCalcResponse(
    IN HASHHEX HA1,           /* H(A1) */
    IN char * pszNonce,       /* nonce from server */
    IN char * pszNonceCount,  /* 8 hex digits */
    IN char * pszCNonce,      /* client nonce */
    IN char * pszQop,         /* qop-value: "", "auth", "auth-int" */
    IN char * pszMethod,      /* method from the request */
    IN char * pszDigestUri,   /* requested URL */
    IN HASHHEX HEntity,       /* H(entity body) if qop="auth-int" */
    OUT HASHHEX Response      /* request-digest or response-digest */
    )
{
	MD5_CTX Md5Ctx;
	HASH HA2;
	HASH RespHash;
	HASHHEX HA2Hex;

	// calculate H(A2)
	MD5Init(&Md5Ctx);
	MD5Update(&Md5Ctx, pszMethod, strlen(pszMethod));
	MD5Update(&Md5Ctx, ":", 1);
	MD5Update(&Md5Ctx, pszDigestUri, strlen(pszDigestUri));
	if( pszQop != NULL )
	{
#ifdef _WIN32_WCE
		if( !wcsicmp((wchar_t*)pszQop,(wchar_t*)"auth-int") )
#else
		if( !stricmp(pszQop,"auth-int") )
#endif
		{
			MD5Update(&Md5Ctx, ":", 1);
			MD5Update(&Md5Ctx, HEntity, HASHHEXLEN);
		}
	}
	MD5Final(HA2, &Md5Ctx);
	CvtHex(HA2, HA2Hex);

	// calculate response
	MD5Init(&Md5Ctx);
	MD5Update(&Md5Ctx, HA1, HASHHEXLEN);
	MD5Update(&Md5Ctx, ":", 1);
	MD5Update(&Md5Ctx, pszNonce, strlen(pszNonce));
	MD5Update(&Md5Ctx, ":", 1);
	if( pszQop != NULL )
	{
		if( pszQop[0] != '\0' )
		{
			MD5Update(&Md5Ctx, pszNonceCount, strlen(pszNonceCount));
			MD5Update(&Md5Ctx, ":", 1);
			MD5Update(&Md5Ctx, pszCNonce, strlen(pszCNonce));
			MD5Update(&Md5Ctx, ":", 1);
			MD5Update(&Md5Ctx, pszQop, strlen(pszQop));
			MD5Update(&Md5Ctx, ":", 1);
		}
	}
	MD5Update(&Md5Ctx, HA2Hex, HASHHEXLEN);
	MD5Final(RespHash, &Md5Ctx);
	CvtHex(RespHash, Response);
};



#if 0
/*
   - RFC 2617 example parameter and result. -

   MD5(A1) = 
	[algorithm == "MD5-sess" case]
		MD5( MD5(username:realm:password):nonce:cnonce );
	[else case]
		MD5( username:realm:password );

   MD5(A2) = 
	[qop == "auth-int" case]
		MD5( method:uri:MD5(entity-body) );
	[else case]
		MD5( method:uri );

   Response = 
	[qop is not present case]
		MD5( MD5(A1):nonce:MD5(A2) );
	[else case]
		MD5( MD5(A1):nonce:nc:cnonce:qop:MD5(A2) );
*/
void main(int argc, char ** argv) {

      char * pszNonce = "dcd98b7102dd2f0e8b11d0f600bfb0c093";
      char * pszCNonce = "0a4f113b";
      char * pszUser = "Mufasa";
      char * pszRealm = "testrealm@host.com";
      char * pszPass = "Circle Of Life";
      char * pszAlg = "md5";
      char szNonceCount[9] = "00000001";
      char * pszMethod = "GET";
      char * pszQop = "auth";
      char * pszURI = "/dir/index.html";
	  char * pszTargetResponse = "6629fae49393a05397450978507c4ef1";
      HASHHEX HA1;
      HASHHEX HA2 = "";
      HASHHEX Response;

      DigestCalcHA1(pszAlg, pszUser, pszRealm, pszPass, pszNonce,pszCNonce, HA1);
      DigestCalcResponse(HA1, pszNonce, szNonceCount, pszCNonce, pszQop,pszMethod, pszURI, HA2, Response);

	  printf("Response Target = %s\n", pszTargetResponse);
      printf("Response Result = %s\n", Response);
	  if( !strcmp(pszTargetResponse,Response) )
		  printf( "Test Success.\n" );
	  else
		  printf( "Test Error.\n" );
};
#endif