/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SipSdp.c>		2005-10-24,21:43

*/

#ifdef _WIN32_WCE
#include <string.h>
#endif

#include "SipSdp.h"





/* SdpAttribute member functions
*/
HS_RESULT new_SdpAttribute(void *pObject)
{
	SdpAttribute *pObj = (SdpAttribute*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	pObj->mAttrName = NULL;
	pObj->mAttrNumber = NULL;
	pObj->mAttrRate = NULL;
	pObj->mAttrValue = NULL;
	return HS_OK;
}


HS_RESULT delete_SdpAttribute(void *pObject)
{
	SdpAttribute *pObj = (SdpAttribute*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mAttrName != NULL )
	{
		HSFree(pObj->mAttrName);
		pObj->mAttrName = NULL;
	}
	if( pObj->mAttrNumber != NULL )
	{
		HSFree(pObj->mAttrNumber);
		pObj->mAttrNumber = NULL;
	}
	if( pObj->mAttrRate != NULL )
	{
		HSFree(pObj->mAttrRate);
		pObj->mAttrRate = NULL;
	}
	if( pObj->mAttrValue != NULL )
	{
		HSFree(pObj->mAttrValue);
		pObj->mAttrValue = NULL;
	}
	return HS_OK;
}


HS_RESULT SdpAttribute_SetAttrNumber(void *pObject, HS_UINT pNumber)
{
	SdpAttribute *pObj = (SdpAttribute*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;


	delete_SdpAttribute(pObj);
	pObj->mAttrName = SipStringAlloc("rtpmap");
	pObj->mAttrNumber = SipUintAlloc(pNumber);

	switch((RtpPayloadType)pNumber)
	{
		/*audio*/
		case e_RtpPayloadType_Pcmu:
			pObj->mAttrValue = SipStringAlloc("PCMU");
			pObj->mAttrRate = SipStringAlloc("8000");
			break;
		case e_RtpPayloadType_Gsm:
			pObj->mAttrValue = SipStringAlloc("GSM");
			pObj->mAttrRate = SipStringAlloc("8000");
			break;
		case e_RtpPayloadType_G723:
			pObj->mAttrValue = SipStringAlloc("G.723.1");
			pObj->mAttrRate = SipStringAlloc("8000");
			break;
		case e_RtpPayloadType_Dvi4_8000:
			pObj->mAttrValue = SipStringAlloc("DVI4");
			pObj->mAttrRate = SipStringAlloc("8000");
			break;
		case e_RtpPayloadType_Dvi4_16000:
			pObj->mAttrValue = SipStringAlloc("DVI4");
			pObj->mAttrRate = SipStringAlloc("16000");
			break;
		case e_RtpPayloadType_Lpc:
			pObj->mAttrValue = SipStringAlloc("LPC");
			pObj->mAttrRate = SipStringAlloc("8000");
			break;
		case e_RtpPayloadType_Pcma:
			pObj->mAttrValue = SipStringAlloc("PCMA");
			pObj->mAttrRate = SipStringAlloc("8000");
			break;
		case e_RtpPayloadType_G722:
			pObj->mAttrValue = SipStringAlloc("G.722");
			pObj->mAttrRate = SipStringAlloc("8000");
			break;
		case e_RtpPayloadType_L16_2ch:
		case e_RtpPayloadType_L16_1ch:
			pObj->mAttrValue = SipStringAlloc("L16");
			pObj->mAttrRate = SipStringAlloc("44100");
			break;
		case e_RtpPayloadType_Qcelp:
			pObj->mAttrValue = SipStringAlloc("QCELP");
			pObj->mAttrRate = SipStringAlloc("8000");
			break;
		case e_RtpPayloadType_Cn:
			pObj->mAttrValue = SipStringAlloc("CN");
			pObj->mAttrRate = SipStringAlloc("8000");
			break;
		case e_RtpPayloadType_Mpa:
			pObj->mAttrValue = SipStringAlloc("MPA");
			pObj->mAttrRate = SipStringAlloc("90000");
			break;
		case e_RtpPayloadType_G728:
			pObj->mAttrValue = SipStringAlloc("G.728");
			pObj->mAttrRate = SipStringAlloc("8000");
			break;
		case e_RtpPayloadType_Dvi4_11025:
			pObj->mAttrValue = SipStringAlloc("DVI4");
			pObj->mAttrRate = SipStringAlloc("11025");
			break;
		case e_RtpPayloadType_Dvi4_22050:
			pObj->mAttrValue = SipStringAlloc("DVI4");
			pObj->mAttrRate = SipStringAlloc("22050");
			break;
		case e_RtpPayloadType_G729:
			pObj->mAttrValue = SipStringAlloc("G.729");
			pObj->mAttrRate = SipStringAlloc("8000");
			break;
		/*video*/
		case e_RtpPayloadType_CelB:
			pObj->mAttrValue = SipStringAlloc("CelB");
			pObj->mAttrRate = SipStringAlloc("90000");
			break;
		case e_RtpPayloadType_Jpeg:
			pObj->mAttrValue = SipStringAlloc("JPEG");
			pObj->mAttrRate = SipStringAlloc("90000");
			break;
		case e_RtpPayloadType_nv:
			pObj->mAttrValue = SipStringAlloc("NV");
			pObj->mAttrRate = SipStringAlloc("90000");
			break;
		case e_RtpPayloadType_H261:
			pObj->mAttrValue = SipStringAlloc("H.261");
			pObj->mAttrRate = SipStringAlloc("90000");
			break;
		case e_RtpPayloadType_Mpv:
			pObj->mAttrValue = SipStringAlloc("MPV");
			pObj->mAttrRate = SipStringAlloc("90000");
			break;
		case e_RtpPayloadType_Mp2t:
			pObj->mAttrValue = SipStringAlloc("MP2T");
			pObj->mAttrRate = SipStringAlloc("90000");
			break;
		case e_RtpPayloadType_H263:
			pObj->mAttrValue = SipStringAlloc("H.263");
			pObj->mAttrRate = SipStringAlloc("90000");
			break;
		/*<nonStandard*/
		case e_RtpPayloadType_iLbc:
			pObj->mAttrValue = SipStringAlloc("iLBC");
			pObj->mAttrRate = SipStringAlloc("8000");
			break;
		case e_RtpPayloadType_Speex:
			pObj->mAttrValue = SipStringAlloc("speex");
			pObj->mAttrRate = SipStringAlloc("90000");
			break;
		/*nonStandard>*/
		case e_RtpPayloadType_Rfc2833:
			pObj->mAttrValue = SipStringAlloc("telephone-event");
			pObj->mAttrRate = SipStringAlloc("8000\r\na=fmtp:101 0-15");
			break;
		default:
			break;
	}

	return HS_OK;
}





/* SdpConnection member functions
*/
HS_RESULT new_SdpConnection(void *pObject)
{
	SdpConnection *pObj = (SdpConnection*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	pObj->mNetworkType = NULL;
	pObj->mAddrType = NULL;
	pObj->mAddr = NULL;
	return HS_OK;
}


HS_RESULT delete_SdpConnection(void *pObject)
{
	SdpConnection *pObj = (SdpConnection*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mNetworkType != NULL )
	{
		HSFree(pObj->mNetworkType);
		pObj->mNetworkType = NULL;
	}
	if( pObj->mAddrType != NULL )
	{
		HSFree(pObj->mAddrType);
		pObj->mAddrType = NULL;
	}
	if( pObj->mAddr != NULL )
	{
		HSFree(pObj->mAddr);
		pObj->mAddr = NULL;
	}
	return HS_OK;
}





/* SdpMediaDescription member functions
*/
HS_RESULT new_SdpMediaDescription(void *pObject)
{
	SdpMediaDescription *pObj = (SdpMediaDescription*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	pObj->mMediaType = NULL;
	pObj->mTsapPort = NULL;
	new_NoLockList(&(pObj->mAttributes),delete_SdpAttribute);
	return HS_OK;
}


HS_RESULT delete_SdpMediaDescription(void *pObject)
{
	SdpMediaDescription *pObj = (SdpMediaDescription*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if(pObj->mMediaType != NULL)
	{
		HSFree(pObj->mMediaType);
		pObj->mMediaType = NULL;
	}
	if(pObj->mTsapPort != NULL)
	{
		HSFree(pObj->mTsapPort);
		pObj->mTsapPort = NULL;
	}
	delete_NoLockList(&(pObj->mAttributes));
	return HS_OK;
}


SdpAttribute *SdpMediaDescription_FindAttribute(void *pObject, char *pNumber, HS_UINT pSize)
{
	HS_UINT i;
	ChainUnit *tChain = NULL;
	SdpAttribute *tAttribute = NULL;
	SdpMediaDescription *pObj = (SdpMediaDescription*)pObject;

	if( pObj==NULL || pNumber==NULL ) return NULL;

	tChain = pObj->mAttributes.units;
	for( i=0; i<pObj->mAttributes.size; i++ )
	{
		if( tChain==NULL ) return NULL;
		if( (tAttribute=(SdpAttribute*)(tChain->data))==NULL ) return NULL;

		if( !memcmp(tAttribute->mAttrNumber,pNumber,pSize) )
			return tAttribute;

		tChain = (ChainUnit*)(tChain->next);
	}

	return NULL;
}





/* SdpMessage member functions
*/
HS_RESULT new_SdpMessage(void *pObject)
{
	SdpMessage *pObj = (SdpMessage*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	pObj->mVersion = NULL;
	pObj->mOwner = NULL;
	pObj->mSessionName = NULL;
	new_SdpConnection(&(pObj->mConnection));
	new_NoLockList(&(pObj->mDescriptions),delete_SdpMediaDescription);
	return HS_OK;
}


HS_RESULT delete_SdpMessage(void *pObject)
{
	SdpMessage *pObj = (SdpMessage*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	if( pObj->mVersion != NULL )
	{
		HSFree(pObj->mVersion);
		pObj->mVersion = NULL;
	}
	if( pObj->mOwner != NULL )
	{
		HSFree(pObj->mOwner);
		pObj->mOwner = NULL;
	}
	if( pObj->mSessionName != NULL )
	{
		HSFree(pObj->mSessionName);
		pObj->mSessionName = NULL;
	}
	delete_SdpConnection(&(pObj->mConnection));
	delete_NoLockList(&(pObj->mDescriptions));
	return HS_OK;
}


SdpAttribute *SdpMessage_FindAttribute(void *pObject, char *pNumber, HS_UINT pSize)
{
	HS_UINT i;
	SdpAttribute *tResult= NULL;
	ChainUnit *tChain = NULL;
	SdpMediaDescription *tMediaDescription = NULL;
	SdpMessage *pObj = (SdpMessage*)pObject;

	if( pObj==NULL || pNumber==NULL ) return NULL;

	tChain = pObj->mDescriptions.units;
	for( i=0; i<pObj->mDescriptions.size; i++ )
	{
		if( tChain==NULL ) return NULL;
		if( (tMediaDescription=(SdpMediaDescription*)(tChain->data))==NULL ) return NULL;

		if( (tResult=SdpMediaDescription_FindAttribute(tMediaDescription,pNumber,pSize)) != NULL )
			return tResult;

		tChain = (ChainUnit*)(tChain->next);
	}

	return NULL;
}


SdpMediaDescription *SdpMessage_FindAudioDescription(void *pObject)
{
	return SdpMessage_FindMediaDescription(pObject,"audio");
}
SdpMediaDescription *SdpMessage_FindVideoDescription(void *pObject)
{
	return SdpMessage_FindMediaDescription(pObject,"video");
}
SdpMediaDescription *SdpMessage_FindMediaDescription(void *pObject, char *pType)
{
	HS_UINT i;
	ChainUnit *tChain = NULL;
	SdpMediaDescription *tResult = NULL;
	SdpMessage *pObj = (SdpMessage*)pObject;

	if( pObj==NULL || pType==NULL ) return NULL;

	tChain = pObj->mDescriptions.units;
	for( i=0; i<pObj->mDescriptions.size; i++ )
	{
		if( tChain == NULL ) return NULL;
		if( (tResult=(SdpMediaDescription*)(tChain->data)) == NULL ) return NULL;

		if( tResult->mMediaType != NULL )
		{
#ifdef _WIN32_WCE
			if( !wcsicmp((wchar_t*)tResult->mMediaType,(wchar_t*)pType) )
#else
			if( !stricmp(tResult->mMediaType,pType) )
#endif
			{
				return tResult;
			}
		}

		tChain = (ChainUnit*)(tChain->next);
	}

	return NULL;
}


HS_RESULT SdpMessage_Encode(void *pObject, char *pData, HS_UINT pMax)
{
	HS_UINT tPos=0;
	return SdpMessage_EncodeEx(pObject,pData,&tPos,pMax);
}


HS_RESULT SdpMessage_EncodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax)
{
	HS_UINT i, j;
	HS_UINT tPos = *pPos;
	ChainUnit *tChainAttr = NULL;
	ChainUnit *tChainDesc = NULL;
	SdpAttribute *tAttribute = NULL;
	SdpMediaDescription *tMediaDescription = NULL;
	SdpMessage *pObj = (SdpMessage*)pObject;

	if( pObj==NULL || pData==NULL ) return HS_ERR_NULL_PARAM;

	/* version
	*/
	if( pObj->mVersion == NULL ) return HS_ERR_SIP_NO_EXIST;
	HS_CHECK_OVER(tPos,(4+strlen(pObj->mVersion)),pMax);
	sprintf(pData+tPos,"%s%s\r\n",HS_SDP_INTEREST_VERSION,pObj->mVersion);
	tPos += (strlen(pObj->mVersion)+4);

	/* owner
	*/
	if( pObj->mOwner == NULL ) return HS_ERR_SIP_NO_EXIST;
	HS_CHECK_OVER(tPos,(strlen(pObj->mOwner)+4),pMax);
	sprintf(pData+tPos,"%s%s\r\n",HS_SDP_INTEREST_OWNER,pObj->mOwner);
	tPos += (strlen(pObj->mOwner)+4);

	/* session name
	*/
	if( pObj->mSessionName == NULL )
		pObj->mSessionName = SipStringAlloc("-");
	HS_CHECK_OVER(tPos,(strlen(pObj->mSessionName)+4),pMax);
	sprintf(pData+tPos,"%s%s\r\n",HS_SDP_INTEREST_SESSION_NAME,pObj->mSessionName);
	tPos += (strlen(pObj->mSessionName)+4);

	/* connection information
	*/
	HS_CHECK_OVER(tPos,2,pMax);
	sprintf(pData+tPos,"%s",HS_SDP_INTEREST_CONNECTION);
	tPos += 2;

	if( pObj->mConnection.mNetworkType == NULL ) return HS_ERR_SIP_NO_EXIST;
	HS_CHECK_OVER(tPos,(strlen(pObj->mConnection.mNetworkType)+1),pMax);
	sprintf(pData+tPos,"%s ",pObj->mConnection.mNetworkType);
	tPos += (strlen(pObj->mConnection.mNetworkType)+1);

	if( pObj->mConnection.mAddrType == NULL ) return HS_ERR_SIP_NO_EXIST;
	HS_CHECK_OVER(tPos,(strlen(pObj->mConnection.mAddrType)+1),pMax);
	sprintf(pData+tPos,"%s ",pObj->mConnection.mAddrType);
	tPos += (strlen(pObj->mConnection.mAddrType)+1);

	if( pObj->mConnection.mAddr == NULL ) return HS_ERR_SIP_NO_EXIST;
	HS_CHECK_OVER(tPos,(strlen(pObj->mConnection.mAddr)+2),pMax);
	sprintf(pData+tPos,"%s\r\n",pObj->mConnection.mAddr);
	tPos += (strlen(pObj->mConnection.mAddr)+2);

	/* time description
	*/
	HS_CHECK_OVER(tPos,7,pMax);
	strcpy(pData+tPos,"t=0 0\r\n");
	tPos += 7;

	tChainDesc = pObj->mDescriptions.units;
	for( i=0; i<pObj->mDescriptions.size; i++ )
	{
		if( tChainDesc==NULL ) return HS_ERR_CONFLICT;
		if( (tMediaDescription=(SdpMediaDescription*)(tChainDesc->data))==NULL )
			return HS_ERR_CONFLICT;

		/* media description
		*/
		HS_CHECK_OVER(tPos,2,pMax);
		sprintf(pData+tPos,"%s",HS_SDP_INTEREST_MEDIA_DESCRIPTION);
		tPos += 2;

		if( tMediaDescription->mMediaType == NULL ) return HS_ERR_SIP_NO_EXIST;
		HS_CHECK_OVER(tPos,(strlen(tMediaDescription->mMediaType)+1),pMax);
		sprintf(pData+tPos,"%s ",tMediaDescription->mMediaType);
		tPos += (strlen(tMediaDescription->mMediaType)+1);
		
		if( tMediaDescription->mTsapPort == NULL ) return HS_ERR_SIP_NO_EXIST;
		HS_CHECK_OVER(tPos,(strlen(tMediaDescription->mTsapPort)+1),pMax);
		sprintf(pData+tPos,"%s ",tMediaDescription->mTsapPort);
		tPos += (strlen(tMediaDescription->mTsapPort)+1);

		HS_CHECK_OVER(tPos,7,pMax);
		strcpy(pData+tPos,"RTP/AVP");
		tPos += 7;

		tChainAttr = tMediaDescription->mAttributes.units;
		for( j=0; j<tMediaDescription->mAttributes.size; j++ )
		{
			if( tChainAttr == NULL ) return HS_ERR_CONFLICT;
			if( (tAttribute=(SdpAttribute*)(tChainAttr->data)) == NULL ) return HS_ERR_CONFLICT;

			if( tAttribute->mAttrNumber == NULL ) return HS_ERR_SIP_NO_EXIST;
			HS_CHECK_OVER(tPos,(strlen(tAttribute->mAttrNumber)+1),pMax);
			sprintf(pData+tPos," %s",tAttribute->mAttrNumber);
			tPos += (strlen(tAttribute->mAttrNumber)+1);
			tChainAttr = (ChainUnit*)(tChainAttr->next);
		}
		HS_CHECK_OVER(tPos,2,pMax);
		strcpy(pData+tPos,"\r\n");
		tPos += 2;
		/* media attributes
		*/
		tChainAttr = tMediaDescription->mAttributes.units;
		for( j=0; j<tMediaDescription->mAttributes.size; j++ )
		{
			if( tChainAttr == NULL ) return HS_ERR_CONFLICT;
			if( (tAttribute=(SdpAttribute*)(tChainAttr->data)) == NULL ) return HS_ERR_CONFLICT;

			HS_CHECK_OVER(tPos,2,pMax);
			sprintf(pData+tPos,"%s",HS_SDP_INTEREST_ATTRIBUTE);
			tPos += 2;
			
			if( tAttribute->mAttrName == NULL ) return HS_ERR_SIP_NO_EXIST;
			HS_CHECK_OVER(tPos,(strlen(tAttribute->mAttrName)+1),pMax);
			sprintf(pData+tPos,"%s:",tAttribute->mAttrName);
			tPos += (strlen(tAttribute->mAttrName)+1);
			
			if( tAttribute->mAttrNumber == NULL ) return HS_ERR_SIP_NO_EXIST;
			HS_CHECK_OVER(tPos,(strlen(tAttribute->mAttrNumber)+1),pMax);
			sprintf(pData+tPos,"%s ",tAttribute->mAttrNumber);
			tPos += (strlen(tAttribute->mAttrNumber)+1);
			
			if( tAttribute->mAttrValue == NULL ) return HS_ERR_SIP_NO_EXIST;
			HS_CHECK_OVER(tPos,(strlen(tAttribute->mAttrValue)+1),pMax);
			sprintf(pData+tPos,"%s/",tAttribute->mAttrValue);
			tPos += (strlen(tAttribute->mAttrValue)+1);

			if( tAttribute->mAttrRate == NULL ) return HS_ERR_SIP_NO_EXIST;
			HS_CHECK_OVER(tPos,(strlen(tAttribute->mAttrRate)+2),pMax);
			sprintf(pData+tPos,"%s\r\n",tAttribute->mAttrRate);
			tPos += (strlen(tAttribute->mAttrRate)+2);

			tChainAttr = (ChainUnit*)(tChainAttr->next);
		}

		tChainDesc = (ChainUnit*)(tChainDesc->next);
	}

	*pPos = tPos;
	return HS_OK;
}


HS_RESULT SdpMessage_Decode(void *pObject, char *pData, HS_UINT pMax)
{
	HS_UINT tPos=0;
	return SdpMessage_DecodeEx(pObject,pData,&tPos,pMax);
}


HS_RESULT SdpMessage_DecodeEx(void *pObject, char *pData, HS_UINT *pPos, HS_UINT pMax)
{
	HS_UINT tOriPos, tPos = *pPos;
	HS_UINT tTokenPos = 0;
	HS_RESULT tRet = HS_OK;
	char tString[32];
	SdpAttribute *tAttribute = NULL;
	SdpMediaDescription *tMediaDescription = NULL;
	SdpMessage *pObj = (SdpMessage*)pObject;

	if( pObj==NULL || pData==NULL ) return HS_ERR_NULL_PARAM;

	tOriPos = tPos;
	delete_SdpMessage(pObj);
	/* find media description
	*/
	while( (tTokenPos=SipFindNextTokenOnlyEx(pData,tPos,pMax,"\r\nm="))!=HS_INVALID_POS )
	{
		tPos += (tTokenPos+4);
		if( (tMediaDescription=(SdpMediaDescription*)HSMalloc(sizeof(SdpMediaDescription)))==NULL )
			return HS_ERR_MALLOC;
		new_SdpMediaDescription(tMediaDescription);

		if( (tTokenPos=SipFindNextToken(pData,tPos,pMax,' '))==HS_INVALID_POS )
			return HS_ERR_SIP_END_OF_LINE;
		if( (tMediaDescription->mMediaType=SipStringAllocEx(pData+tPos,tTokenPos))==NULL )
			return HS_ERR_MALLOC;
		tPos += (tTokenPos+1);

		if( (tTokenPos=SipFindNextToken(pData,tPos,pMax,' '))==HS_INVALID_POS )
			return HS_ERR_SIP_END_OF_LINE;
		if( (tMediaDescription->mTsapPort=SipStringAllocEx(pData+tPos,tTokenPos))==NULL )
			return HS_ERR_MALLOC;
		tPos += (tTokenPos+1);

		if( (tTokenPos=SipFindNextToken(pData,tPos,pMax,' '))==HS_INVALID_POS )
			return HS_ERR_SIP_END_OF_LINE;
		/*RTP/AVP*/
		tPos += (tTokenPos+1);

		while( (tTokenPos=SipFindNextToken(pData,tPos,pMax,' ')) > 0 )
		{
			if( tTokenPos>30 ) return HS_ERR;
			if( (tAttribute=(SdpAttribute*)HSMalloc(sizeof(SdpAttribute)))==NULL )
				return HS_ERR_MALLOC;
			new_SdpAttribute(tAttribute);
			memcpy(tString,pData+tPos,tTokenPos);
			tString[tTokenPos] = '\0';
			HS_TRY( SdpAttribute_SetAttrNumber(tAttribute,atoi(tString)) );
			NoLockList_AttachData(&(tMediaDescription->mAttributes),tAttribute);
			tPos += tTokenPos;

			if( pData[tPos]==' ' ) tPos++;
		}

		tPos += 2;
		NoLockList_AttachData(&(pObj->mDescriptions),tMediaDescription);
	}
	if( pObj->mDescriptions.size == 0 )
		return HS_ERR_SIP_NO_EXIST;


	tPos = tOriPos;
	while(TRUE)
	{
		/* version
		*/
		if( !memcmp(pData+tPos,HS_SDP_INTEREST_VERSION,2) )
		{
			tPos += 2;
			if( (tTokenPos=SipFindEndOfLine(pData,tPos,pMax))==HS_INVALID_POS )
				return HS_ERR_SIP_END_OF_LINE;
			if( (pObj->mVersion=SipStringAllocEx(pData+tPos,tTokenPos))==NULL )
				return HS_ERR_MALLOC;
			tPos += tTokenPos;
		}

		/* owner
		*/
		else if ( !memcmp(pData+tPos,HS_SDP_INTEREST_OWNER,2) )
		{
			tPos += 2;
			if( (tTokenPos=SipFindEndOfLine(pData,tPos,pMax))==HS_INVALID_POS )
				return HS_ERR_SIP_END_OF_LINE;
			if( (pObj->mOwner=SipStringAllocEx(pData+tPos,tTokenPos))==NULL )
				return HS_ERR_MALLOC;
			tPos += tTokenPos;
		}

		/* session name
		*/
		else if ( !memcmp(pData+tPos,HS_SDP_INTEREST_SESSION_NAME,2) )
		{
			tPos += 2;
			if( (tTokenPos=SipFindEndOfLine(pData,tPos,pMax))==HS_INVALID_POS )
				return HS_ERR_SIP_END_OF_LINE;
			if( (pObj->mSessionName=SipStringAllocEx(pData+tPos,tTokenPos))==NULL )
				return HS_ERR_MALLOC;
			tPos += tTokenPos;
		}

		/* connection information
		*/
		else if ( !memcmp(pData+tPos,HS_SDP_INTEREST_CONNECTION,2) )
		{
			tPos += 2;

			if( (tTokenPos=SipFindNextToken(pData,tPos,pMax,' '))==HS_INVALID_POS )
				return HS_ERR_SIP_END_OF_LINE;
			if( (pObj->mConnection.mNetworkType=SipStringAllocEx(pData+tPos,tTokenPos))==NULL )
				return HS_ERR_MALLOC;
			tPos += (tTokenPos+1);

			if( (tTokenPos=SipFindNextToken(pData,tPos,pMax,' '))==HS_INVALID_POS )
				return HS_ERR_SIP_END_OF_LINE;
			if( (pObj->mConnection.mAddrType=SipStringAllocEx(pData+tPos,tTokenPos))==NULL )
				return HS_ERR_MALLOC;
			tPos += (tTokenPos+1);

			if( (tTokenPos=SipFindEndOfLine(pData,tPos,pMax))==HS_INVALID_POS )
				return HS_ERR_SIP_END_OF_LINE;
			if( (pObj->mConnection.mAddr=SipStringAllocEx(pData+tPos,tTokenPos))==NULL )
				return HS_ERR_MALLOC;
			tPos += tTokenPos;
		}

		/* media attributes
		*/
		else if ( !memcmp(pData+tPos,HS_SDP_INTEREST_ATTRIBUTE,2) )
		{
			tPos += 2;
			if( (tTokenPos=SipFindNextTokenOnly(pData,tPos,pMax,':'))==HS_INVALID_POS )
			{
				if( (tTokenPos=SipFindEndOfLine(pData,tPos,pMax))==HS_INVALID_POS )
					return HS_ERR_SIP_END_OF_LINE;
				tPos += tTokenPos;
			}
			else
			{
				memcpy(tString,pData+tPos,tTokenPos);
				tString[tTokenPos] ='\0';
				tPos += (tTokenPos+1);

				if( (tTokenPos=SipFindNextToken(pData,tPos,pMax,' '))==HS_INVALID_POS )
					return HS_ERR_SIP_END_OF_LINE;

				if( (tAttribute=SdpMessage_FindAttribute(pObj,pData+tPos,tTokenPos)) != NULL )
				{
					if(tAttribute->mAttrName != NULL )
					{HSFree(tAttribute->mAttrName);	tAttribute->mAttrName=NULL;}
					if(tAttribute->mAttrRate!= NULL )
					{HSFree(tAttribute->mAttrRate);	tAttribute->mAttrRate=NULL;}
					if(tAttribute->mAttrValue!= NULL )
					{HSFree(tAttribute->mAttrValue);	tAttribute->mAttrValue=NULL;}

					tAttribute->mAttrName = SipStringAlloc(tString);
					tPos += (tTokenPos+1);

					if( (tTokenPos=SipFindNextToken(pData,tPos,pMax,'/'))==HS_INVALID_POS )
						return HS_ERR_SIP_END_OF_LINE;
					if( (tAttribute->mAttrValue=SipStringAllocEx(pData+tPos,tTokenPos))==NULL )
						return HS_ERR_MALLOC;
					tPos += tTokenPos;
					if( memcmp(pData+tPos,HS_SIP_END_OF_LINE,2) )
					{
						tPos++;	/*skip '/' token*/
						if( (tTokenPos=SipFindNextToken(pData,tPos,pMax,'/'))==HS_INVALID_POS )
							return HS_ERR_SIP_END_OF_LINE;
						if( (tAttribute->mAttrRate=SipStringAllocEx(pData+tPos,tTokenPos))==NULL )
							return HS_ERR_MALLOC;
						tPos += tTokenPos;
						if( memcmp(pData+tPos,HS_SIP_END_OF_LINE,2) )
						{
							if( (tTokenPos=SipFindEndOfLine(pData,tPos,pMax))==HS_INVALID_POS )
								return HS_ERR_SIP_END_OF_LINE;
							tPos += tTokenPos;
						}
					}
				}
				else
				{
					if( (tTokenPos=SipFindEndOfLine(pData,tPos,pMax))==HS_INVALID_POS )
						return HS_ERR_SIP_END_OF_LINE;
					tPos += tTokenPos;
				}
			}
		}

		/* no interested line
		*/
		else
		{
			if( (tTokenPos=SipFindEndOfLine(pData,tPos,pMax))==HS_INVALID_POS )
				return HS_ERR_SIP_END_OF_LINE;
			tPos += tTokenPos;
		}

		tPos += 2;
		if( pData[tPos]=='\0' )
			return HS_OK;
	}

	*pPos = tPos;
	return HS_OK;
}




