/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<IDialogue.h>	2005-10-06,19:16

*/

#ifndef __2005_10_06__19_16__IDIALOGUE_H__
#define __2005_10_06__19_16__IDIALOGUE_H__



#include "SipDefine.h"
#include "UaDefine.h"
#include "IUa.h"

#include "SipAuth/SipAuth.h"





#define HS_SIP_MAX_AUTH_COUNT			3





typedef struct
{
	HS_UINT mNumber;
	char	*mType;
	BOOL	mStarted;

	char		*mLocalRtpAddr;
	HS_USHORT	mLocalRtpPort;
	char		*mRemoteRtpAddr;
	HS_USHORT	mRemoteRtpPort;
} MediaInfo;

HS_RESULT new_MediaInfo(void *pObject);
HS_RESULT delete_MediaInfo(void *pObject);



typedef enum
{
	e_DialogueState_Idle,
	e_DialogueState_Invite,
	e_DialogueState_ReadyConnect,
	e_DialogueState_Connect,
	
	/* even though dialogue signaling is over,
	   transaction can wait another response message.
	   for these active transaction, wait until all active transaction is over.
	   and then free itself.
	*/
	e_DialogueState_KillMe,

	e_DialogueStateMax
} DialogueState;


typedef enum
{
	e_SdpState_Idle,
	e_SdpState_Sent,
	e_SdpState_Received,
	e_SdpStateMax
} SdpState;
SdpState SdpState_ChangeSend(SdpState pNow);
SdpState SdpState_ChangeReceive(SdpState pNow);


typedef struct
{
	char			mCallId[MAX_NAME_SIZE];
	HS_UINT			mCseqSeed;
	char			*mExpires;/*for JUST REGISTER call*/
	char			mLocalTag[MAX_NAME_SIZE];
	char			mRemoteTag[MAX_NAME_SIZE];
	BOOL			mIsTcp;

	SipAuthorization *mAuthorization;
	HS_UINT			mNonceCount;
	BOOL			mIsAuthProxy;
	HS_UINT			mAuthCount;

	char			*mDestDisplayName;
	char			*mDestUser;
	char			*mDestAddress;
	HS_USHORT		mDestPort;

	char			mTarget[MAX_NAME_SIZE];
	HS_USHORT		mTargetPort;

	DialogueState	mState;
	SdpMessage		mSdp;
	SdpState		mSdpState;

	MediaInfo		*mAudio;
	MediaInfo		*mVideo;
	char			*mSessionId;

	IUa				*mUa;
	HS_CALL_HANDLE	mHandle;
	NoLockList		mTransactions;
} IDialogue;


HS_RESULT new_IDialogue(void *pObject, IUa *pUa);
HS_RESULT new_IDialogue_ByUser(void *pObject);
HS_RESULT delete_IDialogue(void *pObject);

char *IDialouge_MakeBranchId(void *pObject);
HS_RESULT IDialogue_MakeAuthResponse(void *pObject, char *pMethod);
HS_RESULT IDialogue_MakeAuthorization(void *pObject, SipMessage *pMessage);

HS_RESULT IDialogue_FindMatchMedia(void *pObject, SdpMessage *pSdp, BOOL pIsNewPort);
SdpMessage *IDialogue_MakeSdpAnswer(void *pObject);

HS_RESULT IDialogue_ChangeTarget(void *pObject, IUa *pUa, SipMessage *pMessage);

/* finding functions
*/
ChainUnit*	IDialogue_FindTransactionChainById(void *pObject, char *pBranchId, char *pMethod, char *pNum);
ChainUnit*	IDialogue_FindTransactionChainByHandle(void *pObject, HS_TR_HANDLE pHandle);
void*		IDialogue_FindTransactionById(void *pObject, char *pBranchId, char *pMethod, char *pNum);
void*		IDialogue_FindTransactionByHandle(void *pObject, HS_TR_HANDLE pHandle);
void*		IDialogue_FindTransactionByMethod(void *pObject, char *pMethod);
void*		IDialogue_FindActiveTransactionByMethod(void *pObject, char *pMethod);
HS_RESULT	IDialogue_DeleteTransaction(void *pObject, HS_TR_HANDLE pHandle);


void IDialogue_StateToKillMe(void *pObject, IStack *pStack, IUa *pUa, RemoveReason pReason);
void IDialogue_CallbackOpenMedia(void *pObject, IStack *pStack);
void IDialogue_CallbackCloseMedia(void *pObject, IStack *pStack);

void IDialogue_CallbackInstantMessage(void *pObject,IStack *st,IUa *ua,SipMessage *pMessage);
void IDialogue_CallbackOutbandDtmf(void *pObject,IStack *st,IUa *ua,SipMessage *pMessage);





#endif/*__2005_10_06__19_16__IDIALOGUE_H__*/


