/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<ITransaction.c>	2005-10-17,21:17

*/

#ifndef __2005_10_17__16_21__ITRANSACTION_H__
#define __2005_10_17__16_21__ITRANSACTION_H__



#include "SipDefine.h"
#include "UaDefine.h"
#include "IDialogue.h"



typedef enum
{
	e_TransactionState_Calling,
	e_TransactionState_Trying,
	e_TransactionState_Proceeding,
	e_TransactionState_Completed,
	e_TransactionState_Confirmed,
	e_TransactionState_Terminated,
	e_TransactionStateMax
} TransactionState;


typedef struct
{
	char			*mBranchId;
	HS_UINT			mCseq;
	char			*mMethod;
	BOOL			mIsInvite;
	BOOL			mIsClient;
	BOOL			mIsTcp;
	NoLockList		mVias;
	NoLockList		mRoutes;

	/* some transactions(ex:OPTIONS,MESSAGE) have different peer tag with dialogue
	*/
	BOOL			mIsNewPeerTag;
	char			mLocalTag[MAX_NAME_SIZE];
	char			mRemoteTag[MAX_NAME_SIZE];

	TransactionState mState;
	HS_UINT			mTimer;
	char			*mLingerMessage;
	HS_UINT			mLingerLen;

	IDialogue		*mDialogue;
	HS_TR_HANDLE	mHandle;
} ITransaction;


HS_RESULT new_ITransaction(
	void *pObject, 
	IDialogue *pDialogue,
	BOOL pIsInvite,
	BOOL pIsClient,
	BOOL pIsTcp,
	HS_UINT pCseq
);
HS_RESULT delete_ITransaction(void *pObject);

HS_RESULT ITransaction_MakeLocalVia(void *pObject);
SipContactUnit *ITransaction_GetPrimeContactUnit(void *pObject);
HS_RESULT ITransaction_SetLinger(void *pObject,char *pLinger,HS_UINT pLen);





#endif/*__2005_10_17__16_21__ITRANSACTION_H__*/


