/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<IUa.c>		2005-10-06,18:23

*/

#include "IUa.h"

/* reference header
*/
#include "IDialogue.h"





HS_RESULT new_IUa(void *pObject, IStack *pStack, HS_UINT pExpires)
{
	HS_RESULT tRet = HS_OK;
	IUa *pObj = (IUa*)pObject;

	if( pObj==NULL || pStack==NULL ) return HS_ERR_NULL_PARAM;

	HS_TRY( new_IUa_ByUser(pObj,pExpires) );
	/* ! NOTE : DON'T remove on IUa level.
	*/pObj->mStack = pStack;
	return NoLockList_AttachData(&(pStack->mUas),pObj);
}

HS_RESULT new_IUa_ByUser(void *pObject, HS_UINT pExpires)
{
	IUa *pObj = (IUa*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	/* make registrar dialogue
	*/
	if( (pObj->mRegistrar=(void*)HSMalloc(sizeof(IDialogue)))==NULL )
		return HS_ERR_MALLOC;
	new_IDialogue_ByUser(pObj->mRegistrar);
	((IDialogue*)(pObj->mRegistrar))->mUa = pObj;
	((IDialogue*)(pObj->mRegistrar))->mExpires = SipUintAlloc(pExpires);
	pObj->mIsRegisted = FALSE;

	memset(pObj->mProxy,0,MAX_NAME_SIZE);
	memset(pObj->mOutBoundProxy,0,MAX_NAME_SIZE);
	pObj->mProxyPort = HS_INVALID_TSAP_PORT;
	new_NoLockList(&(pObj->mContacts),delete_SipContact);
	memset(pObj->mPassword,0,MAX_NAME_SIZE);
	pObj->mAuthUser = NULL;

	pObj->mState = e_UaState_Idle;

	pObj->mStack = NULL;

	pObj->mHandle = HS_INVALID_HANDLE;
	new_NoLockList(&(pObj->mDialogues),delete_IDialogue);
	return HS_OK;
}


HS_RESULT delete_IUa(void *pObject)
{
	IUa *pObj = (IUa*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;

	delete_NoLockList(&(pObj->mContacts));
	if( pObj->mAuthUser != NULL )
	{
		HSFree(pObj->mAuthUser);
		pObj->mAuthUser = NULL;
	}
	if( pObj->mRegistrar != NULL )
	{
		delete_IDialogue(pObj->mRegistrar);
		HSFree(pObj->mRegistrar);
		pObj->mRegistrar = NULL;
	}

	delete_NoLockList(&(pObj->mDialogues));
	return HS_OK;
}


HS_RESULT IUa_MakeTag(void *pObject, char *pTag)
{
	IUa *pObj = (IUa*)pObject;

	if( pObj==NULL || pTag==NULL ) return HS_ERR_NULL_PARAM;

	sprintf(pTag,"%02x%02x%02x",SipRand(0xff),SipRand(0xff),SipRand(0xff));
	return HS_OK;
}


HS_RESULT IUa_MakeCallId(void *pObject, char *pId)
{
	IUa *pObj = (IUa*)pObject;
	SipContactUnit *tContactUnit = NULL;

	if( pObj==NULL || pId==NULL )
		return HS_ERR_NULL_PARAM;
	if( (tContactUnit=IUa_GetPrimeContactUnit(pObj))==NULL )
		return HS_ERR_SIP_NO_EXIST;

	sprintf(pId,"%02x%02x%02x%02x771120@%s",
		SipRand(0xff),SipRand(0xff),
		SipRand(0xff),SipRand(0xff),
		tContactUnit->mUri.mAddress
	);
	return HS_OK;
}


SipContactUnit *IUa_GetPrimeContactUnit(void *pObject)
{
	ChainUnit *tChain = NULL;
	IUa *pObj = (IUa*)pObject;

	if( pObj==NULL ) return NULL;

	if( (tChain=(ChainUnit*)(pObj->mContacts.units)) == NULL ) return NULL;
	return SipContact_GetPrimeContactUnit(tChain->data);
}


HS_RESULT IUa_ChangeExpires(void *pObject,HS_UINT pNew)
{
	IDialogue *tRegistrar = NULL;
	IUa *pObj = (IUa*)pObject;

	if( pObj==NULL ) return HS_ERR_NULL_PARAM;
	if( (tRegistrar=(IDialogue*)(pObj->mRegistrar))==NULL ) return HS_ERR;

	if( tRegistrar->mExpires != NULL )
	{
		HSFree(tRegistrar->mExpires);
		tRegistrar->mExpires = NULL;
	}

	tRegistrar->mExpires = HSUintAlloc(pNew);
	return HS_OK;
}





/* finding functions
*/
ChainUnit *IUa_FindDialogueChainById(void *pObject, char *pCallId)
{
	HS_UINT i;
	ChainUnit *tChain = NULL;
	IDialogue *tResult = NULL;
	IUa *pObj = (IUa*)pObject;

	if( pObj==NULL || pCallId==NULL ) return NULL;

	tChain = pObj->mDialogues.units;
	for( i=0; i<pObj->mDialogues.size; i++ )
	{
		if( tChain==NULL ) return NULL;
		if( (tResult=(IDialogue*)(tChain->data))==NULL ) return NULL;
		if( !strcmp(pCallId,tResult->mCallId) ) return tChain;

		tChain = (ChainUnit*)(tChain->next);
	}

	return NULL;
}


ChainUnit *IUa_FindDialogueChainByHandle(void *pObject, HS_CALL_HANDLE pHandle)
{
	HS_UINT i;
	ChainUnit *tChain = NULL;
	IDialogue *tUnit = NULL;
	IDialogue *tResult = NULL;
	IUa *pObj = (IUa*)pObject;

	if( pObj==NULL || pHandle==HS_INVALID_HANDLE ) return NULL;

	tChain = pObj->mDialogues.units;
	for( i=0; i<pObj->mDialogues.size; i++ )
	{
		if( tChain==NULL ) return NULL;
		if( (tResult=(IDialogue*)(tChain->data))==NULL ) return NULL;
		if( tResult->mHandle==pHandle ) return tChain;

		tChain = (ChainUnit*)(tChain->next);
	}

	return NULL;
}


void *IUa_FindDialogueById(void *pObject, char *pCallId)
{
	IDialogue *tResult = NULL;
	ChainUnit *tChain = NULL;
	IUa *pObj = (IUa*)pObject;

	if( pObj==NULL || pCallId==NULL ) return NULL;

	if( (tResult=(IDialogue*)(pObj->mRegistrar)) != NULL )
	{
		if( !strcmp(tResult->mCallId,pCallId) )
			return tResult;
	}

	tChain = IUa_FindDialogueChainById(pObject,pCallId);
	if( tChain==NULL ) return NULL;
	return (tChain->data);
}


void *IUa_FindDialogueByHandle(void *pObject, HS_CALL_HANDLE pHandle)
{
	IDialogue *tResult = NULL;
	ChainUnit *tChain = NULL;
	IUa *pObj = (IUa*)pObject;

	if( pObj==NULL || pHandle==HS_INVALID_HANDLE ) return NULL;

	if( (tResult=(IDialogue*)(pObj->mRegistrar)) != NULL )
	{
		if( tResult->mHandle == pHandle )
			return tResult;
	}

	tChain = IUa_FindDialogueChainByHandle(pObject,pHandle);
	if( tChain==NULL ) return NULL;
	return (tChain->data);
}


HS_RESULT IUa_DeleteDialogue(void *pObject, HS_CALL_HANDLE pHandle)
{
	IUa *pObj = (IUa*)pObject;
	ChainUnit *tChain = IUa_FindDialogueChainByHandle(pObject,pHandle);

	if( tChain==NULL ) return HS_ERR_SIP_NO_EXIST;

	if( pObj->mStack != NULL )
	{
		if( pObj->mStack->CallbackCallRemoved != NULL )
			pObj->mStack->CallbackCallRemoved(pObj->mHandle, ((IDialogue*)(tChain->data))->mHandle);
	}

	return NoLockList_DeleteChain(&(pObj->mDialogues),tChain);
}


void *IUa_FindTransactionByHandle(void *pObject, HS_TR_HANDLE pHandle)
{
	HS_UINT i;
	void *tResult = NULL;
	ChainUnit *tChain = NULL;
	IDialogue *tUnit = NULL;
	IUa *pObj = (IUa*)pObject;

	if( pObj==NULL ) return NULL;

	if( (tUnit=(IDialogue*)(pObj->mRegistrar))!=NULL )
	{
		if( (tResult=IDialogue_FindTransactionByHandle(tUnit,pHandle)) != NULL )
			return tResult;
	}

	tChain = pObj->mDialogues.units;
	for( i=0; i<pObj->mDialogues.size; i++ )
	{
		if( tChain==NULL ) return NULL;
		if( (tUnit=(tChain->data))==NULL ) return NULL;
		if( (tResult=IDialogue_FindTransactionByHandle(tUnit,pHandle))!=NULL )
			return tResult;

		tChain = (ChainUnit*)(tChain->next);
	}

	return NULL;
}

