/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<IUa.h>		2005-10-06,11:42

*/

#ifndef __2005_10_06__11_42__IUA_H__
#define __2005_10_06__11_42__IUA_H__



#include "SipDefine.h"
#include "UaDefine.h"
#include "IStack.h"





typedef enum
{
	e_UaState_Idle,
	e_UaState_Registed,

	/* if user want to remove ua object, ua can have active dialogue.
	   for these active dialogue, wait until all active dialogue is over.
	   and then free itself.
	*/
	e_UaState_KillMe,
	
	e_UaStateMax
} UaState;


typedef struct
{
	char			mProxy[MAX_NAME_SIZE];
	char			mOutBoundProxy[MAX_NAME_SIZE];
	HS_USHORT		mProxyPort;
	NoLockList		mContacts;
	char			mPassword[MAX_NAME_SIZE];
	char			*mAuthUser;
	/*IDialogue for Register*/
	void			*mRegistrar;
	BOOL			mIsRegisted;

	UaState			mState;

	IStack			*mStack;
	HS_UA_HANDLE	mHandle;
	NoLockList		mDialogues;
} IUa;

HS_RESULT new_IUa(void *pObject, IStack *pStack, HS_UINT pExpires);
HS_RESULT new_IUa_ByUser(void *pObject, HS_UINT pExpires);
HS_RESULT delete_IUa(void *pObject);

HS_RESULT IUa_MakeTag(void *pObject, char *pTag);
HS_RESULT IUa_MakeCallId(void *pObject, char *pId);
SipContactUnit *IUa_GetPrimeContactUnit(void *pObject);
HS_RESULT IUa_ChangeExpires(void *pObject,HS_UINT pNew);

/* finding functions
*/
ChainUnit*	IUa_FindDialogueChainById(void *pObject, char *pCallId);
ChainUnit*	IUa_FindDialogueChainByHandle(void *pObject, HS_CALL_HANDLE pHandle);
void*		IUa_FindDialogueById(void *pObject, char *pCallId);
void*		IUa_FindDialogueByHandle(void *pObject, HS_CALL_HANDLE pHandle);
HS_RESULT	IUa_DeleteDialogue(void *pObject, HS_CALL_HANDLE pHandle);

void*		IUa_FindTransactionByHandle(void *pObject, HS_TR_HANDLE pHandle);





#endif/*__2005_10_06__11_42__IUA_H__*/


