/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SipMessageHandler.h>	2005-10-25,21:12

*/

#ifndef __2005_10_25__21_12__SIPMESSAGEHANDLER_H__
#define __2005_10_25__21_12__SIPMESSAGEHANDLER_H__



#include "SipDefine.h"
#include "UaDefine.h"
#include "SipQmessage.h"

#include "SipTimerValue.h"





/* utilities
*/
HS_RESULT String2SockAddr(struct sockaddr_in *pTo, char *pFrom, HS_USHORT pPort);
QmEnetMessage *MakeQmEnetMessage(ITransaction *pTransaction,char *pPacket,HS_UINT pLen);
BOOL IsNeedTransaction(SipMessage *pMessage);
IDialogue *MakeNewDialogue(IStack *pStack, SipMessage *pMessage, BOOL pIsTcp);
ITransaction *MakeNewServerTransaction(IStack *pStack, IDialogue *pDialogue, SipMessage *pMessage, HS_TR_HANDLE pHandle);
ITransaction *MakeNewClientTransaction(IStack *pStack, IDialogue *pDialogue, char *pMethod);
HS_RESULT SendSipMessage(IStack *st,IUa *ua,IDialogue *dg,ITransaction *tr,SipMessage *pMessage,char *pPacket,HS_UINT *pPos,int pLen);
HS_RESULT StartNewTransaction(IStack *st, IUa *ua, IDialogue *dg, SipMethod pMethod, char *pBodyType, char *pBody);
HS_RESULT TrySipRegistration(IUa *pUa);
HS_RESULT CheckReceivedSdp(IStack *st, IDialogue *dg, SipMessage *pMessage);
HS_RESULT MakeSdpAnswer(IDialogue *dg, char *pPacket, int pLen);





/* handling functions
*/
HS_RESULT HandleSipMessage(IStack *pStack, QmEnetMessage *pMessage);

HS_RESULT HandleSipRequest	(ITransaction *pTransaction, SipMessage *pMessage);
HS_RESULT HandleINVITE		(IStack *st, IUa *ua, IDialogue *dg, ITransaction *tr, SipMessage *pMessage);
HS_RESULT HandleCANCEL		(IStack *st, IUa *ua, IDialogue *dg, ITransaction *tr, SipMessage *pMessage);
HS_RESULT HandleBYE			(IStack *st, IUa *ua, IDialogue *dg, ITransaction *tr, SipMessage *pMessage);
HS_RESULT HandleOPTIONS		(IStack *st, IUa *ua, IDialogue *dg, ITransaction *tr, SipMessage *pMessage);
HS_RESULT HandleINFO		(IStack *st, IUa *ua, IDialogue *dg, ITransaction *tr, SipMessage *pMessage);
HS_RESULT HandleACK			(IStack *st, IUa *ua, IDialogue *dg, ITransaction *tr, SipMessage *pMessage);
HS_RESULT HandleUPDATE		(IStack *st, IUa *ua, IDialogue *dg, ITransaction *tr, SipMessage *pMessage);
HS_RESULT HandleSUBSCRIBE	(IStack *st, IUa *ua, IDialogue *dg, ITransaction *tr, SipMessage *pMessage);
HS_RESULT HandleNOTIFY		(IStack *st, IUa *ua, IDialogue *dg, ITransaction *tr, SipMessage *pMessage);
HS_RESULT HandleMESSAGE		(IStack *st, IUa *ua, IDialogue *dg, ITransaction *tr, SipMessage *pMessage);
HS_RESULT HandleREFER		(IStack *st, IUa *ua, IDialogue *dg, ITransaction *tr, SipMessage *pMessage);

HS_RESULT HandleSipResponse(ITransaction *pTransaction, SipMessage *pMessage);
HS_RESULT Handle1xx(IStack *st, IUa *ua, IDialogue *dg, ITransaction *tr, SipMessage *pMessage);
HS_RESULT Handle2xx(IStack *st, IUa *ua, IDialogue *dg, ITransaction *tr, SipMessage *pMessage);
HS_RESULT Handle3xx(IStack *st, IUa *ua, IDialogue *dg, ITransaction *tr, SipMessage *pMessage);
HS_RESULT Handle4xx(IStack *st, IUa *ua, IDialogue *dg, ITransaction *tr, SipMessage *pMessage);
HS_RESULT Handle5xx(IStack *st, IUa *ua, IDialogue *dg, ITransaction *tr, SipMessage *pMessage);
HS_RESULT Handle6xx(IStack *st, IUa *ua, IDialogue *dg, ITransaction *tr, SipMessage *pMessage);





#endif/*__2005_10_25__21_12__SIPMESSAGEHANDLER_H__*/


