/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SipMessageMaker.c>		2005-10-20,22:18

*/

#include "SipMessageMaker.h"





SipMessage *MakeMessage	(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody)
{
	SipMessage *tMessage = NULL;

	if( pStack==NULL || pUa==NULL || pDialogue==NULL || pTransaction==NULL ) return NULL;
	if( (tMessage=newm_SipMessage()) == NULL ) return NULL;

	/* Via:
	*/
	SipVias_Copy(&(tMessage->mVias),&(pTransaction->mVias));

	/* Call-ID:
	*/
	if( (tMessage->mCallId=newm_SipCallId())==NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}
	tMessage->mCallId->mInfo = SipStringAlloc(pDialogue->mCallId);

	/* Route:
	*/
	SipRoutes_Copy(&(tMessage->mRoutes),&(pTransaction->mRoutes));

	/* User-Agent:
	*/
	if( pStack->mUserAgentName != NULL )
	{
		if( (tMessage->mUserAgent=newm_SipUserAgent())==NULL )
		{	HS_SIP_MSG_CLEAR(NULL);	}
		tMessage->mUserAgent->mInfo = SipStringAlloc(pStack->mUserAgentName);
	}

	/* Content-Type:
	*/
	if( pBodyType != NULL )
	{
		if( (tMessage->mContentType=newm_SipContentType())==NULL )
		{	HS_SIP_MSG_CLEAR(NULL);	}
		tMessage->mContentType->mInfo = SipStringAlloc(pBodyType);
	}

	/* Content-Length:
	*/
	if( (tMessage->mContentLength=newm_SipContentLength())==NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}
	if( pBody != NULL )
	{
		tMessage->mContentLength->mInfo = SipUintAlloc(strlen(pBody));
		tMessage->mBody = SipStringAlloc(pBody);
		tMessage->mBodyLen = strlen(pBody);
	}
	else
		tMessage->mContentLength->mInfo = SipUintAlloc(0);

	return tMessage;
}





/*
 *
 * Request message
 *
 */
SipMessage *MakeRequest	(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody, BOOL pIsRegisterMessage)
{
	SipMessage *tMessage = NULL;
	SipContactUnit *tContactUnit = NULL;
	SipContactUnit *tPrimeContactUnit = NULL;

	if( pStack==NULL || pUa==NULL || pDialogue==NULL || pTransaction==NULL ) return NULL;
	if( (tMessage=MakeMessage(pStack,pUa,pDialogue,pTransaction,pBodyType,pBody)) == NULL ) return NULL;

	/* headline
	*/
	tMessage->mHeadLine.mResponseValue = e_SipResponse_Request;
	tMessage->mHeadLine.mUri.mProtocol = SipStringAlloc(pStack->mProtocol);
	if( pDialogue->mDestAddress != NULL )
		tMessage->mHeadLine.mUri.mAddress = SipStringAlloc(pDialogue->mDestAddress);
	else
		tMessage->mHeadLine.mUri.mAddress = SipStringAlloc(pUa->mProxy);
	if( pDialogue->mDestPort != HS_INVALID_TSAP_PORT )
		tMessage->mHeadLine.mUri.mPort = SipUintAlloc(pDialogue->mDestPort);
	tMessage->mHeadLine.mUri.mVersion = SipStringAlloc(pStack->mVersion);

	/* MaxForward:
	*/
	if( (tMessage->mMaxForwards=newm_SipMaxForwards()) == NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}
	tMessage->mMaxForwards->mInfo = SipUintAlloc(pStack->mMaxForward);

	/* From:
	*/
	if( (tPrimeContactUnit=IUa_GetPrimeContactUnit(pUa)) == NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}
	if( (tMessage->mFrom=newm_SipFrom())==NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}
	if( (tContactUnit=newm_SipContactUnit(FALSE))==NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}

	tContactUnit->mDisplayName = SipStringAlloc(tPrimeContactUnit->mDisplayName);
	tContactUnit->mUri.mProtocol = SipStringAlloc(pStack->mProtocol);
	tContactUnit->mUri.mUserName = SipStringAlloc(tPrimeContactUnit->mUri.mUserName);
	if( pIsRegisterMessage==TRUE )
	{
		tContactUnit->mUri.mAddress = SipStringAlloc(pUa->mProxy);
		if( pUa->mProxyPort != HS_INVALID_TSAP_PORT )
			tContactUnit->mUri.mPort = SipUintAlloc((HS_UINT)(pUa->mProxyPort));
	}
	else
	{
		if( pUa->mIsRegisted==TRUE )
			tContactUnit->mUri.mAddress = SipStringAlloc(pUa->mProxy);
		else
		{
			/* direct call state
			*/
			tContactUnit->mUri.mAddress = SipStringAlloc(pStack->mLocalIp);
			if( pTransaction->mIsTcp==TRUE )
				tContactUnit->mUri.mPort = SipUintAlloc((HS_UINT)(pStack->mTcpPort));
			else
				tContactUnit->mUri.mPort = SipUintAlloc((HS_UINT)(pStack->mUdpPort));
		}
	}

	if( pTransaction->mIsNewPeerTag == TRUE )
	{
		/* some transactions(ex:OPTIONS,MESSAGE) have different peer tag with dialogue
		*/
		if( pTransaction->mLocalTag[0] != '\0' )
			tContactUnit->mTag = SipStringAlloc(pTransaction->mLocalTag);
	}
	else
	{
		if( pDialogue->mLocalTag[0] != '\0' )
			tContactUnit->mTag = SipStringAlloc(pDialogue->mLocalTag);
	}

	NoLockList_AttachData(&(tMessage->mFrom->mContactUnits),tContactUnit);

	/* To:
	*/
	if( (tMessage->mTo=newm_SipTo()) == NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}
	if( (tContactUnit=newm_SipContactUnit(FALSE)) == NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}

	if( pIsRegisterMessage==TRUE )
	{
		tContactUnit->mDisplayName = SipStringAlloc(tPrimeContactUnit->mDisplayName);
		tContactUnit->mUri.mUserName = SipStringAlloc(tPrimeContactUnit->mUri.mUserName);
		tContactUnit->mUri.mAddress = SipStringAlloc(pUa->mProxy);
	}
	else
	{
		tContactUnit->mDisplayName = SipStringAlloc(pDialogue->mDestDisplayName);
		tContactUnit->mUri.mUserName = SipStringAlloc(pDialogue->mDestUser);

		if( pDialogue->mDestAddress != NULL )
			tContactUnit->mUri.mAddress = SipStringAlloc(pDialogue->mDestAddress);
		else
			tContactUnit->mUri.mAddress = SipStringAlloc(pUa->mProxy);

		if( pDialogue->mDestPort != HS_INVALID_TSAP_PORT )
			tContactUnit->mUri.mPort = SipUintAlloc((HS_UINT)(pDialogue->mDestPort));
		else if( pUa->mProxyPort != HS_INVALID_TSAP_PORT )
			tContactUnit->mUri.mPort = SipUintAlloc((HS_UINT)(pUa->mProxyPort));
		/* REGISTER message must not have 'to-tag' attribute.
		*/
		if( pTransaction->mIsNewPeerTag == TRUE )
		{
			/* some transactions(ex:OPTIONS,MESSAGE) have different peer tag with dialogue
			*/
			if( pTransaction->mRemoteTag[0] != '\0' )
				tContactUnit->mTag = SipStringAlloc(pTransaction->mRemoteTag);
		}
		else
		{
			if( pDialogue->mRemoteTag[0] != '\0' )
				tContactUnit->mTag = SipStringAlloc(pDialogue->mRemoteTag);
		}
	}

	tContactUnit->mUri.mProtocol = SipStringAlloc(pStack->mProtocol);
	NoLockList_AttachData(&(tMessage->mTo->mContactUnits),tContactUnit);

	return tMessage;
}


SipMessage *MakeRequestRegister(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody)
{
	SipMessage *tMessage = NULL;
	IDialogue *tRegistrar = NULL;

	if( pStack==NULL || pUa==NULL || pDialogue==NULL || pTransaction==NULL ) return NULL;
	if( (tMessage=MakeRequest(pStack,pUa,pDialogue,pTransaction,pBodyType,pBody,TRUE)) == NULL ) return NULL;

	/* headline
	   : !MUST! IDialogue::mDestAddress = NULL
	   : !MUST! IDialogue::mDestPort = HS_INVALID_TSAP_PORT;
	*/
	tMessage->mHeadLine.mMethod = SipStringAlloc("REGISTER");

	/* authorization
	*/
	if( pDialogue->mAuthorization != NULL )
	{
		SipAuthorization *tAuthorization = NULL;

		if( pDialogue->mIsAuthProxy==TRUE )
			tAuthorization = SipAuthorization_Clone(pDialogue->mAuthorization,e_AuthType_ProxyResponse);
		else
			tAuthorization = SipAuthorization_Clone(pDialogue->mAuthorization,e_AuthType_Response);

		if( tAuthorization==NULL )
		{
			HS_SIP_MSG_CLEAR(NULL);
		}

		/* authorization response no have stale parameter.
		*/
		if( tAuthorization->mStale != NULL )
		{
			HSFree(tAuthorization->mStale);
			tAuthorization->mStale = NULL;
		}

		if( pDialogue->mIsAuthProxy==TRUE )
			tMessage->mProxyAuthorization = tAuthorization;
		else
			tMessage->mAuthorization = tAuthorization;
	}
	
	/* CSeq:
	*/
	if( (tMessage->mCSeq=newm_SipCSeq())==NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}
	tMessage->mCSeq->mNumber = SipUintAlloc(pTransaction->mCseq);
	tMessage->mCSeq->mMethod = SipStringAlloc("REGISTER");

	/* (Contact:)s
	*/
	SipContacts_Copy(&(tMessage->mContacts),&(pUa->mContacts));

	/* Expires:
	*/
	if( (tRegistrar=(IDialogue*)(pUa->mRegistrar))!=NULL )
	{
		if( (tMessage->mExpires=newm_SipExpires())==NULL )
		{	HS_SIP_MSG_CLEAR(NULL);	}
		tMessage->mExpires->mInfo = SipStringAlloc(tRegistrar->mExpires);
	}

	return tMessage;
}


SipMessage *MakeRequestInvite(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody)
{
	SipMessage *tMessage = NULL;

	if( pStack==NULL || pUa==NULL || pDialogue==NULL || pTransaction==NULL ) return NULL;
	if( (tMessage=MakeRequest(pStack,pUa,pDialogue,pTransaction,pBodyType,pBody,FALSE)) == NULL ) return NULL;

	/* headline
	*/
	tMessage->mHeadLine.mMethod = SipStringAlloc("INVITE");
	tMessage->mHeadLine.mUri.mUserName = SipStringAlloc(pDialogue->mDestUser);

	/* authorization
	*/
	if( pDialogue->mAuthorization != NULL )
	{
		SipAuthorization *tAuthorization = NULL;

		if( pDialogue->mIsAuthProxy==TRUE )
			tAuthorization = SipAuthorization_Clone(pDialogue->mAuthorization,e_AuthType_ProxyResponse);
		else
			tAuthorization = SipAuthorization_Clone(pDialogue->mAuthorization,e_AuthType_Response);

		if( tAuthorization==NULL )
		{
			HS_SIP_MSG_CLEAR(NULL);
		}

		/* authorization response no have stale parameter.
		*/
		if( tAuthorization->mStale != NULL )
		{
			HSFree(tAuthorization->mStale);
			tAuthorization->mStale = NULL;
		}

		if( pDialogue->mIsAuthProxy==TRUE )
			tMessage->mProxyAuthenticate = tAuthorization;
		else
			tMessage->mAuthorization = tAuthorization;
	}

	/* CSeq:
	*/
	if( (tMessage->mCSeq=newm_SipCSeq())==NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}
	tMessage->mCSeq->mNumber = SipUintAlloc(pTransaction->mCseq);
	tMessage->mCSeq->mMethod = SipStringAlloc("INVITE");

	/* (Contact:)s
	*/
	SipContacts_Copy(&(tMessage->mContacts),&(pUa->mContacts));

	return tMessage;
}


SipMessage *MakeRequestAck(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody)
{
	SipMessage *tMessage = NULL;

	if( pStack==NULL || pUa==NULL || pDialogue==NULL || pTransaction==NULL ) return NULL;
	if( (tMessage=MakeRequest(pStack,pUa,pDialogue,pTransaction,pBodyType,pBody,FALSE)) == NULL ) return NULL;

	/* headline
	*/
	tMessage->mHeadLine.mMethod = SipStringAlloc("ACK");
	tMessage->mHeadLine.mUri.mUserName = SipStringAlloc(pDialogue->mDestUser);

	/* CSeq:
	*/
	if( (tMessage->mCSeq=newm_SipCSeq())==NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}
	tMessage->mCSeq->mNumber = SipUintAlloc(pTransaction->mCseq);
	tMessage->mCSeq->mMethod = SipStringAlloc("ACK");

	return tMessage;
}


SipMessage *MakeRequestBye(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody)
{
	SipMessage *tMessage = NULL;

	if( pStack==NULL || pUa==NULL || pDialogue==NULL || pTransaction==NULL ) return NULL;
	if( (tMessage=MakeRequest(pStack,pUa,pDialogue,pTransaction,pBodyType,pBody,FALSE)) == NULL ) return NULL;

	/* headline
	*/
	tMessage->mHeadLine.mMethod = SipStringAlloc("BYE");
	tMessage->mHeadLine.mUri.mUserName = SipStringAlloc(pDialogue->mDestUser);

	/* CSeq:
	*/
	if( (tMessage->mCSeq=newm_SipCSeq())==NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}
	tMessage->mCSeq->mNumber = SipUintAlloc(pTransaction->mCseq);
	tMessage->mCSeq->mMethod = SipStringAlloc("BYE");

	return tMessage;
}


SipMessage *MakeRequestCancel(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody)
{
	SipMessage *tMessage = NULL;

	if( pStack==NULL || pUa==NULL || pDialogue==NULL || pTransaction==NULL ) return NULL;
	if( (tMessage=MakeRequest(pStack,pUa,pDialogue,pTransaction,pBodyType,pBody,FALSE)) == NULL ) return NULL;

	/* headline
	*/
	tMessage->mHeadLine.mMethod = SipStringAlloc("CANCEL");
	tMessage->mHeadLine.mUri.mUserName = SipStringAlloc(pDialogue->mDestUser);

	/* CSeq:
	*/
	if( (tMessage->mCSeq=newm_SipCSeq())==NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}
	tMessage->mCSeq->mNumber = SipUintAlloc(pTransaction->mCseq);
	tMessage->mCSeq->mMethod = SipStringAlloc("CANCEL");

	return tMessage;
}


SipMessage *MakeRequestInfo(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody)
{
	SipMessage *tMessage = NULL;

	if( pStack==NULL || pUa==NULL || pDialogue==NULL || pTransaction==NULL ) return NULL;
	if( (tMessage=MakeRequest(pStack,pUa,pDialogue,pTransaction,pBodyType,pBody,FALSE)) == NULL ) return NULL;

	/* headline
	*/
	tMessage->mHeadLine.mMethod = SipStringAlloc("INFO");
	tMessage->mHeadLine.mUri.mUserName = SipStringAlloc(pDialogue->mDestUser);

	/* CSeq:
	*/
	if( (tMessage->mCSeq=newm_SipCSeq())==NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}
	tMessage->mCSeq->mNumber = SipUintAlloc(pTransaction->mCseq);
	tMessage->mCSeq->mMethod = SipStringAlloc("INFO");

	return tMessage;
}


SipMessage *MakeRequestMESSAGE(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody)
{
	SipMessage *tMessage = NULL;

	if( pStack==NULL || pUa==NULL || pDialogue==NULL || pTransaction==NULL ) return NULL;
	if( (tMessage=MakeRequest(pStack,pUa,pDialogue,pTransaction,pBodyType,pBody,FALSE)) == NULL ) return NULL;

	/* headline
	*/
	tMessage->mHeadLine.mMethod = SipStringAlloc("MESSAGE");
	tMessage->mHeadLine.mUri.mUserName = SipStringAlloc(pDialogue->mDestUser);

	/* CSeq:
	*/
	if( (tMessage->mCSeq=newm_SipCSeq())==NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}
	tMessage->mCSeq->mNumber = SipUintAlloc(pTransaction->mCseq);
	tMessage->mCSeq->mMethod = SipStringAlloc("MESSAGE");

	return tMessage;
}





/*
 *
 * Response message
 *
 */
SipMessage *MakeResponse(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody)
{
	SipMessage *tMessage = NULL;
	SipContactUnit *tContactUnit = NULL;
	SipContactUnit *tPrimeContactUnit = NULL;

	if( pStack==NULL || pUa==NULL || pDialogue==NULL || pTransaction==NULL ) return NULL;
	if( (tMessage=MakeMessage(pStack,pUa,pDialogue,pTransaction,pBodyType,pBody)) == NULL ) return NULL;

	/* headline
	*/
	tMessage->mHeadLine.mUri.mVersion = SipStringAlloc(pStack->mVersion);

	/* To:
	*/
	if( (tPrimeContactUnit=IUa_GetPrimeContactUnit(pUa)) == NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}
	if( (tMessage->mTo=newm_SipTo())==NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}
	if( (tContactUnit=newm_SipContactUnit(FALSE))==NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}

	tContactUnit->mDisplayName = SipStringAlloc(tPrimeContactUnit->mDisplayName);
	tContactUnit->mUri.mProtocol = SipStringAlloc(pStack->mProtocol);
	tContactUnit->mUri.mUserName = SipStringAlloc(tPrimeContactUnit->mUri.mUserName);
	if( pUa->mIsRegisted==TRUE )
	{
		tContactUnit->mUri.mAddress = SipStringAlloc(pUa->mProxy);
		if( pUa->mProxyPort != HS_INVALID_TSAP_PORT )
			tContactUnit->mUri.mPort = SipUintAlloc((HS_UINT)(pUa->mProxyPort));
	}
	else
	{
		tContactUnit->mUri.mAddress = SipStringAlloc(pStack->mLocalIp);
		if( pTransaction->mIsTcp )
			tContactUnit->mUri.mPort = SipUintAlloc((HS_UINT)(pStack->mTcpPort));
		else
			tContactUnit->mUri.mPort = SipUintAlloc((HS_UINT)(pStack->mUdpPort));
	}

	if( pTransaction->mIsNewPeerTag == TRUE )
	{
		/* some transactions(ex:OPTIONS,MESSAGE) have different peer tag with dialogue
		*/
		if( pTransaction->mLocalTag[0] != '\0' )
			tContactUnit->mTag = SipStringAlloc(pTransaction->mLocalTag);
	}
	else
	{
		if( pDialogue->mLocalTag[0] != '\0' )
			tContactUnit->mTag = SipStringAlloc(pDialogue->mLocalTag);
	}

	NoLockList_AttachData(&(tMessage->mTo->mContactUnits),tContactUnit);

	/* From:
	*/
	if( (tMessage->mFrom=newm_SipFrom()) == NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}
	if( (tContactUnit=newm_SipContactUnit(FALSE)) == NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}

	tContactUnit->mDisplayName = SipStringAlloc(pDialogue->mDestDisplayName);
	tContactUnit->mUri.mProtocol = SipStringAlloc(pStack->mProtocol);
	tContactUnit->mUri.mUserName = SipStringAlloc(pDialogue->mDestUser);

	if( pDialogue->mDestAddress != NULL )
		tContactUnit->mUri.mAddress = SipStringAlloc(pDialogue->mDestAddress);
	else
		tContactUnit->mUri.mAddress = SipStringAlloc(pUa->mProxy);

	if( pDialogue->mDestPort != HS_INVALID_TSAP_PORT )
		tContactUnit->mUri.mPort = SipUintAlloc((HS_UINT)(pDialogue->mDestPort));
	else if( pUa->mProxyPort != HS_INVALID_TSAP_PORT )
		tContactUnit->mUri.mPort = SipUintAlloc((HS_UINT)(pUa->mProxyPort));

	if( pTransaction->mIsNewPeerTag == TRUE )
	{
		/* some transactions(ex:OPTIONS,MESSAGE) have different peer tag with dialogue
		*/
		if( pTransaction->mRemoteTag[0] != '\0' )
			tContactUnit->mTag = SipStringAlloc(pTransaction->mRemoteTag);
	}
	else
	{
		if( pDialogue->mRemoteTag[0] != '\0' )
			tContactUnit->mTag = SipStringAlloc(pDialogue->mRemoteTag);
	}

	NoLockList_AttachData(&(tMessage->mFrom->mContactUnits),tContactUnit);

	/* CSeq:
	*/
	if( (tMessage->mCSeq=newm_SipCSeq())==NULL )
	{	HS_SIP_MSG_CLEAR(NULL);	}
	tMessage->mCSeq->mNumber = SipUintAlloc(pTransaction->mCseq);
	tMessage->mCSeq->mMethod = SipStringAlloc(pTransaction->mMethod);

	return tMessage;
}


#define HS_RESPONSE_CASE(tNum,tName)							\
	case e_SipResponse_##tNum:									\
		tMessage->mHeadLine.mMethod = SipStringAlloc(tName);	\
		break

SipMessage *MakeResponseXxx(IStack *pStack, IUa *pUa, IDialogue *pDialogue, ITransaction *pTransaction, char *pBodyType, char *pBody, SipResponse pValue)
{
	SipMessage *tMessage = NULL;

	if( pStack==NULL || pUa==NULL || pDialogue==NULL || pTransaction==NULL ) return NULL;
	if( (tMessage=MakeResponse(pStack,pUa,pDialogue,pTransaction,pBodyType,pBody)) == NULL ) return NULL;

	/* headline
	*/
	tMessage->mHeadLine.mResponseValue = pValue;
	switch(pValue)
	{
		/*provisional 1xx*/
		case e_SipResponse_Trying:/*=100*/
			tMessage->mHeadLine.mMethod = SipStringAlloc("Trying");
			/* (Contact:)s
			*/
			SipContacts_Copy(&(tMessage->mContacts),&(pUa->mContacts));
			break;
		case e_SipResponse_Ringing:/*=180*/
			tMessage->mHeadLine.mMethod = SipStringAlloc("Ringing");
			/* (Contact:)s
			*/
			SipContacts_Copy(&(tMessage->mContacts),&(pUa->mContacts));
			break;
		case e_SipResponse_SessionProgress:/*=183*/
			tMessage->mHeadLine.mMethod = SipStringAlloc("Session Progress");
			/* (Contact:)s
			*/
			SipContacts_Copy(&(tMessage->mContacts),&(pUa->mContacts));
			break;

		/*successful 2xx*/
		case e_SipResponse_Ok:/*=200*/
			tMessage->mHeadLine.mMethod = SipStringAlloc("OK");
			/* (Contact:)s
			*/
			SipContacts_Copy(&(tMessage->mContacts),&(pUa->mContacts));
			break;
		/*redirection 3xx*/
		HS_RESPONSE_CASE(MultipleChoice,"Multiple Choice");/*=300*/
		HS_RESPONSE_CASE(MovedPermanently,"Moved Permanently");/*=301*/
		HS_RESPONSE_CASE(MovedTemporary,"Moved Temporary");/*=302*/
		HS_RESPONSE_CASE(UseProxy,"Use Proxy");/*=305*/
		HS_RESPONSE_CASE(AlternativeService,"Alternative Service");/*=380*/
		/*request failure 4xx*/
		HS_RESPONSE_CASE(BadRequest,"Bad Request");/*=400*/
		HS_RESPONSE_CASE(Unauthorized,"Unauthorized");/*=401*/
		HS_RESPONSE_CASE(PaymentRequired,"Payment Required");/*=402*/
		HS_RESPONSE_CASE(Forbidden,"Forbidden");/*=403*/
		HS_RESPONSE_CASE(NotFound,"Not Found");/*=404*/
		HS_RESPONSE_CASE(MethodNotAllowed,"Method Not Allowed");/*=405*/
		HS_RESPONSE_CASE(NotAcceptable,"Not Acceptable");/*=406*/
		HS_RESPONSE_CASE(ProxyAuthenticationRequired,"Proxy Authentication Required");/*=407*/
		HS_RESPONSE_CASE(RequestTimeOut,"Request Time Out");/*=408*/
		HS_RESPONSE_CASE(Gone,"Gone");/*=410*/
		HS_RESPONSE_CASE(RequestEntityTooLarge,"Request Entity Too Large");/*=413*/
		HS_RESPONSE_CASE(Request_URITooLong,"Request-URI Too Long");/*=414*/
		HS_RESPONSE_CASE(UnsupportedMediaType,"Unsupported Media Type");/*=415*/
		HS_RESPONSE_CASE(UnsupportedURIScheme,"Unsupported URI Scheme");/*=416*/
		HS_RESPONSE_CASE(BadExtension,"Bad Extension");/*=420*/
		HS_RESPONSE_CASE(ExtensionRequired,"Extension Required");/*=421*/
		HS_RESPONSE_CASE(IntervalTooBrief,"Interval Too Brief");/*=423*/
		HS_RESPONSE_CASE(TemporarilyUnavailable,"Temporarily Unavailable");/*=480*/
		HS_RESPONSE_CASE(CallDoesNotExist,"Call Does Not Exist");/*=481*/
		HS_RESPONSE_CASE(LoopDetected,"Loop Detected");/*=482*/
		HS_RESPONSE_CASE(TooManyHops,"Too Many Hops");/*=483*/
		HS_RESPONSE_CASE(AddressIncomplete,"Address Incomplete");/*=484*/
		HS_RESPONSE_CASE(Ambiguous,"Ambiguous");/*=485*/
		HS_RESPONSE_CASE(BusyHere,"Busy Here");/*=486*/
		HS_RESPONSE_CASE(RequestTerminated,"Request Terminated");/*=487*/
		HS_RESPONSE_CASE(NotAcceptableHere,"Not Acceptable Here");/*=488*/
		HS_RESPONSE_CASE(RequestPending,"Request Pending");/*=491*/
		HS_RESPONSE_CASE(Undechiperable,"Undechiperable");/*=493*/
		/*server failure 5xx*/
		HS_RESPONSE_CASE(ServerInternalError,"Server Internal Error");/*=500*/
		HS_RESPONSE_CASE(NotImplemented,"Not Implemented");/*=501*/
		HS_RESPONSE_CASE(BadGateway,"Bad Gateway");/*=502*/
		HS_RESPONSE_CASE(ServiceUnavailable,"Service Unavailable");/*=503*/
		HS_RESPONSE_CASE(ServerTime_Out,"Server Time-Out");/*=504*/
		HS_RESPONSE_CASE(VersionNotSupported,"Version Not Supported");/*=505*/
		HS_RESPONSE_CASE(MessageTooLarge,"Message Too Large");/*=513*/
		/*global failure 6xx*/
		HS_RESPONSE_CASE(BusyEverywhere,"Busy Everywhere");/*=600*/
		HS_RESPONSE_CASE(Decline,"Decline");/*=603*/
		HS_RESPONSE_CASE(DoesNotExistAnywhere,"Does Not Exist Anywhere");/*=604*/
		HS_RESPONSE_CASE(NotAcceptableEx,"Not Acceptable");/*=606*/
		default:
			{	HS_SIP_MSG_CLEAR(NULL);	}
	}

	return tMessage;
}



