/********************************************************************************

  Copyright (c) 2006, Hyoung-Sun Kim.
  All Rights Reserved.

  You can contact us with
  web site <http://www.voiper.co.kr>
  e-mail <voiper@voiper.co.kr>

  This software is distributed under the terms of the BSD license

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the <organization> nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*********************************************************************************/

/*

	<SipQmessage.h>		2005-10-22,21:35

*/

#ifndef __2005_10_22__21_35__SIPQMESSAGE_H__
#define __2005_10_22__21_35__SIPQMESSAGE_H__



#ifdef _WIN32_WCE
#include <winsock.h>
#endif

#include "SipDefine.h"
#include "UaDefine.h"
#include "SipMessageMaker.h"





/*
 *
 * User Command Queue message
 *
 */
/* add IUa object to IStack
	wParam:none
	lParam:IUa pointer
*/
#define HS_QM_ADD_UA					HS_QM_USER+1
/* try registration on proxy with IUa
	wParam:none
	lParam:HS_UA_HANDLE
*/
#define HS_QM_REGIST_UA					HS_QM_ADD_UA+1
/* remove IUa object from IStack (unregistration from proxy)
	wParam:none
	lParam:HS_UA_HANDLE
*/
#define HS_QM_REMOVE_UA					HS_QM_REGIST_UA+1

/* add IDialogue object to special IUa
	wParam:none
	lParam:QmMakeCall pointer
*/
#define HS_QM_MAKE_CALL					HS_QM_REMOVE_UA+1
typedef struct
{
	IDialogue		*mDialogue;
	HS_UA_HANDLE	mHandle;
} QmMakeCall;

QmMakeCall *newm_QmMakeCall(IDialogue *pDialogue, HS_UA_HANDLE pHandle);
HS_RESULT delete_QmMakeCall(void *pObject);
HS_RESULT deletem_QmMakeCall(void *pObject);

/* accept SIP call (dialog) came from remote user
	wParam:none
	lParam:HS_CALL_HANDLE
*/
#define HS_QM_ACCEPT_CALL				HS_QM_MAKE_CALL+1
/* add IDialogue object to special IUa
	wParam:none
	lParam:QmRemodelCall pointer
*/
#define HS_QM_REMODEL_CALL				HS_QM_ACCEPT_CALL+1
typedef struct
{
	IDialogue		*mDialogue;
	HS_CALL_HANDLE	mHandle;
} QmRemodelCall;

QmRemodelCall *newm_QmRemodelCall(IDialogue *pDialogue, HS_CALL_HANDLE pHandle);
HS_RESULT delete_QmRemodelCall(void *pObject);
HS_RESULT deletem_QmRemodelCall(void *pObject);

/* terminate SIP signaling and remove IDialogue object from IUa
	wParam:remove reason (SipResponse)
	lParam:HS_CALL_HANDLE
*/
#define HS_QM_REMOVE_CALL				HS_QM_REMODEL_CALL+1

typedef struct
{
	HS_CALL_HANDLE	mHandle;
	char			*mType;
	char			*mBody;
} QmMessageBody;

QmMessageBody *newm_QmMessageBody(HS_CALL_HANDLE pHandle,char *pType,char *mBody);
HS_RESULT delete_QmMessageBody(void *pObject);
HS_RESULT deletem_QmMessageBody(void *pObject);

/* supplementary message sending commands - INFO
	wParam:0
	lParam:QmMessageBody object pointer
*/
#define HS_QM_SEND_MESSAGE_INFO			HS_QM_REMOVE_CALL+1
/* supplementary message sending commands - MESSAGE
	wParam:0
	lParam:QmMessageBody object pointer
*/
#define HS_QM_SEND_MESSAGE_MESSAGE		HS_QM_SEND_MESSAGE_INFO+1

/* change SIP listen port
	wParam:HS_USHORT (TSAP port)
	lParam: 0(udp) / 1(tcp)
*/
#define HS_QM_CHANGE_LISTEN_PORT		HS_QM_SEND_MESSAGE_MESSAGE+1





/*
 *
 * Network thread's Queue message
 *
 */

/* when raw data come from Network, Network thread send to Stack thread
   when Stack thread have encoded data to send, Stack thread send to Network thread
	wParam:none
	lParam:QmEnetMessage pointer
*/
#define HS_QM_ENET_MESSAGE				HS_QM_CHANGE_LISTEN_PORT+1
typedef struct
{
	HS_UCHAR		*mRaw;
	int				mLen;
	/* if this handle is valid handle, data send (or received) on TCP.
	   otherwise on UDP, to mAddr.
	   if mHandle is invalid and mAddr is invalid, this message is discarding.
	*/
	HS_TR_HANDLE			mHandle;
	struct sockaddr_in		mAddr;
} QmEnetMessage;

QmEnetMessage *newm_QmEnetMessage(
	HS_UCHAR *pRaw,
	int pLen,
	HS_TR_HANDLE pHandle,
	struct sockaddr_in pAddr
);
HS_RESULT delete_QmEnetMessage(void *pObject);
HS_RESULT deletem_QmEnetMessage(void *pObject);

/* when SIP TCP-transaction is terminated, Stack thread send to Network thread for remove SipSocketSet.
   when TCP transport error occur on Network thread, Network thread send to Stack thread for Reporting it.
	wParam:none
	lParam:HS_TR_HANDLE
*/
#define HS_QM_REMOVE_SOCKET_SET			HS_QM_ENET_MESSAGE+1





#endif/*__2005_10_22__21_35__SIPQMESSAGE_H__*/


